import os, re

class POFileParser:
    def __init__(self, file):
        self.keys = {}
        self.file = file
        self.parse()

    def parse(self):
        f = open(self.file)
        nextline = ""
        for line in f:
            if nextline:
                key = re.sub(r'msgid "(.*)_s"$', r'\1', nextline)
                self.keys[key] = len(re.findall(r'(?<!%)%\d*[asdful]', line[:-1]))
                if line.find('msgstr ""') == -1:
                    nextline = ""
            if line.startswith('msgid') and line[:-1].endswith('_s"'):
                nextline = line[:-1]
        f.close()
        #print self.keys
        
    def compare(self, err_dict, key):
        return len(err_dict[key][0]) == self.keys[key]

