import re
from linda import libchecks, checks
from linda.funcs import run_external_cmd, ExtCmdException

class ControlFilesCheck(libchecks.LindaChecker):
    'Check the maintainer scripts of a package.'
    def init(self):
        self.exec_control = ('postinst', 'prerm', 'postrm', 'preinst', \
            'config')
        self.interp = {}
        for key in self.exec_control:
            self.interp[key] = ''
        self.norm_control = ('control', 'md5sums', 'conffiles', 'templates', \
            'shlibs')
        self.control_files = self.exec_control + self.norm_control

    def check_binary_1(self):
        self.general_checks()
        self.shebang_calls()
        self.conffiles()
        self.finding_things()
        
    def general_checks(self):
        for k in self.information['control']['info'].keys():
            if k not in self.control_files:
                self.signal_error('unknown-control-file', [k])
            if self.information['control']['info'][k][0] != 'root/root':
                self.signal_error('incorrect-ownership-control', [k])
            if (k in self.exec_control and \
                self.information['control']['info'][k][1] != '-rwxr-xr-x') or \
                (k in self.norm_control and \
                self.information['control']['info'][k][1] != '-rw-r--r--'):
                self.signal_error('incorrect-control-perms', [k])
    def shebang_calls(self):
        for x in self.exec_control:
            if not os.path.exists('%s/control/%s' % \
                (self.information['dir'], x)):
                continue
            try:
                f = open('%s/control/%s' % (self.information['dir'], x))
                k = f.readline()[:-1]
                f.close()
            except IOError, e:
                dprint(_("Failed to read shebang line: %s.") % e)
                k = ''
            self.interp[x] = k.split('/')[-1].split(' ')[0]
            cmd = ''
            parser_output = ''
            if self.interp[x] in ('sh', 'ash', 'dash'):
                cmd = 'dash'
            elif parser_call == 'bash':
                cmd = 'bash'
            if cmd:
                try:
                    parser_output = run_external_cmd('%s -n %s/control/%s' % \
                        (cmd, self.information['dir'], x))
                except ExtCmdException:
                    self.signal_error('possible-maint-error', [x, cmd])
    def conffiles(self):
        conffiles = {}
        if os.path.exists('%s/control/conffiles' % self.information['dir']):
            f = open('%s/control/conffiles' % self.information['dir'])
            for x in f:
                y = x.strip()
                if conffiles.has_key(y):
                    conffiles[y] += 1
                else:
                    conffiles[y] = 1
        dprint(_("Conffiles parsed in: %s.") % conffiles, 2)
        for x in conffiles.keys():
            if conffiles[x] >= 2:
                self.signal_error('duplicate-conffile', [x, conffiles[x]])
    def finding_things(self):
        for maint in self.exec_control:
            things_found = {}
            updatercd_calls = {'postrm': 0, 'postinst': 0}
            try:
                f = open('%s/control/%s' % (self.information['dir'], maint))
            except IOError:
                continue
            else:
                if run_external_cmd('file %s' % \
                    os.path.join(self.information['dir'], 'control', \
                    maint)).find('script') == -1:
                    continue
                for k in f:
                    if k.startswith('#!/bin/sh -e'):
                        things_found['bin-sh-e-in-maint'] = 1
                    if re.search(r'((echo|printf)|(\s+)?#)', k):
                        continue
                    if k.find('killall ') != -1:
                        things_found['killall-in-maint'] = 1
                    elif k.find('mknod ') != -1:
                        things_found['mknod-in-maint'] = 1
                    elif k.find('dpkg --print-architecture') != -1:
                        things_found['dpkg-pa-in-maint'] = 1
                    elif k.find('[[') != -1 or k.find(']]') != -1 and \
                        self.interp[maint] != 'bash':
                        things_found['bashism-in-maint'] = 1
                    elif k.find('suidregister ') != -1:
                        things_found['suid-in-maint'] = 1
                    if maint == 'postrm' and \
                        k.find('update-alternatives --remove') != -1:
                        things_found['update-alt-in-postrm'] = 1
                    if re.search('\s*(/var)?/tmp/\w', k) and not \
                        re.search(r'(mk(temp|dir)|tempfile)', k):
                        things_found['insecure-tmp-handling'] = 1
                    if re.search(r'/etc/(services|protocols|rpc)', k):
                        things_found['netbase-managed-in-maint'] = 1
                    if re.search(r'(\>|ed).?/etc/inetd.conf', k):
                        things_found['inetd-in-maint'] = 1
                    if maint.startswith('post') and \
                        re.search(r'update-rc\.d.*remove', k):
                        updatercd_calls[maint] += 1
            for key in things_found.keys():
                if things_found[key]:
                    self.signal_error(key, [maint])
            if updatercd_calls[maint] > 1:
                self.signal_error('multiple-update-rc.d', [maint[2:], \
                    updatercd_calls[maint]])

checks.register(ControlFilesCheck)

