import unittest, os, linda, tempfile, shutil
from po_count import POFileParser
from linda.debug import dprint
from linda.funcs import run_external_cmd
from linda.parser.datavalidator import DataValidator
from linda.libchecks import Checks

linda.checks = Checks()

class CDBSCheckSourceTest(unittest.TestCase):
    def setUp(self):
        execfile('checks/cdbs.py', {'_': __builtins__['_'], 'dprint': \
            dprint, 'DataValidator': DataValidator, 'os': os})
        for klass in linda.checks.registry['source'][2]:
            self.instance = klass('/tmp', '/tmp/test_0.0.1-1_all.deb', {})
        self.instance.information['dir'] = tempfile.mkdtemp()
        run_external_cmd('tar zxCf %s tests/source_cdbs.tar.gz' % \
            self.instance.information['dir'])
        os.mkdir(os.path.join(self.instance.information['dir'], 'debian'))
        self.po_keys = POFileParser('po/en.po')
        
    def tearDown(self):
        shutil.rmtree(self.instance.information['dir'])

    def test_check_cdbs(self):
        "Check the sanity of CDBSCheck"
        method = getattr(self.instance, 'check_cdbs')
        os.rename(os.path.join(self.instance.information['dir'], \
            'rules.nondebhelper'), \
            os.path.join(self.instance.information['dir'], 'debian', 'rules'))
        self.instance.information['control'] = {'self': [{}]}
        method()
        self.assert_('missing-build-dep-on-cdbs' in \
            self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'missing-build-dep-on-cdbs'), True)
        os.rename(os.path.join(self.instance.information['dir'], \
            'rules.noncdbs'), os.path.join(self.instance.information['dir'], \
            'debian', 'rules'))
        self.instance.information['control']['self'][0] = {'build-depends': \
            {'cdbs': {'arch': [None], 'relation': [[None, None]]}}}
        method()
        self.assert_('no-cdbs-but-build-dep' in self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'no-cdbs-but-build-dep'), True)
        self.instance.err_dict.clear()
        os.unlink(os.path.join(self.instance.information['dir'], \
            'debian/rules'))
        os.rename(os.path.join(self.instance.information['dir'], \
            'rules.includes'), os.path.join(self.instance.information['dir'], \
            'debian', 'rules'))
        method()
        self.assertEqual(['missing-build-dep-on-debhelper'], 
            self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'missing-build-dep-on-debhelper'), True)
        self.instance.information['control']['self'][0]['build-depends']['debhelper'] = {'arch': [None], 'relation': [[None, None]]}
        method()
        self.assert_('cdbs-debhelper-build-dep-too-old' in \
            self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'cdbs-debhelper-build-dep-too-old'), True)
        self.instance.err_dict.clear()
        self.instance.information['control']['self'][0]['build-depends']['debhelper']['relation'][0] = ['>>', '3.0']
        method()
        self.assert_('cdbs-debhelper-build-dep-too-old' in \
            self.instance.err_dict.keys())

