from linda import libchecks, checks
from sets import Set

class StandardsVersionCheck(libchecks.LindaChecker):
    'Check the Standards-Version field.'
    def init(self):
        self.standards_versions = {'ancient': (3,), 'out-of-date': (3, 5), \
            'newer': (3, 7, 2)}
    
    def check_source_1(self):
        self.standards_version()
        
    def standards_version(self):
        if self.information['dsc'].has_key('standards-version'):
            standards_version = {'numbers': tuple(map(lambda x: int(x), \
                self.information['dsc']['standards-version'].split('.'))), \
                'pretty': self.information['dsc']['standards-version']}
            if len(standards_version['numbers']) < 3:
                self.signal_error('incorrect-standards-version')
            if standards_version['numbers'][:len(self.standards_versions['ancient'])] < \
                self.standards_versions['ancient']:
                self.signal_error('ancient-standards-version', \
                    [standards_version['pretty']])
            elif standards_version['numbers'][:len(self.standards_versions['out-of-date'])] < self.standards_versions['out-of-date']:
                self.signal_error('out-date-standards-version', \
                    [standards_version['pretty']])
                build_depends = Set(('build-depends', 'build-depends-indep', \
                    'build-conflicts', 'build-conflicts-indep'))
                if len(build_depends.intersection(self.information['dsc'].keys())) >= 1:
                    self.signal_error('build-deps-wrong-s-v')
            elif standards_version['numbers'][:len(self.standards_versions['newer'])] > self.standards_versions['newer']:
                self.signal_error('newer-standards-version', \
                    [standards_version['pretty']])
        else:
            self.signal_error('no-standards-version')

checks.register(StandardsVersionCheck)

