import unittest, gettext, os, linda, tempfile, shutil
from linda.collector import Collector
from linda.debug import dprint
from linda.funcs import iterate_dir
from linda.parser.datavalidator import DataValidator
from linda.libchecks import Checks
from linda.parser.dsc import file_or_sym
from sets import Set

linda.checks = Checks()

class ExampleFilesCheckSourceTest(unittest.TestCase):
    def setUp(self):
        execfile('checks/example_files.py', {'_': gettext.gettext, 'dprint': \
            dprint, 'DataValidator': DataValidator, 'os': os})
        for klass in linda.checks.registry['source'][2]:
            self.instance = klass('/tmp', '/tmp/test_0.0.1-1_all.deb', {})
        self.instance.information['dir'] = tempfile.mkdtemp()

    def tearDown(self):
        shutil.rmtree(self.instance.information['dir'])
        
    def test_example_files(self):
        "Check the sanity of ExamplesFilesCheck"
        method = getattr(self.instance, 'example_files')
        os.mkdir(os.path.join(self.instance.information['dir'], 'debian'))
        for file in ('debian/ex.lala', 'debian/files', 'config.cache'):
            f = open(os.path.join(self.instance.information['dir'], file), \
                'w')
            f.close()
        self.instance.information['collector'] = Collector('src', \
            self.instance.information['dir'], filter(file_or_sym, \
            iterate_dir(self.instance.information['dir'])))
        errors = Set(('examples-files', 'debian-files-found', \
            'autoconf-generated-files'))
        method()
        self.assertEqual(errors.intersection(self.instance.err_dict.keys()), \
            errors)
        shutil.rmtree(os.path.join(self.instance.information['dir'], 'debian'))
        os.remove(os.path.join(self.instance.information['dir'], 'config.cache'))
        for key in self.instance.err_dict.keys():
            del self.instance.err_dict[key]
        os.mkdir(os.path.join(self.instance.information['dir'], 'debian'))
        f = open(os.path.join(self.instance.information['dir'], 'debian', \
            'hyperlatex.dirs'), 'w')
        f.close()
        self.instance.information['collector'] = Collector('src', \
            self.instance.information['dir'], filter(file_or_sym, \
            iterate_dir(self.instance.information['dir'])))
        method()
        self.assertEqual(self.instance.err_dict.keys(), [])
        shutil.rmtree(os.path.join(self.instance.information['dir'], 'debian'))
        
