import unittest, gettext, os, linda, tempfile, shutil
from linda.debug import dprint
from linda.parser.datavalidator import DataValidator
from linda.libchecks import Checks

linda.checks = Checks()

class StandardsVersionCheckSourceTest(unittest.TestCase):
    def setUp(self):
        execfile('checks/standards_version.py', {'_': gettext.gettext, \
            'dprint': dprint, 'DataValidator': DataValidator, 'os': os})
        for klass in linda.checks.registry['source'][1]:
            self.instance = klass('/tmp', '/tmp/test_0.0.1-1_all.deb', {})

    def test_standards_version(self):
        "Check the sanity of StandardsVersionCheck"
        method = getattr(self.instance, 'standards_version')
        self.instance.information = {'dsc': {}}
        method()
        self.assert_('no-standards-version' in self.instance.err_dict.keys())
        self.instance.information['dsc']['standards-version'] = '1.0'
        method()
        self.assert_('incorrect-standards-version' in \
            self.instance.err_dict.keys())
        self.instance.information['dsc']['standards-version'] = '2.0.0'
        method()
        self.assert_('ancient-standards-version' in \
            self.instance.err_dict.keys())
        self.instance.information['dsc']['standards-version'] = '3.0.0'
        method()
        self.assert_('out-date-standards-version' in \
            self.instance.err_dict.keys())
        self.instance.information['dsc']['build-conflicts'] = 'foobar'
        method()
        self.assert_('build-deps-wrong-s-v' in self.instance.err_dict.keys())
        self.instance.information['dsc']['standards-version'] = '3.7.0'
        method()
        self.assert_('newer-standards-version' in \
            self.instance.err_dict.keys())

