import re

class MakefileParser:
    def __init__(self, file):
        self.file = file
        self.data = {}
        self.parsed_data = []
        self.includes = []
        self.key_info = {'vars': [], 'targets': []}
        self.read()
        self.parse()
        
    def read(self):
        try:
            f = open(self.file)
        except IOError, e:
            raise IOError('failed to parse %s, due to %s.' % (self.file, e))
        for x in f:
            if x == '\n' or re.match(r'^(\t+)?#', x):
                continue
            self.parsed_data.append(x)

    def parse(self):
        tag = ''
        for line in self.parsed_data:
            if line.startswith('include'):
                self.includes.append(re.split(r'\s+', line[:-1])[1])
            if re.search(r'^([^\t]+).*\w:', line) and line.find('=') == -1:
                splitted_line = re.split(r'\s+', line[:-1])
                tag = splitted_line[0][:-1]
                self.data[tag] = {'depends': splitted_line[1:], 'commands': []}
            elif line.startswith('\t') and tag:
                untabbed = re.sub(r'\t+', '', line[:-1])
                self.data[tag]['commands'].append(untabbed)
            elif line.find('=') != -1 and not line.startswith('\t') and not \
                tag:
                if line.startswith('export '):
                    line = line[len('export '):]
                split_line = line[:-1].split('=')
                if re.search(r'(\?|:)$', split_line[0]):
                    split_line[0] = split_line[0][:-1]
                self.data[split_line[0].strip()] = {'data': \
                    split_line[1].strip()}
        for key in self.keys():
            if self[key].has_key('depends'):
                self.key_info['targets'].append(key)
            elif self[key].has_key('data'):
                self.key_info['vars'].append(key)
                
    def targets(self):
        return self.key_info['targets']
        
    def variables(self):
        return self.key_info['vars']

    def keys(self):
        return self.data.keys()

    def __getitem__(self, key):
        return self.data[key]

