import unittest
from linda.dpkgver import DpkgVersion

class DpkgVersionBaseTest(unittest.TestCase):
    def test_epoch_cmp(self):
        "Check that dissimilar versions aren't equal"
        dpkg = DpkgVersion('1:2.0-1')
        self.assertNotEqual(dpkg, '2:2.0-1')
        dpkg = DpkgVersion('2.0-1')
        self.assertNotEqual(dpkg, '2.1-1')
        dpkg = DpkgVersion('2.0-1')
        self.assertNotEqual(dpkg, '2.0-2')

    def test_equal(self):
        "Check that similar versions are equal"
        dpkg = DpkgVersion('2.0-1')
        self.assertEqual(dpkg, '2.0-1')

    def test_gt_le(self):
        "Check that versions are greater than, or less than"
        dpkg = DpkgVersion('2.0-2')
        self.assert_(dpkg > '2.0-1')
        self.assert_(dpkg < '2.0-3')

    def test_native_nonnative(self):
        "Check that comparing native versions to non-native works"
        dpkg = DpkgVersion('3.1.4')
        self.assert_(dpkg < '3.1.4-0.1')

    def test_nonnative_native(self):
        "Check that comparing non-native versions to native works"
        dpkg = DpkgVersion('2.1.0-0.1')
        self.assert_(dpkg > '2.1.0')

    def test_nativeness(self):
        "Check the is_native() method of DpkgVersion"
        dpkg = DpkgVersion('2.1.0')
        self.assertEqual(dpkg.is_native(), True)
        dpkg = DpkgVersion('2.1.0-1')
        self.assertEqual(dpkg.is_native(), False)
        dpkg = DpkgVersion('0.0.1')
        self.assertEqual(dpkg.is_native(), True)

