import unittest, gettext, os, linda, shutil, tempfile
from po_count import POFileParser
from linda.debug import dprint
from linda.funcs import run_external_cmd
from linda.parser.datavalidator import DataValidator
from linda.libchecks import Checks
from sets import Set

linda.checks = Checks()

class ShebangCheckBinaryTest(unittest.TestCase):
    def setUp(self):
        execfile('checks/shebang.py', {'_': gettext.gettext, 'dprint': \
            dprint, 'DataValidator': DataValidator, 'os': os})
        for klass in linda.checks.registry['binary'][2]:
            self.instance = klass('/tmp', '/tmp/test_0.0.1-1_all.deb', {})
        self.instance.information['dir'] = tempfile.mkdtemp()
        os.mkdir('%s/control' % self.instance.information['dir'])
        run_external_cmd('tar zxCf %s/control tests/binary_shebang.tar.gz' % \
            self.instance.information['dir'])
        self.po_keys = POFileParser('po/en.po')
        
    def tearDown(self):
        if self.instance.information.has_key('dir'):
            shutil.rmtree(self.instance.information['dir'])

    def test_fetch_script_name(self):
        "Check fetch_script_name() method of ShebangCheck"
        method = getattr(self.instance, 'fetch_script_name')
        method('postrm')
        self.assertEqual(self.instance.scripts['postrm'][0], '/bin/sh')
        method('postinst')
        self.assertEqual(self.instance.scripts['postinst'][0], \
            '/usr/bin/runhugs98')
        method('config')
        self.assertEqual(self.instance.scripts['config'], [])

    def test_check_maint(self):
        "Check check_maint() method of ShebangCheck"
        method = getattr(self.instance, 'check_maint')
        self.instance.scripts = {'postinst': None, 'preinst': None, \
            'prerm': None, 'postrm': None, 'config': None}
        method('config')
        self.assertEqual(self.instance.err_dict.keys(), [])
        self.instance.scripts['prerm'] = ['/bin/bash', \
            os.path.split('/bin/bash')]
        method('prerm')
        self.assertEqual(self.instance.err_dict.keys(), [])
        self.instance.scripts['postinst'] = ['/usr/bin/perl', \
            os.path.split('/usr/bin/perl')]
        method('postinst')
        self.assertEqual(self.instance.err_dict.keys(), [])
        self.instance.scripts['config'] = []
        method('config')
        self.assert_('no-shebang-line' in self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'no-shebang-line'), True)
        self.instance.scripts['postinst'] = ['/usr/local/bin/sh', \
            os.path.split('/usr/local/bin/sh')]
        method('postinst')
        self.assert_('usr-local-interpreter' in self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'usr-local-interpreter'), True)
        self.instance.scripts['preinst'] = ['/bin/lala', \
            os.path.split('/bin/lala')]
        method('preinst')
        self.assert_('unknown-exec' in self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'unknown-exec'), True)
        self.instance.scripts['prerm'] = ['/usr/bin/expect', \
            os.path.split('/usr/bin/expect')]
        self.instance.information['control'] = {'self': [{}]}
        method('prerm')
        self.assert_('script-depends' in self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'script-depends'), True)
        self.instance.scripts['config'] = ['/bin/tcsh', \
            os.path.split('/bin/tcsh')]
        method('config')
        expected_errs = Set(('wrong-path-script', 'csh-harmful'))
        self.assertEqual(expected_errs.intersection(self.instance.err_dict.keys()), expected_errs)
        for key in expected_errs:
            self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
                key), True)

