


#ifndef HDMI_RX_h
#define HDMI_RX_h

//#include <stdio.h>
//#include <stdarg.h>
//#include "i2c_intf.h"
//#include "HDMI_TX_i2c_intf.h"
#include "ANX7150_i2c_intf.h"

//#include "Timer.h"
//#include "mcu.h"
//#include "Uart_int.h"/'/

//typedef unsigned int WORD;
//typedef unsigned char BYTE;
//typedef bit bool;

#define HDMI_RX_FW_VER 0.70
#define INPUT_PORT int //#define INPUT_PORT bool 

#define ANX8770 0x00
#define ANX8775 0x01

#define DVI_MODE 0x00
#define HDMI_MODE 0x01
#define PORT0 0
#define PORT1 1
#define HDMI_PORT0 0x11
#define HDMI_PORT1 0x22
#define KILL_BOOST 0

#define IntPin_Out_Type_open_drain 0x02
#define IntPin_Out_Type_push_pull 0x00
#define IntPin_Out_Polarity_Low 0x01
#define IntPin_Out_Polarity_High 0x00
#define HDMI_POWER_ON 0x00;
#define HDMI_POWER_OFF 0x01;

#define null_state 0x0a


extern int enable_debug_output;//extern bool enable_debug_output;
extern BYTE g_Sys_State,video_format_supported;
extern int g_Video_Muted;//extern bool g_Video_Muted;
extern int g_Audio_Muted;//extern bool g_Audio_Muted;
extern BYTE hdmi_rx_chip_id;
typedef enum {
	_32KHz,
	_44KHz,//44.1KHz
	_48KHz,
	_82KHz,
	_96KHz,
	_192KHz
} HDMI_Audio_Fs;
//extern HDMI_Audio_Fs *HDMI_AUD_Fs;

typedef enum {
	_128Fs,
	_256Fs,
	_384Fs,
	_512Fs
} HDMI_MCLK_Freq;
//extern HDMI_MCLK_Freq *HDMI_MCLK_Fs;

typedef struct{
	BYTE I2S_enable;
	BYTE SPDIF_enable;
}HDMI_Audio_Mode;
extern HDMI_Audio_Mode HDMI_AUD_Mode;

typedef struct {
	BYTE SCK_edge;
	BYTE Size_Select;
	BYTE MSB_SIGN_EXT;
	BYTE WS_POL;
	BYTE JUST_CTRL;
	BYTE DIR_CTRL;
	BYTE SHIFT;
	BYTE Audio_Channel_Swap;
} HDMI_I2S_Format;
extern HDMI_I2S_Format HDMI_I2S_Fmt;

typedef enum{
       Hdmi_legacy,
	Hdmi_24bit,
	Hdmi_30bit,
	Hdmi_36bit
} HDMI_color_depth;
//extern HDMI_color_depth *HDMI_Color_Depth;

typedef struct {
   BYTE Type;
   BYTE Version;
   BYTE Length;
   BYTE CRC;
   BYTE Data[30];
} HDMI_Infoframe_Type;
extern HDMI_Infoframe_Type HDMI_InfoFrame;

typedef enum {
	Monitor_CKDT = 1,
	Wait_SCDT,
	Wait_VIDEO,
	Wait_AUDIO,
	Playback
}HDMI_System_State;
extern HDMI_System_State *HDMI_SysState;

typedef struct {
  int H_Tot;
  int V_Tol;
  int H_Act;
  int V_Act;
  int V_Freq;
  BYTE H_Front_Porch;
  int Hsync_width;
  BYTE V_Front_Porch;
  BYTE V_Back_Porth;
  BYTE HSYNC_POL;
  BYTE VSYNC_POL;
  BYTE pixel_repeat_times;
} HDMI_Video_Detailed_Info_t;
extern HDMI_Video_Detailed_Info_t HDMI_Vid_Info;

typedef enum {
   HDMI_SIGNAL_INTERLACED,
   HDMI_SIGNAL_PROGRESSIVE
} HDMI_interlace;
//extern HDMI_interlace *HDMI_Intl;

typedef enum {
   HDMI_RGB,
   HDMI_YCBCR422,
   HDMI_YCBCR444
} HDMI_color_space;
//extern HDMI_color_space *HDMI_CS;



//******************************************************************************
//  F U N C T I O N     P R O T O T Y P E S
//******************************************************************************
void HDMI_RX_Mute_Video(void);
void HDMI_RX_Mute_Audio(void);
void HDMI_RX_Unmute_Video(void);
void HDMI_RX_Unmute_Audio(void);
void HDMI_RX_Initialize(void);
void HDMI_RX_AVC_On(void);
void HDMI_RX_Port_Select(INPUT_PORT Selected_Port);
void HDMI_RX_Set_HPD(BYTE Port, int delaytime);
void HDMI_RX_SoftReset(void);
void HDMI_RX_VID_Output_Fmt(BYTE Vid_HW_Interface_fmt);
void HDMI_RX_AUD_Output_Fmt(BYTE Aud_HW_Interface_fmt);
void HDMI_RX_MCLK_Source(BYTE MCLK_Source);
void HDMI_RX_Set_MCLK_Freq(BYTE MCLK_Fs_Relationship);
//void HDMI_RX_I2S_Mode(bool SCK_EDGE, bool size_sel, bool msb_sign_ext,
//        bool ws_pol, bool JUST_CTRL, bool DIR_CTRL, bool SHIFT1);
void HDMI_RX_I2S_Mode(int SCK_EDGE, int size_sel, int msb_sign_ext,
        int ws_pol, int JUST_CTRL, int DIR_CTRL, int SHIFT1);
void HDMI_RX_Set_IntPin(BYTE Pin_Output_Type, 
    BYTE Pin_Output_Polarity);
void HDMI_RX_Set_IntMask(BYTE Int_ID, BYTE MaskBits);
void HDMI_RX_Init_var(void);
void HDMI_RX_Video_Timer_Slot(void);
void HDMI_RX_Audio_Timer_Slot(void);
void HDMI_RX_Timer_Slot2(void);
void HDMI_RX_Set_Sys_State(BYTE ss);
void HDMI_RX_Sync_Det_Int(void);
void HDMI_RX_Cts_Rcv_Int(void);
void HDMI_RX_Audio_Rcv_Int(void);
void HDMI_RX_HDCP_Error_Int(void);
void HDMI_RX_Aac_Done_Int(void);
void HDMI_RX_HDMI_DVI_Int(void);
void HDMI_RX_Get_Video_Info(void);
char HDMI_RX_Is_Video_Change(void);
void HDMI_RX_Restart_Audio_Chk(void);
void HDMI_RX_Clk_Detected_Int(void);
void HDMI_RX_Show_Video_Info(void);
void HDMI_RX_New_AVI_Int(void);
BYTE HDMI_RX_ReadI2C_RX0(BYTE sub_addr, BYTE *rxdata);
BYTE HDMI_RX_WriteI2C_RX0(BYTE sub_addr, BYTE txdata);
BYTE HDMI_RX_ReadI2C_RX1(BYTE sub_addr,  BYTE *rxdata);
BYTE HDMI_RX_WriteI2C_RX1(BYTE sub_addr,  BYTE txdata);
BYTE HDMI_RX_Chip_Located(void);
void HDMI_RX_Int_Process(void);
void HDMI_RX_Timer_Process(void);
BYTE HDMI_RX_Get_Power_Status(void);
void HDMI_RX_HardReset(void);
BYTE HDMI_RX_Get_Port_Status(void);
void HDMI_RX_Power_On(void);
void HDMI_RX_Power_Off(void);
BYTE HDMI_RX_Get_VID_Output_Fmt(void);
BYTE HDMI_RX_Get_AUD_MCLK_Freq(void);
BYTE HDMI_RX_Get_AUD_Fs(void);
void HDMI_RX_Get_I2S_Info(void);
void HDMI_RX_Get_AUD_HW_Interface_Fmt(void);
BYTE HDMI_RX_Get_IntMask(BYTE Int_ID);
BYTE HDMI_RX_Get_IntStatus(BYTE Int_ID);
void HDMI_RX_Clear_Int(BYTE Int_ID, BYTE ClrBits);
void HDMI_RX_Set_AEC_CtrlBits(BYTE AEC_ID, BYTE CtrlBits);
void HDMI_RX_AVC_Off(void);
void HDMI_RX_Set_Video_CH_Mapping(BYTE MappingValue);
void HDMI_RX_Set_Color_Depth(BYTE ColorDepth);
BYTE HDMI_RX_Get_Input_Color_Depth(void);
BYTE HDMI_RX_Get_Output_Color_Depth(void);
void HDMI_RX_Get_Infoframe(BYTE infoframe_type); 
BYTE HDMI_RX_Get_SysState(void);
int HDMI_RX_Get_HDMI_DVI_Mode(void);//bool HDMI_RX_Get_HDMI_DVI_Mode(void);
int HDMI_RX_Get_Vid_H_Tol(void);
int HDMI_RX_Get_Vid_V_Tol(void);
int HDMI_RX_Get_Vid_H_Act(void);
int HDMI_RX_Get_Vid_V_Act(void);
int HDMI_RX_Get_Vid_V_Freq(void);
BYTE HDMI_RX_Get_Vid_H_FrontPorch(void);
int HDMI_RX_Get_Vid_Hsync_Width(void);
BYTE HDMI_RX_Get_Vid_V_FrontPorch(void);
BYTE HDMI_RX_Get_Vid_V_BackPorch(void);
int HDMI_RX_Get_Vid_Vsync_Pol(void);//bool HDMI_RX_Get_Vid_Vsync_Pol(void);
int HDMI_RX_Get_Vid_Hsync_Pol(void);//bool HDMI_RX_Get_Vid_Hsync_Pol(void);
BYTE HDMI_RX_Get_Vid_Repeat_Times(void);
BYTE HDMI_RX_Get_Vid_I_P(void);
BYTE HDMI_RX_Get_Vid_CS(void);
BYTE HDMI_RX_Get_Device_ID_Low(void);
BYTE HDMI_RX_Get_Device_ID_High(void);
BYTE HDMI_RX_Get_Device_Revision(void);
BYTE HDMI_RX_Get_AEC_CtrlBits(BYTE AEC_id);
void HDMI_RX_Set_Video_Bit_Swap(int swap_value);//void HDMI_RX_Set_Video_Bit_Swap(bool swap_value);
void HDMI_RX_Set_Video_Bus_Mode(int bus_mode);//void HDMI_RX_Set_Video_Bus_Mode(bool bus_mode);
void HDMI_RX_AUDIO_BIST(void);
void HDMI_RX_Set_Color_Mode(void);

//extern unsigned char sysState,sysState_bkp;

/****************API Function begins***************************/

/****************API Function ends***************************/

//Use for digital video output fomat   
#define RGB444 0x00
#define RGB444_CLK48B 0x80
#define YCbCr444 0x01
#define YCbCr444_CLK48B 0x81
#define YCbCR422 0x03
#define YCbCr422_656 0x0b
#define YCbCr422_YCMUX 0x07
#define YCbCr422_656_YCMUX 0x0f

#define POL_positive 1
#define POL_negative 0

//**************** User defines of chip configuration******************//

// Analog video ouput enable
#define ANALOG_VID_EN 0x00      //0x00  Disable analog video output
                                //0x01  Enable analog video output

#define VIDEO_OUTPUT_FORMAT RGB444

#define Ext_MCLK_Selected      0x01
#define HDMI_MCLK_Selected      0x00
#define MCLK_Fs_128 0x00     // 0x00 Fmclk = 128*Fs
#define MCLK_Fs_256 0x10                              // 0x10 Fmclk = 256*Fs
#define MCLK_Fs_384 0x20                               // 0x20 Fmclk = 384*Fs
#define MCLK_Fs_512 0x30                               // 0x30 Fmclk = 512*Fs

#define I2S_Output_Selected    0x01
#define SPDIF_Output_Selected  0x02
#define I2SandSPDIF_Output_Selected 0x03

#define I2S_SCK_EDGE_Rising 0
#define I2S_SCK_EDGE_Falling 1
#define I2S_Size_16bit 1
#define I2S_Size_32bit 0
#define I2S_MSB_SIGN_EXT_Enable 0
#define I2S_MSB_SIGN_EXT_Disable 1
#define I2S_WS_POL_Low 0 
#define I2S_WS_POL_High 1
#define I2S_JUST_CTRL_Left 0
#define I2S_JUST_CTRL_Right 1
#define I2S_DIR_CTRL_MSB 0
#define I2S_DIR_CTRL_LSB 1
#define I2S_SHIFT 0
#define I2S_NO_SHIFT 1

#define VID_MAP_Red_Green_Blue 0x00
#define VID_MAP_Red_Blue_Green 0x01
#define VID_MAP_Green_Red_Blue 0x02
#define VID_MAP_Blue_Red_Green 0x03
#define VID_MAP_Green_Blue_Red 0x04
#define VID_MAP_Blue_Green_Red 0x05

#define Deep_Color_legacy 0x00
#define Deep_Color_24bit 0x40
#define Deep_Color_30bit 0x50
#define Deep_Color_36bit 0x60

#define InfoFrame_AVI 0
#define InfoFrame_AUD 1
#define InfoFrame_SPD 2
#define InfoFrame_ACP 3
#define InfoFrame_MPEG 4

//**************** End of User Defines ********************************//



//Use For ANX STATE Machine //
#define MONITOR_CKDT 0x01
#define WAIT_SCDT 0x02
#define WAIT_VIDEO 0x03
#define WAIT_AUDIO 0x04
#define PLAYBACK 0x05



// Threshhold Time //
#define VIDEO_STABLE_TH 3     
#define AUDIO_STABLE_TH 1
#define SCDT_EXPIRE_TH 10
#define SCDT_EXPIRE_TH_1 5
#define AFIFO_OV_TH 4
#define AUTH_START_TH 1
#define AUTH_TIMER_TH 20
#define HDMI_RX_FIFO_TH 50   
#define HDMI_RX_POP_NOISE_CNT 5
#define HDMI_RX_POP_NOISE_TH 2

#define HDMI_RX_CTS_ACR_CHANGE 0x38


//*************************************************************
//HDMI_RX Register define

// Registers in address 0x60 
#define HDMI_RX_DEV_IDL_REG 0x00
#define HDMI_RX_DEV_IDH_REG 0x01
#define HDMI_RX_DEV_REV_REG 0x02
#define HDMI_RX_VND_IDL_REG 0x03
#define HDMI_RX_VND_IDH_REG 0x04

#define HDMI_RX_PORT_SEL_REG 0x10
#define HDMI_RX_DDC1_EN	0x20		//bit	
#define HDMI_RX_DDC0_EN 0x10
#define HDMI_RX_TMDS1_EN 0x02
#define HDMI_RX_TMDS0_EN 0x01

#define HDMI_RX_SRST_REG 0x11
#define HDMI_RX_VIDEO_RST 0x10		//BIT
#define HDMI_RX_ACR_MAN_RST 0x08
#define HDMI_RX_HDCP_MAN_RST 0X04
#define HDMI_RX_TMDS_RST 0X02
#define HDMI_RX_SW_MAN_RST 0X01

#define HDMI_RX_SRST2_REG 0X12
#define HDMI_RX_AFIFO_RST 0X10		//BIT
#define HDMI_RX_VFIFO_RST 0X08
#define HDMI_RX_DDC_RST 	0X04
#define HDMI_RX_MISC_RST  0X02
#define HDMI_RX_HW_RST		0X01

#define HDMI_RX_SARST_REG 0X13
#define HDMI_RX_DDC_RST_CTRL 0X10  		//BIT
#define HDMI_RX_MISC_RST_CTRL 0X08
#define HDMI_RX_ACR_RST_CTRL  0X04
#define HDMI_RX_HDCP_RST_CTRL 0X02
#define HDMI_RX_SW_RST_CTRL 	0X01

#define HDMI_RX_SYS_STATUS_REG			0X14
#define HDMI_RX_P1_PWR5V	0X80
#define HDMI_RX_P0_PWR5V  0X40
#define HDMI_RX_PWR5V			0X08
#define HDMI_RX_VSYNC			0X04
#define HDMI_RX_CLK_DET		0X02
#define HDMI_RX_HDMI_DET  0X01

#define HDMI_RX_HDMI_STATUS_REG	0X15
#define HDMI_RX_DEEP_COLOR_MODE 0X40
#define HDMI_RX_HDMI_AUD_LAYOUT 0X08
#define HDMI_RX_MUTE_STAT				0X04
#define HDMI_RX_HDMI_MODE				0X01

#define HDMI_RX_HDMI_MUTE_CTRL_REG 0X16
#define HDMI_RX_MUTE_POL	0X04
#define HDMI_RX_AUD_MUTE	0X02
#define HDMI_RX_VID_MUTE	0X01

#define HDMI_RX_SYS_CTRL1_REG 0X17
#define HDMI_RX_DV_BUS_MODE 0X04
#define HDMI_RX_OUT_CLK_INV	0X02	
#define HDMI_RX_I2C_CLK_SEL 0X01

#define HDMI_RX_SYS_PWDN1_REG 0X18
#define HDMI_RX_PWDN_CTRL	0X01

#define HDMI_RX_SYS_PWDN2_REG 0X19
#define HDMI_RX_PD_PCLK 0X80
#define HDMI_RX_PD_MCLK 0X40
#define HDMI_RX_PD_AO	0X20
#define HDMI_RX_PD_VO 0X10
#define HDMI_RX_PD_DV_OUT 0X04
#define HDMI_RX_PD_SYNC_DE 0X02
#define HDMI_RX_PD_DV_CLK 0X01

#define HDMI_RX_SYS_PWDN3_REG 0X1A
#define HDMI_RX_PD_TERM1 0X80
#define HDMI_RX_PD_TERM0 0X40
#define HDMI_RX_PD_APLL	0X20
#define HDMI_RX_PD_TMDS 0X10
#define HDMI_RX_PD_PLL  0X08
#define HDMI_RX_PD_ALL  0X01

#define HDMI_RX_PIO_CTRL_REG 0X1B
#define HDMI_RX_PIO_DEV_ADDR_IN 0X40
#define HDMI_RX_PIO_CLK_TEST_IN 0X20
#define HDMI_RX_PIO_SPDIF_IN 0X10
#define HDMI_RX_PIO_CLK_TEST_PIN_EN 0X08
#define HDMI_RX_PIO_SPDIF_PIN_EN 0X04
#define HDMI_RX_PIO_CLK_TEST_PIN 0X02
#define HDMI_RX_PIO_SPDIF_PIN 0X01

#define HDMI_RX_AEC_CTRL_REG 0X20		//9021:B5
#define HDMI_RX_AVC_OE 0X20
#define HDMI_RX_AAC_OE 0X10
#define HDMI_RX_AVC_EN 0X02
#define HDMI_RX_AAC_EN 0X01

#define HDMI_RX_VID_AOF_REG 0X21		//9021:5F

#define HDMI_RX_AVC_EXCEPTION_MASK1_REG 0X22
#define HDMI_RX_DOWN_SAMPLE_MASK 0X80
#define HDMI_RX_UP_SAMPLE_MASK 0X40
#define HDMI_RX_Y2R_BT709_EN_MASK 0X20
#define HDMI_RX_RANGE_Y2R_MASK 0X10
#define HDMI_RX_CSPACE_Y2R_MASK 0X08
#define HDMI_RX_R2Y_BT709_EN_MASK 0X04
#define HDMI_RX_RANGE_R2Y_MASK 0X02
#define HDMI_RX_CSPACE_R2Y_MASK 0X01

#define HDMI_RX_AVC_EXCEPTION_MASK2_REG 0X23
#define HDMI_RX_OUT_CLK_DIV_MASK 0X40
#define HDMI_RX_PIXEL_REP_MASK 0X20
#define HDMI_RX_BLANK_MASK 0X10
#define HDMI_RX_EMBED_SYNC_MASK 0X08
#define HDMI_RX_MUX_YC_MASK 0X04

#define HDMI_RX_AEC_EN0_REG 0X24 //0XB6
#define HDMI_RX_AEC_EN07 0X80
#define HDMI_RX_AEC_EN06 0X40
#define HDMI_RX_AEC_EN05 0X20
#define HDMI_RX_AEC_EN04 0X10
#define HDMI_RX_AEC_EN03 0X08
#define HDMI_RX_AEC_EN02 0X04
#define HDMI_RX_AEC_EN01 0X02
#define HDMI_RX_AEC_EN00 0X01

#define HDMI_RX_AEC_EN1_REG 0X25
#define HDMI_RX_AEC_EN15 0X80
#define HDMI_RX_AEC_EN14 0X40
#define HDMI_RX_AEC_EN13 0X20
#define HDMI_RX_AEC_EN12 0X10
#define HDMI_RX_AEC_EN11 0X08
#define HDMI_RX_AEC_EN10 0X04
#define HDMI_RX_AEC_EN09 0X02
#define HDMI_RX_AEC_EN08 0X01

#define HDMI_RX_AEC_EN2_REG 0X26
#define HDMI_RX_AEC_EN23 0X80
#define HDMI_RX_AEC_EN22 0X40
#define HDMI_RX_AEC_EN21 0X20
#define HDMI_RX_AEC_EN20 0X10
#define HDMI_RX_AEC_EN19 0X08
#define HDMI_RX_AEC_EN18 0X04
#define HDMI_RX_AEC_EN17 0X02
#define HDMI_RX_AEC_EN16 0X01

#define HDMI_RX_INT_STATE_REG 0X30
#define HDMI_RX_INTR 0X01

#define HDMI_RX_INT_STATUS1_REG 0X31
#define HDMI_RX_HDMI_DVI 0X80
#define HDMI_RX_CKDT_CHANGE 0X40
#define HDMI_RX_SCDT_CHANGE 0X20
#define HDMI_RX_PCLK_CHANGE 0X10
#define HDMI_RX_PLL_UNLOCK  0X08
#define HDMI_RX_CABLE_UNPLUG 0X04
#define HDMI_RX_SET_MUTE 0X02
#define HDMI_RX_SW_INTR 0X01

#define HDMI_RX_INT_STATUS2_REG 0X32
#define HDMI_RX_AUTH_START 0X80
#define HDMI_RX_AUTH_DONE 0X40
#define HDMI_RX_HDCP_ERR 0X20
#define HDMI_RX_ECC_ERR 0X10
#define HDMI_RX_SPDIF_ERR 0X08
#define HDMI_RX_AUD_LINK_ERR 0X04
#define HDMI_RX_MUTE_DONE 0X02
#define HDMI_RX_FS_CHANGE 0X01

#define HDMI_RX_INT_STATUS3_REG 0X33
#define HDMI_RX_AFIFO_FULL 0X80
#define HDMI_RX_AFIFO_EMPTY 0X40
#define HDMI_RX_AFIFO_OVERFLOW 0X20
#define HDMI_RX_AFIFO_UNDERFLOW 0X10
#define HDMI_RX_ACR_PLL_UNLOCK 0X08
#define HDMI_RX_STATIC_DSD 0X04
#define HDMI_RX_INVALID_DSD 0X02
#define HDMI_RX_AUD_MODE_CHANGE 0X01

#define HDMI_RX_INT_STATUS4_REG 0X34
#define HDMI_RX_VSYNC_DET 0X80
#define HDMI_RX_SYNC_POL_CHANGE 0X40
#define HDMI_RX_V_RES_CHANGE 0X20
#define HDMI_RX_H_RES_CHANGE 0X10
#define HDMI_RX_I_P_CHANGE 0X08
#define HDMI_RX_DP_CHANGE 0X04
#define HDMI_RX_COLOR_DEPTH_CHANGE 0X02
#define HDMI_RX_COLOR_MODE_CHANGE 0X01

#define HDMI_RX_INT_STATUS5_REG 0X35
#define HDMI_RX_VFIFO_OVERFLOW 0X80
#define HDMI_RX_VFIFO_UNDERFLOW 0X40
#define HDMI_RX_ACR_CTS 0X20
#define HDMI_RX_ACR_N 0X10
#define HDMI_RX_CTS_N_ERR 0X08
#define HDMI_RX_APACKET_ECC_ERR 0X04
#define HDMI_RX_NO_AVI 0X02
#define HDMI_RX_AUDIO_RCV 0X01

#define HDMI_RX_INT_STATUS6_REG 0X36
#define HDMI_RX_CTS_RCV 0X80
#define HDMI_RX_NEW_UNR_PKT 0X40
#define HDMI_RX_NEW_MPEG 0X20
#define HDMI_RX_NEW_AUD 0X10
#define HDMI_RX_NEW_SPD 0X08
#define HDMI_RX_NEW_ACP 0X04
#define HDMI_RX_NEW_AVI 0X02
#define HDMI_RX_NEW_CP  0X01

#define HDMI_RX_INT_STATUS7_REG 0X37
#define HDMI_RX_REF_CLK_CHG 0X04
#define HDMI_RX_CEC_RX_READY 0X02
#define HDMI_RX_CEC_TX_DONE 0X01

#define HDMI_RX_ECC_CTRL_REG 0X3E

#define HDMI_RX_PACKET_RECEIVING_INDUCED_INT_CTRL_REG 0X3F
#define HDMI_RX_NEW_UNR 0X40
#define HDMI_RX_NEW_MPEG 0X20
#define HDMI_RX_NEW_AUD 0X10
#define HDMI_RX_NEW_SPD 0X08
#define HDMI_RX_NEW_ACP 0X04
#define HDMI_RX_NEW_AVI 0X02

#define HDMI_RX_INT_CTRL_REG 0X40
#define HDMI_RX_SOFT_INTR 0X04
#define HDMI_RX_INTR_TYPE 0X02
#define HDMI_RX_INTR_POL  0X01

#define HDMI_RX_INT_MASK1_REG 0X41
#define HDMI_RX_INT_MASK2_REG 0X42
#define HDMI_RX_INT_MASK3_REG 0X43
#define HDMI_RX_INT_MASK4_REG 0X44
#define HDMI_RX_INT_MASK5_REG 0X45
#define HDMI_RX_INT_MASK6_REG 0X46
#define HDMI_RX_INT_MASK7_REG 0X47

#define HDMI_RX_TMDS_P0_EQ_REG 0X50
#define HDMI_RX_TMDS_P1_EQ_REG 0X51
#define HDMI_RX_TMDS_EQ2_REG 0X52

#define HDMI_RX_TMDS_EQ_VCOM_REG 0X53
#define HDMI_RX_HI_BOOST 0X20
#define HDMI_RX_EQCOM_BYPASS 0X10

#define HDMI_RX_TMDS_RX_TERMINATION_CTRL_REG 0X54
#define HDMI_RX_CLK_TEST_EN 0X08

#define HDMI_RX_TMDS_PLL_CTRL1_REG 0X55
#define HDMI_RX_CPREG_BLEED 0X20

#define HDMI_RX_TMDS_PLL_CTRL2_REG 0X56

#define HDMI_RX_TMDS_DLL_CTRL_REG 0X57
#define HDMI_RX_CH2_DLL_HSP_TH 0X20
#define HDMI_RX_CH2_DLL_LSP_TH 0X10
#define HDMI_RX_CH1_DLL_HSP_TH 0X08
#define HDMI_RX_CH1_DLL_LSP_TH 0X04
#define HDMI_RX_CH0_DLL_HSP_TH 0X02
#define HDMI_RX_CH0_DLL_LSP_TH 0X01

#define HDMI_RX_TMDS_MANUAL_CTRL_REG 0X58
#define HDMI_RX_MAN_RST 0X08
#define HDMI_RX_PLL_RST 0X04
#define HDMI_RX_DLL_RST 0X02
#define HDMI_RX_PLL_DONE 0X01

#define HDMI_RX_TMDS_TEST_CTRL_REG 0X59
#define HDMI_RX_PLL_TEST_EN 0X08
#define HDMI_RX_DLL_CH2_TEST_EN 0X04
#define HDMI_RX_DLL_CH1_TEST_EN 0X02
#define HDMI_RX_DLL_CH0_TEST_EN 0X01

#define HDMI_RX_TMDS_DEBUG_REG 0X5A
#define HDMI_RX_SEL_DVDD 0X80
#define HDMI_RX_BG_SEL 0X10

#define HDMI_RX_TMDS_PLL_RANGE_CTRL_REG 0X5B
#define HDMI_RX_MISC_LONG_TIMER 0X80
#define HDMI_RX_MAN_RNG 0X10
#define HDMI_RX_PLL_RNG 0X08
#define HDMI_RX_CH2_DLL_RNG 0X04
#define HDMI_RX_CH1_DLL_RNG 0X02
#define HDMI_RX_CH0_DLL_RNG 0X01

#define HDMI_RX_TMDS_PLL_RNG_STATUS_REG 0X5C
#define HDMI_RX_AUTO_PLL_TH 0X80
#define HDMI_RX_AUTO_DLL_TH 0X40
#define HDMI_RX_PLL_LOCK 0X20
#define HDMI_RX_DLL_LOCK 0X10
#define HDMI_RX_PLL_HSPO 0X08
#define HDMI_RX_CH2_DLL_HSPO 0X04
#define HDMI_RX_CH1_DLL_HSPO 0X02
#define HDMI_RX_CH0_DLL_HSPO 0X01

#define HDMI_RX_TMDS_PLL_PCLK_STATUS_REG 0X5D

#define HDMI_RX_TMDS_CLK_TEST_REG 0X5E
#define HDMI_RX_TMDS_CLK_SEL 0X40
#define HDMI_RX_SEL_FBC 0X20
#define HDMI_RX_TESTCK_EN 0X10

#define HDMI_RX_TMDS_SWING_DET_REG 0X5F
#define HDMI_RX_SWDET_PD 0X20
#define HDMI_RX_SWDET_RST 0X10
#define HDMI_RX_SWING_DET 0X01

#define HDMI_RX_TIMING_LOOP_CNFG1_REG 0X60

#define HDMI_RX_TIMING_LOOP_CNFG2_REG 0X61
#define HDMI_RX_INV_PHASE 0X08
#define HDMI_RX_PHASE_EN 0X04
#define HDMI_RX_SNDLOOP_OFF 0X02

#define HDMI_RX_TMDS_CH0_SYNC_STATUS_REG 0X62
#define HDMI_RX_TMDS_CH1_SYNC_STATUS_REG 0X63
#define HDMI_RX_TMDS_CH2_SYNC_STATUS_REG 0X64

#define HDMI_RX_TMDS_CH_ALIGNMENT_STATUS_REG 0X65

#define HDMI_RX_ECC_ERR_CNT_REG 0X66
#define HDMI_RX_CAP_CNT 0X80

#define HDMI_RX_REF_CLK_MONITOR_REG 0X67
#define HDMI_RX_MON_REF_CLK 0X80
#define HDMI_RX_MON_REF_CLK_MODE 0X40

#define HDMI_RX_VIDEO_STATUS_REG 0X70
#define HDMI_RX_DEFAULT_PHASE 0X08
#define HDMI_RX_VIDEO_TYPE 0X04
#define HDMI_RX_VSYNC_POL 0X02
#define HDMI_RX_HSYNC_POL 0X01

#define HDMI_RX_H_RESL_REG 0X71
#define HDMI_RX_H_RESH_REG 0X72
#define HDMI_RX_V_RESL_REG 0X73
#define HDMI_RX_V_RESH_REG 0X74

#define HDMI_RX_DE_PIXL_REG 0X75
#define HDMI_RX_DE_PIXH_REG 0X76
#define HDMI_RX_DE_LINL_REG 0X77
#define HDMI_RX_DE_LINH_REG 0X78

#define HDMI_RX_VSYNC_TO_ACTIVE_LIN_REG 0X79
#define HDMI_RX_ACTIVE_LIN_TO_VSYNC_REG 0X7A
#define HDMI_RX_H_FRONT_PORCH_REG 0X7B
#define HDMI_RX_HSYNC_ACTIVE_WIDTHL_REG 0X7C
#define HDMI_RX_HSYNC_ACTIVE_WIDTHH_REG 0X7D

#define HDMI_RX_VIDEO_MODE1_REG 0X80
#define HDMI_RX_CSC_BT709_EN 0X10
#define HDMI_RX_RANGE_Y2R 0X08
#define HDMI_RX_CSPACE_Y2R 0X04
#define HDMI_RX_RANGE_R2Y 0X02
#define HDMI_RX_CSPACE_R2Y 0X01

#define HDMI_RX_VIDEO_MODE2_REG 0X81
#define HDMI_RX_VID_DS_MODE 0X08
#define HDMI_RX_VID_US_MODE 0X04
#define HDMI_RX_UP_SAMPLE 0X02
#define HDMI_RX_DOWN_SAMPLE 0X01

#define HDMI_RX_VID_PROCESSING_CTRL_REG 0X82
#define HDMI_RX_BRU_EN 0X80
#define HDMI_RX_BRU_RND_DIR 0X10
#define HDMI_RX_BACK_PORCH_MODE 0X04
#define HDMI_RX_DE_DELAY 0X02
#define HDMI_RX_INV_FIELD 0X01

#define HDMI_RX_VID_DATA_RNG_CTRL_REG 0X83
#define HDMI_RX_YC_LIMT 0X10
#define HDMI_RX_OUTPUT_LIMIT_EN 0X08
#define HDMI_RX_OUTPUT_LIMIT_RANGE 0X04
#define HDMI_RX_R2Y_INPUT_LIMIT 0X02
#define HDMI_RX_XVYCC_LIMIT 0X01

#define HDMI_RX_VID_OUTPUT_CTRL1_REG 0X84
#define HDMI_RX_INV_VSYNC 0X80
#define HDMI_RX_INV_HSYNC 0X40
#define HDMI_RX_CLK48B_POL 0X20
#define HDMI_RX_EMBED_SYNC 0X02
#define HDMI_RX_MUX_YC 0X01

#define HDMI_RX_VID_OUTPUT_CTRL2_REG 0X85
#define HDMI_RX_BIT_SWAP 0X08
#define HDMI_RX_BUS_MODE 0X04
#define HDMI_RX_O_YC422 0X02
#define HDMI_RX_O_YCBCR 0X01

#define HDMI_RX_VID_DDR_OUTPUT_CTRL_REG 0X86
#define HDMI_RX_O_DDR_POL 0X10
#define HDMI_RX_O_DDR_REV 0X02
#define HDMI_RX_O_DDR_MODE 0X01

#define HDMI_RX_CH1_VID_BLANK_REG 0X87
#define HDMI_RX_CH2_VID_BLANK_REG 0X88
#define HDMI_RX_CH3_VID_BLANK_REG 0X89

#define HDMI_RX_VID_CH_MAP_REG 0X8A

#define HDMI_RX_VID_PCLK_CNTR_REG 0X8B

#define HDMI_RX_ACR_CTRL1_REG 0XA0
#define HDMI_RX_DSM_MODE_SEL 0X80
#define HDMI_RX_CTS_SEL 0X10
#define HDMI_RX_N_SEL 0X08
#define HDMI_RX_LPF_SEL 0X04
#define HDMI_RX_N_FIX_MODE 0X02
#define HDMI_RX_MCLK_SEL 0X01

#define HDMI_RX_ACR_CTRL2_REG 0XA1

#define HDMI_RX_ACR_AUD_FS_REG 0XA2

#define HDMI_RX_ACR_N_SOFTWARE_VALUE1_REG 0XA3
#define HDMI_RX_ACR_N_SOFTWARE_VALUE2_REG 0XA4
#define HDMI_RX_ACR_N_SOFTWARE_VALUE3_REG 0XA5

#define HDMI_RX_ACR_N_HARDWARE_VALUE1_REG 0XA6
#define HDMI_RX_ACR_N_HARDWARE_VALUE2_REG 0XA7
#define HDMI_RX_ACR_N_HARDWARE_VALUE3_REG 0XA8

#define HDMI_RX_ACR_CTS_SOFTWARE_VALUE1_REG 0XA9
#define HDMI_RX_ACR_CTS_SOFTWARE_VALUE2_REG 0XAA
#define HDMI_RX_ACR_CTS_SOFTWARE_VALUE3_REG 0XAB

#define HDMI_RX_ACR_CTS_HARDWARE_VALUE1_REG 0XAC
#define HDMI_RX_ACR_CTS_HARDWARE_VALUE2_REG 0XAD
#define HDMI_RX_ACR_CTS_HARDWARE_VALUE3_REG 0XAE

#define HDMI_RX_ACR_FRACTIONAL_INTEGER_PORTION_REG 0XAF
#define HDMI_RX_ACR_FRACTIONAL_INTEGER_PORTION1_REG 0XB0
#define HDMI_RX_ACR_FRACTIONAL_INTEGER_PORTION2_REG 0XB1
#define HDMI_RX_ACR_FRACTIONAL_INTEGER_PORTION3_REG 0XB2

#define HDMI_RX_ACR_PLL_DEBUG1_REG 0XB3
#define HDMI_RX_TEST_EN 0X08

#define HDMI_RX_ACR_PLL_DEBUG2_REG 0XB4
#define HDMI_RX_CP_REG_CTRL 0X10
#define HDMI_RX_AUD_PLL_RST 0X01

#define HDMI_RX_ACR_CTRL3_REG 0XB5
#define HDMI_RX_AUTO_CTS_EN 0X10

#define HDMI_RX_ACR_HARDWARE_EXTRACTED_FS_REG 0XB6
#define HDMI_RX_CTS_ADJUST_STEP_REG 0XB7 
#define HDMI_RX_CTS_ADJUST_INTERVAL_REG 0XB8
#define HDMI_RX_DELTA_CTS_REG 0XB9

#define HDMI_RX_AUD_SAMPLE_CNTR1_REG 0XBA
#define HDMI_RX_AUD_SAMPLE_CNTR2_REG 0XBB

#define HDMI_RX_CLK_RNG_OFFSET_REG 0XBC

#define HDMI_RX_CLK_RNG_CNTR1_REG 0XBD
#define HDMI_RX_K1_SEL 0X80
#define HDMI_RX_CLK_RNG_SEL 0X08

#define HDMI_RX_CLK_RNG_CNTR2_REG 0XBE

#define HDMI_RX_ACR_DEBUG_REG 0XBF

#define HDMI_RX_MCLK_FREQUENCY_CNTR_REG 0XC0
#define HDMI_RX_DSD_MUTE_PATTERN_REG 0XC1

#define HDMI_RX_DSD_AUD_CTRL_REG 0XC2
#define HDMI_RX_DSD_MODE 0X02
#define HDMI_RX_DSD_SCK_EDGE 0X01

#define HDMI_RX_AUD_OUT_I2S_CTRL1_REG 0XC3
#define HDMI_RX_SCK_EDGE 0X40
#define HDMI_RX_SIZE_SEL 0X20
#define HDMI_RX_MSB_SIGN_EXT 0X10
#define HDMI_RX_WS_POL 0X08
#define HDMI_RX_JUST_CTRL 0X04
#define HDMI_RX_DIR_CTRL 0X02
#define HDMI_RX_SHIFT1 0X01

#define HDMI_RX_AUD_OUT_I2S_CTRL2_REG 0XC4
#define HDMI_RX_SD3_EN 0X80
#define HDMI_RX_SD2_EN 0X40
#define HDMI_RX_SD1_EN 0X20
#define HDMI_RX_SD0_EN 0X10
#define HDMI_RX_MCLK_EN 0X08
#define HDMI_RX_VUCP_EN 0X02
#define HDMI_RX_PCM_DET 0X01

#define HDMI_RX_AUD_OUT_I2S_MAP_REG 0XC5

#define HDMI_RX_AUDIO_OUT_CTRL_REG 0XC6
#define HDMI_RX_LENOV 0X80
#define HDMI_RX_HBR_CHST_MODE 0X40
#define HDMI_RX_SOFT_MUTE_EN 0X20
#define HDMI_RX_PASS_SPDIF_ERR 0X10
#define HDMI_RX_PASS_AUDIO_ERR 0X08
#define HDMI_RX_I2S_MODE 0X04
#define HDMI_RX_SP_MODE 0X02 
#define HDMI_RX_SP_EN 0X01

#define HDMI_RX_AUD_IN_SPDIF_CH_STATUS1_REG 0XC7
#define HDMI_RX_SW_CPRGT 0X04
#define HDMI_RX_NON_PCM 0X02
#define HDMI_RX_PROF_APP 0X01

#define HDMI_RX_AUD_IN_SPDIF_CH_STATUS2_REG 0XC8
#define HDMI_RX_AUD_IN_SPDIF_CH_STATUS3_REG 0XC9
#define HDMI_RX_AUD_IN_SPDIF_CH_STATUS4_REG 0XCA
#define HDMI_RX_AUD_IN_SPDIF_CH_STATUS5_REG 0XCB

#define HDMI_RX_AUD_SWAP_OVERWRITE_REG 0XCC
#define HDMI_RX_SW3 0X80
#define HDMI_RX_SW2 0X40
#define HDMI_RX_SW1 0X20
#define HDMI_RX_SW0 0X10
#define HDMI_RX_OW_B2 0X04
#define HDMI_RX_OW_CHEN 0X01

#define HDMI_RX_AUD_CHST5_OVERWRITE_REG 0XCD
#define HDMI_RX_AUD_CH_MUTE_REG 0XCE
#define HDMI_RX_CH3_MU 0X08
#define HDMI_RX_CH2_MU 0X04
#define HDMI_RX_CH1_MU 0X02
#define HDMI_RX_CH0_MU 0X01

#define HDMI_RX_CEC_CTRL_REG 0XD0
#define HDMI_RX_CEC_RX_EN 0X08
#define HDMI_RX_CEC_TX_ST 0X04
#define HDMI_RX_CEC_PIN_SEL 0X02
#define HDMI_RX_CEC_RST 0X01

#define HDMI_RX_CEC_RX_STATUS_REG 0XD1
#define HDMI_RX_CEC_RX_BUSY 0X80
#define HDMI_RX_CEC_RX_FULL 0X20
#define HDMI_RX_CEC_RX_EMP 0X10

#define HDMI_RX_CEC_TX_STATUS_REG 0XD2
#define HDMI_RX_CEC_TX_BUSY 0X80
#define HDMI_RX_CEC_TX_FAIL 0X40
#define HDMI_RX_CEC_TX_FULL 0X20
#define HDMI_RX_CEC_TX_EMP 0X10

#define HDMI_RX_CEC_FIFO_REG 0XD3

#define HDMI_RX_CEC_SPEED_CTRL_REG 0XD4

#define HDMI_RX_TMDS_PRBS_TEST_REG 0XE0
#define HDMI_RX_PRBS_TEST_EN 0X80

#define HDMI_RX_HDMI_CRITERIA_REG 0XE1

#define HDMI_RX_HDCP_EN_CRITERIA_REG 0XE2
#define HDMI_RX_ENC_EN_MODE 0X20

#define HDMI_RX_CHIP_CTRL_REG 0XE3
#define HDMI_RX_FIFO_START_METHOD 0X20
#define HDMI_RX_FIFO_AUTO_ADJ 0X10
#define HDMI_RX_MAN_HDMI5V_DET 0X08
#define HDMI_RX_PLLLOCK_CKDT_EN 0X04
#define HDMI_RX_ANALOG_CKDT_EN 0X02
#define HDMI_RX_DIGITAL_CKDT_EN 0X01

#define HDMI_RX_HARDWARE_REG 0XE4
#define HDMI_RX_MAN_OSCCLK_DET 0X80
#define HDMI_RX_CHIP_DEBUG_SEL 0X40
#define HDMI_RX_CHIP_DEBUG_EN 0X20
#define HDMI_RX_AUD_FIFO_ENFORCE 0X10

#define HDMI_RX_AUD_SOFTMUTE_CTRL_REG 0XE5
#define HDMI_RX_UNMUTE_CTRL_EN 0X40
#define HDMI_RX_UNMUTE_ON_VSYNC 0X20
#define HDMI_RX_UNMUTE_ON_DE 0X10
#define HDMI_RX_MUTE_DOWN_INT_ON_UNMUTE 0X08

#define HDMI_RX_AUD_FIFO_CTRL_REG 0XE6

#define HDMI_RX_AUD_FIFO_CTRL2_REG 0XE7

#define HDMI_RX_PACKET_DECODE_CTRL_REG 0XE8
#define HDMI_RX_AUTO_STOP_DEC_ON_HDCPERR 0X02
#define HDMI_RX_STOP_DEC 0X01

#define HDMI_RX_HDCP_KEY_STATUS_REG 0XE9
#define HDMI_RX_BIST_ERR 0X02
#define HDMI_RX_CMD_DONE 0X01

#define HDMI_RX_HDCP_KEY_COMMAND_REG 0XEA 
#define HDMI_RX_AUTO_BIST 0X80

#define HDMI_RX_DEEP_COLOR_DEBUG_REG 0XEB
#define HDMI_RX_VFIFO_OVERFLOW 0X80
#define HDMI_RX_VFIFO_UNDERFLOW 0X40
#define HDMI_RX_VFIFO_TMDS_PHASE_MATCH 0X20
#define HDMI_RX_VFIFO_SYNC_ERR 0X10

#define HDMI_RX_DEEP_COLOR_CTRL_REG 0XEC
#define HDMI_RX_EN_MAN_DEEP_COLOR 0X08

#define HDMI_RX_VID_DEBUG_REG 0XED
#define HDMI_RX_MAN_DEF_PHASE 0X08
#define HDMI_RX_MAN_DEF_PHASE_VAL 0X04

#define HDMI_RX_EEPROM_KEY_PROTECT1_REG 0XF9
#define HDMI_RX_EEPROM_KEY_PROTECT2_REG 0XFA
#define HDMI_RX_EEPROM_KEY_PROTECT3_REG 0XFB

#define HDMI_RX_EEPROM_ACCESS_CNFG_REG 0XFC
#define HDMI_RX_RW_ROM_ADDR8 0X80
#define HDMI_RX_ROM_RW_DONE 0X10
#define HDMI_RX_ROM_BIST_EN 0X08
#define HDMI_RX_ROM_WRITE_EN 0X04
#define HDMI_RX_ROM_READ_EN 0X02
#define HDMI_RX_EESK_MODE 0X01

#define HDMI_RX_EEPROM_RW_ADDR_REG 0XFD

#define HDMI_RX_EEPROM_READ_DATA_REG 0XFE
#define HDMI_RX_EEPROM_WRITE_DATA_REG 0XFF

//0X68/0X6A
#define HDMI_RX_HDCP_BKSV_SHADOW1_REG 0X00
#define HDMI_RX_HDCP_BKSV_SHADOW2_REG 0X01
#define HDMI_RX_HDCP_BKSV_SHADOW3_REG 0X02
#define HDMI_RX_HDCP_BKSV_SHADOW4_REG 0X03
#define HDMI_RX_HDCP_BKSV_SHADOW5_REG 0X04

#define HDMI_RX_HDCP_RI_SHADOW1_REG 0X05
#define HDMI_RX_HDCP_RI_SHADOW2_REG 0X06

#define HDMI_RX_HDCP_PJ_SHADOW_REG 0X07
#define HDMI_RX_HDCP_AKSV_SHADOW1_REG 0X08
#define HDMI_RX_HDCP_AKSV_SHADOW2_REG 0X09
#define HDMI_RX_HDCP_AKSV_SHADOW3_REG 0X0A
#define HDMI_RX_HDCP_AKSV_SHADOW4_REG 0X0B
#define HDMI_RX_HDCP_AKSV_SHADOW5_REG 0X0C

#define HDMI_RX_HDCP_AINFO_SHADOW_REG 0X0D
#define HDMI_RX_11EN 0X02

#define HDMI_RX_HDCP_AN_SHADOW1_REG 0X0E
#define HDMI_RX_HDCP_AN_SHADOW2_REG 0X0F
#define HDMI_RX_HDCP_AN_SHADOW3_REG 0X10
#define HDMI_RX_HDCP_AN_SHADOW4_REG 0X11
#define HDMI_RX_HDCP_AN_SHADOW5_REG 0X12
#define HDMI_RX_HDCP_AN_SHADOW6_REG 0X13
#define HDMI_RX_HDCP_AN_SHADOW7_REG 0X14
#define HDMI_RX_HDCP_AN_SHADOW8_REG 0X15

#define HDMI_RX_DOWNSTREAM_VH0_0_REG 0X16
#define HDMI_RX_DOWNSTREAM_VH0_1_REG 0X17
#define HDMI_RX_DOWNSTREAM_VH0_2_REG 0X18
#define HDMI_RX_DOWNSTREAM_VH0_3_REG 0X19
#define HDMI_RX_DOWNSTREAM_VH1_0_REG 0X1A
#define HDMI_RX_DOWNSTREAM_VH1_1_REG 0X1B
#define HDMI_RX_DOWNSTREAM_VH1_2_REG 0X1C
#define HDMI_RX_DOWNSTREAM_VH1_3_REG 0X1D
#define HDMI_RX_DOWNSTREAM_VH2_0_REG 0X1E
#define HDMI_RX_DOWNSTREAM_VH2_1_REG 0X1F
#define HDMI_RX_DOWNSTREAM_VH2_2_REG 0X20
#define HDMI_RX_DOWNSTREAM_VH2_3_REG 0X21
#define HDMI_RX_DOWNSTREAM_VH3_0_REG 0X22
#define HDMI_RX_DOWNSTREAM_VH3_1_REG 0X23
#define HDMI_RX_DOWNSTREAM_VH3_2_REG 0X24
#define HDMI_RX_DOWNSTREAM_VH3_3_REG 0X25
#define HDMI_RX_DOWNSTREAM_VH4_0_REG 0X26
#define HDMI_RX_DOWNSTREAM_VH4_1_REG 0X27
#define HDMI_RX_DOWNSTREAM_VH4_2_REG 0X28
#define HDMI_RX_DOWNSTREAM_VH4_3_REG 0X29

#define HDMI_RX_HDCP_BCAPS_SHADOW_REG 0X2A
#define HDMI_RX_HDMI_CAP 0X80
#define HDMI_RX_REPERTER 0X40
#define HDMI_RX_READY 0X20
#define HDMI_RX_FAST 0X10
#define HDMI_RX_11FEATURE 0X02
#define HDMI_RX_FAST_REAUTH 0X01

#define HDMI_RX_HDCP_BSTATUS_SHADOW1_REG 0X2B
#define HDMI_RX_DEV_EXC 0X80

#define HDMI_RX_HDCP_BSTATUS_SHADOW2_REG 0X2C
#define HDMI_RX_HDMI_MODE_IN_BSTATUS 0X10
#define HDMI_RX_CAS_EXC 0X08

#define HDMI_RX_HDCP_REPEATER_KSV_FIFO_REG 0X2D

#define HDMI_RX_DEVICE_IDENTIFICATION_SHADOW_REG 0X2E

#define HDMI_RX_HDCP_KSV_SHA_STARTL_REG 0X2F
#define HDMI_RX_HDCP_KSV_SHA_STARTH_REG 0X30

#define HDMI_RX_HDCP_SHA_LENGTHL_REG 0X31
#define HDMI_RX_HDCP_SHA_LENGTHH_REG 0X32

#define HDMI_RX_HDCP_SHA_CTRL_REG 0X33
#define HDMI_RX_SHA_MODE 0X02
#define HDMI_RX_SHA_GO 0X01

#define HDMI_RX_DOWNSTREAM_BSTATUSL_REG 0X34
#define HDMI_RX_DOWNSTREAM_BSTATUSH_REG 0X35

#define HDMI_RX_DOWNSTREAM_M0_0_REG 0X36
#define HDMI_RX_DOWNSTREAM_M0_1_REG 0X37
#define HDMI_RX_DOWNSTREAM_M0_2_REG 0X38
#define HDMI_RX_DOWNSTREAM_M0_3_REG 0X39
#define HDMI_RX_DOWNSTREAM_M0_4_REG 0X3A
#define HDMI_RX_DOWNSTREAM_M0_5_REG 0X3B
#define HDMI_RX_DOWNSTREAM_M0_6_REG 0X3C
#define HDMI_RX_DOWNSTREAM_M0_7_REG 0X3D

#define HDMI_RX_HDCP_DEBUG_REG 0X3E
#define HDMI_RX_STOPHDCP 0X80
#define HDMI_RX_BYPASSHDCP 0X40
#define HDMI_RX_KEY_MODE 0X20
#define HDMI_RX_DDC_DLY_EN 0X10

#define HDMI_RX_HDCP_STATUS_REG 0X3F
#define HDMI_RX_ADV_CIPHER 0X80
#define HDMI_RX_LOAD_KEY_DONE 0X40
#define HDMI_RX_DECRYPT 0X20
#define HDMI_RX_AUTHEN 0X10
#define HDMI_RX_BKSV_DISABLE 0X02
#define HDMI_RX_CLEAR_RI 0X01

#define HDMI_RX_SPD_TYPE_REG 0X40
#define HDMI_RX_SPD_VER_REG 0X41
#define HDMI_RX_SPD_LEN_REG 0X42
#define HDMI_RX_SPD_CHKSUM_REG 0X43
#define HDMI_RX_SPD_DATA00_REG 0X44
#define HDMI_RX_SPD_DATA01_REG 0X45
#define HDMI_RX_SPD_DATA02_REG 0X46
#define HDMI_RX_SPD_DATA03_REG 0X47
#define HDMI_RX_SPD_DATA04_REG 0X48
#define HDMI_RX_SPD_DATA05_REG 0X49
#define HDMI_RX_SPD_DATA06_REG 0X4A
#define HDMI_RX_SPD_DATA07_REG 0X4B
#define HDMI_RX_SPD_DATA08_REG 0X4C
#define HDMI_RX_SPD_DATA09_REG 0X4D
#define HDMI_RX_SPD_DATA0A_REG 0X4E
#define HDMI_RX_SPD_DATA0B_REG 0X4F
#define HDMI_RX_SPD_DATA0C_REG 0X50
#define HDMI_RX_SPD_DATA0D_REG 0X51
#define HDMI_RX_SPD_DATA0E_REG 0X52
#define HDMI_RX_SPD_DATA0F_REG 0X53
#define HDMI_RX_SPD_DATA10_REG 0X54
#define HDMI_RX_SPD_DATA11_REG 0X55
#define HDMI_RX_SPD_DATA12_REG 0X56
#define HDMI_RX_SPD_DATA13_REG 0X57
#define HDMI_RX_SPD_DATA14_REG 0X58
#define HDMI_RX_SPD_DATA15_REG 0X59
#define HDMI_RX_SPD_DATA16_REG 0X5A
#define HDMI_RX_SPD_DATA17_REG 0X5B
#define HDMI_RX_SPD_DATA18_REG 0X5C
#define HDMI_RX_SPD_DATA19_REG 0X5D
#define HDMI_RX_SPD_DATA1A_REG 0X5E

#define HDMI_RX_ACP_HB0_REG 0X60
#define HDMI_RX_ACP_HB1_REG 0X61
#define HDMI_RX_ACP_HB2_REG 0X62
#define HDMI_RX_ACP_DATA00_REG 0X63
#define HDMI_RX_ACP_DATA01_REG 0X64
#define HDMI_RX_ACP_DATA02_REG 0X65
#define HDMI_RX_ACP_DATA03_REG 0X66
#define HDMI_RX_ACP_DATA04_REG 0X67
#define HDMI_RX_ACP_DATA05_REG 0X68
#define HDMI_RX_ACP_DATA06_REG 0X69
#define HDMI_RX_ACP_DATA07_REG 0X6A
#define HDMI_RX_ACP_DATA08_REG 0X6B
#define HDMI_RX_ACP_DATA09_REG 0X6C
#define HDMI_RX_ACP_DATA0A_REG 0X6D
#define HDMI_RX_ACP_DATA0B_REG 0X6E
#define HDMI_RX_ACP_DATA0C_REG 0X6F
#define HDMI_RX_ACP_DATA0D_REG 0X70
#define HDMI_RX_ACP_DATA0E_REG 0X71
#define HDMI_RX_ACP_DATA0F_REG 0X72
#define HDMI_RX_ACP_DATA10_REG 0X73
#define HDMI_RX_ACP_DATA11_REG 0X74
#define HDMI_RX_ACP_DATA12_REG 0X75
#define HDMI_RX_ACP_DATA13_REG 0X76
#define HDMI_RX_ACP_DATA14_REG 0X77
#define HDMI_RX_ACP_DATA15_REG 0X78
#define HDMI_RX_ACP_DATA16_REG 0X79
#define HDMI_RX_ACP_DATA17_REG 0X7A
#define HDMI_RX_ACP_DATA18_REG 0X7B
#define HDMI_RX_ACP_DATA19_REG 0X7C
#define HDMI_RX_ACP_DATA1A_REG 0X7D
#define HDMI_RX_ACP_DATA1B_REG 0X7E

#define HDMI_RX_UNRECOGNIZED_PACKET_REG 0X80

#define HDMI_RX_AVI_TYPE_REG 0XA0
#define HDMI_RX_AVI_VER_REG 0XA1
#define HDMI_RX_AVI_LEN_REG 0XA2
#define HDMI_RX_AVI_CHKSUM_REG 0XA3
#define HDMI_RX_AVI_DATA00_REG 0XA4
#define HDMI_RX_AVI_DATA01_REG 0XA5
#define HDMI_RX_AVI_DATA02_REG 0XA6
#define HDMI_RX_AVI_DATA03_REG 0XA7
#define HDMI_RX_AVI_DATA04_REG 0XA8
#define HDMI_RX_AVI_DATA05_REG 0XA9
#define HDMI_RX_AVI_DATA06_REG 0XAA
#define HDMI_RX_AVI_DATA07_REG 0XAB
#define HDMI_RX_AVI_DATA08_REG 0XAC
#define HDMI_RX_AVI_DATA09_REG 0XAD
#define HDMI_RX_AVI_DATA0A_REG 0XAE
#define HDMI_RX_AVI_DATA0B_REG 0XAF
#define HDMI_RX_AVI_DATA0C_REG 0XB0
#define HDMI_RX_AVI_DATA0D_REG 0XB1
#define HDMI_RX_AVI_DATA0E_REG 0XB2

#define HDMI_RX_AUDIO_TYPE_REG 0XC0
#define HDMI_RX_AUDIO_VER_REG 0XC1
#define HDMI_RX_AUDIO_LEN_REG 0XC2
#define HDMI_RX_AUDIO_CHKSUM_REG 0XC3
#define HDMI_RX_AUDIO_DATA00_REG 0XC4
#define HDMI_RX_AUDIO_DATA01_REG 0XC5
#define HDMI_RX_AUDIO_DATA02_REG 0XC6
#define HDMI_RX_AUDIO_DATA03_REG 0XC7
#define HDMI_RX_AUDIO_DATA04_REG 0XC8
#define HDMI_RX_AUDIO_DATA05_REG 0XC9
#define HDMI_RX_AUDIO_DATA06_REG 0XCA
#define HDMI_RX_AUDIO_DATA07_REG 0XCB
#define HDMI_RX_AUDIO_DATA08_REG 0XCC
#define HDMI_RX_AUDIO_DATA09_REG 0XCD
#define HDMI_RX_AUDIO_DATA0A_REG 0XCE
#define HDMI_RX_AUDIO_DATA0B_REG 0XCF
#define HDMI_RX_AUDIO_DATA0C_REG 0XD0
#define HDMI_RX_AUDIO_DATA0D_REG 0XD1
#define HDMI_RX_AUDIO_DATA0E_REG 0XD2
#define HDMI_RX_AUDIO_DATA0F_REG 0XD3
#define HDMI_RX_AUDIO_DATA10_REG 0XD4
#define HDMI_RX_AUDIO_DATA11_REG 0XD5
#define HDMI_RX_AUDIO_DATA12_REG 0XD6
#define HDMI_RX_AUDIO_DATA13_REG 0XD6
#define HDMI_RX_AUDIO_DATA14_REG 0XD7
#define HDMI_RX_AUDIO_DATA15_REG 0XD9
#define HDMI_RX_AUDIO_DATA16_REG 0XDA
#define HDMI_RX_AUDIO_DATA17_REG 0XDB
#define HDMI_RX_AUDIO_DATA18_REG 0XDC
#define HDMI_RX_AUDIO_DATA19_REG 0XDD

#define HDMI_RX_MPEG_TYPE_REG 0XE0
#define HDMI_RX_MPEG_VER_REG 0XE1
#define HDMI_RX_MPEG_LEN_REG 0XE2
#define HDMI_RX_MPEG_CHKSUM_REG 0XE3
#define HDMI_RX_MPEG_DATA00_REG 0XE4
#define HDMI_RX_MPEG_DATA01_REG 0XE5
#define HDMI_RX_MPEG_DATA02_REG 0XE6
#define HDMI_RX_MPEG_DATA03_REG 0XE7
#define HDMI_RX_MPEG_DATA04_REG 0XE8
#define HDMI_RX_MPEG_DATA05_REG 0XE9
#define HDMI_RX_MPEG_DATA06_REG 0XEA
#define HDMI_RX_MPEG_DATA07_REG 0XEB
#define HDMI_RX_MPEG_DATA08_REG 0XEC
#define HDMI_RX_MPEG_DATA09_REG 0XED
#define HDMI_RX_MPEG_DATA0A_REG 0XEF
#define HDMI_RX_MPEG_DATA0B_REG 0XF0
#define HDMI_RX_MPEG_DATA0C_REG 0XF1
#define HDMI_RX_MPEG_DATA0D_REG 0XF2
#define HDMI_RX_MPEG_DATA0E_REG 0XF3
#define HDMI_RX_MPEG_DATA0F_REG 0XF4
#define HDMI_RX_MPEG_DATA10_REG 0XF5
#define HDMI_RX_MPEG_DATA11_REG 0XF6
#define HDMI_RX_MPEG_DATA12_REG 0XF7
#define HDMI_RX_MPEG_DATA13_REG 0XF8
#define HDMI_RX_MPEG_DATA14_REG 0XF9
#define HDMI_RX_MPEG_DATA15_REG 0XFA
#define HDMI_RX_MPEG_DATA16_REG 0XFB
#define HDMI_RX_MPEG_DATA17_REG 0XFC
#define HDMI_RX_MPEG_DATA18_REG 0XFD
#define HDMI_RX_MPEG_DATA19_REG 0XFE

#define HDMI_RX_SPD_INFO_PACKET_CTRL_REG 0X5F
#define HDMI_RX_ACP_INFO_PACKET_CTRL_REG 0X7F
#define HDMI_RX_GENERAL_CTRL_REG 0X9F
#define HDMI_RX_MPEG_INFO_PACKET_CTRL_REG 0XFF




//*************************************************************


#endif

