#!/usr/bin/awk -f
#
# $Id: zddevlist.awk,v 1.1 2005/04/15 22:34:32 sagamore Exp $
#
# Copyright (C) 2005 Roman Kurakin <sagamore@sourceforge.net>
#
# This file is part of the ZD1211 Wireless USB Driver for Linux.
#
# This driver is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This driver is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this driver; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

BEGIN {
	nproducts = 0;
	nvendors = 0;
}
NR == 1 {
	printf "/*\n"
	printf " * This is auto generated file, do not edit manualy.\n"
	printf " *\n"
	printf " * Source file version:\n"
	printf " *\t" $0 "\n"
	printf " */\n"
	next
}
{
	gsub ("#.*$", "");
}
$1 == "vendor" {
	nvendors++
	if (match ($2, "^[[:alnum:]]+$") == 0 ||
	    match ($3, "^0[xX][[:xdigit:]][[:xdigit:]][[:xdigit:]][[:xdigit:]]$") == 0 ||
	    match ($4, "[^[:space:]]+") == 0) {
		printf "#error \"Error in source file, line " NR "\"\n"
		exit 1
	}
	vendor_index [$2] = nvendors
	vendors [nvendors, 1] = $2
	vendors [nvendors, 2] = $3
	vendors [nvendors, 3] = $4
	next
}
$1 == "product" {
	nproducts++
	if (match ($2, "^[[:alnum:]]+$") == 0 ||
	    match ($3, "^[[:alnum:]]+$") == 0 ||
	    match ($4, "^0[xX][[:xdigit:]][[:xdigit:]][[:xdigit:]][[:xdigit:]]$") == 0 ||
	    match ($5, "[^[:space:]]+") == 0) {
		printf "#error \"Error in source file, line " NR "\"\n"
		exit 1
	}
	products [nproducts, 1] = $2
	products [nproducts, 2] = $3
	products [nproducts, 3] = $4
	desc = $0
	sub("^[[:space:]]*" $1, "", desc)
	sub("^[[:space:]]+" $2, "", desc)
	sub("^[[:space:]]+" $3, "", desc)
	sub("^[[:space:]]+" $4, "", desc)
	sub("^[[:space:]]+", "", desc)
	products [nproducts, 4] = desc
	next
}
$1 == "" {
	next
}
{
	printf "#error \"Error in source file, line " NR "\"\n"
}
END {
	printf "\n"
	for (i = 1; i <= nvendors; i++) {
		printf "#define\tVENDOR_" vendors [i, 1] "\t" \
							vendors [i, 2] "\n"
	}
	printf "\n"
	for (i = 1; i <= nproducts; i++) {
		if (vendor_index [products [i, 1]] + 0 == 0) {
			printf "Unknow vendor \"" products [i, 1]
			printf "\"  for product \"" products [i, 2] "\"\n"
			exit 1
		}
		printf "#define\tPRODUCT_" products [i, 1] "_" \
				products [i, 2] "\t" products [i, 3] "\n"
	}
	printf "\n"
	printf "#define ZD1211_IDS \\\n"
	for (i = 1; i <= nproducts; i++) {
		printf "\t{ USB_DEVICE(VENDOR_" products [i, 1] ",\t"
		printf "PRODUCT_" products [i, 1] "_" products [i, 2] ") },\\\n"
	}
	printf "\t{ } /* Terminating entry */\n"
	printf "\n"
	printf "char * zd1211_ids_description [] = {\n"
	for (i = 1; i <= nproducts; i++) {
		printf "\t\"" products [i, 4] "\",\n"
	}
	printf "\tNULL /* Terminating entry */\n"
	printf "};\n"
}
