; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py

; RUN: llc -verify-machineinstrs -csky-no-aliases < %s -mtriple=csky -float-abi=hard -mattr=+hard-float -mattr=+2e3 -mattr=+fpuv2_sf -mattr=+fpuv2_df | FileCheck %s --check-prefix=CHECK-DF
; RUN: llc -verify-machineinstrs -csky-no-aliases < %s -mtriple=csky -float-abi=hard -mattr=+hard-float -mattr=+2e3 -mattr=+fpuv3_sf -mattr=+fpuv3_df | FileCheck %s --check-prefix=CHECK-DF2

define double @load_I_d(double* nocapture readonly %a) local_unnamed_addr #0 {
;
;
; CHECK-DF-LABEL: load_I_d:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    fldd vr0, (a0, 24)
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: load_I_d:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    fld.64 vr0, (a0, 24)
; CHECK-DF2-NEXT:    rts16
entry:
  %arrayidx = getelementptr inbounds double, double* %a, i64 3
  %0 = load double, double* %arrayidx, align 4
  ret double %0
}



define double @load_R_d(double* nocapture readonly %a, i32 %b) local_unnamed_addr #0 {
;
;
; CHECK-DF-LABEL: load_R_d:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    fldrd vr0, (a0, a1 << 3)
; CHECK-DF-NEXT:    rts16
;
; CHECK-DF2-LABEL: load_R_d:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    fldr.64 vr0, (a0, a1 << 3)
; CHECK-DF2-NEXT:    rts16
entry:
  %idxprom = sext i32 %b to i64
  %arrayidx = getelementptr inbounds double, double* %a, i64 %idxprom
  %0 = load double, double* %arrayidx, align 4
  ret double %0
}

define double @store_I_d(double*  %a, double %b) local_unnamed_addr #0 {
;
;
; CHECK-DF-LABEL: store_I_d:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    fstd vr0, (a0, 24)
; CHECK-DF-NEXT:    grs32 a0, .LCPI2_0
; CHECK-DF-NEXT:    fldd vr0, (a0, 0)
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.1:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI2_0:
; CHECK-DF-NEXT:    .quad 0x0000000000000000 # double 0
;
; CHECK-DF2-LABEL: store_I_d:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    fst.64 vr0, (a0, 24)
; CHECK-DF2-NEXT:    flrw.64 vr0, [.LCPI2_0]
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.1:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI2_0:
; CHECK-DF2-NEXT:    .quad 0x0000000000000000 # double 0
entry:
  %arrayidx = getelementptr inbounds double, double* %a, i64 3
  store double %b, double* %arrayidx, align 4
  ret double 0.0
}

define double @store_R_d(double*  %a, i32 %b, double %c) local_unnamed_addr #0 {
;
;
; CHECK-DF-LABEL: store_R_d:
; CHECK-DF:       # %bb.0: # %entry
; CHECK-DF-NEXT:    fstrd vr0, (a0, a1 << 3)
; CHECK-DF-NEXT:    grs32 a0, .LCPI3_0
; CHECK-DF-NEXT:    fldd vr0, (a0, 0)
; CHECK-DF-NEXT:    rts16
; CHECK-DF-NEXT:    .p2align 1
; CHECK-DF-NEXT:  # %bb.1:
; CHECK-DF-NEXT:    .p2align 2
; CHECK-DF-NEXT:  .LCPI3_0:
; CHECK-DF-NEXT:    .quad 0x0000000000000000 # double 0
;
; CHECK-DF2-LABEL: store_R_d:
; CHECK-DF2:       # %bb.0: # %entry
; CHECK-DF2-NEXT:    fstr.64 vr0, (a0, a1 << 3)
; CHECK-DF2-NEXT:    flrw.64 vr0, [.LCPI3_0]
; CHECK-DF2-NEXT:    rts16
; CHECK-DF2-NEXT:    .p2align 1
; CHECK-DF2-NEXT:  # %bb.1:
; CHECK-DF2-NEXT:    .p2align 2
; CHECK-DF2-NEXT:  .LCPI3_0:
; CHECK-DF2-NEXT:    .quad 0x0000000000000000 # double 0
entry:
  %idxprom = sext i32 %b to i64
  %arrayidx = getelementptr inbounds double, double* %a, i64 %idxprom
  store double %c, double* %arrayidx, align 4
  ret double 0.0
}
