; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=wasm32-unknown-unknown -mattr=+simd128,+nontrapping-fptoint | FileCheck %s

; i32 saturate

define <2 x i32> @stest_f64i32(<2 x double> %x) {
; CHECK-LABEL: stest_f64i32:
; CHECK:         .functype stest_f64i32 (v128) -> (v128)
; CHECK-NEXT:    .local v128
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 0
; CHECK-NEXT:    i64.trunc_sat_f64_s
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 1
; CHECK-NEXT:    i64.trunc_sat_f64_s
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    local.tee 0
; CHECK-NEXT:    v128.const 2147483647, 2147483647
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64x2.lt_s
; CHECK-NEXT:    v128.bitselect
; CHECK-NEXT:    local.tee 0
; CHECK-NEXT:    v128.const -2147483648, -2147483648
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64x2.gt_s
; CHECK-NEXT:    v128.bitselect
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i8x16.shuffle 0, 1, 2, 3, 8, 9, 10, 11, 0, 1, 2, 3, 0, 1, 2, 3
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <2 x double> %x to <2 x i64>
  %0 = icmp slt <2 x i64> %conv, <i64 2147483647, i64 2147483647>
  %spec.store.select = select <2 x i1> %0, <2 x i64> %conv, <2 x i64> <i64 2147483647, i64 2147483647>
  %1 = icmp sgt <2 x i64> %spec.store.select, <i64 -2147483648, i64 -2147483648>
  %spec.store.select7 = select <2 x i1> %1, <2 x i64> %spec.store.select, <2 x i64> <i64 -2147483648, i64 -2147483648>
  %conv6 = trunc <2 x i64> %spec.store.select7 to <2 x i32>
  ret <2 x i32> %conv6
}

define <2 x i32> @utest_f64i32(<2 x double> %x) {
; CHECK-LABEL: utest_f64i32:
; CHECK:         .functype utest_f64i32 (v128) -> (v128)
; CHECK-NEXT:    .local i64, i64
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 0
; CHECK-NEXT:    i64.trunc_sat_f64_u
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 1
; CHECK-NEXT:    i64.trunc_sat_f64_u
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    v128.const 4294967295, 4294967295
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.const 4294967295
; CHECK-NEXT:    i64.lt_u
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const 4294967295
; CHECK-NEXT:    i64.lt_u
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    v128.bitselect
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i8x16.shuffle 0, 1, 2, 3, 8, 9, 10, 11, 0, 1, 2, 3, 0, 1, 2, 3
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptoui <2 x double> %x to <2 x i64>
  %0 = icmp ult <2 x i64> %conv, <i64 4294967295, i64 4294967295>
  %spec.store.select = select <2 x i1> %0, <2 x i64> %conv, <2 x i64> <i64 4294967295, i64 4294967295>
  %conv6 = trunc <2 x i64> %spec.store.select to <2 x i32>
  ret <2 x i32> %conv6
}

define <2 x i32> @ustest_f64i32(<2 x double> %x) {
; CHECK-LABEL: ustest_f64i32:
; CHECK:         .functype ustest_f64i32 (v128) -> (v128)
; CHECK-NEXT:    .local v128
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 0
; CHECK-NEXT:    i64.trunc_sat_f64_s
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 1
; CHECK-NEXT:    i64.trunc_sat_f64_s
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    local.tee 0
; CHECK-NEXT:    v128.const 4294967295, 4294967295
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64x2.lt_s
; CHECK-NEXT:    v128.bitselect
; CHECK-NEXT:    local.tee 0
; CHECK-NEXT:    v128.const 0, 0
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64x2.gt_s
; CHECK-NEXT:    v128.bitselect
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i8x16.shuffle 0, 1, 2, 3, 8, 9, 10, 11, 0, 1, 2, 3, 0, 1, 2, 3
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <2 x double> %x to <2 x i64>
  %0 = icmp slt <2 x i64> %conv, <i64 4294967295, i64 4294967295>
  %spec.store.select = select <2 x i1> %0, <2 x i64> %conv, <2 x i64> <i64 4294967295, i64 4294967295>
  %1 = icmp sgt <2 x i64> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i64> %spec.store.select, <2 x i64> zeroinitializer
  %conv6 = trunc <2 x i64> %spec.store.select7 to <2 x i32>
  ret <2 x i32> %conv6
}

define <4 x i32> @stest_f32i32(<4 x float> %x) {
; CHECK-LABEL: stest_f32i32:
; CHECK:         .functype stest_f32i32 (v128) -> (v128)
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i32x4.trunc_sat_f32x4_s
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <4 x float> %x to <4 x i64>
  %0 = icmp slt <4 x i64> %conv, <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %1 = icmp sgt <4 x i64> %spec.store.select, <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>
  %spec.store.select7 = select <4 x i1> %1, <4 x i64> %spec.store.select, <4 x i64> <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @utest_f32i32(<4 x float> %x) {
; CHECK-LABEL: utest_f32i32:
; CHECK:         .functype utest_f32i32 (v128) -> (v128)
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i32x4.trunc_sat_f32x4_u
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptoui <4 x float> %x to <4 x i64>
  %0 = icmp ult <4 x i64> %conv, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %conv6 = trunc <4 x i64> %spec.store.select to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @ustest_f32i32(<4 x float> %x) {
; CHECK-LABEL: ustest_f32i32:
; CHECK:         .functype ustest_f32i32 (v128) -> (v128)
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i32x4.trunc_sat_f32x4_u
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <4 x float> %x to <4 x i64>
  %0 = icmp slt <4 x i64> %conv, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %1 = icmp sgt <4 x i64> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <4 x i1> %1, <4 x i64> %spec.store.select, <4 x i64> zeroinitializer
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @stest_f16i32(<4 x half> %x) {
; CHECK-LABEL: stest_f16i32:
; CHECK:         .functype stest_f16i32 (f32, f32, f32, f32) -> (v128)
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.splat
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 2
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 3
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <4 x half> %x to <4 x i64>
  %0 = icmp slt <4 x i64> %conv, <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>
  %1 = icmp sgt <4 x i64> %spec.store.select, <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>
  %spec.store.select7 = select <4 x i1> %1, <4 x i64> %spec.store.select, <4 x i64> <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @utesth_f16i32(<4 x half> %x) {
; CHECK-LABEL: utesth_f16i32:
; CHECK:         .functype utesth_f16i32 (f32, f32, f32, f32) -> (v128)
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.splat
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.replace_lane 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.replace_lane 2
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.replace_lane 3
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptoui <4 x half> %x to <4 x i64>
  %0 = icmp ult <4 x i64> %conv, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %conv6 = trunc <4 x i64> %spec.store.select to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @ustest_f16i32(<4 x half> %x) {
; CHECK-LABEL: ustest_f16i32:
; CHECK:         .functype ustest_f16i32 (f32, f32, f32, f32) -> (v128)
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.splat
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.replace_lane 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.replace_lane 2
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.replace_lane 3
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <4 x half> %x to <4 x i64>
  %0 = icmp slt <4 x i64> %conv, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %spec.store.select = select <4 x i1> %0, <4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %1 = icmp sgt <4 x i64> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <4 x i1> %1, <4 x i64> %spec.store.select, <4 x i64> zeroinitializer
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

; i16 saturate

define <2 x i16> @stest_f64i16(<2 x double> %x) {
; CHECK-LABEL: stest_f64i16:
; CHECK:         .functype stest_f64i16 (v128) -> (v128)
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 0
; CHECK-NEXT:    i32.trunc_sat_f64_s
; CHECK-NEXT:    i32x4.splat
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 1
; CHECK-NEXT:    i32.trunc_sat_f64_s
; CHECK-NEXT:    i32x4.replace_lane 1
; CHECK-NEXT:    v128.const 32767, 32767, 32767, 32767
; CHECK-NEXT:    i32x4.min_s
; CHECK-NEXT:    v128.const -32768, -32768, -32768, -32768
; CHECK-NEXT:    i32x4.max_s
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i8x16.shuffle 0, 1, 4, 5, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <2 x double> %x to <2 x i32>
  %0 = icmp slt <2 x i32> %conv, <i32 32767, i32 32767>
  %spec.store.select = select <2 x i1> %0, <2 x i32> %conv, <2 x i32> <i32 32767, i32 32767>
  %1 = icmp sgt <2 x i32> %spec.store.select, <i32 -32768, i32 -32768>
  %spec.store.select7 = select <2 x i1> %1, <2 x i32> %spec.store.select, <2 x i32> <i32 -32768, i32 -32768>
  %conv6 = trunc <2 x i32> %spec.store.select7 to <2 x i16>
  ret <2 x i16> %conv6
}

define <2 x i16> @utest_f64i16(<2 x double> %x) {
; CHECK-LABEL: utest_f64i16:
; CHECK:         .functype utest_f64i16 (v128) -> (v128)
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 0
; CHECK-NEXT:    i32.trunc_sat_f64_u
; CHECK-NEXT:    i32x4.splat
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 1
; CHECK-NEXT:    i32.trunc_sat_f64_u
; CHECK-NEXT:    i32x4.replace_lane 1
; CHECK-NEXT:    v128.const 65535, 65535, 65535, 65535
; CHECK-NEXT:    i32x4.min_u
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i8x16.shuffle 0, 1, 4, 5, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptoui <2 x double> %x to <2 x i32>
  %0 = icmp ult <2 x i32> %conv, <i32 65535, i32 65535>
  %spec.store.select = select <2 x i1> %0, <2 x i32> %conv, <2 x i32> <i32 65535, i32 65535>
  %conv6 = trunc <2 x i32> %spec.store.select to <2 x i16>
  ret <2 x i16> %conv6
}

define <2 x i16> @ustest_f64i16(<2 x double> %x) {
; CHECK-LABEL: ustest_f64i16:
; CHECK:         .functype ustest_f64i16 (v128) -> (v128)
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 0
; CHECK-NEXT:    i32.trunc_sat_f64_s
; CHECK-NEXT:    i32x4.splat
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 1
; CHECK-NEXT:    i32.trunc_sat_f64_s
; CHECK-NEXT:    i32x4.replace_lane 1
; CHECK-NEXT:    v128.const 65535, 65535, 65535, 65535
; CHECK-NEXT:    i32x4.min_s
; CHECK-NEXT:    v128.const 0, 0, 0, 0
; CHECK-NEXT:    i32x4.max_s
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i8x16.shuffle 0, 1, 4, 5, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <2 x double> %x to <2 x i32>
  %0 = icmp slt <2 x i32> %conv, <i32 65535, i32 65535>
  %spec.store.select = select <2 x i1> %0, <2 x i32> %conv, <2 x i32> <i32 65535, i32 65535>
  %1 = icmp sgt <2 x i32> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i32> %spec.store.select, <2 x i32> zeroinitializer
  %conv6 = trunc <2 x i32> %spec.store.select7 to <2 x i16>
  ret <2 x i16> %conv6
}

define <4 x i16> @stest_f32i16(<4 x float> %x) {
; CHECK-LABEL: stest_f32i16:
; CHECK:         .functype stest_f32i16 (v128) -> (v128)
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i32x4.trunc_sat_f32x4_s
; CHECK-NEXT:    v128.const 32767, 32767, 32767, 32767
; CHECK-NEXT:    i32x4.min_s
; CHECK-NEXT:    v128.const -32768, -32768, -32768, -32768
; CHECK-NEXT:    i32x4.max_s
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i8x16.shuffle 0, 1, 4, 5, 8, 9, 12, 13, 0, 1, 0, 1, 0, 1, 0, 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <4 x float> %x to <4 x i32>
  %0 = icmp slt <4 x i32> %conv, <i32 32767, i32 32767, i32 32767, i32 32767>
  %spec.store.select = select <4 x i1> %0, <4 x i32> %conv, <4 x i32> <i32 32767, i32 32767, i32 32767, i32 32767>
  %1 = icmp sgt <4 x i32> %spec.store.select, <i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %spec.store.select7 = select <4 x i1> %1, <4 x i32> %spec.store.select, <4 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %conv6 = trunc <4 x i32> %spec.store.select7 to <4 x i16>
  ret <4 x i16> %conv6
}

define <4 x i16> @utest_f32i16(<4 x float> %x) {
; CHECK-LABEL: utest_f32i16:
; CHECK:         .functype utest_f32i16 (v128) -> (v128)
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i32x4.trunc_sat_f32x4_u
; CHECK-NEXT:    v128.const 65535, 65535, 65535, 65535
; CHECK-NEXT:    i32x4.min_u
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i8x16.shuffle 0, 1, 4, 5, 8, 9, 12, 13, 0, 1, 0, 1, 0, 1, 0, 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptoui <4 x float> %x to <4 x i32>
  %0 = icmp ult <4 x i32> %conv, <i32 65535, i32 65535, i32 65535, i32 65535>
  %spec.store.select = select <4 x i1> %0, <4 x i32> %conv, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>
  %conv6 = trunc <4 x i32> %spec.store.select to <4 x i16>
  ret <4 x i16> %conv6
}

define <4 x i16> @ustest_f32i16(<4 x float> %x) {
; CHECK-LABEL: ustest_f32i16:
; CHECK:         .functype ustest_f32i16 (v128) -> (v128)
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i32x4.trunc_sat_f32x4_s
; CHECK-NEXT:    v128.const 65535, 65535, 65535, 65535
; CHECK-NEXT:    i32x4.min_s
; CHECK-NEXT:    v128.const 0, 0, 0, 0
; CHECK-NEXT:    i32x4.max_s
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i8x16.shuffle 0, 1, 4, 5, 8, 9, 12, 13, 0, 1, 0, 1, 0, 1, 0, 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <4 x float> %x to <4 x i32>
  %0 = icmp slt <4 x i32> %conv, <i32 65535, i32 65535, i32 65535, i32 65535>
  %spec.store.select = select <4 x i1> %0, <4 x i32> %conv, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>
  %1 = icmp sgt <4 x i32> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <4 x i1> %1, <4 x i32> %spec.store.select, <4 x i32> zeroinitializer
  %conv6 = trunc <4 x i32> %spec.store.select7 to <4 x i16>
  ret <4 x i16> %conv6
}

define <8 x i16> @stest_f16i16(<8 x half> %x) {
; CHECK-LABEL: stest_f16i16:
; CHECK:         .functype stest_f16i16 (f32, f32, f32, f32, f32, f32, f32, f32) -> (v128)
; CHECK-NEXT:    .local v128, v128, v128
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 5
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 4
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 6
; CHECK-NEXT:    local.get 7
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 7
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.splat
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 2
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 3
; CHECK-NEXT:    v128.const 32767, 32767, 32767, 32767
; CHECK-NEXT:    local.tee 8
; CHECK-NEXT:    i32x4.min_s
; CHECK-NEXT:    v128.const -32768, -32768, -32768, -32768
; CHECK-NEXT:    local.tee 9
; CHECK-NEXT:    i32x4.max_s
; CHECK-NEXT:    v128.const 65535, 65535, 65535, 65535
; CHECK-NEXT:    local.tee 10
; CHECK-NEXT:    v128.and
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.splat
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 1
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 2
; CHECK-NEXT:    local.get 7
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 3
; CHECK-NEXT:    local.get 8
; CHECK-NEXT:    i32x4.min_s
; CHECK-NEXT:    local.get 9
; CHECK-NEXT:    i32x4.max_s
; CHECK-NEXT:    local.get 10
; CHECK-NEXT:    v128.and
; CHECK-NEXT:    i16x8.narrow_i32x4_u
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <8 x half> %x to <8 x i32>
  %0 = icmp slt <8 x i32> %conv, <i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767>
  %spec.store.select = select <8 x i1> %0, <8 x i32> %conv, <8 x i32> <i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767>
  %1 = icmp sgt <8 x i32> %spec.store.select, <i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %spec.store.select7 = select <8 x i1> %1, <8 x i32> %spec.store.select, <8 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768>
  %conv6 = trunc <8 x i32> %spec.store.select7 to <8 x i16>
  ret <8 x i16> %conv6
}

define <8 x i16> @utesth_f16i16(<8 x half> %x) {
; CHECK-LABEL: utesth_f16i16:
; CHECK:         .functype utesth_f16i16 (f32, f32, f32, f32, f32, f32, f32, f32) -> (v128)
; CHECK-NEXT:    .local v128
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 5
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 4
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 6
; CHECK-NEXT:    local.get 7
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 7
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.splat
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.replace_lane 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.replace_lane 2
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.replace_lane 3
; CHECK-NEXT:    v128.const 65535, 65535, 65535, 65535
; CHECK-NEXT:    local.tee 8
; CHECK-NEXT:    i32x4.min_u
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.splat
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.replace_lane 1
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.replace_lane 2
; CHECK-NEXT:    local.get 7
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.replace_lane 3
; CHECK-NEXT:    local.get 8
; CHECK-NEXT:    i32x4.min_u
; CHECK-NEXT:    i16x8.narrow_i32x4_u
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptoui <8 x half> %x to <8 x i32>
  %0 = icmp ult <8 x i32> %conv, <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %spec.store.select = select <8 x i1> %0, <8 x i32> %conv, <8 x i32> <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %conv6 = trunc <8 x i32> %spec.store.select to <8 x i16>
  ret <8 x i16> %conv6
}

define <8 x i16> @ustest_f16i16(<8 x half> %x) {
; CHECK-LABEL: ustest_f16i16:
; CHECK:         .functype ustest_f16i16 (f32, f32, f32, f32, f32, f32, f32, f32) -> (v128)
; CHECK-NEXT:    .local v128, v128
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 5
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 4
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 6
; CHECK-NEXT:    local.get 7
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 7
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.splat
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 2
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 3
; CHECK-NEXT:    v128.const 65535, 65535, 65535, 65535
; CHECK-NEXT:    local.tee 8
; CHECK-NEXT:    i32x4.min_s
; CHECK-NEXT:    v128.const 0, 0, 0, 0
; CHECK-NEXT:    local.tee 9
; CHECK-NEXT:    i32x4.max_s
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.splat
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 1
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 2
; CHECK-NEXT:    local.get 7
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 3
; CHECK-NEXT:    local.get 8
; CHECK-NEXT:    i32x4.min_s
; CHECK-NEXT:    local.get 9
; CHECK-NEXT:    i32x4.max_s
; CHECK-NEXT:    i16x8.narrow_i32x4_u
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <8 x half> %x to <8 x i32>
  %0 = icmp slt <8 x i32> %conv, <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %spec.store.select = select <8 x i1> %0, <8 x i32> %conv, <8 x i32> <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %1 = icmp sgt <8 x i32> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <8 x i1> %1, <8 x i32> %spec.store.select, <8 x i32> zeroinitializer
  %conv6 = trunc <8 x i32> %spec.store.select7 to <8 x i16>
  ret <8 x i16> %conv6
}

; i64 saturate

define <2 x i64> @stest_f64i64(<2 x double> %x) {
; CHECK-LABEL: stest_f64i64:
; CHECK:         .functype stest_f64i64 (v128) -> (v128)
; CHECK-NEXT:    .local i32, i64, i64, i64, i64
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    global.get __stack_pointer
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.sub
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 1
; CHECK-NEXT:    call __fixdfti
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 0
; CHECK-NEXT:    call __fixdfti
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.load 16
; CHECK-NEXT:    local.set 3
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 4
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 5
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    i64.lt_u
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.lt_s
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i32.select
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 5
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    i64.gt_u
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 4
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.gt_s
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.eq
; CHECK-NEXT:    i32.select
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    i64.lt_u
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.lt_s
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i32.select
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 4
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    i64.gt_u
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.gt_s
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.eq
; CHECK-NEXT:    i32.select
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <2 x double> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 9223372036854775807, i128 9223372036854775807>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>
  %1 = icmp sgt <2 x i128> %spec.store.select, <i128 -9223372036854775808, i128 -9223372036854775808>
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utest_f64i64(<2 x double> %x) {
; CHECK-LABEL: utest_f64i64:
; CHECK:         .functype utest_f64i64 (v128) -> (v128)
; CHECK-NEXT:    .local i32, i64, i64, i64, i64
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    global.get __stack_pointer
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.sub
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 1
; CHECK-NEXT:    call __fixunsdfti
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 0
; CHECK-NEXT:    call __fixunsdfti
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.load 16
; CHECK-NEXT:    local.set 3
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 4
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 5
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptoui <2 x double> %x to <2 x i128>
  %0 = icmp ult <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f64i64(<2 x double> %x) {
; CHECK-LABEL: ustest_f64i64:
; CHECK:         .functype ustest_f64i64 (v128) -> (v128)
; CHECK-NEXT:    .local i32, i64, i64, i64, i64
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    global.get __stack_pointer
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.sub
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 1
; CHECK-NEXT:    call __fixdfti
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 0
; CHECK-NEXT:    call __fixdfti
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.load 16
; CHECK-NEXT:    local.set 3
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 4
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 5
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    i64.lt_s
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 5
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.ne
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 4
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.gt_s
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i32.select
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    i64.lt_s
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 4
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.ne
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.gt_s
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i32.select
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <2 x double> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %1 = icmp sgt <2 x i128> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> zeroinitializer
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @stest_f32i64(<2 x float> %x) {
; CHECK-LABEL: stest_f32i64:
; CHECK:         .functype stest_f32i64 (v128) -> (v128)
; CHECK-NEXT:    .local i32, i64, i64, i64, i64
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    global.get __stack_pointer
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.sub
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f32x4.extract_lane 1
; CHECK-NEXT:    call __fixsfti
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f32x4.extract_lane 0
; CHECK-NEXT:    call __fixsfti
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.load 16
; CHECK-NEXT:    local.set 3
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 4
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 5
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    i64.lt_u
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.lt_s
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i32.select
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 5
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    i64.gt_u
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 4
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.gt_s
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.eq
; CHECK-NEXT:    i32.select
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    i64.lt_u
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.lt_s
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i32.select
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 4
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    i64.gt_u
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.gt_s
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.eq
; CHECK-NEXT:    i32.select
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <2 x float> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 9223372036854775807, i128 9223372036854775807>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>
  %1 = icmp sgt <2 x i128> %spec.store.select, <i128 -9223372036854775808, i128 -9223372036854775808>
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utest_f32i64(<2 x float> %x) {
; CHECK-LABEL: utest_f32i64:
; CHECK:         .functype utest_f32i64 (v128) -> (v128)
; CHECK-NEXT:    .local i32, i64, i64, i64, i64
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    global.get __stack_pointer
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.sub
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f32x4.extract_lane 1
; CHECK-NEXT:    call __fixunssfti
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f32x4.extract_lane 0
; CHECK-NEXT:    call __fixunssfti
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.load 16
; CHECK-NEXT:    local.set 3
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 4
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 5
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptoui <2 x float> %x to <2 x i128>
  %0 = icmp ult <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f32i64(<2 x float> %x) {
; CHECK-LABEL: ustest_f32i64:
; CHECK:         .functype ustest_f32i64 (v128) -> (v128)
; CHECK-NEXT:    .local i32, i64, i64, i64, i64
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    global.get __stack_pointer
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.sub
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f32x4.extract_lane 1
; CHECK-NEXT:    call __fixsfti
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f32x4.extract_lane 0
; CHECK-NEXT:    call __fixsfti
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.load 16
; CHECK-NEXT:    local.set 3
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 4
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 5
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    i64.lt_s
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 5
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.ne
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 4
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.gt_s
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i32.select
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    i64.lt_s
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 4
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.ne
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.gt_s
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i32.select
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <2 x float> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %1 = icmp sgt <2 x i128> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> zeroinitializer
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @stest_f16i64(<2 x half> %x) {
; CHECK-LABEL: stest_f16i64:
; CHECK:         .functype stest_f16i64 (f32, f32) -> (v128)
; CHECK-NEXT:    .local i32, i64, i64, i64, i64
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    global.get __stack_pointer
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.sub
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    call __fixsfti
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    call __fixsfti
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 3
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.load 16
; CHECK-NEXT:    local.set 4
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 5
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 6
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    i64.lt_u
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.lt_s
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i32.select
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 6
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    i64.gt_u
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 5
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.gt_s
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.eq
; CHECK-NEXT:    i32.select
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    i64.lt_u
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.lt_s
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i32.select
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 5
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    i64.gt_u
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 3
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.gt_s
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.eq
; CHECK-NEXT:    i32.select
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <2 x half> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 9223372036854775807, i128 9223372036854775807>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>
  %1 = icmp sgt <2 x i128> %spec.store.select, <i128 -9223372036854775808, i128 -9223372036854775808>
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utesth_f16i64(<2 x half> %x) {
; CHECK-LABEL: utesth_f16i64:
; CHECK:         .functype utesth_f16i64 (f32, f32) -> (v128)
; CHECK-NEXT:    .local i32, i64, i64, i64, i64
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    global.get __stack_pointer
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.sub
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    call __fixunssfti
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    call __fixunssfti
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 3
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.load 16
; CHECK-NEXT:    local.set 4
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 5
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 6
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptoui <2 x half> %x to <2 x i128>
  %0 = icmp ult <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f16i64(<2 x half> %x) {
; CHECK-LABEL: ustest_f16i64:
; CHECK:         .functype ustest_f16i64 (f32, f32) -> (v128)
; CHECK-NEXT:    .local i32, i64, i64, i64, i64
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    global.get __stack_pointer
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.sub
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    call __fixsfti
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    call __fixsfti
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 3
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.load 16
; CHECK-NEXT:    local.set 4
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 5
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 6
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    i64.lt_s
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 6
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.ne
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 5
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.gt_s
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i32.select
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    i64.lt_s
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 5
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.ne
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 3
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.gt_s
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i32.select
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <2 x half> %x to <2 x i128>
  %0 = icmp slt <2 x i128> %conv, <i128 18446744073709551616, i128 18446744073709551616>
  %spec.store.select = select <2 x i1> %0, <2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>
  %1 = icmp sgt <2 x i128> %spec.store.select, zeroinitializer
  %spec.store.select7 = select <2 x i1> %1, <2 x i128> %spec.store.select, <2 x i128> zeroinitializer
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}



; i32 saturate

define <2 x i32> @stest_f64i32_mm(<2 x double> %x) {
; CHECK-LABEL: stest_f64i32_mm:
; CHECK:         .functype stest_f64i32_mm (v128) -> (v128)
; CHECK-NEXT:    .local v128
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 0
; CHECK-NEXT:    i64.trunc_sat_f64_s
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 1
; CHECK-NEXT:    i64.trunc_sat_f64_s
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    local.tee 0
; CHECK-NEXT:    v128.const 2147483647, 2147483647
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64x2.lt_s
; CHECK-NEXT:    v128.bitselect
; CHECK-NEXT:    local.tee 0
; CHECK-NEXT:    v128.const -2147483648, -2147483648
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64x2.gt_s
; CHECK-NEXT:    v128.bitselect
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i8x16.shuffle 0, 1, 2, 3, 8, 9, 10, 11, 0, 1, 2, 3, 0, 1, 2, 3
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <2 x double> %x to <2 x i64>
  %spec.store.select = call <2 x i64> @llvm.smin.v2i64(<2 x i64> %conv, <2 x i64> <i64 2147483647, i64 2147483647>)
  %spec.store.select7 = call <2 x i64> @llvm.smax.v2i64(<2 x i64> %spec.store.select, <2 x i64> <i64 -2147483648, i64 -2147483648>)
  %conv6 = trunc <2 x i64> %spec.store.select7 to <2 x i32>
  ret <2 x i32> %conv6
}

define <2 x i32> @utest_f64i32_mm(<2 x double> %x) {
; CHECK-LABEL: utest_f64i32_mm:
; CHECK:         .functype utest_f64i32_mm (v128) -> (v128)
; CHECK-NEXT:    .local i64, i64
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 0
; CHECK-NEXT:    i64.trunc_sat_f64_u
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 1
; CHECK-NEXT:    i64.trunc_sat_f64_u
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    v128.const 4294967295, 4294967295
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.const 4294967295
; CHECK-NEXT:    i64.lt_u
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const 4294967295
; CHECK-NEXT:    i64.lt_u
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    v128.bitselect
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i8x16.shuffle 0, 1, 2, 3, 8, 9, 10, 11, 0, 1, 2, 3, 0, 1, 2, 3
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptoui <2 x double> %x to <2 x i64>
  %spec.store.select = call <2 x i64> @llvm.umin.v2i64(<2 x i64> %conv, <2 x i64> <i64 4294967295, i64 4294967295>)
  %conv6 = trunc <2 x i64> %spec.store.select to <2 x i32>
  ret <2 x i32> %conv6
}

define <2 x i32> @ustest_f64i32_mm(<2 x double> %x) {
; CHECK-LABEL: ustest_f64i32_mm:
; CHECK:         .functype ustest_f64i32_mm (v128) -> (v128)
; CHECK-NEXT:    .local v128
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 0
; CHECK-NEXT:    i64.trunc_sat_f64_s
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 1
; CHECK-NEXT:    i64.trunc_sat_f64_s
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    local.tee 0
; CHECK-NEXT:    v128.const 4294967295, 4294967295
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64x2.lt_s
; CHECK-NEXT:    v128.bitselect
; CHECK-NEXT:    local.tee 0
; CHECK-NEXT:    v128.const 0, 0
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64x2.gt_s
; CHECK-NEXT:    v128.bitselect
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i8x16.shuffle 0, 1, 2, 3, 8, 9, 10, 11, 0, 1, 2, 3, 0, 1, 2, 3
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <2 x double> %x to <2 x i64>
  %spec.store.select = call <2 x i64> @llvm.smin.v2i64(<2 x i64> %conv, <2 x i64> <i64 4294967295, i64 4294967295>)
  %spec.store.select7 = call <2 x i64> @llvm.smax.v2i64(<2 x i64> %spec.store.select, <2 x i64> zeroinitializer)
  %conv6 = trunc <2 x i64> %spec.store.select7 to <2 x i32>
  ret <2 x i32> %conv6
}

define <4 x i32> @stest_f32i32_mm(<4 x float> %x) {
; CHECK-LABEL: stest_f32i32_mm:
; CHECK:         .functype stest_f32i32_mm (v128) -> (v128)
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i32x4.trunc_sat_f32x4_s
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <4 x float> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.smin.v4i64(<4 x i64> %conv, <4 x i64> <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>)
  %spec.store.select7 = call <4 x i64> @llvm.smax.v4i64(<4 x i64> %spec.store.select, <4 x i64> <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>)
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @utest_f32i32_mm(<4 x float> %x) {
; CHECK-LABEL: utest_f32i32_mm:
; CHECK:         .functype utest_f32i32_mm (v128) -> (v128)
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i32x4.trunc_sat_f32x4_u
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptoui <4 x float> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.umin.v4i64(<4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>)
  %conv6 = trunc <4 x i64> %spec.store.select to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @ustest_f32i32_mm(<4 x float> %x) {
; CHECK-LABEL: ustest_f32i32_mm:
; CHECK:         .functype ustest_f32i32_mm (v128) -> (v128)
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i32x4.trunc_sat_f32x4_u
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <4 x float> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.smin.v4i64(<4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>)
  %spec.store.select7 = call <4 x i64> @llvm.smax.v4i64(<4 x i64> %spec.store.select, <4 x i64> zeroinitializer)
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @stest_f16i32_mm(<4 x half> %x) {
; CHECK-LABEL: stest_f16i32_mm:
; CHECK:         .functype stest_f16i32_mm (f32, f32, f32, f32) -> (v128)
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.splat
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 2
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 3
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <4 x half> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.smin.v4i64(<4 x i64> %conv, <4 x i64> <i64 2147483647, i64 2147483647, i64 2147483647, i64 2147483647>)
  %spec.store.select7 = call <4 x i64> @llvm.smax.v4i64(<4 x i64> %spec.store.select, <4 x i64> <i64 -2147483648, i64 -2147483648, i64 -2147483648, i64 -2147483648>)
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @utesth_f16i32_mm(<4 x half> %x) {
; CHECK-LABEL: utesth_f16i32_mm:
; CHECK:         .functype utesth_f16i32_mm (f32, f32, f32, f32) -> (v128)
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.splat
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.replace_lane 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.replace_lane 2
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.replace_lane 3
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptoui <4 x half> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.umin.v4i64(<4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>)
  %conv6 = trunc <4 x i64> %spec.store.select to <4 x i32>
  ret <4 x i32> %conv6
}

define <4 x i32> @ustest_f16i32_mm(<4 x half> %x) {
; CHECK-LABEL: ustest_f16i32_mm:
; CHECK:         .functype ustest_f16i32_mm (f32, f32, f32, f32) -> (v128)
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.splat
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.replace_lane 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.replace_lane 2
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.replace_lane 3
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <4 x half> %x to <4 x i64>
  %spec.store.select = call <4 x i64> @llvm.smin.v4i64(<4 x i64> %conv, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>)
  %spec.store.select7 = call <4 x i64> @llvm.smax.v4i64(<4 x i64> %spec.store.select, <4 x i64> zeroinitializer)
  %conv6 = trunc <4 x i64> %spec.store.select7 to <4 x i32>
  ret <4 x i32> %conv6
}

; i16 saturate

define <2 x i16> @stest_f64i16_mm(<2 x double> %x) {
; CHECK-LABEL: stest_f64i16_mm:
; CHECK:         .functype stest_f64i16_mm (v128) -> (v128)
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 0
; CHECK-NEXT:    i32.trunc_sat_f64_s
; CHECK-NEXT:    i32x4.splat
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 1
; CHECK-NEXT:    i32.trunc_sat_f64_s
; CHECK-NEXT:    i32x4.replace_lane 1
; CHECK-NEXT:    v128.const 32767, 32767, 32767, 32767
; CHECK-NEXT:    i32x4.min_s
; CHECK-NEXT:    v128.const -32768, -32768, -32768, -32768
; CHECK-NEXT:    i32x4.max_s
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i8x16.shuffle 0, 1, 4, 5, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <2 x double> %x to <2 x i32>
  %spec.store.select = call <2 x i32> @llvm.smin.v2i32(<2 x i32> %conv, <2 x i32> <i32 32767, i32 32767>)
  %spec.store.select7 = call <2 x i32> @llvm.smax.v2i32(<2 x i32> %spec.store.select, <2 x i32> <i32 -32768, i32 -32768>)
  %conv6 = trunc <2 x i32> %spec.store.select7 to <2 x i16>
  ret <2 x i16> %conv6
}

define <2 x i16> @utest_f64i16_mm(<2 x double> %x) {
; CHECK-LABEL: utest_f64i16_mm:
; CHECK:         .functype utest_f64i16_mm (v128) -> (v128)
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 0
; CHECK-NEXT:    i32.trunc_sat_f64_u
; CHECK-NEXT:    i32x4.splat
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 1
; CHECK-NEXT:    i32.trunc_sat_f64_u
; CHECK-NEXT:    i32x4.replace_lane 1
; CHECK-NEXT:    v128.const 65535, 65535, 65535, 65535
; CHECK-NEXT:    i32x4.min_u
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i8x16.shuffle 0, 1, 4, 5, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptoui <2 x double> %x to <2 x i32>
  %spec.store.select = call <2 x i32> @llvm.umin.v2i32(<2 x i32> %conv, <2 x i32> <i32 65535, i32 65535>)
  %conv6 = trunc <2 x i32> %spec.store.select to <2 x i16>
  ret <2 x i16> %conv6
}

define <2 x i16> @ustest_f64i16_mm(<2 x double> %x) {
; CHECK-LABEL: ustest_f64i16_mm:
; CHECK:         .functype ustest_f64i16_mm (v128) -> (v128)
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 0
; CHECK-NEXT:    i32.trunc_sat_f64_s
; CHECK-NEXT:    i32x4.splat
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 1
; CHECK-NEXT:    i32.trunc_sat_f64_s
; CHECK-NEXT:    i32x4.replace_lane 1
; CHECK-NEXT:    v128.const 65535, 65535, 65535, 65535
; CHECK-NEXT:    i32x4.min_s
; CHECK-NEXT:    v128.const 0, 0, 0, 0
; CHECK-NEXT:    i32x4.max_s
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i8x16.shuffle 0, 1, 4, 5, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <2 x double> %x to <2 x i32>
  %spec.store.select = call <2 x i32> @llvm.smin.v2i32(<2 x i32> %conv, <2 x i32> <i32 65535, i32 65535>)
  %spec.store.select7 = call <2 x i32> @llvm.smax.v2i32(<2 x i32> %spec.store.select, <2 x i32> zeroinitializer)
  %conv6 = trunc <2 x i32> %spec.store.select7 to <2 x i16>
  ret <2 x i16> %conv6
}

define <4 x i16> @stest_f32i16_mm(<4 x float> %x) {
; CHECK-LABEL: stest_f32i16_mm:
; CHECK:         .functype stest_f32i16_mm (v128) -> (v128)
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i32x4.trunc_sat_f32x4_s
; CHECK-NEXT:    v128.const 32767, 32767, 32767, 32767
; CHECK-NEXT:    i32x4.min_s
; CHECK-NEXT:    v128.const -32768, -32768, -32768, -32768
; CHECK-NEXT:    i32x4.max_s
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i8x16.shuffle 0, 1, 4, 5, 8, 9, 12, 13, 0, 1, 0, 1, 0, 1, 0, 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <4 x float> %x to <4 x i32>
  %spec.store.select = call <4 x i32> @llvm.smin.v4i32(<4 x i32> %conv, <4 x i32> <i32 32767, i32 32767, i32 32767, i32 32767>)
  %spec.store.select7 = call <4 x i32> @llvm.smax.v4i32(<4 x i32> %spec.store.select, <4 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768>)
  %conv6 = trunc <4 x i32> %spec.store.select7 to <4 x i16>
  ret <4 x i16> %conv6
}

define <4 x i16> @utest_f32i16_mm(<4 x float> %x) {
; CHECK-LABEL: utest_f32i16_mm:
; CHECK:         .functype utest_f32i16_mm (v128) -> (v128)
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i32x4.trunc_sat_f32x4_u
; CHECK-NEXT:    v128.const 65535, 65535, 65535, 65535
; CHECK-NEXT:    i32x4.min_u
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i8x16.shuffle 0, 1, 4, 5, 8, 9, 12, 13, 0, 1, 0, 1, 0, 1, 0, 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptoui <4 x float> %x to <4 x i32>
  %spec.store.select = call <4 x i32> @llvm.umin.v4i32(<4 x i32> %conv, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>)
  %conv6 = trunc <4 x i32> %spec.store.select to <4 x i16>
  ret <4 x i16> %conv6
}

define <4 x i16> @ustest_f32i16_mm(<4 x float> %x) {
; CHECK-LABEL: ustest_f32i16_mm:
; CHECK:         .functype ustest_f32i16_mm (v128) -> (v128)
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i32x4.trunc_sat_f32x4_s
; CHECK-NEXT:    v128.const 65535, 65535, 65535, 65535
; CHECK-NEXT:    i32x4.min_s
; CHECK-NEXT:    v128.const 0, 0, 0, 0
; CHECK-NEXT:    i32x4.max_s
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i8x16.shuffle 0, 1, 4, 5, 8, 9, 12, 13, 0, 1, 0, 1, 0, 1, 0, 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <4 x float> %x to <4 x i32>
  %spec.store.select = call <4 x i32> @llvm.smin.v4i32(<4 x i32> %conv, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>)
  %spec.store.select7 = call <4 x i32> @llvm.smax.v4i32(<4 x i32> %spec.store.select, <4 x i32> zeroinitializer)
  %conv6 = trunc <4 x i32> %spec.store.select7 to <4 x i16>
  ret <4 x i16> %conv6
}

define <8 x i16> @stest_f16i16_mm(<8 x half> %x) {
; CHECK-LABEL: stest_f16i16_mm:
; CHECK:         .functype stest_f16i16_mm (f32, f32, f32, f32, f32, f32, f32, f32) -> (v128)
; CHECK-NEXT:    .local v128, v128, v128
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 5
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 4
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 6
; CHECK-NEXT:    local.get 7
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 7
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.splat
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 2
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 3
; CHECK-NEXT:    v128.const 32767, 32767, 32767, 32767
; CHECK-NEXT:    local.tee 8
; CHECK-NEXT:    i32x4.min_s
; CHECK-NEXT:    v128.const -32768, -32768, -32768, -32768
; CHECK-NEXT:    local.tee 9
; CHECK-NEXT:    i32x4.max_s
; CHECK-NEXT:    v128.const 65535, 65535, 65535, 65535
; CHECK-NEXT:    local.tee 10
; CHECK-NEXT:    v128.and
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.splat
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 1
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 2
; CHECK-NEXT:    local.get 7
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 3
; CHECK-NEXT:    local.get 8
; CHECK-NEXT:    i32x4.min_s
; CHECK-NEXT:    local.get 9
; CHECK-NEXT:    i32x4.max_s
; CHECK-NEXT:    local.get 10
; CHECK-NEXT:    v128.and
; CHECK-NEXT:    i16x8.narrow_i32x4_u
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <8 x half> %x to <8 x i32>
  %spec.store.select = call <8 x i32> @llvm.smin.v8i32(<8 x i32> %conv, <8 x i32> <i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767, i32 32767>)
  %spec.store.select7 = call <8 x i32> @llvm.smax.v8i32(<8 x i32> %spec.store.select, <8 x i32> <i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768, i32 -32768>)
  %conv6 = trunc <8 x i32> %spec.store.select7 to <8 x i16>
  ret <8 x i16> %conv6
}

define <8 x i16> @utesth_f16i16_mm(<8 x half> %x) {
; CHECK-LABEL: utesth_f16i16_mm:
; CHECK:         .functype utesth_f16i16_mm (f32, f32, f32, f32, f32, f32, f32, f32) -> (v128)
; CHECK-NEXT:    .local v128
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 5
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 4
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 6
; CHECK-NEXT:    local.get 7
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 7
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.splat
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.replace_lane 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.replace_lane 2
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.replace_lane 3
; CHECK-NEXT:    v128.const 65535, 65535, 65535, 65535
; CHECK-NEXT:    local.tee 8
; CHECK-NEXT:    i32x4.min_u
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.splat
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.replace_lane 1
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.replace_lane 2
; CHECK-NEXT:    local.get 7
; CHECK-NEXT:    i32.trunc_sat_f32_u
; CHECK-NEXT:    i32x4.replace_lane 3
; CHECK-NEXT:    local.get 8
; CHECK-NEXT:    i32x4.min_u
; CHECK-NEXT:    i16x8.narrow_i32x4_u
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptoui <8 x half> %x to <8 x i32>
  %spec.store.select = call <8 x i32> @llvm.umin.v8i32(<8 x i32> %conv, <8 x i32> <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>)
  %conv6 = trunc <8 x i32> %spec.store.select to <8 x i16>
  ret <8 x i16> %conv6
}

define <8 x i16> @ustest_f16i16_mm(<8 x half> %x) {
; CHECK-LABEL: ustest_f16i16_mm:
; CHECK:         .functype ustest_f16i16_mm (f32, f32, f32, f32, f32, f32, f32, f32) -> (v128)
; CHECK-NEXT:    .local v128, v128
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 5
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 4
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 6
; CHECK-NEXT:    local.get 7
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 7
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.splat
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 2
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 3
; CHECK-NEXT:    v128.const 65535, 65535, 65535, 65535
; CHECK-NEXT:    local.tee 8
; CHECK-NEXT:    i32x4.min_s
; CHECK-NEXT:    v128.const 0, 0, 0, 0
; CHECK-NEXT:    local.tee 9
; CHECK-NEXT:    i32x4.max_s
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.splat
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 1
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 2
; CHECK-NEXT:    local.get 7
; CHECK-NEXT:    i32.trunc_sat_f32_s
; CHECK-NEXT:    i32x4.replace_lane 3
; CHECK-NEXT:    local.get 8
; CHECK-NEXT:    i32x4.min_s
; CHECK-NEXT:    local.get 9
; CHECK-NEXT:    i32x4.max_s
; CHECK-NEXT:    i16x8.narrow_i32x4_u
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <8 x half> %x to <8 x i32>
  %spec.store.select = call <8 x i32> @llvm.smin.v8i32(<8 x i32> %conv, <8 x i32> <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>)
  %spec.store.select7 = call <8 x i32> @llvm.smax.v8i32(<8 x i32> %spec.store.select, <8 x i32> zeroinitializer)
  %conv6 = trunc <8 x i32> %spec.store.select7 to <8 x i16>
  ret <8 x i16> %conv6
}

; i64 saturate

define <2 x i64> @stest_f64i64_mm(<2 x double> %x) {
; CHECK-LABEL: stest_f64i64_mm:
; CHECK:         .functype stest_f64i64_mm (v128) -> (v128)
; CHECK-NEXT:    .local i32, i64, i64, i64, i64
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    global.get __stack_pointer
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.sub
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 1
; CHECK-NEXT:    call __fixdfti
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 0
; CHECK-NEXT:    call __fixdfti
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.load 16
; CHECK-NEXT:    local.set 3
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 4
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 5
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    i64.lt_u
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.lt_s
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 5
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    i64.gt_u
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 63
; CHECK-NEXT:    i64.shr_s
; CHECK-NEXT:    i64.and
; CHECK-NEXT:    local.tee 4
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.gt_s
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.eq
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    i64.lt_u
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.lt_s
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 4
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    i64.gt_u
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const 63
; CHECK-NEXT:    i64.shr_s
; CHECK-NEXT:    i64.and
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.gt_s
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.eq
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <2 x double> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utest_f64i64_mm(<2 x double> %x) {
; CHECK-LABEL: utest_f64i64_mm:
; CHECK:         .functype utest_f64i64_mm (v128) -> (v128)
; CHECK-NEXT:    .local i32, i64, i64, i64, i64
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    global.get __stack_pointer
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.sub
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 1
; CHECK-NEXT:    call __fixunsdfti
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 0
; CHECK-NEXT:    call __fixunsdfti
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.load 16
; CHECK-NEXT:    local.set 3
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 4
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 5
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    i64.eq
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    i64.eq
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptoui <2 x double> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.umin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f64i64_mm(<2 x double> %x) {
; CHECK-LABEL: ustest_f64i64_mm:
; CHECK:         .functype ustest_f64i64_mm (v128) -> (v128)
; CHECK-NEXT:    .local i32, i64, i64, i64, i64
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    global.get __stack_pointer
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.sub
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 1
; CHECK-NEXT:    call __fixdfti
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f64x2.extract_lane 0
; CHECK-NEXT:    call __fixdfti
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.load 16
; CHECK-NEXT:    local.set 3
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 4
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 5
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    i64.lt_s
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    i64.eq
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 5
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 4
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.gt_s
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    i64.lt_s
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    i64.eq
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 4
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.gt_s
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <2 x double> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> zeroinitializer)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @stest_f32i64_mm(<2 x float> %x) {
; CHECK-LABEL: stest_f32i64_mm:
; CHECK:         .functype stest_f32i64_mm (v128) -> (v128)
; CHECK-NEXT:    .local i32, i64, i64, i64, i64
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    global.get __stack_pointer
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.sub
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f32x4.extract_lane 1
; CHECK-NEXT:    call __fixsfti
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f32x4.extract_lane 0
; CHECK-NEXT:    call __fixsfti
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.load 16
; CHECK-NEXT:    local.set 3
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 4
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 5
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    i64.lt_u
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.lt_s
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 5
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    i64.gt_u
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 63
; CHECK-NEXT:    i64.shr_s
; CHECK-NEXT:    i64.and
; CHECK-NEXT:    local.tee 4
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.gt_s
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.eq
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    i64.lt_u
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.lt_s
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 4
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    i64.gt_u
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const 63
; CHECK-NEXT:    i64.shr_s
; CHECK-NEXT:    i64.and
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.gt_s
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.eq
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <2 x float> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utest_f32i64_mm(<2 x float> %x) {
; CHECK-LABEL: utest_f32i64_mm:
; CHECK:         .functype utest_f32i64_mm (v128) -> (v128)
; CHECK-NEXT:    .local i32, i64, i64, i64, i64
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    global.get __stack_pointer
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.sub
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f32x4.extract_lane 1
; CHECK-NEXT:    call __fixunssfti
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f32x4.extract_lane 0
; CHECK-NEXT:    call __fixunssfti
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.load 16
; CHECK-NEXT:    local.set 3
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 4
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 5
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    i64.eq
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    i64.eq
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptoui <2 x float> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.umin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f32i64_mm(<2 x float> %x) {
; CHECK-LABEL: ustest_f32i64_mm:
; CHECK:         .functype ustest_f32i64_mm (v128) -> (v128)
; CHECK-NEXT:    .local i32, i64, i64, i64, i64
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    global.get __stack_pointer
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.sub
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f32x4.extract_lane 1
; CHECK-NEXT:    call __fixsfti
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    f32x4.extract_lane 0
; CHECK-NEXT:    call __fixsfti
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.load 16
; CHECK-NEXT:    local.set 3
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 4
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 5
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    i64.lt_s
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    i64.eq
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 5
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 4
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.gt_s
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    i64.lt_s
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    i64.eq
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 4
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.gt_s
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <2 x float> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> zeroinitializer)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @stest_f16i64_mm(<2 x half> %x) {
; CHECK-LABEL: stest_f16i64_mm:
; CHECK:         .functype stest_f16i64_mm (f32, f32) -> (v128)
; CHECK-NEXT:    .local i32, i64, i64, i64, i64
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    global.get __stack_pointer
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.sub
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    call __fixsfti
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    call __fixsfti
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 3
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.load 16
; CHECK-NEXT:    local.set 4
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 5
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 6
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    i64.lt_u
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.lt_s
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 6
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    i64.gt_u
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 63
; CHECK-NEXT:    i64.shr_s
; CHECK-NEXT:    i64.and
; CHECK-NEXT:    local.tee 5
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.gt_s
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.eq
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    i64.lt_u
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 9223372036854775807
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.lt_s
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 5
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    i64.gt_u
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const -9223372036854775808
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 63
; CHECK-NEXT:    i64.shr_s
; CHECK-NEXT:    i64.and
; CHECK-NEXT:    local.tee 3
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.gt_s
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const -1
; CHECK-NEXT:    i64.eq
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <2 x half> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 9223372036854775807, i128 9223372036854775807>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> <i128 -9223372036854775808, i128 -9223372036854775808>)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @utesth_f16i64_mm(<2 x half> %x) {
; CHECK-LABEL: utesth_f16i64_mm:
; CHECK:         .functype utesth_f16i64_mm (f32, f32) -> (v128)
; CHECK-NEXT:    .local i32, i64, i64, i64, i64
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    global.get __stack_pointer
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.sub
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    call __fixunssfti
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    call __fixunssfti
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 3
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.load 16
; CHECK-NEXT:    local.set 4
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 5
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 6
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    i64.eq
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    i64.eq
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptoui <2 x half> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.umin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %conv6 = trunc <2 x i128> %spec.store.select to <2 x i64>
  ret <2 x i64> %conv6
}

define <2 x i64> @ustest_f16i64_mm(<2 x half> %x) {
; CHECK-LABEL: ustest_f16i64_mm:
; CHECK:         .functype ustest_f16i64_mm (f32, f32) -> (v128)
; CHECK-NEXT:    .local i32, i64, i64, i64, i64
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    global.get __stack_pointer
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.sub
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    call __fixsfti
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call __truncsfhf2
; CHECK-NEXT:    call __extendhfsf2
; CHECK-NEXT:    call __fixsfti
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i32.const 16
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 3
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.load 16
; CHECK-NEXT:    local.set 4
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i32.const 8
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 5
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.load 0
; CHECK-NEXT:    local.set 6
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i32.const 32
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    i64.lt_s
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    i64.eq
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 6
; CHECK-NEXT:    local.get 6
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 5
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.gt_s
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.splat
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 4
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    i64.lt_s
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    i64.eq
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 5
; CHECK-NEXT:    local.get 5
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.const 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.tee 3
; CHECK-NEXT:    i64.const 0
; CHECK-NEXT:    i64.gt_s
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    local.get 3
; CHECK-NEXT:    i64.eqz
; CHECK-NEXT:    i64.select
; CHECK-NEXT:    i64x2.replace_lane 1
; CHECK-NEXT:    # fallthrough-return
entry:
  %conv = fptosi <2 x half> %x to <2 x i128>
  %spec.store.select = call <2 x i128> @llvm.smin.v2i128(<2 x i128> %conv, <2 x i128> <i128 18446744073709551616, i128 18446744073709551616>)
  %spec.store.select7 = call <2 x i128> @llvm.smax.v2i128(<2 x i128> %spec.store.select, <2 x i128> zeroinitializer)
  %conv6 = trunc <2 x i128> %spec.store.select7 to <2 x i64>
  ret <2 x i64> %conv6
}

declare <2 x i32> @llvm.smin.v2i32(<2 x i32>, <2 x i32>)
declare <2 x i32> @llvm.smax.v2i32(<2 x i32>, <2 x i32>)
declare <2 x i32> @llvm.umin.v2i32(<2 x i32>, <2 x i32>)
declare <4 x i32> @llvm.smin.v4i32(<4 x i32>, <4 x i32>)
declare <4 x i32> @llvm.smax.v4i32(<4 x i32>, <4 x i32>)
declare <4 x i32> @llvm.umin.v4i32(<4 x i32>, <4 x i32>)
declare <8 x i32> @llvm.smin.v8i32(<8 x i32>, <8 x i32>)
declare <8 x i32> @llvm.smax.v8i32(<8 x i32>, <8 x i32>)
declare <8 x i32> @llvm.umin.v8i32(<8 x i32>, <8 x i32>)
declare <2 x i64> @llvm.smin.v2i64(<2 x i64>, <2 x i64>)
declare <2 x i64> @llvm.smax.v2i64(<2 x i64>, <2 x i64>)
declare <2 x i64> @llvm.umin.v2i64(<2 x i64>, <2 x i64>)
declare <4 x i64> @llvm.smin.v4i64(<4 x i64>, <4 x i64>)
declare <4 x i64> @llvm.smax.v4i64(<4 x i64>, <4 x i64>)
declare <4 x i64> @llvm.umin.v4i64(<4 x i64>, <4 x i64>)
declare <2 x i128> @llvm.smin.v2i128(<2 x i128>, <2 x i128>)
declare <2 x i128> @llvm.smax.v2i128(<2 x i128>, <2 x i128>)
declare <2 x i128> @llvm.umin.v2i128(<2 x i128>, <2 x i128>)
