; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -S -aa-pipeline=basic-aa -passes=inferattrs,dse | FileCheck %s

target triple = "x86_64-unknown-linux-gnu"

declare ptr @__memset_chk(ptr writeonly, i32, i64, i64) argmemonly
declare ptr @__memcpy_chk(ptr writeonly, ptr readonly, i64, i64) argmemonly nounwind

declare ptr @strncpy(ptr %dest, ptr %src, i64 %n) nounwind
declare void @use(ptr)

; strncpy -> __memset_chk, full overwrite
define void @dse_strncpy_memset_chk_test1(ptr noalias %out, ptr noalias %in, i64 %n) {
; CHECK-LABEL: @dse_strncpy_memset_chk_test1(
; CHECK-NEXT:    [[CALL_2:%.*]] = tail call ptr @__memset_chk(ptr [[OUT:%.*]], i32 42, i64 100, i64 [[N:%.*]])
; CHECK-NEXT:    ret void
;
  %call = tail call ptr @strncpy(ptr %out, ptr %in, i64 100)
  %call.2 = tail call ptr @__memset_chk(ptr %out, i32 42, i64 100, i64 %n)
  ret void
}

define void @dse_memset_chk_eliminate_store1(ptr %out, i64 %n) {
; CHECK-LABEL: @dse_memset_chk_eliminate_store1(
; CHECK-NEXT:    [[CALL_2:%.*]] = tail call ptr @__memset_chk(ptr [[OUT:%.*]], i32 42, i64 100, i64 [[N:%.*]])
; CHECK-NEXT:    ret void
;
  store i8 10, ptr %out
  %call.2 = tail call ptr @__memset_chk(ptr %out, i32 42, i64 100, i64 %n)
  ret void
}

define void @dse_memset_chk_eliminate_store2(ptr %out, i64 %n) {
; CHECK-LABEL: @dse_memset_chk_eliminate_store2(
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds i8, ptr [[OUT:%.*]], i64 100
; CHECK-NEXT:    store i8 10, ptr [[GEP]], align 1
; CHECK-NEXT:    [[CALL_2:%.*]] = tail call ptr @__memset_chk(ptr [[OUT]], i32 42, i64 100, i64 [[N:%.*]])
; CHECK-NEXT:    ret void
;
  %gep = getelementptr inbounds i8, ptr %out, i64 100
  store i8 10, ptr %gep
  %call.2 = tail call ptr @__memset_chk(ptr %out, i32 42, i64 100, i64 %n)
  ret void
}

define void @dse_memset_chk_eliminates_store_local_object_escapes_after(i64 %n) {
; CHECK-LABEL: @dse_memset_chk_eliminates_store_local_object_escapes_after(
; CHECK-NEXT:    [[A:%.*]] = alloca [200 x i8], align 1
; CHECK-NEXT:    [[OUT_100:%.*]] = getelementptr i8, ptr [[A]], i64 100
; CHECK-NEXT:    store i8 10, ptr [[OUT_100]], align 1
; CHECK-NEXT:    [[CALL_2:%.*]] = tail call ptr @__memset_chk(ptr [[A]], i32 42, i64 100, i64 [[N:%.*]])
; CHECK-NEXT:    call void @use(ptr [[A]])
; CHECK-NEXT:    ret void
;
  %a = alloca [200 x i8]
  store i8 10, ptr %a
  %out.100 = getelementptr i8, ptr %a, i64 100
  store i8 10, ptr %out.100
  %call.2 = tail call ptr @__memset_chk(ptr %a, i32 42, i64 100, i64 %n)
  call void @use(ptr %a)
  ret void
}

define void @dse_memset_chk_eliminates_store_local_object_escapes_before(i64 %n) {
; CHECK-LABEL: @dse_memset_chk_eliminates_store_local_object_escapes_before(
; CHECK-NEXT:    [[A:%.*]] = alloca [200 x i8], align 1
; CHECK-NEXT:    call void @use(ptr [[A]])
; CHECK-NEXT:    [[OUT_100:%.*]] = getelementptr i8, ptr [[A]], i64 100
; CHECK-NEXT:    store i8 0, ptr [[OUT_100]], align 1
; CHECK-NEXT:    [[CALL_2:%.*]] = tail call ptr @__memset_chk(ptr [[A]], i32 42, i64 100, i64 [[N:%.*]])
; CHECK-NEXT:    call void @use(ptr [[A]])
; CHECK-NEXT:    ret void
;
  %a = alloca [200 x i8]
  call void @use(ptr %a)
  store i8 10, ptr %a
  %out.100 = getelementptr i8, ptr %a, i64 100
  store i8 0, ptr %out.100
  %call.2 = tail call ptr @__memset_chk(ptr %a, i32 42, i64 100, i64 %n)
  call void @use(ptr %a)
  ret void
}

; strncpy -> memset_chk, partial overwrite
define void @dse_strncpy_memset_chk_test2(ptr noalias %out, ptr noalias %in, i64 %n) {
; CHECK-LABEL: @dse_strncpy_memset_chk_test2(
; CHECK-NEXT:    [[CALL:%.*]] = tail call ptr @strncpy(ptr [[OUT:%.*]], ptr [[IN:%.*]], i64 100)
; CHECK-NEXT:    [[CALL_2:%.*]] = tail call ptr @__memset_chk(ptr [[OUT]], i32 42, i64 99, i64 [[N:%.*]])
; CHECK-NEXT:    ret void
;
  %call = tail call ptr @strncpy(ptr %out, ptr %in, i64 100)
  %call.2 = tail call ptr @__memset_chk(ptr %out, i32 42, i64 99, i64 %n)
  ret void
}

; strncpy -> memset_chk, different destination
define void @dse_strncpy_chk_test3(ptr noalias %out1, ptr noalias %out2, ptr noalias %in, i64 %n) {
; CHECK-LABEL: @dse_strncpy_chk_test3(
; CHECK-NEXT:    [[CALL:%.*]] = tail call ptr @strncpy(ptr [[OUT1:%.*]], ptr [[IN:%.*]], i64 100)
; CHECK-NEXT:    [[CALL_2:%.*]] = tail call ptr @__memset_chk(ptr [[OUT2:%.*]], i32 42, i64 100, i64 [[N:%.*]])
; CHECK-NEXT:    ret void
;
  %call = tail call ptr @strncpy(ptr %out1, ptr %in, i64 100)
  %call.2 = tail call ptr @__memset_chk(ptr %out2, i32 42, i64 100, i64 %n)
  ret void
}

define void @dse_strncpy_memcpy_chk_test1(ptr noalias %out, ptr noalias %in, i64 %n) {
; CHECK-LABEL: @dse_strncpy_memcpy_chk_test1(
; CHECK-NEXT:    [[CALL_1:%.*]] = tail call ptr @__memcpy_chk(ptr [[OUT:%.*]], ptr [[IN:%.*]], i64 100, i64 [[N:%.*]])
; CHECK-NEXT:    ret void
;
  store i32 0, ptr %out
  %call.1 = tail call ptr @__memcpy_chk(ptr %out, ptr %in, i64 100, i64 %n)
  ret void
}

define void @dse_strncpy_memcpy_chk_test2(ptr noalias %out, ptr noalias %in, i64 %n) {
; CHECK-LABEL: @dse_strncpy_memcpy_chk_test2(
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds i8, ptr [[OUT:%.*]], i64 100
; CHECK-NEXT:    store i8 10, ptr [[GEP]], align 1
; CHECK-NEXT:    [[CALL_1:%.*]] = tail call ptr @__memcpy_chk(ptr [[OUT]], ptr [[IN:%.*]], i64 100, i64 [[N:%.*]])
; CHECK-NEXT:    ret void
;
  %gep = getelementptr inbounds i8, ptr %out, i64 100
  store i8 10, ptr %gep
  %call.1 = tail call ptr @__memcpy_chk(ptr %out, ptr %in, i64 100, i64 %n)
  ret void
}
