; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; Test lib call simplification of __memset_chk calls with various values
; for dstlen and len.
;
; RUN: opt < %s -passes=instcombine -S | FileCheck %s
; rdar://7719085

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64"

%struct.T = type { [100 x i32], [100 x i32], [1024 x i8] }
@t = common global %struct.T zeroinitializer

; Check cases where dstlen >= len.

define ptr @test_simplify1() {
; CHECK-LABEL: @test_simplify1(
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr noundef nonnull align 4 dereferenceable(1824) @t, i8 0, i64 1824, i1 false)
; CHECK-NEXT:    ret ptr @t
;

  %ret = call ptr @__memset_chk(ptr @t, i32 0, i64 1824, i64 1824)
  ret ptr %ret
}

define ptr @test_simplify2() {
; CHECK-LABEL: @test_simplify2(
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr noundef nonnull align 4 dereferenceable(1824) @t, i8 0, i64 1824, i1 false)
; CHECK-NEXT:    ret ptr @t
;

  %ret = call ptr @__memset_chk(ptr @t, i32 0, i64 1824, i64 3648)
  ret ptr %ret
}

define ptr @test_simplify3() {
; CHECK-LABEL: @test_simplify3(
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr noundef nonnull align 4 dereferenceable(1824) @t, i8 0, i64 1824, i1 false)
; CHECK-NEXT:    ret ptr @t
;

  %ret = call ptr @__memset_chk(ptr @t, i32 0, i64 1824, i64 -1)
  ret ptr %ret
}

; Same as @test_simplify1 with tail call.
define ptr @test_simplify4() {
; CHECK-LABEL: @test_simplify4(
; CHECK-NEXT:    tail call void @llvm.memset.p0.i64(ptr noundef nonnull align 4 dereferenceable(1824) @t, i8 0, i64 1824, i1 false)
; CHECK-NEXT:    ret ptr @t
;

  %ret = tail call ptr @__memset_chk(ptr @t, i32 0, i64 1824, i64 1824)
  ret ptr %ret
}

; Check cases where dstlen < len.

define ptr @test_no_simplify1() {
; CHECK-LABEL: @test_no_simplify1(
; CHECK-NEXT:    [[RET:%.*]] = call ptr @__memset_chk(ptr nonnull @t, i32 0, i64 1824, i64 400)
; CHECK-NEXT:    ret ptr [[RET]]
;

  %ret = call ptr @__memset_chk(ptr @t, i32 0, i64 1824, i64 400)
  ret ptr %ret
}

define ptr @test_no_simplify2() {
; CHECK-LABEL: @test_no_simplify2(
; CHECK-NEXT:    [[RET:%.*]] = call ptr @__memset_chk(ptr nonnull @t, i32 0, i64 1824, i64 0)
; CHECK-NEXT:    ret ptr [[RET]]
;

  %ret = call ptr @__memset_chk(ptr @t, i32 0, i64 1824, i64 0)
  ret ptr %ret
}

define ptr @test_no_simplify3(ptr %dst, i32 %a, i64 %b, i64 %c) {
; CHECK-LABEL: @test_no_simplify3(
; CHECK-NEXT:    [[RET:%.*]] = musttail call ptr @__memset_chk(ptr [[DST:%.*]], i32 0, i64 1824, i64 1824)
; CHECK-NEXT:    ret ptr [[RET]]
;
  %ret = musttail call ptr @__memset_chk(ptr %dst, i32 0, i64 1824, i64 1824)
  ret ptr %ret
}


; Test that RAUW in SimplifyLibCalls for __memset_chk generates valid IR
define i32 @test_rauw(ptr %a, ptr %b, ptr %c) {
; CHECK-LABEL: @test_rauw(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CALL49:%.*]] = call i64 @strlen(ptr noundef nonnull dereferenceable(1) [[A:%.*]])
; CHECK-NEXT:    [[ADD180:%.*]] = add i64 [[CALL49]], 1
; CHECK-NEXT:    [[YO107:%.*]] = call i64 @llvm.objectsize.i64.p0(ptr [[B:%.*]], i1 false, i1 false, i1 false)
; CHECK-NEXT:    [[CALL50:%.*]] = call ptr @__memmove_chk(ptr [[B]], ptr [[A]], i64 [[ADD180]], i64 [[YO107]])
; CHECK-NEXT:    [[STRLEN:%.*]] = call i64 @strlen(ptr noundef nonnull dereferenceable(1) [[B]])
; CHECK-NEXT:    [[STRCHR1:%.*]] = getelementptr inbounds i8, ptr [[B]], i64 [[STRLEN]]
; CHECK-NEXT:    [[D:%.*]] = load ptr, ptr [[C:%.*]], align 8
; CHECK-NEXT:    [[SUB182:%.*]] = ptrtoint ptr [[D]] to i64
; CHECK-NEXT:    [[SUB183:%.*]] = ptrtoint ptr [[B]] to i64
; CHECK-NEXT:    [[SUB184:%.*]] = sub i64 [[SUB182]], [[SUB183]]
; CHECK-NEXT:    [[ADD52_I_I:%.*]] = add nsw i64 [[SUB184]], 1
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[STRCHR1]], i8 0, i64 [[ADD52_I_I]], i1 false)
; CHECK-NEXT:    ret i32 4
;
entry:
  %call49 = call i64 @strlen(ptr %a)
  %add180 = add i64 %call49, 1
  %yo107 = call i64 @llvm.objectsize.i64.p0(ptr %b, i1 false, i1 false, i1 false)
  %call50 = call ptr @__memmove_chk(ptr %b, ptr %a, i64 %add180, i64 %yo107)
  %call51i = call ptr @strrchr(ptr %b, i32 0)
  %d = load ptr, ptr %c, align 8
  %sub182 = ptrtoint ptr %d to i64
  %sub183 = ptrtoint ptr %b to i64
  %sub184 = sub i64 %sub182, %sub183
  %add52.i.i = add nsw i64 %sub184, 1
  %call185 = call ptr @__memset_chk(ptr %call51i, i32 0, i64 %add52.i.i, i64 -1)
  ret i32 4
}

declare ptr @__memmove_chk(ptr, ptr, i64, i64)
declare ptr @strrchr(ptr, i32)
declare i64 @strlen(ptr nocapture)
declare i64 @llvm.objectsize.i64.p0(ptr, i1, i1, i1)

declare ptr @__memset_chk(ptr, i32, i64, i64)

; FIXME: memset(malloc(x), 0, x) -> calloc(1, x)

define ptr @pr25892(i64 %size) #0 {
; CHECK-LABEL: @pr25892(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CALL:%.*]] = tail call ptr @malloc(i64 [[SIZE:%.*]]) #[[ATTR3:[0-9]+]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq ptr [[CALL]], null
; CHECK-NEXT:    br i1 [[CMP]], label [[CLEANUP:%.*]], label [[IF_END:%.*]]
; CHECK:       if.end:
; CHECK-NEXT:    [[CALL2:%.*]] = tail call i64 @llvm.objectsize.i64.p0(ptr nonnull [[CALL]], i1 false, i1 false, i1 false)
; CHECK-NEXT:    [[CALL3:%.*]] = tail call ptr @__memset_chk(ptr nonnull [[CALL]], i32 0, i64 [[SIZE]], i64 [[CALL2]]) #[[ATTR3]]
; CHECK-NEXT:    br label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[RETVAL_0:%.*]] = phi ptr [ [[CALL]], [[IF_END]] ], [ null, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret ptr [[RETVAL_0]]
;
entry:
  %call = tail call ptr @malloc(i64 %size) #1
  %cmp = icmp eq ptr %call, null
  br i1 %cmp, label %cleanup, label %if.end
if.end:
  %call2 = tail call i64 @llvm.objectsize.i64.p0(ptr nonnull %call, i1 false, i1 false, i1 false)
  %call3 = tail call ptr @__memset_chk(ptr nonnull %call, i32 0, i64 %size, i64 %call2) #1
  br label %cleanup
cleanup:
  %retval.0 = phi ptr [ %call, %if.end ], [ null, %entry ]
  ret ptr %retval.0

}

define ptr @test_no_incompatible_attr(ptr %mem, i32 %val, i32 %size) {
; CHECK-LABEL: @test_no_incompatible_attr(
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr noundef nonnull align 4 dereferenceable(1824) @t, i8 0, i64 1824, i1 false)
; CHECK-NEXT:    ret ptr @t
;

  %ret = call dereferenceable(1) ptr @__memset_chk(ptr @t, i32 0, i64 1824, i64 1824)
  ret ptr %ret
}

declare noalias ptr @malloc(i64) #1

attributes #0 = { nounwind ssp uwtable }
attributes #1 = { nounwind }
attributes #2 = { nounwind readnone }

