/**
 * @file cache/component/debtags/serializer.h
 * @author Enrico Zini (enrico) <enrico@enricozini.org>
 */

#ifndef APTFRONT_CACHE_COMPONENT_DEBTAGS_SERIALIZER_H
#define APTFRONT_CACHE_COMPONENT_DEBTAGS_SERIALIZER_H

#include <apt-front/forward.h>
#include <apt-front/cache/cache.h>
#include <tagcoll/Serializer.h>

namespace Tagcoll
{

/**
 * Convert Packages to strings
 */
template<>
class Converter<aptFront::cache::entity::Package, std::string>
{
public:
	std::string operator()(const aptFront::cache::entity::Package& item);
	OpSet<std::string> operator()(const OpSet<aptFront::cache::entity::Package>& items);
};

/**
 * Convert strings to Packages
 */
template<>
class Converter<std::string, aptFront::cache::entity::Package>
{
protected:
	aptFront::cache::Cache* cache;
public:
	Converter(aptFront::cache::Cache* cache = 0) : cache(cache) {}

	void setOwnerCache( aptFront::cache::Cache *c ) { cache = c; }

	aptFront::cache::entity::Package operator()(const std::string& item);
	OpSet<aptFront::cache::entity::Package> operator()(const OpSet<std::string>& items);
};

/**
 * Convert Facets to strings
 */
template<>
class Converter<aptFront::cache::entity::Facet, std::string>
{
public:
	std::string operator()(const aptFront::cache::entity::Facet& item);
	OpSet<std::string> operator()(const OpSet<aptFront::cache::entity::Facet>& items);
};

/**
 * Convert strings to Facets
 */
template<>
class Converter<std::string, aptFront::cache::entity::Facet>
{
protected:
	aptFront::cache::Cache* cache;
public:
	Converter(aptFront::cache::Cache* cache = 0) : cache(cache) {}

	void setOwnerCache( aptFront::cache::Cache *c ) { cache = c; }

	aptFront::cache::entity::Facet operator()(const std::string& item);
	OpSet<aptFront::cache::entity::Facet> operator()(const OpSet<std::string>& items);
};


/**
 * Convert Tags to strings
 */
template<>
class Converter<aptFront::cache::entity::Tag, std::string>
{
public:
	std::string operator()(const aptFront::cache::entity::Tag& item);
	OpSet<std::string> operator()(const OpSet<aptFront::cache::entity::Tag>& items);
};

/**
 * Convert strings to Tags
 */
template<>
class Converter<std::string, aptFront::cache::entity::Tag>
{
protected:
	aptFront::cache::Cache* cache;
public:
	Converter(aptFront::cache::Cache* cache = 0) : cache(cache) {}

	void setOwnerCache( aptFront::cache::Cache *c ) { cache = c; }

	aptFront::cache::entity::Tag operator()(const std::string& item);
	OpSet<aptFront::cache::entity::Tag> operator()(const OpSet<std::string>& items);
};


};

#endif
