/**
   @file cache/component/history.cpp
   @author Peter Rockai <me@mornfall.net>
*/

#include <apt-front/cache/component/history.h>
#include <apt-front/cache/component/state.h>

using namespace aptFront::cache;
using namespace aptFront::cache::component;

#ifdef COMPILE_TESTSUITE
#include "test-utils.h"

namespace tut {

struct cache_component_history_shar {
    Cache c;
    cache_component_history_shar() {
        aptInit();
        c.open( Cache::OpenDefault | Cache::OpenReadOnly );
        c.addComponent( new History<State>() );
    }
};

TESTGRP( cache_component_history );

template<> template<>
void to::test<1>()
{
    History<State> &s = c.component<History<State> >();
    entity::Package p = c.packages().packageByName( "exim4" );
    while (!p.canInstall()) {
        p = p.nextInCache();
    }
    s.checkpoint();
    p.markInstall();
    ensure( p.markedInstall() );
    ensure( !s.canRedo() );
    ensure( s.canUndo() );
    s.undo();
    ensure( !s.canUndo() );
    ensure( !p.markedInstall() );
    ensure( s.canRedo() );
    s.redo();
    ensure( !s.canRedo() );
    ensure( p.markedInstall() );
    s.undo();
    s.checkpoint();
    p.markInstall();
    ensure( p.markedInstall() );
    ensure( !s.canRedo() );
    ensure( s.canUndo() );
    s.undo();
    ensure( !p.markedInstall() );
    ensure( s.canRedo() );
    ensure( !s.canUndo() );
}

template<> template<>
void to::test<2>()
{
    History<State> &s = c.component<History<State> >();
    entity::Package p = c.packages().packageByName( "exim4" );
    while (!p.canInstall()) {
        p = p.nextInCache();
    }
    s.checkpoint();
    p.markInstall();
    ensure( p.markedInstall() );
    ensure( !s.canRedo() );
    ensure( s.canUndo() );
    s.undo();
    ensure( !s.canUndo() );
    ensure( !p.markedInstall() );
    ensure( s.canRedo() );
    c.reopen();
    ensure( !s.canUndo() );
    ensure( !s.canRedo() );
}

template<> template<>
void to::test<3>()
{
    History<State> &s = c.component<History<State> >();
    entity::Package p = c.packages().packageByName( "exim4" );
    while (!p.canInstall()) {
        p = p.nextInCache();
    }
    s.checkpoint();
    p.markInstall();
    ensure( p.markedInstall() );
    ensure( !s.canRedo() );
    ensure( s.canUndo() );
    s.undo();
    ensure( !s.canUndo() );
    ensure( !p.markedInstall() );
    ensure( s.canRedo() );
    s.redo();
    c.reopen();
    ensure( !s.canUndo() );
    ensure( !s.canRedo() );
}

template<> template<>
void to::test<4>()
{
    History<State> &s = c.component<History<State> >();
    entity::Package p = c.packages().packageByName( "exim4" );
    while (!p.canInstall()) {
        p = p.nextInCache();
    }
    s.setAutoCheckpoint( true );
    p.markInstall();
    ensure( p.markedInstall() );
    ensure( !s.canRedo() );
    ensure( s.canUndo() );
    s.undo();
    ensure( !s.canUndo() );
    ensure( !p.markedInstall() );
    ensure( s.canRedo() );
    s.redo();
    c.reopen();
    ensure( !s.canUndo() );
    ensure( !s.canRedo() );
    p = c.packages().packageByName( "exim4" );
    while (!p.canInstall()) {
        p = p.nextInCache();
    }
    p.markInstall();
    ensure( s.canUndo() );
    ensure( !s.canRedo() );
    p.markRemove();
    ensure( s.canUndo() );
    ensure( !s.canRedo() );
    s.undo();
    ensure( s.canUndo() );
    ensure( s.canRedo() );
    s.undo();
    ensure( !s.canUndo() );
    s.redo();
    ensure( s.canUndo() );
    ensure( s.canRedo() );
}

}

#endif
