/*
 * Copyright © 2016 Advanced Micro Devices, Inc.
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef __AMDGPU_ASIC_ID_H__
#define __AMDGPU_ASIC_ID_H__

static struct amdgpu_asic_id_table_t {
	uint32_t did;
	uint32_t rid;
	const char *marketing_name;
} const amdgpu_asic_id_table [] = {
	{0x6600,	0x0,	"AMD Radeon HD 8600/8700M"},
	{0x6600,	0x81,	"AMD Radeon R7 M370"},
	{0x6601,	0x0,	"AMD Radeon HD 8500M/8700M"},
	{0x6604,	0x0,	"AMD Radeon R7 M265 Series"},
	{0x6604,	0x81,	"AMD Radeon R7 M350"},
	{0x6605,	0x0,	"AMD Radeon R7 M260 Series"},
	{0x6605,	0x81,	"AMD Radeon R7 M340"},
	{0x6606,	0x0,	"AMD Radeon HD 8790M"},
	{0x6607,	0x0,	"AMD Radeon HD8530M"},
	{0x6608,	0x0,	"AMD FirePro W2100"},
	{0x6610,	0x0,	"AMD Radeon HD 8600 Series"},
	{0x6610,	0x81,	"AMD Radeon R7 350"},
	{0x6610,	0x83,	"AMD Radeon R5 340"},
	{0x6611,	0x0,	"AMD Radeon HD 8500 Series"},
	{0x6613,	0x0,	"AMD Radeon HD 8500 series"},
	{0x6617,	0xC7,	"AMD Radeon R7 240 Series"},
	{0x6640,	0x0,	"AMD Radeon HD 8950"},
	{0x6640,	0x80,	"AMD Radeon R9 M380"},
	{0x6646,	0x0,	"AMD Radeon R9 M280X"},
	{0x6646,	0x80,	"AMD Radeon R9 M470X"},
	{0x6647,	0x0,	"AMD Radeon R9 M270X"},
	{0x6647,	0x80,	"AMD Radeon R9 M380"},
	{0x6649,	0x0,	"AMD FirePro W5100"},
	{0x6658,	0x0,	"AMD Radeon R7 200 Series"},
	{0x665C,	0x0,	"AMD Radeon HD 7700 Series"},
	{0x665D,	0x0,	"AMD Radeon R7 200 Series"},
	{0x665F,	0x81,	"AMD Radeon R7 300 Series"},
	{0x6660,	0x0,	"AMD Radeon HD 8600M Series"},
	{0x6660,	0x81,	"AMD Radeon R5 M335"},
	{0x6660,	0x83,	"AMD Radeon R5 M330"},
	{0x6663,	0x0,	"AMD Radeon HD 8500M Series"},
	{0x6663,	0x83,	"AMD Radeon R5 M320"},
	{0x6664,	0x0,	"AMD Radeon R5 M200 Series"},
	{0x6665,	0x0,	"AMD Radeon R5 M200 Series"},
	{0x6665,	0x83,	"AMD Radeon R5 M320"},
	{0x6667,	0x0,	"AMD Radeon R5 M200 Series"},
	{0x666F,	0x0,	"AMD Radeon HD 8500M"},
	{0x6780,	0x0,	"ATI FirePro V (FireGL V) Graphics Adapter"},
	{0x678A,	0x0,	"ATI FirePro V (FireGL V) Graphics Adapter"},
	{0x6798,	0x0,	"AMD Radeon HD 7900 Series"},
	{0x679A,	0x0,	"AMD Radeon HD 7900 Series"},
	{0x679B,	0x0,	"AMD Radeon HD 7900 Series"},
	{0x679E,	0x0,	"AMD Radeon HD 7800 Series"},
	{0x67A0,	0x0,	"HAWAII XTGL (67A0)"},
	{0x67A1,	0x0,	"HAWAII GL40 (67A1)"},
	{0x67B0,	0x0,	"AMD Radeon R9 200 Series"},
	{0x67B0,	0x80,	"AMD Radeon R9 390 Series"},
	{0x67B1,	0x0,	"AMD Radeon R9 200 Series"},
	{0x67B1,	0x80,	"AMD Radeon R9 390 Series"},
	{0x67B9,	0x0,	"AMD Radeon R9 200 Series"},
	{0x67DF,	0xC4,	"AMD Radeon RX 480 Graphics"},
	{0x67DF,	0xC5,	"AMD Radeon RX 470 Graphics"},
	{0x67DF,	0xC7,	"AMD Radeon RX 480 Graphics"},
	{0x67DF,	0xCF,	"AMD Radeon RX 470 Graphics"},
	{0x67C4,	0x00,	"AMD Radeon Pro WX 7100 Graphics"},
	{0x67C7,	0x00,	"AMD Radeon Pro WX 5100 Graphics"},
	{0x67C0,	0x00,	"AMD Radeon Pro WX 7100 Graphics"},
	{0x67E0,	0x00,	"AMD Radeon Pro WX Series Graphics"},
	{0x67E3,	0x00,	"AMD Radeon Pro WX 4100 Graphics"},
	{0x67E8,	0x00,	"AMD Radeon Pro WX Series Graphics"},
	{0x67E8,	0x01,	"AMD Radeon Pro WX Series Graphics"},
	{0x67E8,	0x80,	"AMD Radeon E9260 Graphics"},
	{0x67EB,	0x00,	"AMD Radeon Pro WX Series Graphics"},
	{0x67EF,	0xC0,	"AMD Radeon RX Graphics"},
	{0x67EF,	0xC1,	"AMD Radeon RX 460 Graphics"},
	{0x67EF,	0xC5,	"AMD Radeon RX 460 Graphics"},
	{0x67EF,	0xC7,	"AMD Radeon RX Graphics"},
	{0x67EF,	0xCF,	"AMD Radeon RX 460 Graphics"},
	{0x67EF,	0xEF,	"AMD Radeon RX Graphics"},
	{0x67FF,	0xC0,	"AMD Radeon RX Graphics"},
	{0x67FF,	0xC1,	"AMD Radeon RX Graphics"},
	{0x6800,	0x0,	"AMD Radeon HD 7970M"},
	{0x6801,	0x0,	"AMD Radeon(TM) HD8970M"},
	{0x6808,	0x0,	"ATI FirePro V(FireGL V) Graphics Adapter"},
	{0x6809,	0x0,	"ATI FirePro V(FireGL V) Graphics Adapter"},
	{0x6810,	0x0,	"AMD Radeon(TM) HD 8800 Series"},
	{0x6810,	0x81,	"AMD Radeon R7 370 Series"},
	{0x6811,	0x0,	"AMD Radeon(TM) HD8800 Series"},
	{0x6811,	0x81,	"AMD Radeon R7 300 Series"},
	{0x6818,	0x0,	"AMD Radeon HD 7800 Series"},
	{0x6819,	0x0,	"AMD Radeon HD 7800 Series"},
	{0x6820,	0x0,	"AMD Radeon HD 8800M Series"},
	{0x6820,	0x81,	"AMD Radeon R9 M375"},
	{0x6820,	0x83,	"AMD Radeon R9 M375X"},
	{0x6821,	0x0,	"AMD Radeon HD 8800M Series"},
	{0x6821,	0x87,	"AMD Radeon R7 M380"},
	{0x6821,	0x83,	"AMD Radeon R9 M370X"},
	{0x6822,	0x0,	"AMD Radeon E8860"},
	{0x6823,	0x0,	"AMD Radeon HD 8800M Series"},
	{0x6825,	0x0,	"AMD Radeon HD 7800M Series"},
	{0x6827,	0x0,	"AMD Radeon HD 7800M Series"},
	{0x6828,	0x0,	"ATI FirePro V(FireGL V) Graphics Adapter"},
	{0x682B,	0x0,	"AMD Radeon HD 8800M Series"},
	{0x682B,	0x87,	"AMD Radeon R9 M360"},
	{0x682C,	0x0,	"AMD FirePro W4100"},
	{0x682D,	0x0,	"AMD Radeon HD 7700M Series"},
	{0x682F,	0x0,	"AMD Radeon HD 7700M Series"},
	{0x6835,	0x0,	"AMD Radeon R7 Series / HD 9000 Series"},
	{0x6837,	0x0,	"AMD Radeon HD7700 Series"},
	{0x683D,	0x0,	"AMD Radeon HD 7700 Series"},
	{0x683F,	0x0,	"AMD Radeon HD 7700 Series"},
	{0x6900,	0x0,	"AMD Radeon R7 M260"},
	{0x6900,	0x81,	"AMD Radeon R7 M360"},
	{0x6900,	0x83,	"AMD Radeon R7 M340"},
	{0x6901,	0x0,	"AMD Radeon R5 M255"},
	{0x6907,	0x0,	"AMD Radeon R5 M255"},
	{0x6907,	0x87,	"AMD Radeon R5 M315"},
	{0x6920,	0x0,	"AMD Radeon R9 M395X"},
	{0x6920,	0x1,	"AMD Radeon R9 M390X"},
	{0x6921,	0x0,	"AMD Radeon R9 M295X"},
	{0x6929,	0x0,	"AMD FirePro S7150"},
	{0x692B,	0x0,	"AMD FirePro W7100"},
	{0x6938,	0x0,	"AMD Radeon R9 200 Series"},
	{0x6938,	0xF0,	"AMD Radeon R9 200 Series"},
	{0x6938,	0xF1,	"AMD Radeon R9 380 Series"},
	{0x6939,	0xF0,	"AMD Radeon R9 200 Series"},
	{0x6939,	0x0,	"AMD Radeon R9 200 Series"},
	{0x6939,	0xF1,	"AMD Radeon R9 380 Series"},
	{0x7300,	0xC8,	"AMD Radeon R9 Fury Series"},
	{0x7300,	0xCB,	"AMD Radeon R9 Fury Series"},
	{0x7300,	0xCA,	"AMD Radeon R9 Fury Series"},
	{0x9874,	0xC4,	"AMD Radeon R7 Graphics"},
	{0x9874,	0xC5,	"AMD Radeon R6 Graphics"},
	{0x9874,	0xC6,	"AMD Radeon R6 Graphics"},
	{0x9874,	0xC7,	"AMD Radeon R5 Graphics"},
	{0x9874,	0x81,	"AMD Radeon R6 Graphics"},
	{0x9874,	0x87,	"AMD Radeon R5 Graphics"},
	{0x9874,	0x85,	"AMD Radeon R6 Graphics"},
	{0x9874,	0x84,	"AMD Radeon R7 Graphics"},

	{0x0000,	0x0,	"\0"},
};
#endif
