/*
 * Copyright (C) 2007  Enrico Zini <enrico@enricozini.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <tests/test-utils.h>
#include <ept/apt/packagerecord.h>

namespace std {
ostream& operator<<(ostream& out, const set<string>& s)
{
	for (set<string>::const_iterator i = s.begin();
			i != s.end(); ++i)
		if (i == s.begin())
			out << *i;
		else
			out << ", " << *i;
	return out;
}
}

namespace tut {
using namespace std;
using namespace ept;
using namespace ept::apt;

struct ept_apt_packagerecord_shar {
};
TESTGRP(ept_apt_packagerecord);

// Check that the supported fields are understood
template<> template<>
void to::test<1>()
{
	string record =
		"Package: apt\n"
		"Priority: important\n"
		"Section: admin\n"
		"Installed-Size: 4368\n"
		"Maintainer: APT Development Team <deity@lists.debian.org>\n"
		"Architecture: amd64\n"
		"Source: apt\n"
		"Version: 0.6.46.4-0.1\n"
		"Replaces: libapt-pkg-doc (<< 0.3.7), libapt-pkg-dev (<< 0.3.7)\n"
		"Provides: libapt-pkg-libc6.3-6-3.11\n"
		"Depends: libc6 (>= 2.3.5-1), libgcc1 (>= 1:4.1.1-12), libstdc++6 (>= 4.1.1-12), debian-archive-keyring\n"
		"Pre-Depends: debtags (maybe)\n"
		"Suggests: aptitude | synaptic | gnome-apt | wajig, dpkg-dev, apt-doc, bzip2\n"
		"Recommends: debtags (maybe)\n"
		"Enhances: debian\n"
		"Conflicts: marameo\n"
		"Filename: pool/main/a/apt/apt_0.6.46.4-0.1_amd64.deb\n"
		"Size: 1436478\n"
		"MD5sum: 1776421f80d6300c77a608e77a9f4a15\n"
		"SHA1: 1bd7337d2df56d267632cf72ac930c0a4895898f\n"
		"SHA256: b92442ab60046b4d0728245f39cc932f26e17db9f7933a5ec9aaa63172f51fda\n"
		"Description: Advanced front-end for dpkg\n"
		" This is Debian's next generation front-end for the dpkg package manager.\n"
		" It provides the apt-get utility and APT dselect method that provides a\n"
		" simpler, safer way to install and upgrade packages.\n"
		" .\n"
		" APT features complete installation ordering, multiple source capability\n"
		" and several other unique features, see the Users Guide in apt-doc.\n"
		"Build-Essential: yes\n"
		"Tag: admin::package-management, filetransfer::ftp, filetransfer::http, hardware::storage:cd, interface::commandline, network::client, protocol::{ftp,http,ipv6}, role::program, suite::debian, use::downloading, use::searching, works-with::software:package\n";

	PackageRecord p(record);

	ensure_equals(p.size(), 24u);

	ensure_equals(p.package(), "apt");
	ensure_equals(p.priority(), "important");
	ensure_equals(p.section(), "admin");
	ensure_equals(p.installedSize(), 4368u);
	ensure_equals(p.maintainer(), "APT Development Team <deity@lists.debian.org>");
	ensure_equals(p.architecture(), "amd64");
	ensure_equals(p.source(), "apt");
	ensure_equals(p.version(), "0.6.46.4-0.1");
	ensure_equals(p.replaces(), "libapt-pkg-doc (<< 0.3.7), libapt-pkg-dev (<< 0.3.7)");
	ensure_equals(p.provides(), "libapt-pkg-libc6.3-6-3.11");
	ensure_equals(p.depends(), "libc6 (>= 2.3.5-1), libgcc1 (>= 1:4.1.1-12), libstdc++6 (>= 4.1.1-12), debian-archive-keyring");
	ensure_equals(p.preDepends(), "debtags (maybe)");
	ensure_equals(p.recommends(), "debtags (maybe)");
	ensure_equals(p.suggests(), "aptitude | synaptic | gnome-apt | wajig, dpkg-dev, apt-doc, bzip2");
	ensure_equals(p.enhances(), "debian");
	ensure_equals(p.conflicts(), "marameo");
	ensure_equals(p.filename(), "pool/main/a/apt/apt_0.6.46.4-0.1_amd64.deb");
	ensure_equals(p.packageSize(), 1436478u);
	ensure_equals(p.md5sum(), "1776421f80d6300c77a608e77a9f4a15");
	ensure_equals(p.sha1(), "1bd7337d2df56d267632cf72ac930c0a4895898f");
	ensure_equals(p.sha256(), "b92442ab60046b4d0728245f39cc932f26e17db9f7933a5ec9aaa63172f51fda");
	ensure_equals(p.description(), "Advanced front-end for dpkg\n"
		" This is Debian's next generation front-end for the dpkg package manager.\n"
		" It provides the apt-get utility and APT dselect method that provides a\n"
		" simpler, safer way to install and upgrade packages.\n"
		" .\n"
		" APT features complete installation ordering, multiple source capability\n"
		" and several other unique features, see the Users Guide in apt-doc.");
	ensure_equals(p.shortDescription(), "Advanced front-end for dpkg");
	ensure_equals(p.longDescription(),
		"This is Debian's next generation front-end for the dpkg package manager.\n"
		" It provides the apt-get utility and APT dselect method that provides a\n"
		" simpler, safer way to install and upgrade packages.\n"
		" .\n"
		" APT features complete installation ordering, multiple source capability\n"
		" and several other unique features, see the Users Guide in apt-doc.");
	ensure_equals(p.buildEssential(), true);
	
	std::set<std::string> tags;
	tags.insert("admin::package-management");
	tags.insert("filetransfer::ftp");
	tags.insert("filetransfer::http");
	tags.insert("hardware::storage:cd");
	tags.insert("interface::commandline");
	tags.insert("network::client");
	tags.insert("protocol::ftp");
	tags.insert("protocol::http");
	tags.insert("protocol::ipv6");
	tags.insert("role::program");
	tags.insert("suite::debian");
	tags.insert("use::downloading");
	tags.insert("use::searching");
	tags.insert("works-with::software:package");
	ensure_equals(p.tag(), tags);
}


}

// vim:set ts=4 sw=4:
