#include <ept/core/apt.h>
#include <ept/core/list.h>
#include <ept/core/xapian.h>

using namespace ept::core;

struct Main {

    AptDatabase db;

    xapian::Source xap;
    record::Source rec;

    std::vector< std::string > args;

    template< typename List >
    void printList( List l ) {
        while ( !l.empty() ) {
            std::cout << l.head().token().package() << " - "
                      << rec.get< record::ShortDescription >( l.head().token() )
                      << std::endl;
            l = l.tail();
        }
    }

    Main( int argc, char **argv )
        : rec( db )
    {
        for ( int i = 1; i < argc; ++i )
            args.push_back( argv[i] );
    }

    int run() {
        Xapian::Enquire enq( xap.db() );
        enq.set_query( xap.makeORQuery( args.begin(), args.end() ) );
        printList( list::take( 50, xapian::List( enq ) ) );
        return 0;
    }
};

int main( int argc, char **argv ) {
    return Main( argc, argv ).run();
}
