/**
 * ===========================================
 * LibFonts : a free Java font reading library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libfonts/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * FontCache.java
 * ------------
 */

package org.pentaho.reporting.libraries.fonts.cache;

import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.registry.FontKey;

/**
 * A font cache is a two-level structure.
 *
 * FontMetrics that are currently in use are held completely in memory (so that at a given time only one font-metric
 * object exists). This way, the font-metrics object can employ internal caches for kerning, charwidth and baselines
 * without having to spend ages with synchronization between the local copy and the global cache.
 *
 * Once the font-metrics are no longer used, they are pushed down to the second-level cache, and may be invalidated
 * or removed later. Fonts are transfered to the second-level cache when the font-storage implementation is closed.
 *
 * @author : Thomas Morgner
 */
public interface FontCache
{
  public FontMetrics getFontMetrics (final FontKey fontKey);
  public void putFontMetrics (final FontKey key, final FontMetrics fontMetrics);
  public void commit();
}
