/**
 * ===========================================
 * LibFonts : a free Java font reading library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libfonts/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * ITextFontRegistry.java
 * ------------
 */

package org.pentaho.reporting.libraries.fonts.itext;

import org.pentaho.reporting.libraries.fonts.merge.CompoundFontRegistry;
import org.pentaho.reporting.libraries.fonts.truetype.TrueTypeFontRegistry;
import org.pentaho.reporting.libraries.fonts.afm.AfmFontRegistry;
import org.pentaho.reporting.libraries.fonts.pfm.PfmFontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.cache.FontCache;
import org.pentaho.reporting.libraries.fonts.LibFontBoot;

/**
 * This class provides access to the iText font system. The IText registry does not actually use iText to
 * register the fonts (as iText does not provide all information we need for that task). 
 *
 * @author Thomas Morgner
 */
public class ITextFontRegistry extends CompoundFontRegistry
{
  private static FontCache secondLevelCache;

  protected static synchronized FontCache internalGetSecondLevelCache()
  {
    if (secondLevelCache == null)
    {
      secondLevelCache = LibFontBoot.getInstance().createDefaultCache();
    }
    return secondLevelCache;
  }

  public ITextFontRegistry()
  {
    addRegistry(new ITextBuiltInFontRegistry());
    addRegistry(new TrueTypeFontRegistry());
    addRegistry(new AfmFontRegistry());
    addRegistry(new PfmFontRegistry());
  }

  public FontCache getSecondLevelCache()
  {
    return internalGetSecondLevelCache();
  }

  public FontMetricsFactory createMetricsFactory()
  {
    return new ITextFontMetricsFactory(this);
  }
}
