/**
 * =========================================
 * LibFormula : a free Java formula library
 * =========================================
 *
 * Project Info:  http://reporting.pentaho.org/libformula/
 *
 * (C) Copyright 2006-2007, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * $Id: GeneratedFormulaParser.java 3522 2007-10-16 10:56:57Z tmorgner $
 * ------------
 * (C) Copyright 2006-2007, by Pentaho Corporation.
 */

/* Generated By:JavaCC: Do not edit this line. GeneratedFormulaParser.java */
package org.jfree.formula.parser;

import java.math.BigDecimal;
import java.util.ArrayList;

import org.jfree.formula.lvalues.ContextLookup;
import org.jfree.formula.lvalues.FormulaFunction;
import org.jfree.formula.lvalues.LValue;
import org.jfree.formula.lvalues.PostfixTerm;
import org.jfree.formula.lvalues.PrefixTerm;
import org.jfree.formula.lvalues.StaticValue;
import org.jfree.formula.lvalues.Term;
import org.jfree.formula.lvalues.DefaultDataTable;
import org.jfree.formula.operators.InfixOperator;
import org.jfree.formula.operators.OperatorFactory;
import org.jfree.formula.operators.PostfixOperator;
import org.jfree.formula.operators.PrefixOperator;
import org.jfree.formula.typing.coretypes.NumberType;
import org.jfree.formula.typing.coretypes.TextType;

public abstract class GeneratedFormulaParser implements GeneratedFormulaParserConstants {

  protected GeneratedFormulaParser ()
  {
  }

  protected abstract OperatorFactory getOperatorFactory();

  public final LValue getExpression() throws ParseException {
  LValue retval;
  Term term = null;
    retval = getLValue();
    switch (jj_nt.kind) {
    case PLUS:
    case MINUS:
    case MULT:
    case DIV:
    case POW:
    case EQUALS:
    case NOT_EQUALS:
    case LT_EQUALS:
    case GT_EQUALS:
    case LT:
    case GT:
    case CONCAT:
      term = startTail(new Term(retval));
      label_1:
      while (true) {
        switch (jj_nt.kind) {
        case PLUS:
        case MINUS:
        case MULT:
        case DIV:
        case POW:
        case EQUALS:
        case NOT_EQUALS:
        case LT_EQUALS:
        case GT_EQUALS:
        case LT:
        case GT:
        case CONCAT:
          break;
        default:
          jj_la1[0] = jj_gen;
          break label_1;
        }
        term = startTail(term);
      }
      break;
    default:
      jj_la1[1] = jj_gen;
    }
    if (term != null)
    {
      {if (true)
      {
        return term;
      }
      }
    }
    {if (true)
    {
      return retval;
    }
    }
    throw new Error("Missing return statement in function");
  }

  public final Term startTail(final LValue retval) throws ParseException {
  LValue val;
  InfixOperator op;
  Term ex;
    op = getInfixOperator();
    val = getLValue();
      if (retval instanceof Term)
      {
        ex = (Term) retval;
      }
      else
      {
        ex = new Term (retval);
      }
      ex.add (op, val);

      {if (true)
      {
        return ex;
      }
      }
    throw new Error("Missing return statement in function");
  }

  public final LValue getLValue() throws ParseException {
  Token value;
  LValue retval;
  PrefixOperator prefixOp = null;
  PostfixOperator postfixOp = null;
    switch (jj_nt.kind) {
    case PLUS:
    case MINUS:
      prefixOp = getPrefixOperator();
      break;
    default:
      jj_la1[2] = jj_gen;
    }
    switch (jj_nt.kind) {
    case COLUMN_LOOKUP:
      value = jj_consume_token(COLUMN_LOOKUP);
                                retval = new ContextLookup (ParserTools.stripQuote(value.image));
      break;
    case STRING_LITERAL:
      value = jj_consume_token(STRING_LITERAL);
                                 retval = new StaticValue (ParserTools.stripQuote(value.image), TextType.TYPE);
      break;
    case UNSIGNED_NUMERIC_LITERAL:
      value = jj_consume_token(UNSIGNED_NUMERIC_LITERAL);
                                           retval = new StaticValue (new BigDecimal (value.image), NumberType.GENERIC_NUMBER);
      break;
    case UNSIGNED_INTEGER:
      value = jj_consume_token(UNSIGNED_INTEGER);
                                   retval = new StaticValue (new BigDecimal (value.image), NumberType.GENERIC_NUMBER);
      break;
    case NULL:
      jj_consume_token(NULL);
               retval = new StaticValue (null);
      break;
    case L_BRACE:
      jj_consume_token(L_BRACE);
      retval = parseArray();
      jj_consume_token(R_BRACE);
      break;
    case IDENTIFIER:
      value = jj_consume_token(IDENTIFIER);
      jj_consume_token(L_PAREN);
                                       retval = parseFunction(value.image);
      jj_consume_token(R_PAREN);
      break;
    case L_PAREN:
      jj_consume_token(L_PAREN);
                  retval = getExpression ();
      jj_consume_token(R_PAREN);
      if (retval instanceof Term == false)
      {
        retval = new Term (retval);
      }
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_nt.kind) {
    case PERCENT:
      postfixOp = getPostfixOperator();
      break;
    default:
      jj_la1[4] = jj_gen;
    }
    if (postfixOp != null)
    {
      retval = new PostfixTerm(retval, postfixOp);
    }
    if (prefixOp != null)
    {
      retval = new PrefixTerm(prefixOp, retval);
    }
    {if (true)
    {
      return retval;
    }
    }
    throw new Error("Missing return statement in function");
  }

  public final LValue parseArray() throws ParseException {
        final ArrayList rows = new ArrayList();
        LValue[] row;
    row = parseRow();
                        rows.add(row);
    label_2:
    while (true) {
      switch (jj_nt.kind) {
      case PIPE:
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_2;
      }
      jj_consume_token(PIPE);
      row = parseRow();
                // should we check here for column count equality to the first row column count?
                // or do we give this responsability to a DefaultDataTable constructor?
                        rows.add(row);
    }
                final LValue[][] table = (LValue[][])rows.toArray(new LValue[rows.size()][]);
                {if (true)
                {
                  return new DefaultDataTable(table);
                }
                }
    throw new Error("Missing return statement in function");
  }

  public final LValue[] parseRow() throws ParseException {
        final ArrayList cols = new ArrayList();
    LValue column;
    column = getExpression();
        cols.add(column);
    label_3:
    while (true) {
      switch (jj_nt.kind) {
      case SEMICOLON:
        break;
      default:
        jj_la1[6] = jj_gen;
        break label_3;
      }
      jj_consume_token(SEMICOLON);
      column = getExpression();
           cols.add(column);
    }
                {if (true)
                {
                  return (LValue[]) cols.toArray(new LValue[cols.size()]);
                }
                }
    throw new Error("Missing return statement in function");
  }

  public final LValue parseFunction(final String name) throws ParseException {
   final ArrayList params = new ArrayList();
   LValue parameter;
    switch (jj_nt.kind) {
    case UNSIGNED_INTEGER:
    case SEMICOLON:
    case L_PAREN:
    case L_BRACE:
    case PLUS:
    case MINUS:
    case IDENTIFIER:
    case COLUMN_LOOKUP:
    case STRING_LITERAL:
    case UNSIGNED_NUMERIC_LITERAL:
    case NULL:
      switch (jj_nt.kind) {
      case SEMICOLON:
        jj_consume_token(SEMICOLON);
           params.add(new StaticValue(null));
        break;
      case UNSIGNED_INTEGER:
      case L_PAREN:
      case L_BRACE:
      case PLUS:
      case MINUS:
      case IDENTIFIER:
      case COLUMN_LOOKUP:
      case STRING_LITERAL:
      case UNSIGNED_NUMERIC_LITERAL:
      case NULL:
        parameter = getExpression();
           params.add(parameter);
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_4:
      while (true) {
        switch (jj_nt.kind) {
        case SEMICOLON:
          break;
        default:
          jj_la1[8] = jj_gen;
          break label_4;
        }
        jj_consume_token(SEMICOLON);
        switch (jj_nt.kind) {
        case UNSIGNED_INTEGER:
        case L_PAREN:
        case L_BRACE:
        case PLUS:
        case MINUS:
        case IDENTIFIER:
        case COLUMN_LOOKUP:
        case STRING_LITERAL:
        case UNSIGNED_NUMERIC_LITERAL:
        case NULL:
          parameter = getExpression();
           params.add(parameter);
          break;
        default:
          jj_la1[9] = jj_gen;
        }
      }
      break;
    default:
      jj_la1[10] = jj_gen;
    }
     if (params == null)
     {
       {if (true)
       {
         return new FormulaFunction(name, new LValue[0]);
       }
       }
     }

     final LValue[] paramVals = (LValue[]) params.toArray(new LValue[params.size()]);
     {if (true)
     {
       return new FormulaFunction(name, paramVals);
     }
     }
    throw new Error("Missing return statement in function");
  }

  public final PrefixOperator getPrefixOperator() throws ParseException {
  Token value;
    switch (jj_nt.kind) {
    case PLUS:
      value = jj_consume_token(PLUS);
      break;
    case MINUS:
      value = jj_consume_token(MINUS);
      break;
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     {if (true)
     {
       return getOperatorFactory().createPrefixOperator(value.image);
     }
     }
    throw new Error("Missing return statement in function");
  }

  public final PostfixOperator getPostfixOperator() throws ParseException {
  Token value;
    value = jj_consume_token(PERCENT);
     {if (true)
     {
       return getOperatorFactory().createPostfixOperator(value.image);
     }
     }
    throw new Error("Missing return statement in function");
  }

  public final InfixOperator getInfixOperator() throws ParseException {
  final InfixOperator op = null;
  Token value;
    switch (jj_nt.kind) {
    case PLUS:
      value = jj_consume_token(PLUS);
      break;
    case MINUS:
      value = jj_consume_token(MINUS);
      break;
    case MULT:
      value = jj_consume_token(MULT);
      break;
    case DIV:
      value = jj_consume_token(DIV);
      break;
    case POW:
      value = jj_consume_token(POW);
      break;
    case EQUALS:
      value = jj_consume_token(EQUALS);
      break;
    case NOT_EQUALS:
      value = jj_consume_token(NOT_EQUALS);
      break;
    case LT_EQUALS:
      value = jj_consume_token(LT_EQUALS);
      break;
    case GT_EQUALS:
      value = jj_consume_token(GT_EQUALS);
      break;
    case LT:
      value = jj_consume_token(LT);
      break;
    case GT:
      value = jj_consume_token(GT);
      break;
    case CONCAT:
      value = jj_consume_token(CONCAT);
      break;
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true)
    {
      return getOperatorFactory().createInfixOperator(value.image);
    }
    }
    throw new Error("Missing return statement in function");
  }

  public GeneratedFormulaParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  public Token token;
  public Token jj_nt;
  private int jj_gen;
  private final int[] jj_la1 = new int[13];
  private static int[] jj_la1_0;
  private static int[] jj_la1_1;
  static {
      jj_la1_0();
      jj_la1_1();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0xf8000000,0xf8000000,0x18000000,0x1080100,0x0,0x4000000,0x40000,0x190c0100,0x40000,0x19080100,0x190c0100,0x18000000,0xf8000000,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x7f,0x7f,0x0,0x10f00,0x80,0x0,0x0,0x10f00,0x0,0x10f00,0x10f00,0x0,0x7f,};
   }

  public GeneratedFormulaParser(final java.io.InputStream stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new GeneratedFormulaParserTokenManager(jj_input_stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 13; i++)
    {
      jj_la1[i] = -1;
    }
  }

  public void ReInit(final java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 13; i++)
    {
      jj_la1[i] = -1;
    }
  }

  public GeneratedFormulaParser(final java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new GeneratedFormulaParserTokenManager(jj_input_stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 13; i++)
    {
      jj_la1[i] = -1;
    }
  }

  public void ReInit(final java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 13; i++)
    {
      jj_la1[i] = -1;
    }
  }

  public GeneratedFormulaParser(final GeneratedFormulaParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 13; i++)
    {
      jj_la1[i] = -1;
    }
  }

  public void ReInit(final GeneratedFormulaParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 13; i++)
    {
      jj_la1[i] = -1;
    }
  }

  private final Token jj_consume_token(final int kind) throws ParseException {
    final Token oldToken = token;
    if ((token = jj_nt).next != null)
    {
      jj_nt = jj_nt.next;
    }
    else
    {
      jj_nt = jj_nt.next = token_source.getNextToken();
    }
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    jj_nt = token;
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  public final Token getNextToken() {
    if ((token = jj_nt).next != null)
    {
      jj_nt = jj_nt.next;
    }
    else
    {
      jj_nt = jj_nt.next = token_source.getNextToken();
    }
    jj_gen++;
    return token;
  }

  public final Token getToken(final int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null)
      {
        t = t.next;
      }
      else
      {
        t = t.next = token_source.getNextToken();
      }
    }
    return t;
  }

  private ArrayList jj_expentries = new ArrayList();
  private int[] jj_expentry;
  private int jj_kind = -1;

  public ParseException generateParseException() {
    jj_expentries.clear();
    final boolean[] la1tokens = new boolean[49];
    for (int i = 0; i < 49; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 13; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 49; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    final int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  public final void enable_tracing() {
  }

  public final void disable_tracing() {
  }

}
