/* linkedlist.c generated by valac 0.44.7, the Vala compiler
 * generated from linkedlist.vala, do not modify */

/* linkedlist.vala
 *
 * Copyright (C) 2004-2005  Novell, Inc
 * Copyright (C) 2005  David Waite
 * Copyright (C) 2007-2008  Jürg Billeter
 * Copyright (C) 2009  Mark Lee, Didier Villevalois
 * Copyright (C) 2010-2014  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Mark Lee <marklee@src.gnome.org>
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib-object.h>
#include <glib.h>

#define GEE_TYPE_TRAVERSABLE (gee_traversable_get_type ())
#define GEE_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversable))
#define GEE_IS_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TRAVERSABLE))
#define GEE_TRAVERSABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversableIface))

typedef struct _GeeTraversable GeeTraversable;
typedef struct _GeeTraversableIface GeeTraversableIface;
typedef gboolean (*GeeForallFunc) (gpointer g, gpointer user_data);
typedef enum  {
	GEE_TRAVERSABLE_STREAM_YIELD,
	GEE_TRAVERSABLE_STREAM_CONTINUE,
	GEE_TRAVERSABLE_STREAM_END,
	GEE_TRAVERSABLE_STREAM_WAIT
} GeeTraversableStream;

#define GEE_TRAVERSABLE_TYPE_STREAM (gee_traversable_stream_get_type ())

#define GEE_TYPE_LAZY (gee_lazy_get_type ())
#define GEE_LAZY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LAZY, GeeLazy))
#define GEE_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LAZY, GeeLazyClass))
#define GEE_IS_LAZY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LAZY))
#define GEE_IS_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LAZY))
#define GEE_LAZY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LAZY, GeeLazyClass))

typedef struct _GeeLazy GeeLazy;
typedef struct _GeeLazyClass GeeLazyClass;
typedef GeeTraversableStream (*GeeStreamFunc) (GeeTraversableStream state, GeeLazy* g, GeeLazy* * lazy, gpointer user_data);

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;
typedef gpointer (*GeeFoldFunc) (gpointer g, gpointer a, gpointer user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, gpointer user_data);
typedef gboolean (*GeePredicate) (gconstpointer g, gpointer user_data);
typedef GeeIterator* (*GeeFlatMapFunc) (gpointer g, gpointer user_data);

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_LIST (gee_list_get_type ())
#define GEE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST, GeeList))
#define GEE_IS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST))
#define GEE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST, GeeListIface))

typedef struct _GeeList GeeList;
typedef struct _GeeListIface GeeListIface;

#define GEE_TYPE_LIST_ITERATOR (gee_list_iterator_get_type ())
#define GEE_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIterator))
#define GEE_IS_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST_ITERATOR))
#define GEE_LIST_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIteratorIface))

typedef struct _GeeListIterator GeeListIterator;
typedef struct _GeeListIteratorIface GeeListIteratorIface;

#define GEE_TYPE_ABSTRACT_LIST (gee_abstract_list_get_type ())
#define GEE_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractList))
#define GEE_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))
#define GEE_IS_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_LIST))
#define GEE_IS_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_LIST))
#define GEE_ABSTRACT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))

typedef struct _GeeAbstractList GeeAbstractList;
typedef struct _GeeAbstractListClass GeeAbstractListClass;
typedef struct _GeeAbstractListPrivate GeeAbstractListPrivate;

#define GEE_TYPE_BIDIR_LIST (gee_bidir_list_get_type ())
#define GEE_BIDIR_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_BIDIR_LIST, GeeBidirList))
#define GEE_IS_BIDIR_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_BIDIR_LIST))
#define GEE_BIDIR_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_BIDIR_LIST, GeeBidirListIface))

typedef struct _GeeBidirList GeeBidirList;
typedef struct _GeeBidirListIface GeeBidirListIface;

#define GEE_TYPE_BIDIR_LIST_ITERATOR (gee_bidir_list_iterator_get_type ())
#define GEE_BIDIR_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_BIDIR_LIST_ITERATOR, GeeBidirListIterator))
#define GEE_IS_BIDIR_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_BIDIR_LIST_ITERATOR))
#define GEE_BIDIR_LIST_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_BIDIR_LIST_ITERATOR, GeeBidirListIteratorIface))

typedef struct _GeeBidirListIterator GeeBidirListIterator;
typedef struct _GeeBidirListIteratorIface GeeBidirListIteratorIface;

#define GEE_TYPE_BIDIR_ITERATOR (gee_bidir_iterator_get_type ())
#define GEE_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIterator))
#define GEE_IS_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_BIDIR_ITERATOR))
#define GEE_BIDIR_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIteratorIface))

typedef struct _GeeBidirIterator GeeBidirIterator;
typedef struct _GeeBidirIteratorIface GeeBidirIteratorIface;

#define GEE_TYPE_ABSTRACT_BIDIR_LIST (gee_abstract_bidir_list_get_type ())
#define GEE_ABSTRACT_BIDIR_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirList))
#define GEE_ABSTRACT_BIDIR_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirListClass))
#define GEE_IS_ABSTRACT_BIDIR_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_BIDIR_LIST))
#define GEE_IS_ABSTRACT_BIDIR_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_BIDIR_LIST))
#define GEE_ABSTRACT_BIDIR_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirListClass))

typedef struct _GeeAbstractBidirList GeeAbstractBidirList;
typedef struct _GeeAbstractBidirListClass GeeAbstractBidirListClass;
typedef struct _GeeAbstractBidirListPrivate GeeAbstractBidirListPrivate;

#define GEE_TYPE_QUEUE (gee_queue_get_type ())
#define GEE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_QUEUE, GeeQueue))
#define GEE_IS_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_QUEUE))
#define GEE_QUEUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_QUEUE, GeeQueueIface))

typedef struct _GeeQueue GeeQueue;
typedef struct _GeeQueueIface GeeQueueIface;

#define GEE_TYPE_DEQUE (gee_deque_get_type ())
#define GEE_DEQUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_DEQUE, GeeDeque))
#define GEE_IS_DEQUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_DEQUE))
#define GEE_DEQUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_DEQUE, GeeDequeIface))

typedef struct _GeeDeque GeeDeque;
typedef struct _GeeDequeIface GeeDequeIface;

#define GEE_TYPE_LINKED_LIST (gee_linked_list_get_type ())
#define GEE_LINKED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LINKED_LIST, GeeLinkedList))
#define GEE_LINKED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LINKED_LIST, GeeLinkedListClass))
#define GEE_IS_LINKED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LINKED_LIST))
#define GEE_IS_LINKED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LINKED_LIST))
#define GEE_LINKED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LINKED_LIST, GeeLinkedListClass))

typedef struct _GeeLinkedList GeeLinkedList;
typedef struct _GeeLinkedListClass GeeLinkedListClass;
typedef struct _GeeLinkedListPrivate GeeLinkedListPrivate;
typedef struct _GeeLinkedListNode GeeLinkedListNode;

#define GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE (gee_functions_equal_data_func_closure_get_type ())
#define GEE_FUNCTIONS_EQUAL_DATA_FUNC_CLOSURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE, GeeFunctionsEqualDataFuncClosure))
#define GEE_FUNCTIONS_EQUAL_DATA_FUNC_CLOSURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE, GeeFunctionsEqualDataFuncClosureClass))
#define GEE_FUNCTIONS_IS_EQUAL_DATA_FUNC_CLOSURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE))
#define GEE_FUNCTIONS_IS_EQUAL_DATA_FUNC_CLOSURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE))
#define GEE_FUNCTIONS_EQUAL_DATA_FUNC_CLOSURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE, GeeFunctionsEqualDataFuncClosureClass))

typedef struct _GeeFunctionsEqualDataFuncClosure GeeFunctionsEqualDataFuncClosure;
typedef struct _GeeFunctionsEqualDataFuncClosureClass GeeFunctionsEqualDataFuncClosureClass;
enum  {
	GEE_LINKED_LIST_0_PROPERTY,
	GEE_LINKED_LIST_G_TYPE,
	GEE_LINKED_LIST_G_DUP_FUNC,
	GEE_LINKED_LIST_G_DESTROY_FUNC,
	GEE_LINKED_LIST_SIZE_PROPERTY,
	GEE_LINKED_LIST_READ_ONLY_PROPERTY,
	GEE_LINKED_LIST_CAPACITY_PROPERTY,
	GEE_LINKED_LIST_REMAINING_CAPACITY_PROPERTY,
	GEE_LINKED_LIST_IS_FULL_PROPERTY,
	GEE_LINKED_LIST_NUM_PROPERTIES
};
static GParamSpec* gee_linked_list_properties[GEE_LINKED_LIST_NUM_PROPERTIES];
#define _gee_linked_list_node_free0(var) ((var == NULL) ? NULL : (var = (gee_linked_list_node_free (var), NULL)))
#define _gee_functions_equal_data_func_closure_unref0(var) ((var == NULL) ? NULL : (var = (gee_functions_equal_data_func_closure_unref (var), NULL)))
typedef gboolean (*GeeEqualDataFunc) (gconstpointer a, gconstpointer b, gpointer user_data);

#define GEE_LINKED_LIST_TYPE_ITERATOR (gee_linked_list_iterator_get_type ())
#define GEE_LINKED_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIterator))
#define GEE_LINKED_LIST_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIteratorClass))
#define GEE_LINKED_LIST_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_LINKED_LIST_TYPE_ITERATOR))
#define GEE_LINKED_LIST_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_LINKED_LIST_TYPE_ITERATOR))
#define GEE_LINKED_LIST_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIteratorClass))

typedef struct _GeeLinkedListIterator GeeLinkedListIterator;
typedef struct _GeeLinkedListIteratorClass GeeLinkedListIteratorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GeeFunctionsEqualDataFuncClosurePrivate GeeFunctionsEqualDataFuncClosurePrivate;
typedef struct _GeeLinkedListIteratorPrivate GeeLinkedListIteratorPrivate;
enum  {
	GEE_LINKED_LIST_ITERATOR_0_PROPERTY,
	GEE_LINKED_LIST_ITERATOR_G_TYPE,
	GEE_LINKED_LIST_ITERATOR_G_DUP_FUNC,
	GEE_LINKED_LIST_ITERATOR_G_DESTROY_FUNC,
	GEE_LINKED_LIST_ITERATOR_READ_ONLY_PROPERTY,
	GEE_LINKED_LIST_ITERATOR_VALID_PROPERTY,
	GEE_LINKED_LIST_ITERATOR_NUM_PROPERTIES
};
static GParamSpec* gee_linked_list_iterator_properties[GEE_LINKED_LIST_ITERATOR_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
	gboolean (*get_valid) (GeeIterator* self);
	gboolean (*get_read_only) (GeeIterator* self);
};

struct _GeeTraversableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeTraversable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeTraversable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeTraversable* self);
	gboolean (*foreach) (GeeTraversable* self, GeeForallFunc f, gpointer f_target);
	GeeIterator* (*stream) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, gpointer f_target, GDestroyNotify f_target_destroy_notify);
	gpointer (*fold) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, gpointer f_target, gpointer seed);
	GeeIterator* (*map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, gpointer f_target);
	GeeIterator* (*scan) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, gpointer f_target, gpointer seed);
	GeeIterator* (*filter) (GeeTraversable* self, GeePredicate pred, gpointer pred_target, GDestroyNotify pred_target_destroy_notify);
	GeeIterator* (*chop) (GeeTraversable* self, gint offset, gint length);
	GType (*get_element_type) (GeeTraversable* self);
	GeeIterator* (*flat_map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFlatMapFunc f, gpointer f_target, GDestroyNotify f_target_destroy_notify);
	GeeIterator** (*tee) (GeeTraversable* self, guint forks, gint* result_length1);
	gpointer (*first_match) (GeeTraversable* self, GeePredicate pred, gpointer pred_target, GDestroyNotify pred_target_destroy_notify);
	gboolean (*any_match) (GeeTraversable* self, GeePredicate pred, gpointer pred_target, GDestroyNotify pred_target_destroy_notify);
	gboolean (*all_match) (GeeTraversable* self, GeePredicate pred, gpointer pred_target, GDestroyNotify pred_target_destroy_notify);
	gpointer (*max) (GeeTraversable* self, GCompareDataFunc compare, gpointer compare_target, GDestroyNotify compare_target_destroy_notify);
	gpointer (*min) (GeeTraversable* self, GCompareDataFunc compare, gpointer compare_target, GDestroyNotify compare_target_destroy_notify);
	GeeIterator* (*order_by) (GeeTraversable* self, GCompareDataFunc compare, gpointer compare_target, GDestroyNotify compare_target_destroy_notify);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeIterable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeIterable* self);
	GeeIterator* (*iterator) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeCollection* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeCollection* self);
	GDestroyNotify (*get_g_destroy_func) (GeeCollection* self);
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, gint* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	gboolean (*get_read_only) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
	gboolean (*add_all_array) (GeeCollection* self, gpointer* array, gint array_length1);
	gboolean (*contains_all_array) (GeeCollection* self, gpointer* array, gint array_length1);
	gboolean (*remove_all_array) (GeeCollection* self, gpointer* array, gint array_length1);
	gboolean (*add_all_iterator) (GeeCollection* self, GeeIterator* iter);
	gboolean (*contains_all_iterator) (GeeCollection* self, GeeIterator* iter);
	gboolean (*remove_all_iterator) (GeeCollection* self, GeeIterator* iter);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gboolean (*foreach) (GeeAbstractCollection* self, GeeForallFunc f, gpointer f_target);
	void (*reserved0) (GeeAbstractCollection* self);
	void (*reserved1) (GeeAbstractCollection* self);
	void (*reserved2) (GeeAbstractCollection* self);
	void (*reserved3) (GeeAbstractCollection* self);
	void (*reserved4) (GeeAbstractCollection* self);
	void (*reserved5) (GeeAbstractCollection* self);
	void (*reserved6) (GeeAbstractCollection* self);
	void (*reserved7) (GeeAbstractCollection* self);
	void (*reserved8) (GeeAbstractCollection* self);
	void (*reserved9) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_read_only) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeListIteratorIface {
	GTypeInterface parent_iface;
	void (*set) (GeeListIterator* self, gconstpointer item);
	void (*add) (GeeListIterator* self, gconstpointer item);
	gint (*index) (GeeListIterator* self);
};

struct _GeeListIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeList* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeList* self);
	GDestroyNotify (*get_g_destroy_func) (GeeList* self);
	GeeListIterator* (*list_iterator) (GeeList* self);
	gpointer (*get) (GeeList* self, gint index);
	void (*set) (GeeList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeList* self, gconstpointer item);
	void (*insert) (GeeList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeList* self, gint index);
	GeeList* (*slice) (GeeList* self, gint start, gint stop);
	gpointer (*first) (GeeList* self);
	gpointer (*last) (GeeList* self);
	void (*insert_all) (GeeList* self, gint index, GeeCollection* collection);
	void (*sort) (GeeList* self, GCompareDataFunc compare_func, gpointer compare_func_target, GDestroyNotify compare_func_target_destroy_notify);
	GeeList* (*get_read_only_view) (GeeList* self);
};

struct _GeeAbstractList {
	GeeAbstractCollection parent_instance;
	GeeAbstractListPrivate * priv;
};

struct _GeeAbstractListClass {
	GeeAbstractCollectionClass parent_class;
	GeeListIterator* (*list_iterator) (GeeAbstractList* self);
	gpointer (*get) (GeeAbstractList* self, gint index);
	void (*set) (GeeAbstractList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeAbstractList* self, gconstpointer item);
	void (*insert) (GeeAbstractList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeAbstractList* self, gint index);
	GeeList* (*slice) (GeeAbstractList* self, gint start, gint stop);
	void (*reserved0) (GeeAbstractList* self);
	void (*reserved1) (GeeAbstractList* self);
	void (*reserved2) (GeeAbstractList* self);
	void (*reserved3) (GeeAbstractList* self);
	void (*reserved4) (GeeAbstractList* self);
	void (*reserved5) (GeeAbstractList* self);
	void (*reserved6) (GeeAbstractList* self);
	void (*reserved7) (GeeAbstractList* self);
	void (*reserved8) (GeeAbstractList* self);
	void (*reserved9) (GeeAbstractList* self);
	GeeList* (*get_read_only_view) (GeeAbstractList* self);
};

struct _GeeBidirIteratorIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeBidirIterator* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeBidirIterator* self);
	GDestroyNotify (*get_g_destroy_func) (GeeBidirIterator* self);
	gboolean (*previous) (GeeBidirIterator* self);
	gboolean (*has_previous) (GeeBidirIterator* self);
	gboolean (*first) (GeeBidirIterator* self);
	gboolean (*last) (GeeBidirIterator* self);
};

struct _GeeBidirListIteratorIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeBidirListIterator* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeBidirListIterator* self);
	GDestroyNotify (*get_g_destroy_func) (GeeBidirListIterator* self);
	void (*insert) (GeeBidirListIterator* self, gconstpointer item);
};

struct _GeeBidirListIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeBidirList* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeBidirList* self);
	GDestroyNotify (*get_g_destroy_func) (GeeBidirList* self);
	GeeBidirListIterator* (*bidir_list_iterator) (GeeBidirList* self);
	GeeBidirList* (*get_read_only_view) (GeeBidirList* self);
};

struct _GeeAbstractBidirList {
	GeeAbstractList parent_instance;
	GeeAbstractBidirListPrivate * priv;
};

struct _GeeAbstractBidirListClass {
	GeeAbstractListClass parent_class;
	GeeBidirListIterator* (*bidir_list_iterator) (GeeAbstractBidirList* self);
	void (*reserved0) (GeeAbstractBidirList* self);
	void (*reserved1) (GeeAbstractBidirList* self);
	void (*reserved2) (GeeAbstractBidirList* self);
	void (*reserved3) (GeeAbstractBidirList* self);
	void (*reserved4) (GeeAbstractBidirList* self);
	void (*reserved5) (GeeAbstractBidirList* self);
	void (*reserved6) (GeeAbstractBidirList* self);
	void (*reserved7) (GeeAbstractBidirList* self);
	void (*reserved8) (GeeAbstractBidirList* self);
	void (*reserved9) (GeeAbstractBidirList* self);
	GeeBidirList* (*get_read_only_view) (GeeAbstractBidirList* self);
};

struct _GeeQueueIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeQueue* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeQueue* self);
	GDestroyNotify (*get_g_destroy_func) (GeeQueue* self);
	gboolean (*offer) (GeeQueue* self, gconstpointer element);
	gpointer (*peek) (GeeQueue* self);
	gpointer (*poll) (GeeQueue* self);
	gint (*drain) (GeeQueue* self, GeeCollection* recipient, gint amount);
	gint (*get_capacity) (GeeQueue* self);
	gint (*get_remaining_capacity) (GeeQueue* self);
	gboolean (*get_is_full) (GeeQueue* self);
};

struct _GeeDequeIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeDeque* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeDeque* self);
	GDestroyNotify (*get_g_destroy_func) (GeeDeque* self);
	gboolean (*offer_head) (GeeDeque* self, gconstpointer element);
	gpointer (*peek_head) (GeeDeque* self);
	gpointer (*poll_head) (GeeDeque* self);
	gint (*drain_head) (GeeDeque* self, GeeCollection* recipient, gint amount);
	gboolean (*offer_tail) (GeeDeque* self, gconstpointer element);
	gpointer (*peek_tail) (GeeDeque* self);
	gpointer (*poll_tail) (GeeDeque* self);
	gint (*drain_tail) (GeeDeque* self, GeeCollection* recipient, gint amount);
};

struct _GeeLinkedList {
	GeeAbstractBidirList parent_instance;
	GeeLinkedListPrivate * priv;
};

struct _GeeLinkedListClass {
	GeeAbstractBidirListClass parent_class;
};

struct _GeeLinkedListPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gint _size;
	gint _stamp;
	GeeLinkedListNode* _head;
	GeeLinkedListNode* _tail;
	GeeFunctionsEqualDataFuncClosure* _equal_func;
};

struct _GeeLinkedListNode {
	gpointer data;
	GeeLinkedListNode* prev;
	GeeLinkedListNode* next;
};

struct _GeeFunctionsEqualDataFuncClosure {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GeeFunctionsEqualDataFuncClosurePrivate * priv;
	GeeEqualDataFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
};

struct _GeeFunctionsEqualDataFuncClosureClass {
	GTypeClass parent_class;
	void (*finalize) (GeeFunctionsEqualDataFuncClosure *self);
};

struct _GeeLinkedListIterator {
	GObject parent_instance;
	GeeLinkedListIteratorPrivate * priv;
	gboolean _removed;
	GeeLinkedListNode* _position;
	gint _stamp;
	GeeLinkedList* _list;
	gint _index;
};

struct _GeeLinkedListIteratorClass {
	GObjectClass parent_class;
};

struct _GeeLinkedListIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

static gint GeeLinkedList_private_offset;
static gpointer gee_linked_list_parent_class = NULL;
static gint GeeLinkedListIterator_private_offset;
static gpointer gee_linked_list_iterator_parent_class = NULL;
static GeeTraversableIface * gee_linked_list_iterator_gee_traversable_parent_iface = NULL;
static GeeIteratorIface * gee_linked_list_iterator_gee_iterator_parent_iface = NULL;
static GeeBidirIteratorIface * gee_linked_list_iterator_gee_bidir_iterator_parent_iface = NULL;
static GeeListIteratorIface * gee_linked_list_iterator_gee_list_iterator_parent_iface = NULL;
static GeeBidirListIteratorIface * gee_linked_list_iterator_gee_bidir_list_iterator_parent_iface = NULL;
static GeeQueueIface * gee_linked_list_gee_queue_parent_iface = NULL;
static GeeDequeIface * gee_linked_list_gee_deque_parent_iface = NULL;

GType gee_traversable_stream_get_type (void) G_GNUC_CONST;
gpointer gee_lazy_ref (gpointer instance);
void gee_lazy_unref (gpointer instance);
GParamSpec* gee_param_spec_lazy (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
void gee_value_set_lazy (GValue* value,
                         gpointer v_object);
void gee_value_take_lazy (GValue* value,
                          gpointer v_object);
gpointer gee_value_get_lazy (const GValue* value);
GType gee_lazy_get_type (void) G_GNUC_CONST;
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_list_iterator_get_type (void) G_GNUC_CONST;
GType gee_list_get_type (void) G_GNUC_CONST;
GType gee_abstract_list_get_type (void) G_GNUC_CONST;
GType gee_bidir_iterator_get_type (void) G_GNUC_CONST;
GType gee_bidir_list_iterator_get_type (void) G_GNUC_CONST;
GType gee_bidir_list_get_type (void) G_GNUC_CONST;
GType gee_abstract_bidir_list_get_type (void) G_GNUC_CONST;
GType gee_queue_get_type (void) G_GNUC_CONST;
GType gee_deque_get_type (void) G_GNUC_CONST;
GType gee_linked_list_get_type (void) G_GNUC_CONST;
static void gee_linked_list_node_free (GeeLinkedListNode * self);
G_GNUC_INTERNAL gpointer gee_functions_equal_data_func_closure_ref (gpointer instance);
G_GNUC_INTERNAL void gee_functions_equal_data_func_closure_unref (gpointer instance);
G_GNUC_INTERNAL GParamSpec* gee_functions_param_spec_equal_data_func_closure (const gchar* name,
                                                              const gchar* nick,
                                                              const gchar* blurb,
                                                              GType object_type,
                                                              GParamFlags flags);
G_GNUC_INTERNAL void gee_functions_value_set_equal_data_func_closure (GValue* value,
                                                      gpointer v_object) G_GNUC_UNUSED;
G_GNUC_INTERNAL void gee_functions_value_take_equal_data_func_closure (GValue* value,
                                                       gpointer v_object);
G_GNUC_INTERNAL gpointer gee_functions_value_get_equal_data_func_closure (const GValue* value) G_GNUC_UNUSED;
G_GNUC_INTERNAL GType gee_functions_equal_data_func_closure_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
void gee_abstract_collection_clear (GeeAbstractCollection* self);
GeeLinkedList* gee_linked_list_new (GType g_type,
                                    GBoxedCopyFunc g_dup_func,
                                    GDestroyNotify g_destroy_func,
                                    GeeEqualDataFunc equal_func,
                                    gpointer equal_func_target,
                                    GDestroyNotify equal_func_target_destroy_notify);
GeeLinkedList* gee_linked_list_construct (GType object_type,
                                          GType g_type,
                                          GBoxedCopyFunc g_dup_func,
                                          GDestroyNotify g_destroy_func,
                                          GeeEqualDataFunc equal_func,
                                          gpointer equal_func_target,
                                          GDestroyNotify equal_func_target_destroy_notify);
GeeAbstractBidirList* gee_abstract_bidir_list_construct (GType object_type,
                                                         GType g_type,
                                                         GBoxedCopyFunc g_dup_func,
                                                         GDestroyNotify g_destroy_func);
GeeEqualDataFunc gee_functions_get_equal_func_for (GType t,
                                                   gpointer* result_target,
                                                   GDestroyNotify* result_target_destroy_notify);
G_GNUC_INTERNAL GeeFunctionsEqualDataFuncClosure* gee_functions_equal_data_func_closure_new (GType g_type,
                                                                             GBoxedCopyFunc g_dup_func,
                                                                             GDestroyNotify g_destroy_func,
                                                                             GeeEqualDataFunc func,
                                                                             gpointer func_target,
                                                                             GDestroyNotify func_target_destroy_notify);
G_GNUC_INTERNAL GeeFunctionsEqualDataFuncClosure* gee_functions_equal_data_func_closure_construct (GType object_type,
                                                                                   GType g_type,
                                                                                   GBoxedCopyFunc g_dup_func,
                                                                                   GDestroyNotify g_destroy_func,
                                                                                   GeeEqualDataFunc func,
                                                                                   gpointer func_target,
                                                                                   GDestroyNotify func_target_destroy_notify);
static GeeLinkedList* gee_linked_list_new_with_closures (GType g_type,
                                                  GBoxedCopyFunc g_dup_func,
                                                  GDestroyNotify g_destroy_func,
                                                  GeeFunctionsEqualDataFuncClosure* equal_func);
static GeeLinkedList* gee_linked_list_construct_with_closures (GType object_type,
                                                        GType g_type,
                                                        GBoxedCopyFunc g_dup_func,
                                                        GDestroyNotify g_destroy_func,
                                                        GeeFunctionsEqualDataFuncClosure* equal_func);
static gboolean gee_linked_list_real_foreach (GeeAbstractCollection* base,
                                       GeeForallFunc f,
                                       gpointer f_target);
static GeeIterator* gee_linked_list_real_iterator (GeeAbstractCollection* base);
static GeeLinkedListIterator* gee_linked_list_iterator_new (GType g_type,
                                                     GBoxedCopyFunc g_dup_func,
                                                     GDestroyNotify g_destroy_func,
                                                     GeeLinkedList* list);
static GeeLinkedListIterator* gee_linked_list_iterator_construct (GType object_type,
                                                           GType g_type,
                                                           GBoxedCopyFunc g_dup_func,
                                                           GDestroyNotify g_destroy_func,
                                                           GeeLinkedList* list);
static GType gee_linked_list_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GeeListIterator* gee_linked_list_real_list_iterator (GeeAbstractList* base);
static GeeBidirListIterator* gee_linked_list_real_bidir_list_iterator (GeeAbstractBidirList* base);
static gboolean gee_linked_list_real_contains (GeeAbstractCollection* base,
                                        gconstpointer item);
gint gee_abstract_list_index_of (GeeAbstractList* self,
                                 gconstpointer item);
static gboolean gee_linked_list_real_add (GeeAbstractCollection* base,
                                   gconstpointer item);
static GeeLinkedListNode* gee_linked_list_node_new (gpointer data);
static gboolean gee_linked_list_real_remove (GeeAbstractCollection* base,
                                      gconstpointer item);
GeeEqualDataFunc gee_linked_list_get_equal_func (GeeLinkedList* self,
                                                 gpointer* result_target);
static void _gee_linked_list_remove_node (GeeLinkedList* self,
                                   GeeLinkedListNode* _n);
static void gee_linked_list_real_clear (GeeAbstractCollection* base);
static gpointer gee_linked_list_real_get (GeeAbstractList* base,
                                   gint index);
static GeeLinkedListNode* _gee_linked_list_get_node_at (GeeLinkedList* self,
                                                 gint index);
static void gee_linked_list_real_set (GeeAbstractList* base,
                               gint index,
                               gconstpointer item);
static gint gee_linked_list_real_index_of (GeeAbstractList* base,
                                    gconstpointer item);
static void gee_linked_list_real_insert (GeeAbstractList* base,
                                  gint index,
                                  gconstpointer item);
gboolean gee_abstract_collection_add (GeeAbstractCollection* self,
                                      gconstpointer item);
static gpointer gee_linked_list_real_remove_at (GeeAbstractList* base,
                                         gint index);
static GeeList* gee_linked_list_real_slice (GeeAbstractList* base,
                                     gint start,
                                     gint stop);
gboolean gee_collection_add (GeeCollection* self,
                             gconstpointer item);
gpointer gee_linked_list_first (GeeLinkedList* self);
gpointer gee_linked_list_last (GeeLinkedList* self);
static gboolean gee_linked_list_real_offer (GeeQueue* base,
                                     gconstpointer element);
gboolean gee_deque_offer_tail (GeeDeque* self,
                               gconstpointer element);
static gpointer gee_linked_list_real_peek (GeeQueue* base);
gpointer gee_deque_peek_head (GeeDeque* self);
static gpointer gee_linked_list_real_poll (GeeQueue* base);
gpointer gee_deque_poll_head (GeeDeque* self);
static gint gee_linked_list_real_drain (GeeQueue* base,
                                 GeeCollection* recipient,
                                 gint amount);
gint gee_deque_drain_head (GeeDeque* self,
                           GeeCollection* recipient,
                           gint amount);
static gboolean gee_linked_list_real_offer_head (GeeDeque* base,
                                          gconstpointer element);
void gee_abstract_list_insert (GeeAbstractList* self,
                               gint index,
                               gconstpointer item);
static gpointer gee_linked_list_real_peek_head (GeeDeque* base);
gpointer gee_abstract_list_get (GeeAbstractList* self,
                                gint index);
static gpointer gee_linked_list_real_poll_head (GeeDeque* base);
gpointer gee_abstract_list_remove_at (GeeAbstractList* self,
                                      gint index);
static gint gee_linked_list_real_drain_head (GeeDeque* base,
                                      GeeCollection* recipient,
                                      gint amount);
static gboolean gee_linked_list_real_offer_tail (GeeDeque* base,
                                          gconstpointer element);
static gpointer gee_linked_list_real_peek_tail (GeeDeque* base);
static gpointer gee_linked_list_real_poll_tail (GeeDeque* base);
static gint gee_linked_list_real_drain_tail (GeeDeque* base,
                                      GeeCollection* recipient,
                                      gint amount);
static void gee_linked_list_set_equal_func (GeeLinkedList* self,
                                     GeeEqualDataFunc value,
                                     gpointer value_target);
#define GEE_QUEUE_UNBOUNDED_CAPACITY -1
static void gee_linked_list_node_instance_init (GeeLinkedListNode * self);
static GeeLinkedListIterator* gee_linked_list_iterator_new_from_iterator (GType g_type,
                                                                   GBoxedCopyFunc g_dup_func,
                                                                   GDestroyNotify g_destroy_func,
                                                                   GeeLinkedListIterator* iter);
static GeeLinkedListIterator* gee_linked_list_iterator_construct_from_iterator (GType object_type,
                                                                         GType g_type,
                                                                         GBoxedCopyFunc g_dup_func,
                                                                         GDestroyNotify g_destroy_func,
                                                                         GeeLinkedListIterator* iter);
static gboolean gee_linked_list_iterator_real_next (GeeIterator* base);
static gboolean gee_linked_list_iterator_real_has_next (GeeIterator* base);
static gboolean gee_linked_list_iterator_real_first (GeeBidirIterator* base);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
static gpointer gee_linked_list_iterator_real_get (GeeIterator* base);
static void gee_linked_list_iterator_real_remove (GeeIterator* base);
static gboolean gee_linked_list_iterator_real_previous (GeeBidirIterator* base);
static gboolean gee_linked_list_iterator_real_has_previous (GeeBidirIterator* base);
static gboolean gee_linked_list_iterator_real_last (GeeBidirIterator* base);
static void gee_linked_list_iterator_real_set (GeeListIterator* base,
                                        gconstpointer item);
static void gee_linked_list_iterator_real_insert (GeeBidirListIterator* base,
                                           gconstpointer item);
static void gee_linked_list_iterator_real_add (GeeListIterator* base,
                                        gconstpointer item);
static gint gee_linked_list_iterator_real_index (GeeListIterator* base);
static gboolean gee_linked_list_iterator_real_foreach (GeeTraversable* base,
                                                GeeForallFunc f,
                                                gpointer f_target);
static GeeIterator** gee_linked_list_iterator_real_tee (GeeTraversable* base,
                                                 guint forks,
                                                 gint* result_length1);
static void gee_linked_list_iterator_finalize (GObject * obj);
gboolean gee_iterator_get_read_only (GeeIterator* self);
gboolean gee_iterator_get_valid (GeeIterator* self);
static void _vala_gee_linked_list_iterator_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_gee_linked_list_iterator_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void gee_linked_list_finalize (GObject * obj);
gboolean gee_abstract_collection_get_read_only (GeeAbstractCollection* self);
gint gee_queue_get_capacity (GeeQueue* self);
gint gee_queue_get_remaining_capacity (GeeQueue* self);
gboolean gee_queue_get_is_full (GeeQueue* self);
static void _vala_gee_linked_list_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_gee_linked_list_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
gee_linked_list_get_instance_private (GeeLinkedList* self)
{
	return G_STRUCT_MEMBER_P (self, GeeLinkedList_private_offset);
}

/**
 * Constructs a new, empty linked list.
 *
 * If not provided, the function parameter is requested to the
 * {@link Functions} function factory methods.
 *
 * @param equal_func an optional element equality testing function
 */
GeeLinkedList*
gee_linked_list_construct (GType object_type,
                           GType g_type,
                           GBoxedCopyFunc g_dup_func,
                           GDestroyNotify g_destroy_func,
                           GeeEqualDataFunc equal_func,
                           gpointer equal_func_target,
                           GDestroyNotify equal_func_target_destroy_notify)
{
	GeeLinkedList * self = NULL;
	GeeEqualDataFunc _tmp3_;
	gpointer _tmp3__target;
	GDestroyNotify _tmp3__target_destroy_notify;
	GeeFunctionsEqualDataFuncClosure* _tmp4_;
	self = (GeeLinkedList*) gee_abstract_bidir_list_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	if (equal_func == NULL) {
		void* _tmp0_ = NULL;
		GDestroyNotify _tmp1_ = NULL;
		GeeEqualDataFunc _tmp2_;
		_tmp2_ = gee_functions_get_equal_func_for (g_type, &_tmp0_, &_tmp1_);
		(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
		equal_func = NULL;
		equal_func_target = NULL;
		equal_func_target_destroy_notify = NULL;
		equal_func = _tmp2_;
		equal_func_target = _tmp0_;
		equal_func_target_destroy_notify = _tmp1_;
	}
	_tmp3_ = equal_func;
	_tmp3__target = equal_func_target;
	_tmp3__target_destroy_notify = equal_func_target_destroy_notify;
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	_tmp4_ = gee_functions_equal_data_func_closure_new (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, _tmp3_, _tmp3__target, _tmp3__target_destroy_notify);
	_gee_functions_equal_data_func_closure_unref0 (self->priv->_equal_func);
	self->priv->_equal_func = _tmp4_;
	(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	return self;
}

GeeLinkedList*
gee_linked_list_new (GType g_type,
                     GBoxedCopyFunc g_dup_func,
                     GDestroyNotify g_destroy_func,
                     GeeEqualDataFunc equal_func,
                     gpointer equal_func_target,
                     GDestroyNotify equal_func_target_destroy_notify)
{
	return gee_linked_list_construct (GEE_TYPE_LINKED_LIST, g_type, g_dup_func, g_destroy_func, equal_func, equal_func_target, equal_func_target_destroy_notify);
}

static gpointer
_gee_functions_equal_data_func_closure_ref0 (gpointer self)
{
	return self ? gee_functions_equal_data_func_closure_ref (self) : NULL;
}

static GeeLinkedList*
gee_linked_list_construct_with_closures (GType object_type,
                                         GType g_type,
                                         GBoxedCopyFunc g_dup_func,
                                         GDestroyNotify g_destroy_func,
                                         GeeFunctionsEqualDataFuncClosure* equal_func)
{
	GeeLinkedList * self = NULL;
	GeeFunctionsEqualDataFuncClosure* _tmp0_;
	g_return_val_if_fail (equal_func != NULL, NULL);
	self = (GeeLinkedList*) gee_abstract_bidir_list_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _gee_functions_equal_data_func_closure_ref0 (equal_func);
	_gee_functions_equal_data_func_closure_unref0 (self->priv->_equal_func);
	self->priv->_equal_func = _tmp0_;
	_gee_functions_equal_data_func_closure_unref0 (equal_func);
	return self;
}

static GeeLinkedList*
gee_linked_list_new_with_closures (GType g_type,
                                   GBoxedCopyFunc g_dup_func,
                                   GDestroyNotify g_destroy_func,
                                   GeeFunctionsEqualDataFuncClosure* equal_func)
{
	return gee_linked_list_construct_with_closures (GEE_TYPE_LINKED_LIST, g_type, g_dup_func, g_destroy_func, equal_func);
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_linked_list_real_foreach (GeeAbstractCollection* base,
                              GeeForallFunc f,
                              gpointer f_target)
{
	GeeLinkedList * self;
	gboolean result = FALSE;
	self = (GeeLinkedList*) base;
	{
		GeeLinkedListNode* node = NULL;
		GeeLinkedListNode* _tmp0_;
		_tmp0_ = self->priv->_head;
		node = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GeeLinkedListNode* _tmp4_;
				GeeLinkedListNode* _tmp5_;
				gconstpointer _tmp6_;
				gpointer _tmp7_;
				if (!_tmp1_) {
					GeeLinkedListNode* _tmp2_;
					GeeLinkedListNode* _tmp3_;
					_tmp2_ = node;
					_tmp3_ = _tmp2_->next;
					node = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = node;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = node;
				_tmp6_ = _tmp5_->data;
				_tmp7_ = ((_tmp6_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp6_) : ((gpointer) _tmp6_);
				if (!f (_tmp7_, f_target)) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

/**
 * {@inheritDoc}
 */
static GeeIterator*
gee_linked_list_real_iterator (GeeAbstractCollection* base)
{
	GeeLinkedList * self;
	GeeIterator* result = NULL;
	GeeLinkedListIterator* _tmp0_;
	self = (GeeLinkedList*) base;
	_tmp0_ = gee_linked_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, self);
	result = (GeeIterator*) _tmp0_;
	return result;
}

/**
 * {@inheritDoc}
 */
static GeeListIterator*
gee_linked_list_real_list_iterator (GeeAbstractList* base)
{
	GeeLinkedList * self;
	GeeListIterator* result = NULL;
	GeeLinkedListIterator* _tmp0_;
	self = (GeeLinkedList*) base;
	_tmp0_ = gee_linked_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, self);
	result = (GeeListIterator*) _tmp0_;
	return result;
}

/**
 * {@inheritDoc}
 */
static GeeBidirListIterator*
gee_linked_list_real_bidir_list_iterator (GeeAbstractBidirList* base)
{
	GeeLinkedList * self;
	GeeBidirListIterator* result = NULL;
	GeeLinkedListIterator* _tmp0_;
	self = (GeeLinkedList*) base;
	_tmp0_ = gee_linked_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, self);
	result = (GeeBidirListIterator*) _tmp0_;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_linked_list_real_contains (GeeAbstractCollection* base,
                               gconstpointer item)
{
	GeeLinkedList * self;
	gboolean result = FALSE;
	self = (GeeLinkedList*) base;
	result = gee_abstract_list_index_of ((GeeAbstractList*) self, item) != -1;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_linked_list_real_add (GeeAbstractCollection* base,
                          gconstpointer item)
{
	GeeLinkedList * self;
	gboolean result = FALSE;
	GeeLinkedListNode* n = NULL;
	gpointer _tmp0_;
	GeeLinkedListNode* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeLinkedListNode* _tmp3_;
	gint _tmp13_;
	self = (GeeLinkedList*) base;
	_tmp0_ = ((item != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) item) : ((gpointer) item);
	_tmp1_ = gee_linked_list_node_new (_tmp0_);
	n = _tmp1_;
	_tmp3_ = self->priv->_head;
	if (_tmp3_ == NULL) {
		GeeLinkedListNode* _tmp4_;
		_tmp4_ = self->priv->_tail;
		_tmp2_ = _tmp4_ == NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GeeLinkedListNode* _tmp5_;
		GeeLinkedListNode* _tmp6_;
		_tmp5_ = n;
		self->priv->_tail = _tmp5_;
		_tmp6_ = n;
		n = NULL;
		_gee_linked_list_node_free0 (self->priv->_head);
		self->priv->_head = _tmp6_;
	} else {
		GeeLinkedListNode* _tmp7_;
		GeeLinkedListNode* _tmp8_;
		GeeLinkedListNode* _tmp9_;
		GeeLinkedListNode* _tmp10_;
		GeeLinkedListNode* _tmp11_;
		GeeLinkedListNode* _tmp12_;
		_tmp7_ = n;
		_tmp8_ = self->priv->_tail;
		_tmp7_->prev = _tmp8_;
		_tmp9_ = self->priv->_tail;
		_tmp10_ = n;
		n = NULL;
		_gee_linked_list_node_free0 (_tmp9_->next);
		_tmp9_->next = _tmp10_;
		_tmp11_ = self->priv->_tail;
		_tmp12_ = _tmp11_->next;
		self->priv->_tail = _tmp12_;
	}
	_tmp13_ = self->priv->_size;
	self->priv->_size = _tmp13_ + 1;
	result = TRUE;
	_gee_linked_list_node_free0 (n);
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_linked_list_real_remove (GeeAbstractCollection* base,
                             gconstpointer item)
{
	GeeLinkedList * self;
	gboolean result = FALSE;
	self = (GeeLinkedList*) base;
	{
		GeeLinkedListNode* n = NULL;
		GeeLinkedListNode* _tmp0_;
		_tmp0_ = self->priv->_head;
		n = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GeeLinkedListNode* _tmp4_;
				GeeEqualDataFunc _tmp5_;
				gpointer _tmp5__target;
				GeeEqualDataFunc _tmp6_;
				gpointer _tmp6__target;
				GeeLinkedListNode* _tmp7_;
				gconstpointer _tmp8_;
				if (!_tmp1_) {
					GeeLinkedListNode* _tmp2_;
					GeeLinkedListNode* _tmp3_;
					_tmp2_ = n;
					_tmp3_ = _tmp2_->next;
					n = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = n;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = gee_linked_list_get_equal_func (self, &_tmp5__target);
				_tmp6_ = _tmp5_;
				_tmp6__target = _tmp5__target;
				_tmp7_ = n;
				_tmp8_ = _tmp7_->data;
				if (_tmp6_ (item, _tmp8_, _tmp6__target)) {
					GeeLinkedListNode* _tmp9_;
					_tmp9_ = n;
					_gee_linked_list_remove_node (self, _tmp9_);
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

/**
 * {@inheritDoc}
 */
static void
gee_linked_list_real_clear (GeeAbstractCollection* base)
{
	GeeLinkedList * self;
	self = (GeeLinkedList*) base;
	while (TRUE) {
		GeeLinkedListNode* _tmp0_;
		GeeLinkedListNode* _tmp1_;
		_tmp0_ = self->priv->_head;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = self->priv->_head;
		_gee_linked_list_remove_node (self, _tmp1_);
	}
	self->priv->_stamp = self->priv->_stamp + 1;
	_gee_linked_list_node_free0 (self->priv->_head);
	self->priv->_head = NULL;
	self->priv->_tail = NULL;
	self->priv->_size = 0;
}

/**
 * {@inheritDoc}
 */
static gpointer
gee_linked_list_real_get (GeeAbstractList* base,
                          gint index)
{
	GeeLinkedList * self;
	gpointer result = NULL;
	GeeLinkedListNode* n = NULL;
	GeeLinkedListNode* _tmp0_;
	gconstpointer _tmp1_;
	gpointer _tmp2_;
	self = (GeeLinkedList*) base;
	_vala_assert (index >= 0, "index >= 0");
	_vala_assert (index < self->priv->_size, "index < this._size");
	_tmp0_ = _gee_linked_list_get_node_at (self, index);
	n = _tmp0_;
	_vala_assert (n != NULL, "n != null");
	_tmp1_ = n->data;
	_tmp2_ = ((_tmp1_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp1_) : ((gpointer) _tmp1_);
	result = _tmp2_;
	return result;
}

/**
 * {@inheritDoc}
 */
static void
gee_linked_list_real_set (GeeAbstractList* base,
                          gint index,
                          gconstpointer item)
{
	GeeLinkedList * self;
	GeeLinkedListNode* n = NULL;
	GeeLinkedListNode* _tmp0_;
	gpointer _tmp1_;
	self = (GeeLinkedList*) base;
	_vala_assert (index >= 0, "index >= 0");
	_vala_assert (index < self->priv->_size, "index < this._size");
	_tmp0_ = _gee_linked_list_get_node_at (self, index);
	n = _tmp0_;
	g_return_if_fail (n != NULL);
	_tmp1_ = ((item != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) item) : ((gpointer) item);
	((n->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (n->data = (self->priv->g_destroy_func (n->data), NULL));
	n->data = _tmp1_;
}

/**
 * {@inheritDoc}
 */
static gint
gee_linked_list_real_index_of (GeeAbstractList* base,
                               gconstpointer item)
{
	GeeLinkedList * self;
	gint result = 0;
	gint idx = 0;
	self = (GeeLinkedList*) base;
	idx = 0;
	{
		GeeLinkedListNode* node = NULL;
		GeeLinkedListNode* _tmp0_;
		_tmp0_ = self->priv->_head;
		node = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GeeLinkedListNode* _tmp5_;
				GeeEqualDataFunc _tmp6_;
				gpointer _tmp6__target;
				GeeEqualDataFunc _tmp7_;
				gpointer _tmp7__target;
				GeeLinkedListNode* _tmp8_;
				gconstpointer _tmp9_;
				if (!_tmp1_) {
					GeeLinkedListNode* _tmp2_;
					GeeLinkedListNode* _tmp3_;
					gint _tmp4_;
					_tmp2_ = node;
					_tmp3_ = _tmp2_->next;
					node = _tmp3_;
					_tmp4_ = idx;
					idx = _tmp4_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp5_ = node;
				if (!(_tmp5_ != NULL)) {
					break;
				}
				_tmp6_ = gee_linked_list_get_equal_func (self, &_tmp6__target);
				_tmp7_ = _tmp6_;
				_tmp7__target = _tmp6__target;
				_tmp8_ = node;
				_tmp9_ = _tmp8_->data;
				if (_tmp7_ (item, _tmp9_, _tmp7__target)) {
					result = idx;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}

/**
 * {@inheritDoc}
 */
static void
gee_linked_list_real_insert (GeeAbstractList* base,
                             gint index,
                             gconstpointer item)
{
	GeeLinkedList * self;
	self = (GeeLinkedList*) base;
	_vala_assert (index >= 0, "index >= 0");
	_vala_assert (index <= self->priv->_size, "index <= this._size");
	if (index == self->priv->_size) {
		gee_abstract_collection_add ((GeeAbstractCollection*) self, item);
	} else {
		GeeLinkedListNode* n = NULL;
		gpointer _tmp0_;
		GeeLinkedListNode* _tmp1_;
		gint _tmp23_;
		_tmp0_ = ((item != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) item) : ((gpointer) item);
		_tmp1_ = gee_linked_list_node_new (_tmp0_);
		n = _tmp1_;
		if (index == 0) {
			GeeLinkedListNode* _tmp2_;
			GeeLinkedListNode* _tmp3_;
			GeeLinkedListNode* _tmp4_;
			GeeLinkedListNode* _tmp5_;
			GeeLinkedListNode* _tmp6_;
			GeeLinkedListNode* _tmp7_;
			_tmp2_ = n;
			_tmp3_ = self->priv->_head;
			self->priv->_head = NULL;
			_gee_linked_list_node_free0 (_tmp2_->next);
			_tmp2_->next = _tmp3_;
			_tmp4_ = n;
			_tmp5_ = _tmp4_->next;
			_tmp6_ = n;
			_tmp5_->prev = _tmp6_;
			_tmp7_ = n;
			n = NULL;
			_gee_linked_list_node_free0 (self->priv->_head);
			self->priv->_head = _tmp7_;
		} else {
			GeeLinkedListNode* prev = NULL;
			GeeLinkedListNode* _tmp8_;
			GeeLinkedListNode* _tmp13_;
			GeeLinkedListNode* _tmp14_;
			GeeLinkedListNode* _tmp15_;
			GeeLinkedListNode* _tmp16_;
			GeeLinkedListNode* _tmp17_;
			GeeLinkedListNode* _tmp18_;
			GeeLinkedListNode* _tmp19_;
			GeeLinkedListNode* _tmp20_;
			GeeLinkedListNode* _tmp21_;
			GeeLinkedListNode* _tmp22_;
			_tmp8_ = self->priv->_head;
			prev = _tmp8_;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp9_ = FALSE;
					_tmp9_ = TRUE;
					while (TRUE) {
						GeeLinkedListNode* _tmp11_;
						GeeLinkedListNode* _tmp12_;
						if (!_tmp9_) {
							gint _tmp10_;
							_tmp10_ = i;
							i = _tmp10_ + 1;
						}
						_tmp9_ = FALSE;
						if (!(i < (index - 1))) {
							break;
						}
						_tmp11_ = prev;
						_tmp12_ = _tmp11_->next;
						prev = _tmp12_;
					}
				}
			}
			_tmp13_ = n;
			_tmp14_ = prev;
			_tmp13_->prev = _tmp14_;
			_tmp15_ = n;
			_tmp16_ = prev;
			_tmp17_ = _tmp16_->next;
			_tmp16_->next = NULL;
			_gee_linked_list_node_free0 (_tmp15_->next);
			_tmp15_->next = _tmp17_;
			_tmp18_ = n;
			_tmp19_ = _tmp18_->next;
			_tmp20_ = n;
			_tmp19_->prev = _tmp20_;
			_tmp21_ = prev;
			_tmp22_ = n;
			n = NULL;
			_gee_linked_list_node_free0 (_tmp21_->next);
			_tmp21_->next = _tmp22_;
		}
		_tmp23_ = self->priv->_size;
		self->priv->_size = _tmp23_ + 1;
		_gee_linked_list_node_free0 (n);
	}
}

/**
 * {@inheritDoc}
 */
static gpointer
gee_linked_list_real_remove_at (GeeAbstractList* base,
                                gint index)
{
	GeeLinkedList * self;
	gpointer result = NULL;
	GeeLinkedListNode* n = NULL;
	GeeLinkedListNode* _tmp0_;
	gpointer element = NULL;
	gconstpointer _tmp1_;
	gpointer _tmp2_;
	self = (GeeLinkedList*) base;
	_vala_assert (index >= 0, "index >= 0");
	_vala_assert (index < self->priv->_size, "index < this._size");
	_tmp0_ = _gee_linked_list_get_node_at (self, index);
	n = _tmp0_;
	_vala_assert (n != NULL, "n != null");
	_tmp1_ = n->data;
	_tmp2_ = ((_tmp1_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp1_) : ((gpointer) _tmp1_);
	element = _tmp2_;
	_gee_linked_list_remove_node (self, n);
	result = element;
	return result;
}

/**
 * {@inheritDoc}
 */
static GeeList*
gee_linked_list_real_slice (GeeAbstractList* base,
                            gint start,
                            gint stop)
{
	GeeLinkedList * self;
	GeeList* result = NULL;
	GeeList* slice = NULL;
	GeeFunctionsEqualDataFuncClosure* _tmp0_;
	GeeFunctionsEqualDataFuncClosure* _tmp1_;
	GeeLinkedList* _tmp2_;
	GeeLinkedListNode* n = NULL;
	GeeLinkedListNode* _tmp3_;
	self = (GeeLinkedList*) base;
	g_return_val_if_fail (start <= stop, NULL);
	g_return_val_if_fail (start >= 0, NULL);
	g_return_val_if_fail (stop <= self->priv->_size, NULL);
	_tmp0_ = self->priv->_equal_func;
	_tmp1_ = _gee_functions_equal_data_func_closure_ref0 (_tmp0_);
	_tmp2_ = gee_linked_list_new_with_closures (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, _tmp1_);
	slice = (GeeList*) _tmp2_;
	_tmp3_ = _gee_linked_list_get_node_at (self, start);
	n = _tmp3_;
	{
		gint i = 0;
		i = start;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				GeeList* _tmp6_;
				GeeLinkedListNode* _tmp7_;
				gconstpointer _tmp8_;
				GeeLinkedListNode* _tmp9_;
				GeeLinkedListNode* _tmp10_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(i < stop)) {
					break;
				}
				_tmp6_ = slice;
				_tmp7_ = n;
				_tmp8_ = _tmp7_->data;
				gee_collection_add ((GeeCollection*) _tmp6_, _tmp8_);
				_tmp9_ = n;
				_tmp10_ = _tmp9_->next;
				n = _tmp10_;
			}
		}
	}
	result = slice;
	return result;
}

/**
 * {@inheritDoc}
 */
gpointer
gee_linked_list_first (GeeLinkedList* self)
{
	gpointer result = NULL;
	GeeLinkedListNode* _tmp0_;
	gconstpointer _tmp1_;
	gpointer _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->priv->_size > 0, "_size > 0");
	_tmp0_ = self->priv->_head;
	_tmp1_ = _tmp0_->data;
	_tmp2_ = ((_tmp1_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp1_) : ((gpointer) _tmp1_);
	result = _tmp2_;
	return result;
}

/**
 * {@inheritDoc}
 */
gpointer
gee_linked_list_last (GeeLinkedList* self)
{
	gpointer result = NULL;
	GeeLinkedListNode* _tmp0_;
	gconstpointer _tmp1_;
	gpointer _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->priv->_size > 0, "_size > 0");
	_tmp0_ = self->priv->_tail;
	_tmp1_ = _tmp0_->data;
	_tmp2_ = ((_tmp1_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp1_) : ((gpointer) _tmp1_);
	result = _tmp2_;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_linked_list_real_offer (GeeQueue* base,
                            gconstpointer element)
{
	GeeLinkedList * self;
	gboolean result = FALSE;
	self = (GeeLinkedList*) base;
	result = gee_deque_offer_tail ((GeeDeque*) self, element);
	return result;
}

/**
 * {@inheritDoc}
 */
static gpointer
gee_linked_list_real_peek (GeeQueue* base)
{
	GeeLinkedList * self;
	gpointer result = NULL;
	gpointer _tmp0_;
	self = (GeeLinkedList*) base;
	_tmp0_ = gee_deque_peek_head ((GeeDeque*) self);
	result = _tmp0_;
	return result;
}

/**
 * {@inheritDoc}
 */
static gpointer
gee_linked_list_real_poll (GeeQueue* base)
{
	GeeLinkedList * self;
	gpointer result = NULL;
	gpointer _tmp0_;
	self = (GeeLinkedList*) base;
	_tmp0_ = gee_deque_poll_head ((GeeDeque*) self);
	result = _tmp0_;
	return result;
}

/**
 * {@inheritDoc}
 */
static gint
gee_linked_list_real_drain (GeeQueue* base,
                            GeeCollection* recipient,
                            gint amount)
{
	GeeLinkedList * self;
	gint result = 0;
	self = (GeeLinkedList*) base;
	g_return_val_if_fail (recipient != NULL, 0);
	result = gee_deque_drain_head ((GeeDeque*) self, recipient, amount);
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_linked_list_real_offer_head (GeeDeque* base,
                                 gconstpointer element)
{
	GeeLinkedList * self;
	gboolean result = FALSE;
	self = (GeeLinkedList*) base;
	gee_abstract_list_insert ((GeeAbstractList*) self, 0, element);
	result = TRUE;
	return result;
}

/**
 * {@inheritDoc}
 */
static gpointer
gee_linked_list_real_peek_head (GeeDeque* base)
{
	GeeLinkedList * self;
	gpointer result = NULL;
	gpointer _tmp0_;
	self = (GeeLinkedList*) base;
	if (self->priv->_size == 0) {
		result = NULL;
		return result;
	}
	_tmp0_ = gee_abstract_list_get ((GeeAbstractList*) self, 0);
	result = _tmp0_;
	return result;
}

/**
 * {@inheritDoc}
 */
static gpointer
gee_linked_list_real_poll_head (GeeDeque* base)
{
	GeeLinkedList * self;
	gpointer result = NULL;
	gpointer _tmp0_;
	self = (GeeLinkedList*) base;
	if (self->priv->_size == 0) {
		result = NULL;
		return result;
	}
	_tmp0_ = gee_abstract_list_remove_at ((GeeAbstractList*) self, 0);
	result = _tmp0_;
	return result;
}

/**
 * {@inheritDoc}
 */
static gint
gee_linked_list_real_drain_head (GeeDeque* base,
                                 GeeCollection* recipient,
                                 gint amount)
{
	GeeLinkedList * self;
	gint result = 0;
	self = (GeeLinkedList*) base;
	g_return_val_if_fail (recipient != NULL, 0);
	if (amount == -1) {
		amount = self->priv->_size;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gpointer _tmp2_;
				gpointer _tmp3_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < amount)) {
					break;
				}
				if (self->priv->_size == 0) {
					result = i;
					return result;
				}
				_tmp2_ = gee_abstract_list_remove_at ((GeeAbstractList*) self, 0);
				_tmp3_ = _tmp2_;
				gee_collection_add (recipient, _tmp3_);
				((_tmp3_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp3_ = (self->priv->g_destroy_func (_tmp3_), NULL));
			}
		}
	}
	result = amount;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
gee_linked_list_real_offer_tail (GeeDeque* base,
                                 gconstpointer element)
{
	GeeLinkedList * self;
	gboolean result = FALSE;
	self = (GeeLinkedList*) base;
	result = gee_abstract_collection_add ((GeeAbstractCollection*) self, element);
	return result;
}

/**
 * {@inheritDoc}
 */
static gpointer
gee_linked_list_real_peek_tail (GeeDeque* base)
{
	GeeLinkedList * self;
	gpointer result = NULL;
	gpointer _tmp0_;
	self = (GeeLinkedList*) base;
	if (self->priv->_size == 0) {
		result = NULL;
		return result;
	}
	_tmp0_ = gee_abstract_list_get ((GeeAbstractList*) self, self->priv->_size - 1);
	result = _tmp0_;
	return result;
}

/**
 * {@inheritDoc}
 */
static gpointer
gee_linked_list_real_poll_tail (GeeDeque* base)
{
	GeeLinkedList * self;
	gpointer result = NULL;
	gpointer _tmp0_;
	self = (GeeLinkedList*) base;
	if (self->priv->_size == 0) {
		result = NULL;
		return result;
	}
	_tmp0_ = gee_abstract_list_remove_at ((GeeAbstractList*) self, self->priv->_size - 1);
	result = _tmp0_;
	return result;
}

/**
 * {@inheritDoc}
 */
static gint
gee_linked_list_real_drain_tail (GeeDeque* base,
                                 GeeCollection* recipient,
                                 gint amount)
{
	GeeLinkedList * self;
	gint result = 0;
	self = (GeeLinkedList*) base;
	g_return_val_if_fail (recipient != NULL, 0);
	if (amount == -1) {
		amount = self->priv->_size;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gpointer _tmp2_;
				gpointer _tmp3_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < amount)) {
					break;
				}
				if (self->priv->_size == 0) {
					result = i;
					return result;
				}
				_tmp2_ = gee_abstract_list_remove_at ((GeeAbstractList*) self, self->priv->_size - 1);
				_tmp3_ = _tmp2_;
				gee_collection_add (recipient, _tmp3_);
				((_tmp3_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp3_ = (self->priv->g_destroy_func (_tmp3_), NULL));
			}
		}
	}
	result = amount;
	return result;
}

static GeeLinkedListNode*
_gee_linked_list_get_node_at (GeeLinkedList* self,
                              gint index)
{
	GeeLinkedListNode* result = NULL;
	GeeLinkedListNode* n = NULL;
	GeeLinkedListNode* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	n = NULL;
	if (index == 0) {
		GeeLinkedListNode* _tmp0_;
		_tmp0_ = self->priv->_head;
		n = _tmp0_;
	} else {
		if (index == (self->priv->_size - 1)) {
			GeeLinkedListNode* _tmp1_;
			_tmp1_ = self->priv->_tail;
			n = _tmp1_;
		} else {
			if (index <= (self->priv->_size / 2)) {
				GeeLinkedListNode* _tmp2_;
				_tmp2_ = self->priv->_head;
				n = _tmp2_;
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							GeeLinkedListNode* _tmp5_;
							GeeLinkedListNode* _tmp6_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = i;
								i = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							if (!(index != i)) {
								break;
							}
							_tmp5_ = n;
							_tmp6_ = _tmp5_->next;
							n = _tmp6_;
						}
					}
				}
			} else {
				GeeLinkedListNode* _tmp7_;
				_tmp7_ = self->priv->_tail;
				n = _tmp7_;
				{
					gint i = 0;
					i = self->priv->_size - 1;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							GeeLinkedListNode* _tmp10_;
							GeeLinkedListNode* _tmp11_;
							if (!_tmp8_) {
								gint _tmp9_;
								_tmp9_ = i;
								i = _tmp9_ - 1;
							}
							_tmp8_ = FALSE;
							if (!(index != i)) {
								break;
							}
							_tmp10_ = n;
							_tmp11_ = _tmp10_->prev;
							n = _tmp11_;
						}
					}
				}
			}
		}
	}
	_tmp12_ = n;
	result = _tmp12_;
	return result;
}

static void
_gee_linked_list_remove_node (GeeLinkedList* self,
                              GeeLinkedListNode* _n)
{
	GeeLinkedListNode* n = NULL;
	GeeLinkedListNode* next = NULL;
	GeeLinkedListNode* _tmp0_;
	GeeLinkedListNode* _tmp12_;
	GeeLinkedListNode* _tmp13_;
	GeeLinkedListNode* _tmp19_;
	GeeLinkedListNode* _tmp20_;
	GeeLinkedListNode* _tmp21_;
	gint _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_n != NULL);
	_tmp0_ = self->priv->_head;
	if (_n == _tmp0_) {
		GeeLinkedListNode* _tmp1_;
		GeeLinkedListNode* _tmp2_;
		GeeLinkedListNode* _tmp3_;
		GeeLinkedListNode* _tmp4_;
		_tmp1_ = self->priv->_head;
		self->priv->_head = NULL;
		_gee_linked_list_node_free0 (n);
		n = _tmp1_;
		_tmp2_ = n;
		_tmp3_ = _tmp2_->next;
		_tmp2_->next = NULL;
		_gee_linked_list_node_free0 (self->priv->_head);
		self->priv->_head = _tmp3_;
		_tmp4_ = self->priv->_head;
		next = _tmp4_;
	} else {
		GeeLinkedListNode* _tmp5_;
		GeeLinkedListNode* _tmp6_;
		GeeLinkedListNode* _tmp7_;
		GeeLinkedListNode* _tmp8_;
		GeeLinkedListNode* _tmp9_;
		GeeLinkedListNode* _tmp10_;
		GeeLinkedListNode* _tmp11_;
		_tmp5_ = _n->prev;
		_tmp6_ = _tmp5_->next;
		_tmp5_->next = NULL;
		_gee_linked_list_node_free0 (n);
		n = _tmp6_;
		_tmp7_ = n;
		_tmp8_ = _tmp7_->prev;
		_tmp9_ = n;
		_tmp10_ = _tmp9_->next;
		_tmp9_->next = NULL;
		_gee_linked_list_node_free0 (_tmp8_->next);
		_tmp8_->next = _tmp10_;
		_tmp11_ = _tmp8_->next;
		next = _tmp11_;
	}
	_tmp12_ = n;
	_tmp13_ = self->priv->_tail;
	if (_tmp12_ == _tmp13_) {
		GeeLinkedListNode* _tmp14_;
		GeeLinkedListNode* _tmp15_;
		_tmp14_ = n;
		_tmp15_ = _tmp14_->prev;
		self->priv->_tail = _tmp15_;
	} else {
		GeeLinkedListNode* _tmp16_;
		GeeLinkedListNode* _tmp17_;
		GeeLinkedListNode* _tmp18_;
		_tmp16_ = next;
		_tmp17_ = n;
		_tmp18_ = _tmp17_->prev;
		_tmp16_->prev = _tmp18_;
	}
	_tmp19_ = n;
	_tmp19_->prev = NULL;
	_tmp20_ = n;
	_gee_linked_list_node_free0 (_tmp20_->next);
	_tmp20_->next = NULL;
	_tmp21_ = n;
	((_tmp21_->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp21_->data = (self->priv->g_destroy_func (_tmp21_->data), NULL));
	_tmp21_->data = NULL;
	self->priv->_stamp = self->priv->_stamp + 1;
	_tmp22_ = self->priv->_size;
	self->priv->_size = _tmp22_ - 1;
	_gee_linked_list_node_free0 (n);
}

GeeEqualDataFunc
gee_linked_list_get_equal_func (GeeLinkedList* self,
                                gpointer* result_target)
{
	GeeEqualDataFunc result;
	GeeFunctionsEqualDataFuncClosure* _tmp0_;
	GeeEqualDataFunc _tmp1_;
	gpointer _tmp1__target;
	GeeEqualDataFunc _tmp2_;
	gpointer _tmp2__target;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equal_func;
	_tmp1_ = _tmp0_->func;
	_tmp1__target = _tmp0_->func_target;
	_tmp2_ = _tmp1_;
	_tmp2__target = _tmp1__target;
	*result_target = _tmp2__target;
	result = _tmp2_;
	return result;
}

static void
gee_linked_list_set_equal_func (GeeLinkedList* self,
                                GeeEqualDataFunc value,
                                gpointer value_target)
{
	g_return_if_fail (self != NULL);
}

static gint
gee_linked_list_real_get_size (GeeAbstractCollection* base)
{
	gint result;
	GeeLinkedList* self;
	self = (GeeLinkedList*) base;
	result = self->priv->_size;
	return result;
}

static gboolean
gee_linked_list_real_get_read_only (GeeAbstractCollection* base)
{
	gboolean result;
	GeeLinkedList* self;
	self = (GeeLinkedList*) base;
	result = FALSE;
	return result;
}

static gint
gee_linked_list_real_get_capacity (GeeQueue* base)
{
	gint result;
	GeeLinkedList* self;
	self = (GeeLinkedList*) base;
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
	return result;
}

static gint
gee_linked_list_real_get_remaining_capacity (GeeQueue* base)
{
	gint result;
	GeeLinkedList* self;
	self = (GeeLinkedList*) base;
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
	return result;
}

static gboolean
gee_linked_list_real_get_is_full (GeeQueue* base)
{
	gboolean result;
	GeeLinkedList* self;
	self = (GeeLinkedList*) base;
	result = FALSE;
	return result;
}

static GeeLinkedListNode*
gee_linked_list_node_new (gpointer data)
{
	GeeLinkedListNode* self;
	self = g_slice_new0 (GeeLinkedListNode);
	gee_linked_list_node_instance_init (self);
	self->data = data;
	return self;
}

static void
gee_linked_list_node_instance_init (GeeLinkedListNode * self)
{
	self->prev = NULL;
	self->next = NULL;
}

static void
gee_linked_list_node_free (GeeLinkedListNode * self)
{
	_gee_linked_list_node_free0 (self->next);
	g_slice_free (GeeLinkedListNode, self);
}

static inline gpointer
gee_linked_list_iterator_get_instance_private (GeeLinkedListIterator* self)
{
	return G_STRUCT_MEMBER_P (self, GeeLinkedListIterator_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GeeLinkedListIterator*
gee_linked_list_iterator_construct (GType object_type,
                                    GType g_type,
                                    GBoxedCopyFunc g_dup_func,
                                    GDestroyNotify g_destroy_func,
                                    GeeLinkedList* list)
{
	GeeLinkedListIterator * self = NULL;
	GeeLinkedList* _tmp0_;
	g_return_val_if_fail (list != NULL, NULL);
	self = (GeeLinkedListIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _g_object_ref0 (list);
	_g_object_unref0 (self->_list);
	self->_list = _tmp0_;
	self->_position = NULL;
	self->_index = -1;
	self->_stamp = list->priv->_stamp;
	return self;
}

static GeeLinkedListIterator*
gee_linked_list_iterator_new (GType g_type,
                              GBoxedCopyFunc g_dup_func,
                              GDestroyNotify g_destroy_func,
                              GeeLinkedList* list)
{
	return gee_linked_list_iterator_construct (GEE_LINKED_LIST_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, list);
}

static GeeLinkedListIterator*
gee_linked_list_iterator_construct_from_iterator (GType object_type,
                                                  GType g_type,
                                                  GBoxedCopyFunc g_dup_func,
                                                  GDestroyNotify g_destroy_func,
                                                  GeeLinkedListIterator* iter)
{
	GeeLinkedListIterator * self = NULL;
	GeeLinkedListNode* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* _tmp2_;
	g_return_val_if_fail (iter != NULL, NULL);
	self = (GeeLinkedListIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	self->_removed = iter->_removed;
	_tmp0_ = iter->_position;
	self->_position = _tmp0_;
	self->_stamp = iter->_stamp;
	_tmp1_ = iter->_list;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->_list);
	self->_list = _tmp2_;
	self->_index = iter->_index;
	return self;
}

static GeeLinkedListIterator*
gee_linked_list_iterator_new_from_iterator (GType g_type,
                                            GBoxedCopyFunc g_dup_func,
                                            GDestroyNotify g_destroy_func,
                                            GeeLinkedListIterator* iter)
{
	return gee_linked_list_iterator_construct_from_iterator (GEE_LINKED_LIST_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, iter);
}

static gboolean
gee_linked_list_iterator_real_next (GeeIterator* base)
{
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	GeeLinkedList* _tmp0_;
	GeeLinkedListNode* _tmp1_;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "this._stamp == this._list._stamp");
	_tmp1_ = self->_position;
	if (G_UNLIKELY (_tmp1_ == NULL)) {
		GeeLinkedList* _tmp2_;
		GeeLinkedListNode* _tmp3_;
		_vala_assert (!self->_removed, "!_removed");
		_tmp2_ = self->_list;
		_tmp3_ = _tmp2_->priv->_head;
		if (_tmp3_ != NULL) {
			GeeLinkedList* _tmp4_;
			GeeLinkedListNode* _tmp5_;
			_tmp4_ = self->_list;
			_tmp5_ = _tmp4_->priv->_head;
			self->_position = _tmp5_;
			self->_index = 0;
			result = TRUE;
			return result;
		} else {
			result = FALSE;
			return result;
		}
	} else {
		GeeLinkedListNode* _tmp6_;
		GeeLinkedListNode* _tmp7_;
		_tmp6_ = self->_position;
		_tmp7_ = _tmp6_->next;
		if (_tmp7_ != NULL) {
			GeeLinkedListNode* _tmp8_;
			GeeLinkedListNode* _tmp9_;
			gint _tmp10_;
			_tmp8_ = self->_position;
			_tmp9_ = _tmp8_->next;
			self->_position = _tmp9_;
			_tmp10_ = self->_index;
			self->_index = _tmp10_ + 1;
			self->_removed = FALSE;
			result = TRUE;
			return result;
		} else {
			result = FALSE;
			return result;
		}
	}
}

static gboolean
gee_linked_list_iterator_real_has_next (GeeIterator* base)
{
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	GeeLinkedList* _tmp0_;
	GeeLinkedListNode* _tmp1_;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	_tmp1_ = self->_position;
	if (G_UNLIKELY (_tmp1_ == NULL)) {
		GeeLinkedList* _tmp2_;
		GeeLinkedListNode* _tmp3_;
		_tmp2_ = self->_list;
		_tmp3_ = _tmp2_->priv->_head;
		result = _tmp3_ != NULL;
		return result;
	} else {
		GeeLinkedListNode* _tmp4_;
		GeeLinkedListNode* _tmp5_;
		_tmp4_ = self->_position;
		_tmp5_ = _tmp4_->next;
		result = _tmp5_ != NULL;
		return result;
	}
}

static gboolean
gee_linked_list_iterator_real_first (GeeBidirIterator* base)
{
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeLinkedList* _tmp4_;
	GeeLinkedListNode* _tmp5_;
	GeeLinkedListNode* _tmp6_;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	_tmp1_ = self->_list;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->_list;
	_tmp5_ = _tmp4_->priv->_head;
	self->_position = _tmp5_;
	self->_index = 0;
	self->_removed = FALSE;
	_tmp6_ = self->_position;
	_vala_assert (_tmp6_ != NULL, "_position != null");
	result = TRUE;
	return result;
}

static gpointer
gee_linked_list_iterator_real_get (GeeIterator* base)
{
	GeeLinkedListIterator * self;
	gpointer result = NULL;
	GeeLinkedList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeLinkedListNode* _tmp2_;
	GeeLinkedListNode* _tmp3_;
	gconstpointer _tmp4_;
	gpointer _tmp5_;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	_tmp2_ = self->_position;
	if (_tmp2_ != NULL) {
		_tmp1_ = !self->_removed;
	} else {
		_tmp1_ = FALSE;
	}
	_vala_assert (_tmp1_, "_position != null && !_removed");
	_tmp3_ = self->_position;
	_tmp4_ = _tmp3_->data;
	_tmp5_ = ((_tmp4_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
	result = _tmp5_;
	return result;
}

static void
gee_linked_list_iterator_real_remove (GeeIterator* base)
{
	GeeLinkedListIterator * self;
	GeeLinkedList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeLinkedListNode* _tmp2_;
	GeeLinkedListNode* new_position = NULL;
	GeeLinkedListNode* _tmp3_;
	GeeLinkedListNode* _tmp4_;
	GeeLinkedList* _tmp5_;
	GeeLinkedListNode* _tmp6_;
	GeeLinkedListNode* _tmp7_;
	GeeLinkedListNode* _tmp8_;
	gint _tmp9_;
	GeeLinkedList* _tmp10_;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	_tmp2_ = self->_position;
	if (_tmp2_ != NULL) {
		_tmp1_ = !self->_removed;
	} else {
		_tmp1_ = FALSE;
	}
	_vala_assert (_tmp1_, "_position != null && !_removed");
	_tmp3_ = self->_position;
	_tmp4_ = _tmp3_->prev;
	new_position = _tmp4_;
	_tmp5_ = self->_list;
	_tmp6_ = self->_position;
	_gee_linked_list_remove_node (_tmp5_, _tmp6_);
	_tmp7_ = new_position;
	self->_position = _tmp7_;
	_tmp8_ = self->_position;
	if (_tmp8_ != NULL) {
		self->_removed = TRUE;
	}
	_tmp9_ = self->_index;
	self->_index = _tmp9_ - 1;
	_tmp10_ = self->_list;
	self->_stamp = _tmp10_->priv->_stamp;
}

static gboolean
gee_linked_list_iterator_real_previous (GeeBidirIterator* base)
{
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	GeeLinkedList* _tmp0_;
	GeeLinkedListNode* _tmp1_;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	_tmp1_ = self->_position;
	if (G_LIKELY (_tmp1_ != NULL)) {
		if (G_UNLIKELY (self->_removed)) {
			self->_removed = FALSE;
			result = TRUE;
			return result;
		} else {
			GeeLinkedListNode* _tmp2_;
			GeeLinkedListNode* _tmp3_;
			_tmp2_ = self->_position;
			_tmp3_ = _tmp2_->prev;
			if (G_LIKELY (_tmp3_ != NULL)) {
				GeeLinkedListNode* _tmp4_;
				GeeLinkedListNode* _tmp5_;
				gint _tmp6_;
				_tmp4_ = self->_position;
				_tmp5_ = _tmp4_->prev;
				self->_position = _tmp5_;
				_tmp6_ = self->_index;
				self->_index = _tmp6_ - 1;
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	} else {
		result = FALSE;
		return result;
	}
}

static gboolean
gee_linked_list_iterator_real_has_previous (GeeBidirIterator* base)
{
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	GeeLinkedList* _tmp0_;
	GeeLinkedListNode* _tmp1_;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	_tmp1_ = self->_position;
	if (G_LIKELY (_tmp1_ != NULL)) {
		if (G_UNLIKELY (self->_removed)) {
			result = TRUE;
			return result;
		} else {
			GeeLinkedListNode* _tmp2_;
			GeeLinkedListNode* _tmp3_;
			_tmp2_ = self->_position;
			_tmp3_ = _tmp2_->prev;
			result = _tmp3_ != NULL;
			return result;
		}
	} else {
		result = FALSE;
		return result;
	}
}

static gboolean
gee_linked_list_iterator_real_last (GeeBidirIterator* base)
{
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeLinkedList* _tmp4_;
	GeeLinkedListNode* _tmp5_;
	GeeLinkedList* _tmp6_;
	GeeLinkedListNode* _tmp7_;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	_tmp1_ = self->_list;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->_list;
	_tmp5_ = _tmp4_->priv->_tail;
	self->_position = _tmp5_;
	_tmp6_ = self->_list;
	self->_index = _tmp6_->priv->_size - 1;
	_tmp7_ = self->_position;
	_vala_assert (_tmp7_ != NULL, "_position != null");
	result = TRUE;
	return result;
}

static void
gee_linked_list_iterator_real_set (GeeListIterator* base,
                                   gconstpointer item)
{
	GeeLinkedListIterator * self;
	GeeLinkedList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeLinkedListNode* _tmp2_;
	GeeLinkedListNode* _tmp3_;
	gpointer _tmp4_;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	_tmp2_ = self->_position;
	if (_tmp2_ != NULL) {
		_tmp1_ = !self->_removed;
	} else {
		_tmp1_ = FALSE;
	}
	_vala_assert (_tmp1_, "_position != null && !_removed");
	_tmp3_ = self->_position;
	_tmp4_ = ((item != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) item) : ((gpointer) item);
	((_tmp3_->data == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp3_->data = (self->priv->g_destroy_func (_tmp3_->data), NULL));
	_tmp3_->data = _tmp4_;
}

static void
gee_linked_list_iterator_real_insert (GeeBidirListIterator* base,
                                      gconstpointer item)
{
	GeeLinkedListIterator * self;
	GeeLinkedList* _tmp0_;
	GeeLinkedListNode* n = NULL;
	gpointer _tmp1_;
	GeeLinkedListNode* _tmp2_;
	GeeLinkedListNode* n_ref = NULL;
	GeeLinkedListNode* _tmp3_;
	GeeLinkedListNode* _tmp4_;
	GeeLinkedList* _tmp54_;
	gint _tmp55_;
	gint _tmp56_;
	GeeLinkedList* _tmp57_;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	_tmp1_ = ((item != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) item) : ((gpointer) item);
	_tmp2_ = gee_linked_list_node_new (_tmp1_);
	n = _tmp2_;
	_tmp3_ = n;
	n_ref = _tmp3_;
	_tmp4_ = self->_position;
	if (_tmp4_ == NULL) {
		GeeLinkedListNode* position = NULL;
		GeeLinkedList* _tmp5_;
		GeeLinkedListNode* _tmp6_;
		GeeLinkedListNode* _tmp7_;
		GeeLinkedListNode* _tmp16_;
		GeeLinkedList* _tmp18_;
		GeeLinkedListNode* _tmp19_;
		_tmp5_ = self->_list;
		_tmp6_ = _tmp5_->priv->_head;
		_tmp5_->priv->_head = NULL;
		position = _tmp6_;
		_tmp7_ = position;
		if (_tmp7_ != NULL) {
			GeeLinkedListNode* _tmp8_;
			GeeLinkedListNode* _tmp9_;
			GeeLinkedListNode* _tmp10_;
			GeeLinkedListNode* _tmp11_;
			_tmp8_ = position;
			_tmp9_ = n;
			_tmp8_->prev = _tmp9_;
			_tmp10_ = n;
			_tmp11_ = position;
			position = NULL;
			_gee_linked_list_node_free0 (_tmp10_->next);
			_tmp10_->next = _tmp11_;
		} else {
			GeeLinkedList* _tmp12_;
			GeeLinkedListNode* _tmp13_;
			GeeLinkedList* _tmp14_;
			GeeLinkedListNode* _tmp15_;
			_tmp12_ = self->_list;
			_tmp13_ = _tmp12_->priv->_tail;
			_vala_assert (_tmp13_ == NULL, "_list._tail == null");
			_tmp14_ = self->_list;
			_tmp15_ = n;
			_tmp14_->priv->_tail = _tmp15_;
		}
		_tmp16_ = self->_position;
		if (_tmp16_ == NULL) {
			GeeLinkedListNode* _tmp17_;
			_tmp17_ = n_ref;
			self->_position = _tmp17_;
		}
		_tmp18_ = self->_list;
		_tmp19_ = n;
		n = NULL;
		_gee_linked_list_node_free0 (_tmp18_->priv->_head);
		_tmp18_->priv->_head = _tmp19_;
		_gee_linked_list_node_free0 (position);
	} else {
		if (self->_removed) {
			GeeLinkedListNode* _tmp20_;
			GeeLinkedListNode* _tmp21_;
			GeeLinkedListNode* _tmp30_;
			GeeLinkedListNode* _tmp31_;
			GeeLinkedListNode* _tmp32_;
			GeeLinkedListNode* _tmp33_;
			GeeLinkedListNode* _tmp34_;
			_tmp20_ = self->_position;
			_tmp21_ = _tmp20_->next;
			if (_tmp21_ != NULL) {
				GeeLinkedListNode* _tmp22_;
				GeeLinkedListNode* _tmp23_;
				GeeLinkedListNode* _tmp24_;
				GeeLinkedListNode* _tmp25_;
				GeeLinkedListNode* _tmp26_;
				GeeLinkedListNode* _tmp27_;
				_tmp22_ = n;
				_tmp23_ = self->_position;
				_tmp24_ = _tmp23_->next;
				_tmp23_->next = NULL;
				_gee_linked_list_node_free0 (_tmp22_->next);
				_tmp22_->next = _tmp24_;
				_tmp25_ = n;
				_tmp26_ = _tmp25_->next;
				_tmp27_ = n;
				_tmp26_->prev = _tmp27_;
			} else {
				GeeLinkedList* _tmp28_;
				GeeLinkedListNode* _tmp29_;
				_tmp28_ = self->_list;
				_tmp29_ = n;
				_tmp28_->priv->_tail = _tmp29_;
			}
			_tmp30_ = n;
			_tmp31_ = self->_position;
			_tmp30_->prev = _tmp31_;
			_tmp32_ = self->_position;
			_tmp33_ = n;
			n = NULL;
			_gee_linked_list_node_free0 (_tmp32_->next);
			_tmp32_->next = _tmp33_;
			_tmp34_ = n_ref;
			self->_position = _tmp34_;
		} else {
			GeeLinkedListNode* _tmp35_;
			GeeLinkedListNode* _tmp36_;
			GeeLinkedListNode* _tmp37_;
			GeeLinkedListNode* _tmp38_;
			GeeLinkedListNode* _tmp39_;
			GeeLinkedListNode* _tmp40_;
			GeeLinkedListNode* _tmp41_;
			_tmp35_ = n;
			_tmp36_ = self->_position;
			_tmp37_ = _tmp36_->prev;
			_tmp35_->prev = _tmp37_;
			_tmp38_ = self->_position;
			_tmp39_ = n;
			_tmp38_->prev = _tmp39_;
			_tmp40_ = n;
			_tmp41_ = _tmp40_->prev;
			if (_tmp41_ != NULL) {
				GeeLinkedListNode* _tmp42_;
				GeeLinkedListNode* _tmp43_;
				GeeLinkedListNode* _tmp44_;
				GeeLinkedListNode* _tmp45_;
				GeeLinkedListNode* _tmp46_;
				GeeLinkedListNode* _tmp47_;
				GeeLinkedListNode* _tmp48_;
				_tmp42_ = n;
				_tmp43_ = n;
				_tmp44_ = _tmp43_->prev;
				_tmp45_ = _tmp44_->next;
				_tmp44_->next = NULL;
				_gee_linked_list_node_free0 (_tmp42_->next);
				_tmp42_->next = _tmp45_;
				_tmp46_ = n;
				_tmp47_ = _tmp46_->prev;
				_tmp48_ = n;
				n = NULL;
				_gee_linked_list_node_free0 (_tmp47_->next);
				_tmp47_->next = _tmp48_;
			} else {
				GeeLinkedListNode* _tmp49_;
				GeeLinkedList* _tmp50_;
				GeeLinkedListNode* _tmp51_;
				GeeLinkedList* _tmp52_;
				GeeLinkedListNode* _tmp53_;
				_tmp49_ = n;
				_tmp50_ = self->_list;
				_tmp51_ = _tmp50_->priv->_head;
				_tmp50_->priv->_head = NULL;
				_gee_linked_list_node_free0 (_tmp49_->next);
				_tmp49_->next = _tmp51_;
				_tmp52_ = self->_list;
				_tmp53_ = n;
				n = NULL;
				_gee_linked_list_node_free0 (_tmp52_->priv->_head);
				_tmp52_->priv->_head = _tmp53_;
			}
		}
	}
	_tmp54_ = self->_list;
	_tmp55_ = _tmp54_->priv->_size;
	_tmp54_->priv->_size = _tmp55_ + 1;
	_tmp56_ = self->_index;
	self->_index = _tmp56_ + 1;
	_tmp57_ = self->_list;
	self->_stamp = _tmp57_->priv->_stamp;
	_gee_linked_list_node_free0 (n);
}

static void
gee_linked_list_iterator_real_add (GeeListIterator* base,
                                   gconstpointer item)
{
	GeeLinkedListIterator * self;
	GeeLinkedList* _tmp0_;
	GeeLinkedListNode* n = NULL;
	gpointer _tmp1_;
	GeeLinkedListNode* _tmp2_;
	GeeLinkedListNode* n_ref = NULL;
	GeeLinkedListNode* _tmp3_;
	GeeLinkedListNode* _tmp4_;
	GeeLinkedListNode* _tmp28_;
	GeeLinkedList* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	GeeLinkedList* _tmp32_;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	_tmp1_ = ((item != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) item) : ((gpointer) item);
	_tmp2_ = gee_linked_list_node_new (_tmp1_);
	n = _tmp2_;
	_tmp3_ = n;
	n_ref = _tmp3_;
	_tmp4_ = self->_position;
	if (_tmp4_ == NULL) {
		GeeLinkedListNode* position = NULL;
		GeeLinkedList* _tmp5_;
		GeeLinkedListNode* _tmp6_;
		GeeLinkedListNode* _tmp7_;
		GeeLinkedListNode* _tmp8_;
		GeeLinkedListNode* _tmp9_;
		GeeLinkedListNode* _tmp10_;
		GeeLinkedList* _tmp11_;
		GeeLinkedListNode* _tmp12_;
		_tmp5_ = self->_list;
		_tmp6_ = _tmp5_->priv->_head;
		_tmp5_->priv->_head = NULL;
		position = _tmp6_;
		_tmp7_ = position;
		_tmp8_ = n;
		_tmp7_->prev = _tmp8_;
		_tmp9_ = n;
		_tmp10_ = position;
		position = NULL;
		_gee_linked_list_node_free0 (_tmp9_->next);
		_tmp9_->next = _tmp10_;
		_tmp11_ = self->_list;
		_tmp12_ = n;
		n = NULL;
		_gee_linked_list_node_free0 (_tmp11_->priv->_head);
		_tmp11_->priv->_head = _tmp12_;
		_gee_linked_list_node_free0 (position);
	} else {
		GeeLinkedListNode* _tmp13_;
		GeeLinkedListNode* _tmp14_;
		GeeLinkedListNode* _tmp23_;
		GeeLinkedListNode* _tmp24_;
		GeeLinkedListNode* _tmp25_;
		GeeLinkedListNode* _tmp26_;
		GeeLinkedListNode* _tmp27_;
		_tmp13_ = self->_position;
		_tmp14_ = _tmp13_->next;
		if (_tmp14_ != NULL) {
			GeeLinkedListNode* _tmp15_;
			GeeLinkedListNode* _tmp16_;
			GeeLinkedListNode* _tmp17_;
			GeeLinkedListNode* _tmp18_;
			GeeLinkedListNode* _tmp19_;
			GeeLinkedListNode* _tmp20_;
			_tmp15_ = self->_position;
			_tmp16_ = _tmp15_->next;
			_tmp17_ = n;
			_tmp16_->prev = _tmp17_;
			_tmp18_ = n;
			_tmp19_ = self->_position;
			_tmp20_ = _tmp19_->next;
			_tmp19_->next = NULL;
			_gee_linked_list_node_free0 (_tmp18_->next);
			_tmp18_->next = _tmp20_;
		} else {
			GeeLinkedList* _tmp21_;
			GeeLinkedListNode* _tmp22_;
			_tmp21_ = self->_list;
			_tmp22_ = n;
			_tmp21_->priv->_tail = _tmp22_;
		}
		_tmp23_ = self->_position;
		_tmp24_ = n;
		n = NULL;
		_gee_linked_list_node_free0 (_tmp23_->next);
		_tmp23_->next = _tmp24_;
		_tmp25_ = self->_position;
		_tmp26_ = _tmp25_->next;
		_tmp27_ = self->_position;
		_tmp26_->prev = _tmp27_;
	}
	_tmp28_ = n_ref;
	self->_position = _tmp28_;
	self->_removed = FALSE;
	_tmp29_ = self->_list;
	_tmp30_ = _tmp29_->priv->_size;
	_tmp29_->priv->_size = _tmp30_ + 1;
	_tmp31_ = self->_index;
	self->_index = _tmp31_ + 1;
	_tmp32_ = self->_list;
	self->_stamp = _tmp32_->priv->_stamp;
	_gee_linked_list_node_free0 (n);
}

static gint
gee_linked_list_iterator_real_index (GeeListIterator* base)
{
	GeeLinkedListIterator * self;
	gint result = 0;
	GeeLinkedList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeLinkedListNode* _tmp2_;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	_tmp2_ = self->_position;
	if (_tmp2_ != NULL) {
		_tmp1_ = !self->_removed;
	} else {
		_tmp1_ = FALSE;
	}
	_vala_assert (_tmp1_, "_position != null && !_removed");
	result = self->_index;
	return result;
}

static gboolean
gee_linked_list_iterator_real_foreach (GeeTraversable* base,
                                       GeeForallFunc f,
                                       gpointer f_target)
{
	GeeLinkedListIterator * self;
	gboolean result = FALSE;
	GeeLinkedList* _tmp0_;
	GeeLinkedListNode* _tmp1_;
	GeeLinkedList* _tmp12_;
	GeeLinkedListNode* _tmp13_;
	self = (GeeLinkedListIterator*) base;
	_tmp0_ = self->_list;
	_vala_assert (self->_stamp == _tmp0_->priv->_stamp, "_stamp == _list._stamp");
	_tmp1_ = self->_position;
	if (_tmp1_ == NULL) {
		GeeLinkedList* _tmp2_;
		GeeLinkedListNode* _tmp3_;
		_tmp2_ = self->_list;
		_tmp3_ = _tmp2_->priv->_head;
		self->_position = _tmp3_;
	}
	if (self->_removed) {
		GeeLinkedListNode* _tmp4_;
		GeeLinkedListNode* _tmp5_;
		_tmp4_ = self->_position;
		_tmp5_ = _tmp4_->next;
		self->_position = _tmp5_;
		self->_removed = FALSE;
	}
	while (TRUE) {
		GeeLinkedListNode* _tmp6_;
		GeeLinkedListNode* _tmp7_;
		gconstpointer _tmp8_;
		gpointer _tmp9_;
		GeeLinkedListNode* _tmp10_;
		GeeLinkedListNode* _tmp11_;
		_tmp6_ = self->_position;
		if (!(_tmp6_ != NULL)) {
			break;
		}
		_tmp7_ = self->_position;
		_tmp8_ = _tmp7_->data;
		_tmp9_ = ((_tmp8_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp8_) : ((gpointer) _tmp8_);
		if (!f (_tmp9_, f_target)) {
			result = FALSE;
			return result;
		}
		_tmp10_ = self->_position;
		_tmp11_ = _tmp10_->next;
		self->_position = _tmp11_;
	}
	_tmp12_ = self->_list;
	_tmp13_ = _tmp12_->priv->_tail;
	self->_position = _tmp13_;
	result = TRUE;
	return result;
}

static GeeIterator**
gee_linked_list_iterator_real_tee (GeeTraversable* base,
                                   guint forks,
                                   gint* result_length1)
{
	GeeLinkedListIterator * self;
	GeeIterator** result = NULL;
	self = (GeeLinkedListIterator*) base;
	if (forks == ((guint) 0)) {
		GeeIterator** _tmp0_;
		GeeIterator** _tmp1_;
		gint _tmp1__length1;
		_tmp0_ = g_new0 (GeeIterator*, 0 + 1);
		_tmp1_ = _tmp0_;
		_tmp1__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp1__length1;
		}
		result = _tmp1_;
		return result;
	} else {
		GeeIterator** _result_ = NULL;
		GeeIterator** _tmp2_;
		gint _result__length1;
		gint __result__size_;
		GeeIterator** _tmp3_;
		gint _tmp3__length1;
		GeeIterator* _tmp4_;
		GeeIterator** _tmp9_;
		gint _tmp9__length1;
		_tmp2_ = g_new0 (GeeIterator*, forks + 1);
		_result_ = _tmp2_;
		_result__length1 = forks;
		__result__size_ = _result__length1;
		_tmp3_ = _result_;
		_tmp3__length1 = _result__length1;
		_tmp4_ = _g_object_ref0 ((GeeIterator*) self);
		_g_object_unref0 (_tmp3_[0]);
		_tmp3_[0] = _tmp4_;
		{
			guint i = 0U;
			i = (guint) 1;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					GeeIterator** _tmp7_;
					gint _tmp7__length1;
					GeeLinkedListIterator* _tmp8_;
					if (!_tmp5_) {
						guint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					if (!(i < forks)) {
						break;
					}
					_tmp7_ = _result_;
					_tmp7__length1 = _result__length1;
					_tmp8_ = gee_linked_list_iterator_new_from_iterator (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, self);
					_g_object_unref0 (_tmp7_[i]);
					_tmp7_[i] = (GeeIterator*) _tmp8_;
				}
			}
		}
		_tmp9_ = _result_;
		_tmp9__length1 = _result__length1;
		if (result_length1) {
			*result_length1 = _tmp9__length1;
		}
		result = _tmp9_;
		return result;
	}
}

static gboolean
gee_linked_list_iterator_real_get_read_only (GeeIterator* base)
{
	gboolean result;
	GeeLinkedListIterator* self;
	self = (GeeLinkedListIterator*) base;
	result = FALSE;
	return result;
}

static gboolean
gee_linked_list_iterator_real_get_valid (GeeIterator* base)
{
	gboolean result;
	GeeLinkedListIterator* self;
	gboolean _tmp0_ = FALSE;
	self = (GeeLinkedListIterator*) base;
	if (!self->_removed) {
		GeeLinkedListNode* _tmp1_;
		_tmp1_ = self->_position;
		_tmp0_ = _tmp1_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
gee_linked_list_iterator_class_init (GeeLinkedListIteratorClass * klass,
                                     gpointer klass_data)
{
	gee_linked_list_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GeeLinkedListIterator_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_linked_list_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_linked_list_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_linked_list_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_ITERATOR_READ_ONLY_PROPERTY, gee_linked_list_iterator_properties[GEE_LINKED_LIST_ITERATOR_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_ITERATOR_VALID_PROPERTY, gee_linked_list_iterator_properties[GEE_LINKED_LIST_ITERATOR_VALID_PROPERTY] = g_param_spec_boolean ("valid", "valid", "valid", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static GType
gee_linked_list_iterator_gee_traversable_get_g_type (GeeLinkedListIterator* self)
{
	return self->priv->g_type;
}

static GBoxedCopyFunc
gee_linked_list_iterator_gee_traversable_get_g_dup_func (GeeLinkedListIterator* self)
{
	return self->priv->g_dup_func;
}

static GDestroyNotify
gee_linked_list_iterator_gee_traversable_get_g_destroy_func (GeeLinkedListIterator* self)
{
	return self->priv->g_destroy_func;
}

static void
gee_linked_list_iterator_gee_traversable_interface_init (GeeTraversableIface * iface,
                                                         gpointer iface_data)
{
	gee_linked_list_iterator_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
	iface->foreach = (gboolean (*) (GeeTraversable*, GeeForallFunc, gpointer)) gee_linked_list_iterator_real_foreach;
	iface->tee = (GeeIterator** (*) (GeeTraversable*, guint, gint*)) gee_linked_list_iterator_real_tee;
	iface->get_g_type = (GType (*) (GeeTraversable *)) gee_linked_list_iterator_gee_traversable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeTraversable *)) gee_linked_list_iterator_gee_traversable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeTraversable *)) gee_linked_list_iterator_gee_traversable_get_g_destroy_func;
}

static void
gee_linked_list_iterator_gee_iterator_interface_init (GeeIteratorIface * iface,
                                                      gpointer iface_data)
{
	gee_linked_list_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (gboolean (*) (GeeIterator*)) gee_linked_list_iterator_real_next;
	iface->has_next = (gboolean (*) (GeeIterator*)) gee_linked_list_iterator_real_has_next;
	iface->get = (gpointer (*) (GeeIterator*)) gee_linked_list_iterator_real_get;
	iface->remove = (void (*) (GeeIterator*)) gee_linked_list_iterator_real_remove;
	iface->get_read_only = gee_linked_list_iterator_real_get_read_only;
	iface->get_valid = gee_linked_list_iterator_real_get_valid;
}

static GType
gee_linked_list_iterator_gee_bidir_iterator_get_g_type (GeeLinkedListIterator* self)
{
	return self->priv->g_type;
}

static GBoxedCopyFunc
gee_linked_list_iterator_gee_bidir_iterator_get_g_dup_func (GeeLinkedListIterator* self)
{
	return self->priv->g_dup_func;
}

static GDestroyNotify
gee_linked_list_iterator_gee_bidir_iterator_get_g_destroy_func (GeeLinkedListIterator* self)
{
	return self->priv->g_destroy_func;
}

static void
gee_linked_list_iterator_gee_bidir_iterator_interface_init (GeeBidirIteratorIface * iface,
                                                            gpointer iface_data)
{
	gee_linked_list_iterator_gee_bidir_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->first = (gboolean (*) (GeeBidirIterator*)) gee_linked_list_iterator_real_first;
	iface->previous = (gboolean (*) (GeeBidirIterator*)) gee_linked_list_iterator_real_previous;
	iface->has_previous = (gboolean (*) (GeeBidirIterator*)) gee_linked_list_iterator_real_has_previous;
	iface->last = (gboolean (*) (GeeBidirIterator*)) gee_linked_list_iterator_real_last;
	iface->get_g_type = (GType (*) (GeeBidirIterator *)) gee_linked_list_iterator_gee_bidir_iterator_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeBidirIterator *)) gee_linked_list_iterator_gee_bidir_iterator_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeBidirIterator *)) gee_linked_list_iterator_gee_bidir_iterator_get_g_destroy_func;
}

static void
gee_linked_list_iterator_gee_list_iterator_interface_init (GeeListIteratorIface * iface,
                                                           gpointer iface_data)
{
	gee_linked_list_iterator_gee_list_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->set = (void (*) (GeeListIterator*, gconstpointer)) gee_linked_list_iterator_real_set;
	iface->add = (void (*) (GeeListIterator*, gconstpointer)) gee_linked_list_iterator_real_add;
	iface->index = (gint (*) (GeeListIterator*)) gee_linked_list_iterator_real_index;
}

static GType
gee_linked_list_iterator_gee_bidir_list_iterator_get_g_type (GeeLinkedListIterator* self)
{
	return self->priv->g_type;
}

static GBoxedCopyFunc
gee_linked_list_iterator_gee_bidir_list_iterator_get_g_dup_func (GeeLinkedListIterator* self)
{
	return self->priv->g_dup_func;
}

static GDestroyNotify
gee_linked_list_iterator_gee_bidir_list_iterator_get_g_destroy_func (GeeLinkedListIterator* self)
{
	return self->priv->g_destroy_func;
}

static void
gee_linked_list_iterator_gee_bidir_list_iterator_interface_init (GeeBidirListIteratorIface * iface,
                                                                 gpointer iface_data)
{
	gee_linked_list_iterator_gee_bidir_list_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->insert = (void (*) (GeeBidirListIterator*, gconstpointer)) gee_linked_list_iterator_real_insert;
	iface->get_g_type = (GType (*) (GeeBidirListIterator *)) gee_linked_list_iterator_gee_bidir_list_iterator_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeBidirListIterator *)) gee_linked_list_iterator_gee_bidir_list_iterator_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeBidirListIterator *)) gee_linked_list_iterator_gee_bidir_list_iterator_get_g_destroy_func;
}

static void
gee_linked_list_iterator_instance_init (GeeLinkedListIterator * self,
                                        gpointer klass)
{
	self->priv = gee_linked_list_iterator_get_instance_private (self);
	self->_removed = FALSE;
}

static void
gee_linked_list_iterator_finalize (GObject * obj)
{
	GeeLinkedListIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIterator);
	_g_object_unref0 (self->_list);
	G_OBJECT_CLASS (gee_linked_list_iterator_parent_class)->finalize (obj);
}

static GType
gee_linked_list_iterator_get_type (void)
{
	static volatile gsize gee_linked_list_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_linked_list_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeLinkedListIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_linked_list_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeLinkedListIterator), 0, (GInstanceInitFunc) gee_linked_list_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) gee_linked_list_iterator_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_linked_list_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_bidir_iterator_info = { (GInterfaceInitFunc) gee_linked_list_iterator_gee_bidir_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_list_iterator_info = { (GInterfaceInitFunc) gee_linked_list_iterator_gee_list_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_bidir_list_iterator_info = { (GInterfaceInitFunc) gee_linked_list_iterator_gee_bidir_list_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_linked_list_iterator_type_id;
		gee_linked_list_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeLinkedListIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_linked_list_iterator_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
		g_type_add_interface_static (gee_linked_list_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_type_add_interface_static (gee_linked_list_iterator_type_id, GEE_TYPE_BIDIR_ITERATOR, &gee_bidir_iterator_info);
		g_type_add_interface_static (gee_linked_list_iterator_type_id, GEE_TYPE_LIST_ITERATOR, &gee_list_iterator_info);
		g_type_add_interface_static (gee_linked_list_iterator_type_id, GEE_TYPE_BIDIR_LIST_ITERATOR, &gee_bidir_list_iterator_info);
		GeeLinkedListIterator_private_offset = g_type_add_instance_private (gee_linked_list_iterator_type_id, sizeof (GeeLinkedListIteratorPrivate));
		g_once_init_leave (&gee_linked_list_iterator_type_id__volatile, gee_linked_list_iterator_type_id);
	}
	return gee_linked_list_iterator_type_id__volatile;
}

static void
_vala_gee_linked_list_iterator_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	GeeLinkedListIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIterator);
	switch (property_id) {
		case GEE_LINKED_LIST_ITERATOR_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, gee_iterator_get_read_only ((GeeIterator*) self));
		break;
		case GEE_LINKED_LIST_ITERATOR_VALID_PROPERTY:
		g_value_set_boolean (value, gee_iterator_get_valid ((GeeIterator*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gee_linked_list_iterator_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	GeeLinkedListIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_LINKED_LIST_TYPE_ITERATOR, GeeLinkedListIterator);
	switch (property_id) {
		case GEE_LINKED_LIST_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_LINKED_LIST_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_LINKED_LIST_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
gee_linked_list_class_init (GeeLinkedListClass * klass,
                            gpointer klass_data)
{
	gee_linked_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GeeLinkedList_private_offset);
	((GeeAbstractCollectionClass *) klass)->foreach = (gboolean (*) (GeeAbstractCollection*, GeeForallFunc, gpointer)) gee_linked_list_real_foreach;
	((GeeAbstractCollectionClass *) klass)->iterator = (GeeIterator* (*) (GeeAbstractCollection*)) gee_linked_list_real_iterator;
	((GeeAbstractListClass *) klass)->list_iterator = (GeeListIterator* (*) (GeeAbstractList*)) gee_linked_list_real_list_iterator;
	((GeeAbstractBidirListClass *) klass)->bidir_list_iterator = (GeeBidirListIterator* (*) (GeeAbstractBidirList*)) gee_linked_list_real_bidir_list_iterator;
	((GeeAbstractCollectionClass *) klass)->contains = (gboolean (*) (GeeAbstractCollection*, gconstpointer)) gee_linked_list_real_contains;
	((GeeAbstractCollectionClass *) klass)->add = (gboolean (*) (GeeAbstractCollection*, gconstpointer)) gee_linked_list_real_add;
	((GeeAbstractCollectionClass *) klass)->remove = (gboolean (*) (GeeAbstractCollection*, gconstpointer)) gee_linked_list_real_remove;
	((GeeAbstractCollectionClass *) klass)->clear = (void (*) (GeeAbstractCollection*)) gee_linked_list_real_clear;
	((GeeAbstractListClass *) klass)->get = (gpointer (*) (GeeAbstractList*, gint)) gee_linked_list_real_get;
	((GeeAbstractListClass *) klass)->set = (void (*) (GeeAbstractList*, gint, gconstpointer)) gee_linked_list_real_set;
	((GeeAbstractListClass *) klass)->index_of = (gint (*) (GeeAbstractList*, gconstpointer)) gee_linked_list_real_index_of;
	((GeeAbstractListClass *) klass)->insert = (void (*) (GeeAbstractList*, gint, gconstpointer)) gee_linked_list_real_insert;
	((GeeAbstractListClass *) klass)->remove_at = (gpointer (*) (GeeAbstractList*, gint)) gee_linked_list_real_remove_at;
	((GeeAbstractListClass *) klass)->slice = (GeeList* (*) (GeeAbstractList*, gint, gint)) gee_linked_list_real_slice;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_linked_list_real_get_size;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_read_only = gee_linked_list_real_get_read_only;
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_linked_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_linked_list_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_linked_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_SIZE_PROPERTY, gee_linked_list_properties[GEE_LINKED_LIST_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_READ_ONLY_PROPERTY, gee_linked_list_properties[GEE_LINKED_LIST_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_CAPACITY_PROPERTY, gee_linked_list_properties[GEE_LINKED_LIST_CAPACITY_PROPERTY] = g_param_spec_int ("capacity", "capacity", "capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_REMAINING_CAPACITY_PROPERTY, gee_linked_list_properties[GEE_LINKED_LIST_REMAINING_CAPACITY_PROPERTY] = g_param_spec_int ("remaining-capacity", "remaining-capacity", "remaining-capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_LINKED_LIST_IS_FULL_PROPERTY, gee_linked_list_properties[GEE_LINKED_LIST_IS_FULL_PROPERTY] = g_param_spec_boolean ("is-full", "is-full", "is-full", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static GType
gee_linked_list_gee_queue_get_g_type (GeeLinkedList* self)
{
	return self->priv->g_type;
}

static GBoxedCopyFunc
gee_linked_list_gee_queue_get_g_dup_func (GeeLinkedList* self)
{
	return self->priv->g_dup_func;
}

static GDestroyNotify
gee_linked_list_gee_queue_get_g_destroy_func (GeeLinkedList* self)
{
	return self->priv->g_destroy_func;
}

static void
gee_linked_list_gee_queue_interface_init (GeeQueueIface * iface,
                                          gpointer iface_data)
{
	gee_linked_list_gee_queue_parent_iface = g_type_interface_peek_parent (iface);
	iface->offer = (gboolean (*) (GeeQueue*, gconstpointer)) gee_linked_list_real_offer;
	iface->peek = (gpointer (*) (GeeQueue*)) gee_linked_list_real_peek;
	iface->poll = (gpointer (*) (GeeQueue*)) gee_linked_list_real_poll;
	iface->drain = (gint (*) (GeeQueue*, GeeCollection*, gint)) gee_linked_list_real_drain;
	iface->get_g_type = (GType (*) (GeeQueue *)) gee_linked_list_gee_queue_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeQueue *)) gee_linked_list_gee_queue_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeQueue *)) gee_linked_list_gee_queue_get_g_destroy_func;
	iface->get_capacity = gee_linked_list_real_get_capacity;
	iface->get_remaining_capacity = gee_linked_list_real_get_remaining_capacity;
	iface->get_is_full = gee_linked_list_real_get_is_full;
}

static GType
gee_linked_list_gee_deque_get_g_type (GeeLinkedList* self)
{
	return self->priv->g_type;
}

static GBoxedCopyFunc
gee_linked_list_gee_deque_get_g_dup_func (GeeLinkedList* self)
{
	return self->priv->g_dup_func;
}

static GDestroyNotify
gee_linked_list_gee_deque_get_g_destroy_func (GeeLinkedList* self)
{
	return self->priv->g_destroy_func;
}

static void
gee_linked_list_gee_deque_interface_init (GeeDequeIface * iface,
                                          gpointer iface_data)
{
	gee_linked_list_gee_deque_parent_iface = g_type_interface_peek_parent (iface);
	iface->offer_head = (gboolean (*) (GeeDeque*, gconstpointer)) gee_linked_list_real_offer_head;
	iface->peek_head = (gpointer (*) (GeeDeque*)) gee_linked_list_real_peek_head;
	iface->poll_head = (gpointer (*) (GeeDeque*)) gee_linked_list_real_poll_head;
	iface->drain_head = (gint (*) (GeeDeque*, GeeCollection*, gint)) gee_linked_list_real_drain_head;
	iface->offer_tail = (gboolean (*) (GeeDeque*, gconstpointer)) gee_linked_list_real_offer_tail;
	iface->peek_tail = (gpointer (*) (GeeDeque*)) gee_linked_list_real_peek_tail;
	iface->poll_tail = (gpointer (*) (GeeDeque*)) gee_linked_list_real_poll_tail;
	iface->drain_tail = (gint (*) (GeeDeque*, GeeCollection*, gint)) gee_linked_list_real_drain_tail;
	iface->get_g_type = (GType (*) (GeeDeque *)) gee_linked_list_gee_deque_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeDeque *)) gee_linked_list_gee_deque_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeDeque *)) gee_linked_list_gee_deque_get_g_destroy_func;
}

static void
gee_linked_list_instance_init (GeeLinkedList * self,
                               gpointer klass)
{
	self->priv = gee_linked_list_get_instance_private (self);
	self->priv->_size = 0;
	self->priv->_stamp = 0;
	self->priv->_head = NULL;
	self->priv->_tail = NULL;
}

static void
gee_linked_list_finalize (GObject * obj)
{
	GeeLinkedList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_TYPE_LINKED_LIST, GeeLinkedList);
	gee_abstract_collection_clear ((GeeAbstractCollection*) self);
	_gee_linked_list_node_free0 (self->priv->_head);
	_gee_functions_equal_data_func_closure_unref0 (self->priv->_equal_func);
	G_OBJECT_CLASS (gee_linked_list_parent_class)->finalize (obj);
}

/**
 * Doubly-linked list implementation of the {@link List} interface.
 *
 * This implementation is pretty well designed for highly mutable data. When
 * indexed access is privileged prefer using {@link ArrayList}.
 *
 * @see ArrayList
 */
GType
gee_linked_list_get_type (void)
{
	static volatile gsize gee_linked_list_type_id__volatile = 0;
	if (g_once_init_enter (&gee_linked_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeLinkedListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_linked_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeLinkedList), 0, (GInstanceInitFunc) gee_linked_list_instance_init, NULL };
		static const GInterfaceInfo gee_queue_info = { (GInterfaceInitFunc) gee_linked_list_gee_queue_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_deque_info = { (GInterfaceInitFunc) gee_linked_list_gee_deque_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_linked_list_type_id;
		gee_linked_list_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_BIDIR_LIST, "GeeLinkedList", &g_define_type_info, 0);
		g_type_add_interface_static (gee_linked_list_type_id, GEE_TYPE_QUEUE, &gee_queue_info);
		g_type_add_interface_static (gee_linked_list_type_id, GEE_TYPE_DEQUE, &gee_deque_info);
		GeeLinkedList_private_offset = g_type_add_instance_private (gee_linked_list_type_id, sizeof (GeeLinkedListPrivate));
		g_once_init_leave (&gee_linked_list_type_id__volatile, gee_linked_list_type_id);
	}
	return gee_linked_list_type_id__volatile;
}

static void
_vala_gee_linked_list_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	GeeLinkedList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_LINKED_LIST, GeeLinkedList);
	switch (property_id) {
		case GEE_LINKED_LIST_SIZE_PROPERTY:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		case GEE_LINKED_LIST_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, gee_abstract_collection_get_read_only ((GeeAbstractCollection*) self));
		break;
		case GEE_LINKED_LIST_CAPACITY_PROPERTY:
		g_value_set_int (value, gee_queue_get_capacity ((GeeQueue*) self));
		break;
		case GEE_LINKED_LIST_REMAINING_CAPACITY_PROPERTY:
		g_value_set_int (value, gee_queue_get_remaining_capacity ((GeeQueue*) self));
		break;
		case GEE_LINKED_LIST_IS_FULL_PROPERTY:
		g_value_set_boolean (value, gee_queue_get_is_full ((GeeQueue*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gee_linked_list_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	GeeLinkedList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_LINKED_LIST, GeeLinkedList);
	switch (property_id) {
		case GEE_LINKED_LIST_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_LINKED_LIST_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_LINKED_LIST_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

