/* GNOME-DB Components
 * Copyright (C) 2000-2003 The GNOME Foundation.
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#if !defined(__sql_viewer_h__)
#  define __sql_viewer_h__

#include <libgda/gda-connection.h>
#include <gtk/gtkvbox.h>

G_BEGIN_DECLS

#define TYPE_SQL_VIEWER            (sql_viewer_get_type())
#define SQL_VIEWER(obj)            (G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SQL_VIEWER, SqlViewer))
#define SQL_VIEWER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST (klass, TYPE_SQL_VIEWER, SqlViewerClass))
#define IS_SQL_VIEWER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE (obj, TYPE_SQL_VIEWER))
#define IS_SQL_VIEWER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SQL_VIEWER))

typedef struct {
	GtkVBox parent;

	/* private fields */
	GtkWidget *sql_editor;
	GtkWidget *grid;
} SqlViewer;

typedef struct {
	GtkVBoxClass parent_class;
} SqlViewerClass;

GType      sql_viewer_get_type (void);
GtkWidget *sql_viewer_new (GdaConnection *cnc, const gchar *sql);

G_END_DECLS

#endif
