/* GNOME DB library
 * Copyright (C) 1999-2002 The GNOME Foundation.
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined(__gnome_db_control_h__)
#  define __gnome_db_control_h__

#include <bonobo/bonobo-control.h>
#include <libgda/gda-value.h>

G_BEGIN_DECLS

#define GNOME_DB_TYPE_CONTROL            (gnome_db_control_get_type())
#define GNOME_DB_CONTROL(obj)            (G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_DB_TYPE_CONTROL, GnomeDbControl))
#define GNOME_DB_CONTROL_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST (klass, GNOME_DB_TYPE_CONTROL, GnomeDbControlClass))
#define GNOME_DB_IS_CONTROL(obj)         (G_TYPE_CHECK_INSTANCE_TYPE (obj, GNOME_DB_TYPE_CONTROL))
#define GNOME_DB_IS_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_DB_TYPE_CONTROL))

typedef struct _GnomeDbControl        GnomeDbControl;
typedef struct _GnomeDbControlClass   GnomeDbControlClass;
typedef struct _GnomeDbControlPrivate GnomeDbControlPrivate;

struct _GnomeDbControl {
	BonoboControl control;
	GnomeDbControlPrivate *priv;
};

struct _GnomeDbControlClass {
	BonoboControlClass parent_class;

	/* signals */
	void (* activated)    (GnomeDbControl *control);
	void (* get_property) (GnomeDbControl *control, GdaValue *value, guint id);
	void (* set_property) (GnomeDbControl *control, const GdaValue *value, guint id);
};

GType           gnome_db_control_get_type (void);
GnomeDbControl *gnome_db_control_construct (GnomeDbControl *control, GtkWidget *widget);
GnomeDbControl *gnome_db_control_new (GtkWidget *widget);
void            gnome_db_control_set_ui (GnomeDbControl *control,
					 const gchar *app_prefix,
					 const gchar *ui_xml_file,
					 BonoboUIVerb *verbs,
					 gpointer user_data);
void            gnome_db_control_activate (GnomeDbControl *control);
void            gnome_db_control_deactivate (GnomeDbControl *control);
void            gnome_db_control_set_status (GnomeDbControl *control, const gchar *msg);

G_END_DECLS

#endif
