#!/usr/bin/env python

import sys
import musicbrainz
from musicbrainz.queries import *

def main():
    mb = musicbrainz.mb()
    mb.SetDepth(2)
    mb.SetDebug(1)
    
    mb.QueryWithArgs(MBQ_FindAlbumByName, [u'1'])
    print mb.GetResultRDF()
    print "no. of albums:", mb.GetResultInt(MBE_GetNumAlbums)
    mb.Select1(MBS_SelectAlbum, 1)
    for ii in range(1, mb.GetResultInt(MBE_AlbumGetNumTracks) + 1):
        name = mb.GetResultData1(MBE_AlbumGetTrackName, ii)
        dura = mb.GetResultData1(MBE_AlbumGetTrackDuration, ii)
        track = mb.GetResultData1(MBE_AlbumGetTrackNum, ii)
        
        print "track: %s %s %r" % (dura, track, name) 
        

if __name__ == '__main__':
    main()
