/*
 *
 *  OpenOBEX - Free implementation of the Object Exchange protocol
 *
 *  Copyright (C) 1999-2000  Dag Brattli <dagb@cs.uit.no>
 *  Copyright (C) 1999-2000  Pontus Fuchs <pontus.fuchs@tactel.se>
 *  Copyright (C) 2001-2002  Jean Tourrilhes <jt@hpl.hp.com>
 *  Copyright (C) 2002-2006  Marcel Holtmann <marcel@holtmann.org>
 *
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef __OBEX_H
#define __OBEX_H

#ifdef __cplusplus
extern "C" {
#endif

#include <inttypes.h>

#ifdef _WIN32
#include <winsock.h>
#else
#include <sys/socket.h>
#endif

/* Hum... This would need to be autogenerated from configure,
 * I hate hardcoding version numbers. Jean II */
#define OPENOBEX_VERSION(a,b,c) (((a) << 16) + ((b) << 8) + (c))
//#define OPENOBEX_VERSION_CODE	OPENOBEX_VERSION(1,0,0)

// These are also defined in obex_main.h
// They are defined here otherwise any app including it
// would require obex_main.h which includes a lot of other 
// unnecessary stuff.
typedef void* obex_t;
typedef void* obex_object_t;
typedef void (*obex_event_t)(obex_t *handle, obex_object_t *obj, int mode, int event, int obex_cmd, int obex_rsp);
// This is to workaround compilation without Bluetooth support. - Jean II
#ifndef SOL_RFCOMM
typedef char* bdaddr_t;
#endif

#include <openobex/obex_const.h>

/*
 *  OBEX API
 */
obex_t *OBEX_Init(int transport, obex_event_t eventcb, unsigned int flags);
void    OBEX_Cleanup(obex_t *self);
void OBEX_SetUserData(obex_t *self, void * data);
void * OBEX_GetUserData(obex_t *self);
void OBEX_SetUserCallBack(obex_t *self, obex_event_t eventcb, void * data);
int OBEX_SetTransportMTU(obex_t *self, uint16_t mtu_rx, uint16_t mtu_tx_max);
int OBEX_GetFD(obex_t *self);

int OBEX_RegisterCTransport(obex_t *self, obex_ctrans_t *ctrans);
void OBEX_SetCustomData(obex_t *self, void * data);
void * OBEX_GetCustomData(obex_t *self);

int    OBEX_TransportConnect(obex_t *self, struct sockaddr *saddr, int addlen);
int    OBEX_TransportDisconnect(obex_t *self);
int    OBEX_CustomDataFeed(obex_t *self, uint8_t *inputbuf, int actual);
int    OBEX_HandleInput(obex_t *self, int timeout);

int    OBEX_ServerRegister(obex_t *self, struct sockaddr *saddr, int addrlen);
obex_t *OBEX_ServerAccept(obex_t *server, obex_event_t eventcb, void * data);
int    OBEX_Request(obex_t *self, obex_object_t *object);
int    OBEX_CancelRequest(obex_t *self, int nice);
int    OBEX_SuspendRequest(obex_t *self, obex_object_t *object);
int    OBEX_ResumeRequest(obex_t *self);

obex_object_t	*OBEX_ObjectNew(obex_t *self, uint8_t cmd);
int		OBEX_ObjectDelete(obex_t *self, obex_object_t *object);

int		OBEX_ObjectAddHeader(obex_t *self, obex_object_t *object, uint8_t hi, 
			obex_headerdata_t hv, uint32_t hv_size, unsigned int flags);
int OBEX_ObjectGetNextHeader(obex_t *self, obex_object_t *object, uint8_t *hi,
					obex_headerdata_t *hv,
					uint32_t *hv_size);
int OBEX_ObjectReParseHeaders(obex_t *self, obex_object_t *object);
int OBEX_ObjectSetRsp(obex_object_t *object, uint8_t rsp, uint8_t lastrsp);

int OBEX_ObjectGetNonHdrData(obex_object_t *object, uint8_t **buffer);
int OBEX_ObjectSetNonHdrData(obex_object_t *object, const uint8_t *buffer, unsigned int len);
int OBEX_ObjectSetHdrOffset(obex_object_t *object, unsigned int offset);
int OBEX_ObjectReadStream(obex_t *self, obex_object_t *object, const uint8_t **buf);

int OBEX_UnicodeToChar(uint8_t *c, const uint8_t *uc, int size);
int OBEX_CharToUnicode(uint8_t *uc, const uint8_t *c, int size);

char *OBEX_ResponseToString(int rsp);

/*
 * This function is deprecated and will be removed in OpenOBEX 1.1.0
 *
 * Please use the OBEX_ResponseToString instead.
 *
 */
char* OBEX_GetResponseMessage(obex_t *self, int rsp);

/*
 * InOBEX API (TCP/IP)
 */
 int InOBEX_ServerRegister(obex_t *self);
 int InOBEX_TransportConnect(obex_t *self, struct sockaddr *saddr, int addrlen);

/*
 * IrOBEX API 
 */
 int IrOBEX_ServerRegister(obex_t *self, const char *service);
 int IrOBEX_TransportConnect(obex_t *self, const char *service);

/*
 * Bluetooth OBEX API
 */
 int BtOBEX_ServerRegister(obex_t *self, bdaddr_t *src, uint8_t channel);
 int BtOBEX_TransportConnect(obex_t *self, bdaddr_t *src, bdaddr_t *dst, uint8_t channel);

/*
 * OBEX File API
 */
int FdOBEX_TransportSetup(obex_t *self, int rfd, int wfd, int mtu);

/*  
 * OBEX interface discovery API 
 */
 int OBEX_FindInterfaces(obex_t *self, obex_interface_t **interfaces);
 int OBEX_InterfaceConnect(obex_t *self, obex_interface_t *interface);
 void OBEX_FreeInterfaces(obex_t *self);

#ifdef __cplusplus
}
#endif

#endif /* __OBEX_H */
