/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libe-book project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#include <librevenge/librevenge.h>

#include "FB2BinaryContext.h"
#include "FB2Collector.h"
#include "FB2Content.h"
#include "FB2Token.h"

namespace libebook
{

FB2BinaryContext::FB2BinaryContext(FB2ParserContext *const parentContext, FB2Collector *const collector)
  : FB2NodeContextBase(parentContext, collector)
  , m_id()
  , m_contentType()
{
}

FB2XMLParserContext *FB2BinaryContext::element(const FB2TokenData &, const FB2TokenData &)
{
  return 0;
}

void FB2BinaryContext::endOfElement()
{
}

void FB2BinaryContext::attribute(const FB2TokenData &name, const FB2TokenData *ns, const char *value)
{
  if (FB2_NO_NAMESPACE(ns))
  {
    switch (getFB2TokenID(name))
    {
    case FB2Token::content_type :
      m_contentType = value;
      break;
    case FB2Token::id :
      m_id = value;
      break;
    default :
      break;
    }
  }
}

void FB2BinaryContext::text(const char *value)
{
  getCollector()->defineID(m_id.c_str());
  getCollector()->insertBitmapData(m_contentType.c_str(), value);
}

}

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
