/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#include <rtflistener.hxx>
#include <oox/token/namespaces.hxx>
#include <oox/token/tokens.hxx>
#include <string.h>

namespace writerfilter
{
namespace rtftok
{

RTFSymbol aRTFControlWords[] =
{
    // sKeyword nControlType nIndex
    {"'", CONTROL_SYMBOL, RTF_HEXCHAR},
    {"-", CONTROL_SYMBOL, RTF_OPTHYPH},
    {"*", CONTROL_SYMBOL, RTF_IGNORE},
    {":", CONTROL_SYMBOL, RTF_SUBENTRY},
    {"\\", CONTROL_SYMBOL, RTF_BACKSLASH},
    {"\n", CONTROL_SYMBOL, RTF_PAR},
    {"\r", CONTROL_SYMBOL, RTF_PAR},
    {"\r\n", CONTROL_SYMBOL, RTF_PAR},
    {"_", CONTROL_SYMBOL, RTF_NOBRKHYPH},
    {"{", CONTROL_SYMBOL, RTF_LBRACE},
    {"|", CONTROL_SYMBOL, RTF_FORMULA},
    {"}", CONTROL_SYMBOL, RTF_RBRACE},
    {"~", CONTROL_SYMBOL, RTF_NOBREAK},
    {"ab", CONTROL_TOGGLE, RTF_AB},
    {"absh", CONTROL_VALUE, RTF_ABSH},
    {"abslock", CONTROL_FLAG, RTF_ABSLOCK},
    {"absnoovrlp", CONTROL_TOGGLE, RTF_ABSNOOVRLP},
    {"absw", CONTROL_VALUE, RTF_ABSW},
    {"acaps", CONTROL_TOGGLE, RTF_ACAPS},
    {"acccircle", CONTROL_TOGGLE, RTF_ACCCIRCLE},
    {"acccomma", CONTROL_TOGGLE, RTF_ACCCOMMA},
    {"accdot", CONTROL_TOGGLE, RTF_ACCDOT},
    {"accnone", CONTROL_TOGGLE, RTF_ACCNONE},
    {"accunderdot", CONTROL_TOGGLE, RTF_ACCUNDERDOT},
    {"acf", CONTROL_VALUE, RTF_ACF},
    {"adeff", CONTROL_VALUE, RTF_ADEFF},
    {"additive", CONTROL_FLAG, RTF_ADDITIVE},
    {"adeflang", CONTROL_VALUE, RTF_ADEFLANG},
    {"adjustright", CONTROL_FLAG, RTF_ADJUSTRIGHT},
    {"adn", CONTROL_VALUE, RTF_ADN},
    {"aenddoc", CONTROL_FLAG, RTF_AENDDOC},
    {"aendnotes", CONTROL_FLAG, RTF_AENDNOTES},
    {"aexpnd", CONTROL_VALUE, RTF_AEXPND},
    {"af", CONTROL_VALUE, RTF_AF},
    {"afelev", CONTROL_FLAG, RTF_AFELEV},
    {"afs", CONTROL_VALUE, RTF_AFS},
    {"aftnbj", CONTROL_FLAG, RTF_AFTNBJ},
    {"aftncn", CONTROL_DESTINATION, RTF_AFTNCN},
    {"aftnnalc", CONTROL_FLAG, RTF_AFTNNALC},
    {"aftnnar", CONTROL_FLAG, RTF_AFTNNAR},
    {"aftnnauc", CONTROL_FLAG, RTF_AFTNNAUC},
    {"aftnnchi", CONTROL_FLAG, RTF_AFTNNCHI},
    {"aftnnchosung", CONTROL_FLAG, RTF_AFTNNCHOSUNG},
    {"aftnncnum", CONTROL_FLAG, RTF_AFTNNCNUM},
    {"aftnndbar", CONTROL_FLAG, RTF_AFTNNDBAR},
    {"aftnndbnum", CONTROL_FLAG, RTF_AFTNNDBNUM},
    {"aftnndbnumd", CONTROL_FLAG, RTF_AFTNNDBNUMD},
    {"aftnndbnumk", CONTROL_FLAG, RTF_AFTNNDBNUMK},
    {"aftnndbnumt", CONTROL_FLAG, RTF_AFTNNDBNUMT},
    {"aftnnganada", CONTROL_FLAG, RTF_AFTNNGANADA},
    {"aftnngbnum", CONTROL_FLAG, RTF_AFTNNGBNUM},
    {"aftnngbnumd", CONTROL_FLAG, RTF_AFTNNGBNUMD},
    {"aftnngbnumk", CONTROL_FLAG, RTF_AFTNNGBNUMK},
    {"aftnngbnuml", CONTROL_FLAG, RTF_AFTNNGBNUML},
    {"aftnnrlc", CONTROL_FLAG, RTF_AFTNNRLC},
    {"aftnnruc", CONTROL_FLAG, RTF_AFTNNRUC},
    {"aftnnzodiac", CONTROL_FLAG, RTF_AFTNNZODIAC},
    {"aftnnzodiacd", CONTROL_FLAG, RTF_AFTNNZODIACD},
    {"aftnnzodiacl", CONTROL_FLAG, RTF_AFTNNZODIACL},
    {"aftnrestart", CONTROL_FLAG, RTF_AFTNRESTART},
    {"aftnrstcont", CONTROL_FLAG, RTF_AFTNRSTCONT},
    {"aftnsep", CONTROL_DESTINATION, RTF_AFTNSEP},
    {"aftnsepc", CONTROL_DESTINATION, RTF_AFTNSEPC},
    {"aftnstart", CONTROL_VALUE, RTF_AFTNSTART},
    {"aftntj", CONTROL_FLAG, RTF_AFTNTJ},
    {"ai", CONTROL_TOGGLE, RTF_AI},
    {"alang", CONTROL_VALUE, RTF_ALANG},
    {"allowfieldendsel", CONTROL_FLAG, RTF_ALLOWFIELDENDSEL},
    {"allprot", CONTROL_FLAG, RTF_ALLPROT},
    {"alntblind", CONTROL_FLAG, RTF_ALNTBLIND},
    {"alt", CONTROL_FLAG, RTF_ALT},
    {"animtext", CONTROL_VALUE, RTF_ANIMTEXT},
    {"annotation", CONTROL_DESTINATION, RTF_ANNOTATION},
    {"annotprot", CONTROL_FLAG, RTF_ANNOTPROT},
    {"ansi", CONTROL_FLAG, RTF_ANSI},
    {"ansicpg", CONTROL_VALUE, RTF_ANSICPG},
    {"aoutl", CONTROL_TOGGLE, RTF_AOUTL},
    {"ApplyBrkRules", CONTROL_FLAG, RTF_APPLYBRKRULES},
    {"ascaps", CONTROL_TOGGLE, RTF_ASCAPS},
    {"ashad", CONTROL_TOGGLE, RTF_ASHAD},
    {"asianbrkrule", CONTROL_FLAG, RTF_ASIANBRKRULE},
    {"aspalpha", CONTROL_TOGGLE, RTF_ASPALPHA},
    {"aspnum", CONTROL_TOGGLE, RTF_ASPNUM},
    {"astrike", CONTROL_TOGGLE, RTF_ASTRIKE},
    {"atnauthor", CONTROL_DESTINATION, RTF_ATNAUTHOR},
    {"atndate", CONTROL_DESTINATION, RTF_ATNDATE},
    {"atnicn", CONTROL_DESTINATION, RTF_ATNICN},
    {"atnid", CONTROL_DESTINATION, RTF_ATNID},
    {"atnparent", CONTROL_DESTINATION, RTF_ATNPARENT},
    {"atnref", CONTROL_DESTINATION, RTF_ATNREF},
    {"atntime", CONTROL_DESTINATION, RTF_ATNTIME},
    {"atrfend", CONTROL_DESTINATION, RTF_ATRFEND},
    {"atrfstart", CONTROL_DESTINATION, RTF_ATRFSTART},
    {"aul", CONTROL_TOGGLE, RTF_AUL},
    {"auld", CONTROL_TOGGLE, RTF_AULD},
    {"auldb", CONTROL_TOGGLE, RTF_AULDB},
    {"aulnone", CONTROL_TOGGLE, RTF_AULNONE},
    {"aulw", CONTROL_TOGGLE, RTF_AULW},
    {"aup", CONTROL_VALUE, RTF_AUP},
    {"author", CONTROL_DESTINATION, RTF_AUTHOR},
    {"autofmtoverride", CONTROL_FLAG, RTF_AUTOFMTOVERRIDE},
    {"b", CONTROL_TOGGLE, RTF_B},
    {"background", CONTROL_DESTINATION, RTF_BACKGROUND},
    {"bdbfhdr", CONTROL_FLAG, RTF_BDBFHDR},
    {"bdrrlswsix", CONTROL_FLAG, RTF_BDRRLSWSIX},
    {"bgbdiag", CONTROL_FLAG, RTF_BGBDIAG},
    {"bgcross", CONTROL_FLAG, RTF_BGCROSS},
    {"bgdcross", CONTROL_FLAG, RTF_BGDCROSS},
    {"bgdkbdiag", CONTROL_FLAG, RTF_BGDKBDIAG},
    {"bgdkcross", CONTROL_FLAG, RTF_BGDKCROSS},
    {"bgdkdcross", CONTROL_FLAG, RTF_BGDKDCROSS},
    {"bgdkfdiag", CONTROL_FLAG, RTF_BGDKFDIAG},
    {"bgdkhoriz", CONTROL_FLAG, RTF_BGDKHORIZ},
    {"bgdkvert", CONTROL_FLAG, RTF_BGDKVERT},
    {"bgfdiag", CONTROL_FLAG, RTF_BGFDIAG},
    {"bghoriz", CONTROL_FLAG, RTF_BGHORIZ},
    {"bgvert", CONTROL_FLAG, RTF_BGVERT},
    {"bin", CONTROL_VALUE, RTF_BIN},
    {"binfsxn", CONTROL_VALUE, RTF_BINFSXN},
    {"binsxn", CONTROL_VALUE, RTF_BINSXN},
    {"bkmkcolf", CONTROL_VALUE, RTF_BKMKCOLF},
    {"bkmkcoll", CONTROL_VALUE, RTF_BKMKCOLL},
    {"bkmkend", CONTROL_DESTINATION, RTF_BKMKEND},
    {"bkmkpub", CONTROL_FLAG, RTF_BKMKPUB},
    {"bkmkstart", CONTROL_DESTINATION, RTF_BKMKSTART},
    {"bliptag", CONTROL_VALUE, RTF_BLIPTAG},
    {"blipuid", CONTROL_DESTINATION, RTF_BLIPUID},
    {"blipupi", CONTROL_VALUE, RTF_BLIPUPI},
    {"blue", CONTROL_VALUE, RTF_BLUE},
    {"bookfold", CONTROL_FLAG, RTF_BOOKFOLD},
    {"bookfoldrev", CONTROL_FLAG, RTF_BOOKFOLDREV},
    {"bookfoldsheets", CONTROL_VALUE, RTF_BOOKFOLDSHEETS},
    {"box", CONTROL_FLAG, RTF_BOX},
    {"brdrart", CONTROL_VALUE, RTF_BRDRART},
    {"brdrb", CONTROL_FLAG, RTF_BRDRB},
    {"brdrbar", CONTROL_FLAG, RTF_BRDRBAR},
    {"brdrbtw", CONTROL_FLAG, RTF_BRDRBTW},
    {"brdrcf", CONTROL_VALUE, RTF_BRDRCF},
    {"brdrdash", CONTROL_FLAG, RTF_BRDRDASH},
    {"brdrdashd", CONTROL_FLAG, RTF_BRDRDASHD},
    {"brdrdashdd", CONTROL_FLAG, RTF_BRDRDASHDD},
    {"brdrdashdot", CONTROL_FLAG, RTF_BRDRDASHDOT},
    {"brdrdashdotdot", CONTROL_FLAG, RTF_BRDRDASHDOTDOT},
    {"brdrdashdotstr", CONTROL_FLAG, RTF_BRDRDASHDOTSTR},
    {"brdrdashsm", CONTROL_FLAG, RTF_BRDRDASHSM},
    {"brdrdb", CONTROL_FLAG, RTF_BRDRDB},
    {"brdrdot", CONTROL_FLAG, RTF_BRDRDOT},
    {"brdremboss", CONTROL_FLAG, RTF_BRDREMBOSS},
    {"brdrengrave", CONTROL_FLAG, RTF_BRDRENGRAVE},
    {"brdrframe", CONTROL_FLAG, RTF_BRDRFRAME},
    {"brdrhair", CONTROL_FLAG, RTF_BRDRHAIR},
    {"brdrinset", CONTROL_FLAG, RTF_BRDRINSET},
    {"brdrl", CONTROL_FLAG, RTF_BRDRL},
    {"brdrnil", CONTROL_FLAG, RTF_BRDRNIL},
    {"brdrnone", CONTROL_FLAG, RTF_BRDRNONE},
    {"brdroutset", CONTROL_FLAG, RTF_BRDROUTSET},
    {"brdrr", CONTROL_FLAG, RTF_BRDRR},
    {"brdrs", CONTROL_FLAG, RTF_BRDRS},
    {"brdrsh", CONTROL_FLAG, RTF_BRDRSH},
    {"brdrt", CONTROL_FLAG, RTF_BRDRT},
    {"brdrtbl", CONTROL_FLAG, RTF_BRDRTBL},
    {"brdrth", CONTROL_FLAG, RTF_BRDRTH},
    {"brdrthtnlg", CONTROL_FLAG, RTF_BRDRTHTNLG},
    {"brdrthtnmg", CONTROL_FLAG, RTF_BRDRTHTNMG},
    {"brdrthtnsg", CONTROL_FLAG, RTF_BRDRTHTNSG},
    {"brdrtnthlg", CONTROL_FLAG, RTF_BRDRTNTHLG},
    {"brdrtnthmg", CONTROL_FLAG, RTF_BRDRTNTHMG},
    {"brdrtnthsg", CONTROL_FLAG, RTF_BRDRTNTHSG},
    {"brdrtnthtnlg", CONTROL_FLAG, RTF_BRDRTNTHTNLG},
    {"brdrtnthtnmg", CONTROL_FLAG, RTF_BRDRTNTHTNMG},
    {"brdrtnthtnsg", CONTROL_FLAG, RTF_BRDRTNTHTNSG},
    {"brdrtriple", CONTROL_FLAG, RTF_BRDRTRIPLE},
    {"brdrw", CONTROL_VALUE, RTF_BRDRW},
    {"brdrwavy", CONTROL_FLAG, RTF_BRDRWAVY},
    {"brdrwavydb", CONTROL_FLAG, RTF_BRDRWAVYDB},
    {"brkfrm", CONTROL_FLAG, RTF_BRKFRM},
    {"brsp", CONTROL_VALUE, RTF_BRSP},
    {"bullet", CONTROL_SYMBOL, RTF_BULLET},
    {"buptim", CONTROL_DESTINATION, RTF_BUPTIM},
    {"bxe", CONTROL_FLAG, RTF_BXE},
    {"caccentfive", CONTROL_FLAG, RTF_CACCENTFIVE},
    {"caccentfour", CONTROL_FLAG, RTF_CACCENTFOUR},
    {"caccentone", CONTROL_FLAG, RTF_CACCENTONE},
    {"caccentsix", CONTROL_FLAG, RTF_CACCENTSIX},
    {"caccentthree", CONTROL_FLAG, RTF_CACCENTTHREE},
    {"caccenttwo", CONTROL_FLAG, RTF_CACCENTTWO},
    {"cachedcolbal", CONTROL_FLAG, RTF_CACHEDCOLBAL},
    {"caps", CONTROL_TOGGLE, RTF_CAPS},
    {"category", CONTROL_DESTINATION, RTF_CATEGORY},
    {"cb", CONTROL_VALUE, RTF_CB},
    {"cbackgroundone", CONTROL_FLAG, RTF_CBACKGROUNDONE},
    {"cbackgroundtwo", CONTROL_FLAG, RTF_CBACKGROUNDTWO},
    {"cbpat", CONTROL_VALUE, RTF_CBPAT},
    {"cchs", CONTROL_VALUE, RTF_CCHS},
    {"cell", CONTROL_SYMBOL, RTF_CELL},
    {"cellx", CONTROL_VALUE, RTF_CELLX},
    {"cf", CONTROL_VALUE, RTF_CF},
    {"cfollowedhyperlink", CONTROL_FLAG, RTF_CFOLLOWEDHYPERLINK},
    {"cfpat", CONTROL_VALUE, RTF_CFPAT},
    {"cgrid", CONTROL_VALUE, RTF_CGRID},
    {"charrsid", CONTROL_VALUE, RTF_CHARRSID},
    {"charscalex", CONTROL_VALUE, RTF_CHARSCALEX},
    {"chatn", CONTROL_SYMBOL, RTF_CHATN},
    {"chbgbdiag", CONTROL_FLAG, RTF_CHBGBDIAG},
    {"chbgcross", CONTROL_FLAG, RTF_CHBGCROSS},
    {"chbgdcross", CONTROL_FLAG, RTF_CHBGDCROSS},
    {"chbgdkbdiag", CONTROL_FLAG, RTF_CHBGDKBDIAG},
    {"chbgdkcross", CONTROL_FLAG, RTF_CHBGDKCROSS},
    {"chbgdkdcross", CONTROL_FLAG, RTF_CHBGDKDCROSS},
    {"chbgdkfdiag", CONTROL_FLAG, RTF_CHBGDKFDIAG},
    {"chbgdkhoriz", CONTROL_FLAG, RTF_CHBGDKHORIZ},
    {"chbgdkvert", CONTROL_FLAG, RTF_CHBGDKVERT},
    {"chbgfdiag", CONTROL_FLAG, RTF_CHBGFDIAG},
    {"chbghoriz", CONTROL_FLAG, RTF_CHBGHORIZ},
    {"chbgvert", CONTROL_FLAG, RTF_CHBGVERT},
    {"chbrdr", CONTROL_FLAG, RTF_CHBRDR},
    {"chcbpat", CONTROL_VALUE, RTF_CHCBPAT},
    {"chcfpat", CONTROL_VALUE, RTF_CHCFPAT},
    {"chdate", CONTROL_SYMBOL, RTF_CHDATE},
    {"chdpa", CONTROL_SYMBOL, RTF_CHDPA},
    {"chdpl", CONTROL_SYMBOL, RTF_CHDPL},
    {"chftn", CONTROL_SYMBOL, RTF_CHFTN},
    {"chftnsep", CONTROL_SYMBOL, RTF_CHFTNSEP},
    {"chftnsepc", CONTROL_SYMBOL, RTF_CHFTNSEPC},
    {"chpgn", CONTROL_SYMBOL, RTF_CHPGN},
    {"chhres", CONTROL_VALUE, RTF_CHHRES},
    {"chshdng", CONTROL_VALUE, RTF_CHSHDNG},
    {"chtime", CONTROL_SYMBOL, RTF_CHTIME},
    {"chyperlink", CONTROL_FLAG, RTF_CHYPERLINK},
    {"clbgbdiag", CONTROL_FLAG, RTF_CLBGBDIAG},
    {"clbgcross", CONTROL_FLAG, RTF_CLBGCROSS},
    {"clbgdcross", CONTROL_FLAG, RTF_CLBGDCROSS},
    {"clbgdkbdiag", CONTROL_FLAG, RTF_CLBGDKBDIAG},
    {"clbgdkcross", CONTROL_FLAG, RTF_CLBGDKCROSS},
    {"clbgdkdcross", CONTROL_FLAG, RTF_CLBGDKDCROSS},
    {"clbgdkfdiag", CONTROL_FLAG, RTF_CLBGDKFDIAG},
    {"clbgdkhor", CONTROL_FLAG, RTF_CLBGDKHOR},
    {"clbgdkvert", CONTROL_FLAG, RTF_CLBGDKVERT},
    {"clbgfdiag", CONTROL_FLAG, RTF_CLBGFDIAG},
    {"clbghoriz", CONTROL_FLAG, RTF_CLBGHORIZ},
    {"clbgvert", CONTROL_FLAG, RTF_CLBGVERT},
    {"clbrdrb", CONTROL_FLAG, RTF_CLBRDRB},
    {"clbrdrl", CONTROL_FLAG, RTF_CLBRDRL},
    {"clbrdrr", CONTROL_FLAG, RTF_CLBRDRR},
    {"clbrdrt", CONTROL_FLAG, RTF_CLBRDRT},
    {"clcbpat", CONTROL_VALUE, RTF_CLCBPAT},
    {"clcbpatraw", CONTROL_VALUE, RTF_CLCBPATRAW},
    {"clcfpat", CONTROL_VALUE, RTF_CLCFPAT},
    {"clcfpatraw", CONTROL_VALUE, RTF_CLCFPATRAW},
    {"cldel", CONTROL_FLAG, RTF_CLDEL},
    {"cldelauth", CONTROL_VALUE, RTF_CLDELAUTH},
    {"cldeldttm", CONTROL_VALUE, RTF_CLDELDTTM},
    {"cldgll", CONTROL_FLAG, RTF_CLDGLL},
    {"cldglu", CONTROL_FLAG, RTF_CLDGLU},
    {"clFitText", CONTROL_FLAG, RTF_CLFITTEXT},
    {"clftsWidth", CONTROL_VALUE, RTF_CLFTSWIDTH},
    {"clhidemark", CONTROL_FLAG, RTF_CLHIDEMARK},
    {"clins", CONTROL_FLAG, RTF_CLINS},
    {"clinsauth", CONTROL_VALUE, RTF_CLINSAUTH},
    {"clinsdttm", CONTROL_VALUE, RTF_CLINSDTTM},
    {"clmgf", CONTROL_FLAG, RTF_CLMGF},
    {"clmrg", CONTROL_FLAG, RTF_CLMRG},
    {"clmrgd", CONTROL_FLAG, RTF_CLMRGD},
    {"clmrgdauth", CONTROL_VALUE, RTF_CLMRGDAUTH},
    {"clmrgddttm", CONTROL_VALUE, RTF_CLMRGDDTTM},
    {"clmrgdr", CONTROL_FLAG, RTF_CLMRGDR},
    {"clNoWrap", CONTROL_FLAG, RTF_CLNOWRAP},
    {"clpadb", CONTROL_VALUE, RTF_CLPADB},
    {"clpadfb", CONTROL_VALUE, RTF_CLPADFB},
    {"clpadfl", CONTROL_VALUE, RTF_CLPADFL},
    {"clpadfr", CONTROL_VALUE, RTF_CLPADFR},
    {"clpadft", CONTROL_VALUE, RTF_CLPADFT},
    {"clpadl", CONTROL_VALUE, RTF_CLPADL},
    {"clpadr", CONTROL_VALUE, RTF_CLPADR},
    {"clpadt", CONTROL_VALUE, RTF_CLPADT},
    {"clspb", CONTROL_VALUE, RTF_CLSPB},
    {"clspfb", CONTROL_VALUE, RTF_CLSPFB},
    {"clspfl", CONTROL_VALUE, RTF_CLSPFL},
    {"clspfr", CONTROL_VALUE, RTF_CLSPFR},
    {"clspft", CONTROL_VALUE, RTF_CLSPFT},
    {"clspl", CONTROL_VALUE, RTF_CLSPL},
    {"clspr", CONTROL_VALUE, RTF_CLSPR},
    {"clspt", CONTROL_VALUE, RTF_CLSPT},
    {"clshdng", CONTROL_VALUE, RTF_CLSHDNG},
    {"clshdngraw", CONTROL_VALUE, RTF_CLSHDNGRAW},
    {"clshdrawnil", CONTROL_FLAG, RTF_CLSHDRAWNIL},
    {"clsplit", CONTROL_FLAG, RTF_CLSPLIT},
    {"clsplitr", CONTROL_FLAG, RTF_CLSPLITR},
    {"cltxbtlr", CONTROL_FLAG, RTF_CLTXBTLR},
    {"cltxlrtb", CONTROL_FLAG, RTF_CLTXLRTB},
    {"cltxlrtbv", CONTROL_FLAG, RTF_CLTXLRTBV},
    {"cltxtbrl", CONTROL_FLAG, RTF_CLTXTBRL},
    {"cltxtbrlv", CONTROL_FLAG, RTF_CLTXTBRLV},
    {"clvertalb", CONTROL_FLAG, RTF_CLVERTALB},
    {"clvertalc", CONTROL_FLAG, RTF_CLVERTALC},
    {"clvertalt", CONTROL_FLAG, RTF_CLVERTALT},
    {"clvmgf", CONTROL_FLAG, RTF_CLVMGF},
    {"clvmrg", CONTROL_FLAG, RTF_CLVMRG},
    {"clwWidth", CONTROL_VALUE, RTF_CLWWIDTH},
    {"cmaindarkone", CONTROL_FLAG, RTF_CMAINDARKONE},
    {"cmaindarktwo", CONTROL_FLAG, RTF_CMAINDARKTWO},
    {"cmainlightone", CONTROL_FLAG, RTF_CMAINLIGHTONE},
    {"cmainlighttwo", CONTROL_FLAG, RTF_CMAINLIGHTTWO},
    {"collapsed", CONTROL_FLAG, RTF_COLLAPSED},
    {"colno", CONTROL_VALUE, RTF_COLNO},
    {"colorschememapping", CONTROL_DESTINATION, RTF_COLORSCHEMEMAPPING},
    {"colortbl", CONTROL_DESTINATION, RTF_COLORTBL},
    {"cols", CONTROL_VALUE, RTF_COLS},
    {"colsr", CONTROL_VALUE, RTF_COLSR},
    {"colsx", CONTROL_VALUE, RTF_COLSX},
    {"column", CONTROL_SYMBOL, RTF_COLUMN},
    {"colw", CONTROL_VALUE, RTF_COLW},
    {"comment", CONTROL_DESTINATION, RTF_COMMENT},
    {"company", CONTROL_DESTINATION, RTF_COMPANY},
    {"contextualspace", CONTROL_FLAG, RTF_CONTEXTUALSPACE},
    {"cpg", CONTROL_VALUE, RTF_CPG},
    {"crauth", CONTROL_VALUE, RTF_CRAUTH},
    {"crdate", CONTROL_VALUE, RTF_CRDATE},
    {"creatim", CONTROL_DESTINATION, RTF_CREATIM},
    {"cs", CONTROL_VALUE, RTF_CS},
    {"cshade", CONTROL_VALUE, RTF_CSHADE},
    {"ctextone", CONTROL_FLAG, RTF_CTEXTONE},
    {"ctexttwo", CONTROL_FLAG, RTF_CTEXTTWO},
    {"ctint", CONTROL_VALUE, RTF_CTINT},
    {"ctrl", CONTROL_FLAG, RTF_CTRL},
    {"cts", CONTROL_VALUE, RTF_CTS},
    {"cufi", CONTROL_VALUE, RTF_CUFI},
    {"culi", CONTROL_VALUE, RTF_CULI},
    {"curi", CONTROL_VALUE, RTF_CURI},
    {"cvmme", CONTROL_FLAG, RTF_CVMME},
    {"datafield", CONTROL_DESTINATION, RTF_DATAFIELD},
    {"datastore", CONTROL_DESTINATION, RTF_DATASTORE},
    {"date", CONTROL_FLAG, RTF_DATE},
    {"dbch", CONTROL_FLAG, RTF_DBCH},
    {"defchp", CONTROL_DESTINATION, RTF_DEFCHP},
    {"deff", CONTROL_VALUE, RTF_DEFF},
    {"defformat", CONTROL_FLAG, RTF_DEFFORMAT},
    {"deflang", CONTROL_VALUE, RTF_DEFLANG},
    {"deflangfe", CONTROL_VALUE, RTF_DEFLANGFE},
    {"defpap", CONTROL_DESTINATION, RTF_DEFPAP},
    {"defshp", CONTROL_FLAG, RTF_DEFSHP},
    {"deftab", CONTROL_VALUE, RTF_DEFTAB},
    {"deleted", CONTROL_TOGGLE, RTF_DELETED},
    {"delrsid", CONTROL_VALUE, RTF_DELRSID},
    {"dfrauth", CONTROL_VALUE, RTF_DFRAUTH},
    {"dfrdate", CONTROL_VALUE, RTF_DFRDATE},
    {"dfrmtxtx", CONTROL_VALUE, RTF_DFRMTXTX},
    {"dfrmtxty", CONTROL_VALUE, RTF_DFRMTXTY},
    {"dfrstart", CONTROL_VALUE, RTF_DFRSTART},
    {"dfrstop", CONTROL_VALUE, RTF_DFRSTOP},
    {"dfrxst", CONTROL_VALUE, RTF_DFRXST},
    {"dghorigin", CONTROL_VALUE, RTF_DGHORIGIN},
    {"dghshow", CONTROL_VALUE, RTF_DGHSHOW},
    {"dghspace", CONTROL_VALUE, RTF_DGHSPACE},
    {"dgmargin", CONTROL_FLAG, RTF_DGMARGIN},
    {"dgsnap", CONTROL_FLAG, RTF_DGSNAP},
    {"dgvorigin", CONTROL_VALUE, RTF_DGVORIGIN},
    {"dgvshow", CONTROL_VALUE, RTF_DGVSHOW},
    {"dgvspace", CONTROL_VALUE, RTF_DGVSPACE},
    {"dibitmap", CONTROL_VALUE, RTF_DIBITMAP},
    {"disabled", CONTROL_TOGGLE, RTF_DISABLED},
    {"dn", CONTROL_VALUE, RTF_DN},
    {"dntblnsbdb", CONTROL_FLAG, RTF_DNTBLNSBDB},
    {"do", CONTROL_DESTINATION, RTF_DO},
    {"dobxcolumn", CONTROL_FLAG, RTF_DOBXCOLUMN},
    {"dobxmargin", CONTROL_FLAG, RTF_DOBXMARGIN},
    {"dobxpage", CONTROL_FLAG, RTF_DOBXPAGE},
    {"dobymargin", CONTROL_FLAG, RTF_DOBYMARGIN},
    {"dobypage", CONTROL_FLAG, RTF_DOBYPAGE},
    {"dobypara", CONTROL_FLAG, RTF_DOBYPARA},
    {"doccomm", CONTROL_DESTINATION, RTF_DOCCOMM},
    {"doctemp", CONTROL_FLAG, RTF_DOCTEMP},
    {"doctype", CONTROL_VALUE, RTF_DOCTYPE},
    {"docvar", CONTROL_DESTINATION, RTF_DOCVAR},
    {"dodhgt", CONTROL_VALUE, RTF_DODHGT},
    {"dolock", CONTROL_FLAG, RTF_DOLOCK},
    {"donotembedlingdata", CONTROL_VALUE, RTF_DONOTEMBEDLINGDATA},
    {"donotembedsysfont", CONTROL_VALUE, RTF_DONOTEMBEDSYSFONT},
    {"donotshowcomments", CONTROL_FLAG, RTF_DONOTSHOWCOMMENTS},
    {"donotshowinsdel", CONTROL_FLAG, RTF_DONOTSHOWINSDEL},
    {"donotshowmarkup", CONTROL_FLAG, RTF_DONOTSHOWMARKUP},
    {"donotshowprops", CONTROL_FLAG, RTF_DONOTSHOWPROPS},
    {"dpaendhol", CONTROL_FLAG, RTF_DPAENDHOL},
    {"dpaendl", CONTROL_VALUE, RTF_DPAENDL},
    {"dpaendsol", CONTROL_FLAG, RTF_DPAENDSOL},
    {"dpaendw", CONTROL_VALUE, RTF_DPAENDW},
    {"dparc", CONTROL_FLAG, RTF_DPARC},
    {"dparcflipx", CONTROL_FLAG, RTF_DPARCFLIPX},
    {"dparcflipy", CONTROL_FLAG, RTF_DPARCFLIPY},
    {"dpastarthol", CONTROL_FLAG, RTF_DPASTARTHOL},
    {"dpastartl", CONTROL_VALUE, RTF_DPASTARTL},
    {"dpastartsol", CONTROL_FLAG, RTF_DPASTARTSOL},
    {"dpastartw", CONTROL_VALUE, RTF_DPASTARTW},
    {"dpcallout", CONTROL_FLAG, RTF_DPCALLOUT},
    {"dpcoa", CONTROL_VALUE, RTF_DPCOA},
    {"dpcoaccent", CONTROL_FLAG, RTF_DPCOACCENT},
    {"dpcobestfit", CONTROL_FLAG, RTF_DPCOBESTFIT},
    {"dpcoborder", CONTROL_FLAG, RTF_DPCOBORDER},
    {"dpcodabs", CONTROL_FLAG, RTF_DPCODABS},
    {"dpcodbottom", CONTROL_FLAG, RTF_DPCODBOTTOM},
    {"dpcodcenter", CONTROL_FLAG, RTF_DPCODCENTER},
    {"dpcodescent", CONTROL_VALUE, RTF_DPCODESCENT},
    {"dpcodtop", CONTROL_FLAG, RTF_DPCODTOP},
    {"dpcolength", CONTROL_VALUE, RTF_DPCOLENGTH},
    {"dpcominusx", CONTROL_FLAG, RTF_DPCOMINUSX},
    {"dpcominusy", CONTROL_FLAG, RTF_DPCOMINUSY},
    {"dpcooffset", CONTROL_VALUE, RTF_DPCOOFFSET},
    {"dpcosmarta", CONTROL_FLAG, RTF_DPCOSMARTA},
    {"dpcotdouble", CONTROL_FLAG, RTF_DPCOTDOUBLE},
    {"dpcotright", CONTROL_FLAG, RTF_DPCOTRIGHT},
    {"dpcotsingle", CONTROL_FLAG, RTF_DPCOTSINGLE},
    {"dpcottriple", CONTROL_FLAG, RTF_DPCOTTRIPLE},
    {"dpcount", CONTROL_VALUE, RTF_DPCOUNT},
    {"dpellipse", CONTROL_FLAG, RTF_DPELLIPSE},
    {"dpendgroup", CONTROL_FLAG, RTF_DPENDGROUP},
    {"dpfillbgcb", CONTROL_VALUE, RTF_DPFILLBGCB},
    {"dpfillbgcg", CONTROL_VALUE, RTF_DPFILLBGCG},
    {"dpfillbgcr", CONTROL_VALUE, RTF_DPFILLBGCR},
    {"dpfillbggray", CONTROL_VALUE, RTF_DPFILLBGGRAY},
    {"dpfillbgpal", CONTROL_FLAG, RTF_DPFILLBGPAL},
    {"dpfillfgcb", CONTROL_VALUE, RTF_DPFILLFGCB},
    {"dpfillfgcg", CONTROL_VALUE, RTF_DPFILLFGCG},
    {"dpfillfgcr", CONTROL_VALUE, RTF_DPFILLFGCR},
    {"dpfillfggray", CONTROL_VALUE, RTF_DPFILLFGGRAY},
    {"dpfillfgpal", CONTROL_FLAG, RTF_DPFILLFGPAL},
    {"dpfillpat", CONTROL_VALUE, RTF_DPFILLPAT},
    {"dpgroup", CONTROL_FLAG, RTF_DPGROUP},
    {"dpline", CONTROL_FLAG, RTF_DPLINE},
    {"dplinecob", CONTROL_VALUE, RTF_DPLINECOB},
    {"dplinecog", CONTROL_VALUE, RTF_DPLINECOG},
    {"dplinecor", CONTROL_VALUE, RTF_DPLINECOR},
    {"dplinedado", CONTROL_FLAG, RTF_DPLINEDADO},
    {"dplinedadodo", CONTROL_FLAG, RTF_DPLINEDADODO},
    {"dplinedash", CONTROL_FLAG, RTF_DPLINEDASH},
    {"dplinedot", CONTROL_FLAG, RTF_DPLINEDOT},
    {"dplinegray", CONTROL_VALUE, RTF_DPLINEGRAY},
    {"dplinehollow", CONTROL_FLAG, RTF_DPLINEHOLLOW},
    {"dplinepal", CONTROL_FLAG, RTF_DPLINEPAL},
    {"dplinesolid", CONTROL_FLAG, RTF_DPLINESOLID},
    {"dplinew", CONTROL_VALUE, RTF_DPLINEW},
    {"dppolycount", CONTROL_VALUE, RTF_DPPOLYCOUNT},
    {"dppolygon", CONTROL_FLAG, RTF_DPPOLYGON},
    {"dppolyline", CONTROL_FLAG, RTF_DPPOLYLINE},
    {"dpptx", CONTROL_VALUE, RTF_DPPTX},
    {"dppty", CONTROL_VALUE, RTF_DPPTY},
    {"dprect", CONTROL_FLAG, RTF_DPRECT},
    {"dproundr", CONTROL_FLAG, RTF_DPROUNDR},
    {"dpshadow", CONTROL_FLAG, RTF_DPSHADOW},
    {"dpshadx", CONTROL_VALUE, RTF_DPSHADX},
    {"dpshady", CONTROL_VALUE, RTF_DPSHADY},
    {"dptxbtlr", CONTROL_FLAG, RTF_DPTXBTLR},
    {"dptxbx", CONTROL_FLAG, RTF_DPTXBX},
    {"dptxbxmar", CONTROL_VALUE, RTF_DPTXBXMAR},
    {"dptxbxtext", CONTROL_DESTINATION, RTF_DPTXBXTEXT},
    {"dptxlrtb", CONTROL_FLAG, RTF_DPTXLRTB},
    {"dptxlrtbv", CONTROL_FLAG, RTF_DPTXLRTBV},
    {"dptxtbrl", CONTROL_FLAG, RTF_DPTXTBRL},
    {"dptxtbrlv", CONTROL_FLAG, RTF_DPTXTBRLV},
    {"dpx", CONTROL_VALUE, RTF_DPX},
    {"dpxsize", CONTROL_VALUE, RTF_DPXSIZE},
    {"dpy", CONTROL_VALUE, RTF_DPY},
    {"dpysize", CONTROL_VALUE, RTF_DPYSIZE},
    {"dropcapli", CONTROL_VALUE, RTF_DROPCAPLI},
    {"dropcapt", CONTROL_VALUE, RTF_DROPCAPT},
    {"ds", CONTROL_VALUE, RTF_DS},
    {"dxfrtext", CONTROL_VALUE, RTF_DXFRTEXT},
    {"dy", CONTROL_VALUE, RTF_DY},
    {"ebcend", CONTROL_DESTINATION, RTF_EBCEND},
    {"ebcstart", CONTROL_DESTINATION, RTF_EBCSTART},
    {"edmins", CONTROL_VALUE, RTF_EDMINS},
    {"embo", CONTROL_TOGGLE, RTF_EMBO},
    {"emdash", CONTROL_SYMBOL, RTF_EMDASH},
    {"emfblip", CONTROL_FLAG, RTF_EMFBLIP},
    {"emspace", CONTROL_SYMBOL, RTF_EMSPACE},
    {"endash", CONTROL_SYMBOL, RTF_ENDASH},
    {"enddoc", CONTROL_FLAG, RTF_ENDDOC},
    {"endnhere", CONTROL_FLAG, RTF_ENDNHERE},
    {"endnotes", CONTROL_FLAG, RTF_ENDNOTES},
    {"enforceprot", CONTROL_VALUE, RTF_ENFORCEPROT},
    {"enspace", CONTROL_SYMBOL, RTF_ENSPACE},
    {"expnd", CONTROL_VALUE, RTF_EXPND},
    {"expndtw", CONTROL_VALUE, RTF_EXPNDTW},
    {"expshrtn", CONTROL_FLAG, RTF_EXPSHRTN},
    {"f", CONTROL_VALUE, RTF_F},
    {"faauto", CONTROL_FLAG, RTF_FAAUTO},
    {"facenter", CONTROL_FLAG, RTF_FACENTER},
    {"facingp", CONTROL_TOGGLE, RTF_FACINGP},
    {"factoidname", CONTROL_DESTINATION, RTF_FACTOIDNAME},
    {"fafixed", CONTROL_FLAG, RTF_FAFIXED},
    {"fahang", CONTROL_FLAG, RTF_FAHANG},
    {"falt", CONTROL_DESTINATION, RTF_FALT},
    {"faroman", CONTROL_FLAG, RTF_FAROMAN},
    {"favar", CONTROL_FLAG, RTF_FAVAR},
    {"fbias", CONTROL_VALUE, RTF_FBIAS},
    {"fbidi", CONTROL_FLAG, RTF_FBIDI},
    {"fbidis", CONTROL_FLAG, RTF_FBIDIS},
    {"fbimajor", CONTROL_FLAG, RTF_FBIMAJOR},
    {"fbiminor", CONTROL_FLAG, RTF_FBIMINOR},
    {"fchars", CONTROL_DESTINATION, RTF_FCHARS},
    {"fcharset", CONTROL_VALUE, RTF_FCHARSET},
    {"fcs", CONTROL_VALUE, RTF_FCS},
    {"fdbmajor", CONTROL_FLAG, RTF_FDBMAJOR},
    {"fdbminor", CONTROL_FLAG, RTF_FDBMINOR},
    {"fdecor", CONTROL_FLAG, RTF_FDECOR},
    {"felnbrelev", CONTROL_FLAG, RTF_FELNBRELEV},
    {"fet", CONTROL_VALUE, RTF_FET},
    {"fetch", CONTROL_FLAG, RTF_FETCH},
    {"ffdefres", CONTROL_VALUE, RTF_FFDEFRES},
    {"ffdeftext", CONTROL_DESTINATION, RTF_FFDEFTEXT},
    {"ffentrymcr", CONTROL_DESTINATION, RTF_FFENTRYMCR},
    {"ffexitmcr", CONTROL_DESTINATION, RTF_FFEXITMCR},
    {"ffformat", CONTROL_DESTINATION, RTF_FFFORMAT},
    {"ffhaslistbox", CONTROL_VALUE, RTF_FFHASLISTBOX},
    {"ffhelptext", CONTROL_DESTINATION, RTF_FFHELPTEXT},
    {"ffhps", CONTROL_VALUE, RTF_FFHPS},
    {"ffl", CONTROL_DESTINATION, RTF_FFL},
    {"ffmaxlen", CONTROL_VALUE, RTF_FFMAXLEN},
    {"ffname", CONTROL_DESTINATION, RTF_FFNAME},
    {"ffownhelp", CONTROL_VALUE, RTF_FFOWNHELP},
    {"ffownstat", CONTROL_VALUE, RTF_FFOWNSTAT},
    {"ffprot", CONTROL_VALUE, RTF_FFPROT},
    {"ffrecalc", CONTROL_VALUE, RTF_FFRECALC},
    {"ffres", CONTROL_VALUE, RTF_FFRES},
    {"ffsize", CONTROL_VALUE, RTF_FFSIZE},
    {"ffstattext", CONTROL_DESTINATION, RTF_FFSTATTEXT},
    {"fftype", CONTROL_VALUE, RTF_FFTYPE},
    {"fftypetxt", CONTROL_VALUE, RTF_FFTYPETXT},
    {"fhimajor", CONTROL_FLAG, RTF_FHIMAJOR},
    {"fhiminor", CONTROL_FLAG, RTF_FHIMINOR},
    {"fi", CONTROL_VALUE, RTF_FI},
    {"fid", CONTROL_VALUE, RTF_FID},
    {"field", CONTROL_DESTINATION, RTF_FIELD},
    {"file", CONTROL_DESTINATION, RTF_FILE},
    {"filetbl", CONTROL_DESTINATION, RTF_FILETBL},
    {"fittext", CONTROL_VALUE, RTF_FITTEXT},
    {"fjgothic", CONTROL_FLAG, RTF_FJGOTHIC},
    {"fjminchou", CONTROL_FLAG, RTF_FJMINCHOU},
    {"fldalt", CONTROL_FLAG, RTF_FLDALT},
    {"flddirty", CONTROL_FLAG, RTF_FLDDIRTY},
    {"fldedit", CONTROL_FLAG, RTF_FLDEDIT},
    {"fldinst", CONTROL_DESTINATION, RTF_FLDINST},
    {"fldlock", CONTROL_FLAG, RTF_FLDLOCK},
    {"fldpriv", CONTROL_FLAG, RTF_FLDPRIV},
    {"fldrslt", CONTROL_DESTINATION, RTF_FLDRSLT},
    {"fldtype", CONTROL_DESTINATION, RTF_FLDTYPE},
    {"flomajor", CONTROL_FLAG, RTF_FLOMAJOR},
    {"flominor", CONTROL_FLAG, RTF_FLOMINOR},
    {"fmodern", CONTROL_FLAG, RTF_FMODERN},
    {"fn", CONTROL_VALUE, RTF_FN},
    {"fname", CONTROL_DESTINATION, RTF_FNAME},
    {"fnetwork", CONTROL_FLAG, RTF_FNETWORK},
    {"fnil", CONTROL_FLAG, RTF_FNIL},
    {"fnonfilesys", CONTROL_FLAG, RTF_FNONFILESYS},
    {"fontemb", CONTROL_DESTINATION, RTF_FONTEMB},
    {"fontfile", CONTROL_DESTINATION, RTF_FONTFILE},
    {"fonttbl", CONTROL_DESTINATION, RTF_FONTTBL},
    {"footer", CONTROL_DESTINATION, RTF_FOOTER},
    {"footerf", CONTROL_DESTINATION, RTF_FOOTERF},
    {"footerl", CONTROL_DESTINATION, RTF_FOOTERL},
    {"footerr", CONTROL_DESTINATION, RTF_FOOTERR},
    {"footery", CONTROL_VALUE, RTF_FOOTERY},
    {"footnote", CONTROL_DESTINATION, RTF_FOOTNOTE},
    {"forceupgrade", CONTROL_FLAG, RTF_FORCEUPGRADE},
    {"formdisp", CONTROL_FLAG, RTF_FORMDISP},
    {"formfield", CONTROL_DESTINATION, RTF_FORMFIELD},
    {"formprot", CONTROL_FLAG, RTF_FORMPROT},
    {"formshade", CONTROL_FLAG, RTF_FORMSHADE},
    {"fosnum", CONTROL_VALUE, RTF_FOSNUM},
    {"fprq", CONTROL_VALUE, RTF_FPRQ},
    {"fracwidth", CONTROL_FLAG, RTF_FRACWIDTH},
    {"frelative", CONTROL_VALUE, RTF_FRELATIVE},
    {"frmtxbtlr", CONTROL_FLAG, RTF_FRMTXBTLR},
    {"frmtxlrtb", CONTROL_FLAG, RTF_FRMTXLRTB},
    {"frmtxlrtbv", CONTROL_FLAG, RTF_FRMTXLRTBV},
    {"frmtxtbrl", CONTROL_FLAG, RTF_FRMTXTBRL},
    {"frmtxtbrlv", CONTROL_FLAG, RTF_FRMTXTBRLV},
    {"froman", CONTROL_FLAG, RTF_FROMAN},
    {"fromhtml", CONTROL_VALUE, RTF_FROMHTML},
    {"fromtext", CONTROL_FLAG, RTF_FROMTEXT},
    {"fs", CONTROL_VALUE, RTF_FS},
    {"fscript", CONTROL_FLAG, RTF_FSCRIPT},
    {"fswiss", CONTROL_FLAG, RTF_FSWISS},
    {"ftech", CONTROL_FLAG, RTF_FTECH},
    {"ftnalt", CONTROL_FLAG, RTF_FTNALT},
    {"ftnbj", CONTROL_FLAG, RTF_FTNBJ},
    {"ftncn", CONTROL_DESTINATION, RTF_FTNCN},
    {"ftnil", CONTROL_FLAG, RTF_FTNIL},
    {"ftnlytwnine", CONTROL_FLAG, RTF_FTNLYTWNINE},
    {"ftnnalc", CONTROL_FLAG, RTF_FTNNALC},
    {"ftnnar", CONTROL_FLAG, RTF_FTNNAR},
    {"ftnnauc", CONTROL_FLAG, RTF_FTNNAUC},
    {"ftnnchi", CONTROL_FLAG, RTF_FTNNCHI},
    {"ftnnchosung", CONTROL_FLAG, RTF_FTNNCHOSUNG},
    {"ftnncnum", CONTROL_FLAG, RTF_FTNNCNUM},
    {"ftnndbar", CONTROL_FLAG, RTF_FTNNDBAR},
    {"ftnndbnum", CONTROL_FLAG, RTF_FTNNDBNUM},
    {"ftnndbnumd", CONTROL_FLAG, RTF_FTNNDBNUMD},
    {"ftnndbnumk", CONTROL_FLAG, RTF_FTNNDBNUMK},
    {"ftnndbnumt", CONTROL_FLAG, RTF_FTNNDBNUMT},
    {"ftnnganada", CONTROL_FLAG, RTF_FTNNGANADA},
    {"ftnngbnum", CONTROL_FLAG, RTF_FTNNGBNUM},
    {"ftnngbnumd", CONTROL_FLAG, RTF_FTNNGBNUMD},
    {"ftnngbnumk", CONTROL_FLAG, RTF_FTNNGBNUMK},
    {"ftnngbnuml", CONTROL_FLAG, RTF_FTNNGBNUML},
    {"ftnnrlc", CONTROL_FLAG, RTF_FTNNRLC},
    {"ftnnruc", CONTROL_FLAG, RTF_FTNNRUC},
    {"ftnnzodiac", CONTROL_FLAG, RTF_FTNNZODIAC},
    {"ftnnzodiacd", CONTROL_FLAG, RTF_FTNNZODIACD},
    {"ftnnzodiacl", CONTROL_FLAG, RTF_FTNNZODIACL},
    {"ftnrestart", CONTROL_FLAG, RTF_FTNRESTART},
    {"ftnrstcont", CONTROL_FLAG, RTF_FTNRSTCONT},
    {"ftnrstpg", CONTROL_FLAG, RTF_FTNRSTPG},
    {"ftnsep", CONTROL_DESTINATION, RTF_FTNSEP},
    {"ftnsepc", CONTROL_DESTINATION, RTF_FTNSEPC},
    {"ftnstart", CONTROL_VALUE, RTF_FTNSTART},
    {"ftntj", CONTROL_FLAG, RTF_FTNTJ},
    {"fttruetype", CONTROL_FLAG, RTF_FTTRUETYPE},
    {"fvaliddos", CONTROL_FLAG, RTF_FVALIDDOS},
    {"fvalidhpfs", CONTROL_FLAG, RTF_FVALIDHPFS},
    {"fvalidmac", CONTROL_FLAG, RTF_FVALIDMAC},
    {"fvalidntfs", CONTROL_FLAG, RTF_FVALIDNTFS},
    {"g", CONTROL_DESTINATION, RTF_G},
    {"gcw", CONTROL_VALUE, RTF_GCW},
    {"generator", CONTROL_DESTINATION, RTF_GENERATOR},
    {"green", CONTROL_VALUE, RTF_GREEN},
    {"grfdocevents", CONTROL_VALUE, RTF_GRFDOCEVENTS},
    {"gridtbl", CONTROL_DESTINATION, RTF_GRIDTBL},
    {"gutter", CONTROL_VALUE, RTF_GUTTER},
    {"gutterprl", CONTROL_FLAG, RTF_GUTTERPRL},
    {"guttersxn", CONTROL_VALUE, RTF_GUTTERSXN},
    {"header", CONTROL_DESTINATION, RTF_HEADER},
    {"headerf", CONTROL_DESTINATION, RTF_HEADERF},
    {"headerl", CONTROL_DESTINATION, RTF_HEADERL},
    {"headerr", CONTROL_DESTINATION, RTF_HEADERR},
    {"headery", CONTROL_VALUE, RTF_HEADERY},
    {"hich", CONTROL_FLAG, RTF_HICH},
    {"highlight", CONTROL_VALUE, RTF_HIGHLIGHT},
    {"hl", CONTROL_DESTINATION, RTF_HL},
    {"hlfr", CONTROL_DESTINATION, RTF_HLFR},
    {"hlinkbase", CONTROL_DESTINATION, RTF_HLINKBASE},
    {"hlloc", CONTROL_DESTINATION, RTF_HLLOC},
    {"hlsrc", CONTROL_DESTINATION, RTF_HLSRC},
    {"horzdoc", CONTROL_FLAG, RTF_HORZDOC},
    {"horzsect", CONTROL_FLAG, RTF_HORZSECT},
    {"horzvert", CONTROL_VALUE, RTF_HORZVERT},
    {"hr", CONTROL_VALUE, RTF_HR},
    {"hres", CONTROL_VALUE, RTF_HRES},
    {"hrule", CONTROL_FLAG, RTF_HRULE},
    {"hsv", CONTROL_DESTINATION, RTF_HSV},
    {"htmautsp", CONTROL_FLAG, RTF_HTMAUTSP},
    {"htmlbase", CONTROL_FLAG, RTF_HTMLBASE},
    {"htmlrtf", CONTROL_TOGGLE, RTF_HTMLRTF},
    {"htmltag", CONTROL_DESTINATION, RTF_HTMLTAG},
    {"hwelev", CONTROL_FLAG, RTF_HWELEV},
    {"hyphauto", CONTROL_TOGGLE, RTF_HYPHAUTO},
    {"hyphcaps", CONTROL_TOGGLE, RTF_HYPHCAPS},
    {"hyphconsec", CONTROL_VALUE, RTF_HYPHCONSEC},
    {"hyphhotz", CONTROL_VALUE, RTF_HYPHHOTZ},
    {"hyphpar", CONTROL_TOGGLE, RTF_HYPHPAR},
    {"i", CONTROL_TOGGLE, RTF_I},
    {"id", CONTROL_VALUE, RTF_ID},
    {"ignoremixedcontent", CONTROL_VALUE, RTF_IGNOREMIXEDCONTENT},
    {"ilfomacatclnup", CONTROL_VALUE, RTF_ILFOMACATCLNUP},
    {"ilvl", CONTROL_VALUE, RTF_ILVL},
    {"impr", CONTROL_TOGGLE, RTF_IMPR},
    {"indmirror", CONTROL_FLAG, RTF_INDMIRROR},
    {"indrlsweleven", CONTROL_FLAG, RTF_INDRLSWELEVEN},
    {"info", CONTROL_DESTINATION, RTF_INFO},
    {"insrsid", CONTROL_VALUE, RTF_INSRSID},
    {"intbl", CONTROL_FLAG, RTF_INTBL},
    {"ipgp", CONTROL_VALUE, RTF_IPGP},
    {"irowband", CONTROL_VALUE, RTF_IROWBAND},
    {"irow", CONTROL_VALUE, RTF_IROW},
    {"itap", CONTROL_VALUE, RTF_ITAP},
    {"ixe", CONTROL_FLAG, RTF_IXE},
    {"jcompress", CONTROL_FLAG, RTF_JCOMPRESS},
    {"jexpand", CONTROL_FLAG, RTF_JEXPAND},
    {"jis", CONTROL_FLAG, RTF_JIS},
    {"jpegblip", CONTROL_FLAG, RTF_JPEGBLIP},
    {"jsksu", CONTROL_FLAG, RTF_JSKSU},
    {"keep", CONTROL_FLAG, RTF_KEEP},
    {"keepn", CONTROL_FLAG, RTF_KEEPN},
    {"kerning", CONTROL_VALUE, RTF_KERNING},
    {"keycode", CONTROL_DESTINATION, RTF_KEYCODE},
    {"keywords", CONTROL_DESTINATION, RTF_KEYWORDS},
    {"krnprsnet", CONTROL_FLAG, RTF_KRNPRSNET},
    {"ksulang", CONTROL_VALUE, RTF_KSULANG},
    {"jclisttab", CONTROL_FLAG, RTF_JCLISTTAB},
    {"landscape", CONTROL_FLAG, RTF_LANDSCAPE},
    {"lang", CONTROL_VALUE, RTF_LANG},
    {"langfe", CONTROL_VALUE, RTF_LANGFE},
    {"langfenp", CONTROL_VALUE, RTF_LANGFENP},
    {"langnp", CONTROL_VALUE, RTF_LANGNP},
    {"lastrow", CONTROL_FLAG, RTF_LASTROW},
    {"latentstyles", CONTROL_DESTINATION, RTF_LATENTSTYLES},
    {"lbr", CONTROL_VALUE, RTF_LBR},
    {"lchars", CONTROL_DESTINATION, RTF_LCHARS},
    {"ldblquote", CONTROL_SYMBOL, RTF_LDBLQUOTE},
    {"level", CONTROL_VALUE, RTF_LEVEL},
    {"levelfollow", CONTROL_VALUE, RTF_LEVELFOLLOW},
    {"levelindent", CONTROL_VALUE, RTF_LEVELINDENT},
    {"leveljc", CONTROL_VALUE, RTF_LEVELJC},
    {"leveljcn", CONTROL_VALUE, RTF_LEVELJCN},
    {"levellegal", CONTROL_VALUE, RTF_LEVELLEGAL},
    {"levelnfc", CONTROL_VALUE, RTF_LEVELNFC},
    {"levelnfcn", CONTROL_VALUE, RTF_LEVELNFCN},
    {"levelnorestart", CONTROL_VALUE, RTF_LEVELNORESTART},
    {"levelnumbers", CONTROL_DESTINATION, RTF_LEVELNUMBERS},
    {"levelold", CONTROL_VALUE, RTF_LEVELOLD},
    {"levelpicture", CONTROL_VALUE, RTF_LEVELPICTURE},
    {"levelpicturenosize", CONTROL_FLAG, RTF_LEVELPICTURENOSIZE},
    {"levelprev", CONTROL_VALUE, RTF_LEVELPREV},
    {"levelprevspace", CONTROL_VALUE, RTF_LEVELPREVSPACE},
    {"levelspace", CONTROL_VALUE, RTF_LEVELSPACE},
    {"levelstartat", CONTROL_VALUE, RTF_LEVELSTARTAT},
    {"leveltemplateid", CONTROL_VALUE, RTF_LEVELTEMPLATEID},
    {"leveltext", CONTROL_DESTINATION, RTF_LEVELTEXT},
    {"lfolevel", CONTROL_DESTINATION, RTF_LFOLEVEL},
    {"li", CONTROL_VALUE, RTF_LI},
    {"line", CONTROL_SYMBOL, RTF_LINE},
    {"linebetcol", CONTROL_FLAG, RTF_LINEBETCOL},
    {"linecont", CONTROL_FLAG, RTF_LINECONT},
    {"linemod", CONTROL_VALUE, RTF_LINEMOD},
    {"lineppage", CONTROL_FLAG, RTF_LINEPPAGE},
    {"linerestart", CONTROL_FLAG, RTF_LINERESTART},
    {"linestart", CONTROL_VALUE, RTF_LINESTART},
    {"linestarts", CONTROL_VALUE, RTF_LINESTARTS},
    {"linex", CONTROL_VALUE, RTF_LINEX},
    {"linkself", CONTROL_FLAG, RTF_LINKSELF},
    {"linkstyles", CONTROL_FLAG, RTF_LINKSTYLES},
    {"linkval", CONTROL_DESTINATION, RTF_LINKVAL},
    {"lin", CONTROL_VALUE, RTF_LIN},
    {"lisa", CONTROL_VALUE, RTF_LISA},
    {"lisb", CONTROL_VALUE, RTF_LISB},
    {"list", CONTROL_DESTINATION, RTF_LIST},
    {"listhybrid", CONTROL_FLAG, RTF_LISTHYBRID},
    {"listid", CONTROL_VALUE, RTF_LISTID},
    {"listlevel", CONTROL_DESTINATION, RTF_LISTLEVEL},
    {"listname", CONTROL_DESTINATION, RTF_LISTNAME},
    {"listoverride", CONTROL_DESTINATION, RTF_LISTOVERRIDE},
    {"listoverridecount", CONTROL_VALUE, RTF_LISTOVERRIDECOUNT},
    {"listoverrideformat", CONTROL_VALUE, RTF_LISTOVERRIDEFORMAT},
    {"listoverridestartat", CONTROL_FLAG, RTF_LISTOVERRIDESTARTAT},
    {"listoverridetable", CONTROL_DESTINATION, RTF_LISTOVERRIDETABLE},
    {"listpicture", CONTROL_DESTINATION, RTF_LISTPICTURE},
    {"listrestarthdn", CONTROL_VALUE, RTF_LISTRESTARTHDN},
    {"listsimple", CONTROL_VALUE, RTF_LISTSIMPLE},
    {"liststyleid", CONTROL_VALUE, RTF_LISTSTYLEID},
    {"liststylename", CONTROL_DESTINATION, RTF_LISTSTYLENAME},
    {"listtable", CONTROL_DESTINATION, RTF_LISTTABLE},
    {"listtemplateid", CONTROL_VALUE, RTF_LISTTEMPLATEID},
    {"listtext", CONTROL_DESTINATION, RTF_LISTTEXT},
    {"lnbrkrule", CONTROL_FLAG, RTF_LNBRKRULE},
    {"lndscpsxn", CONTROL_FLAG, RTF_LNDSCPSXN},
    {"lnongrid", CONTROL_FLAG, RTF_LNONGRID},
    {"loch", CONTROL_FLAG, RTF_LOCH},
    {"lquote", CONTROL_SYMBOL, RTF_LQUOTE},
    {"ls", CONTROL_VALUE, RTF_LS},
    {"lsdlocked", CONTROL_VALUE, RTF_LSDLOCKED},
    {"lsdlockeddef", CONTROL_VALUE, RTF_LSDLOCKEDDEF},
    {"lsdlockedexcept", CONTROL_DESTINATION, RTF_LSDLOCKEDEXCEPT},
    {"lsdpriority", CONTROL_VALUE, RTF_LSDPRIORITY},
    {"lsdprioritydef", CONTROL_VALUE, RTF_LSDPRIORITYDEF},
    {"lsdqformat", CONTROL_VALUE, RTF_LSDQFORMAT},
    {"lsdqformatdef", CONTROL_VALUE, RTF_LSDQFORMATDEF},
    {"lsdsemihidden", CONTROL_VALUE, RTF_LSDSEMIHIDDEN},
    {"lsdsemihiddendef", CONTROL_VALUE, RTF_LSDSEMIHIDDENDEF},
    {"lsdstimax", CONTROL_VALUE, RTF_LSDSTIMAX},
    {"lsdunhideused", CONTROL_VALUE, RTF_LSDUNHIDEUSED},
    {"lsdunhideuseddef", CONTROL_VALUE, RTF_LSDUNHIDEUSEDDEF},
    {"ltrch", CONTROL_FLAG, RTF_LTRCH},
    {"ltrdoc", CONTROL_FLAG, RTF_LTRDOC},
    {"ltrmark", CONTROL_SYMBOL, RTF_LTRMARK},
    {"ltrpar", CONTROL_FLAG, RTF_LTRPAR},
    {"ltrrow", CONTROL_FLAG, RTF_LTRROW},
    {"ltrsect", CONTROL_FLAG, RTF_LTRSECT},
    {"lvltentative", CONTROL_FLAG, RTF_LVLTENTATIVE},
    {"lytcalctblwd", CONTROL_FLAG, RTF_LYTCALCTBLWD},
    {"lytexcttp", CONTROL_FLAG, RTF_LYTEXCTTP},
    {"lytprtmet", CONTROL_FLAG, RTF_LYTPRTMET},
    {"lyttblrtgr", CONTROL_FLAG, RTF_LYTTBLRTGR},
    {"mac", CONTROL_FLAG, RTF_MAC},
    {"macc", CONTROL_DESTINATION, RTF_MACC},
    {"maccPr", CONTROL_DESTINATION, RTF_MACCPR},
    {"macpict", CONTROL_FLAG, RTF_MACPICT},
    {"mailmerge", CONTROL_DESTINATION, RTF_MAILMERGE},
    {"makebackup", CONTROL_FLAG, RTF_MAKEBACKUP},
    {"maln", CONTROL_DESTINATION, RTF_MALN},
    {"malnScr", CONTROL_DESTINATION, RTF_MALNSCR},
    {"manager", CONTROL_DESTINATION, RTF_MANAGER},
    {"margb", CONTROL_VALUE, RTF_MARGB},
    {"margbsxn", CONTROL_VALUE, RTF_MARGBSXN},
    {"margl", CONTROL_VALUE, RTF_MARGL},
    {"marglsxn", CONTROL_VALUE, RTF_MARGLSXN},
    {"margmirror", CONTROL_FLAG, RTF_MARGMIRROR},
    {"margmirsxn", CONTROL_FLAG, RTF_MARGMIRSXN},
    {"margPr", CONTROL_DESTINATION, RTF_MARGPR},
    {"margr", CONTROL_VALUE, RTF_MARGR},
    {"margrsxn", CONTROL_VALUE, RTF_MARGRSXN},
    {"margSz", CONTROL_VALUE, RTF_MARGSZ},
    {"margt", CONTROL_VALUE, RTF_MARGT},
    {"margtsxn", CONTROL_VALUE, RTF_MARGTSXN},
    {"mbar", CONTROL_DESTINATION, RTF_MBAR},
    {"mbarPr", CONTROL_DESTINATION, RTF_MBARPR},
    {"mbaseJc", CONTROL_DESTINATION, RTF_MBASEJC},
    {"mbegChr", CONTROL_DESTINATION, RTF_MBEGCHR},
    {"mborderBox", CONTROL_DESTINATION, RTF_MBORDERBOX},
    {"mborderBoxPr", CONTROL_DESTINATION, RTF_MBORDERBOXPR},
    {"mbox", CONTROL_DESTINATION, RTF_MBOX},
    {"mboxPr", CONTROL_DESTINATION, RTF_MBOXPR},
    {"mbrk", CONTROL_VALUE, RTF_MBRK},
    {"mbrkBin", CONTROL_VALUE, RTF_MBRKBIN},
    {"mbrkBinSub", CONTROL_VALUE, RTF_MBRKBINSUB},
    {"mcGp", CONTROL_VALUE, RTF_MCGP},
    {"mcGpRule", CONTROL_VALUE, RTF_MCGPRULE},
    {"mchr", CONTROL_DESTINATION, RTF_MCHR},
    {"mcount", CONTROL_DESTINATION, RTF_MCOUNT},
    {"mcSp", CONTROL_VALUE, RTF_MCSP},
    {"mctrlPr", CONTROL_DESTINATION, RTF_MCTRLPR},
    {"md", CONTROL_DESTINATION, RTF_MD},
    {"mdefJc", CONTROL_VALUE, RTF_MDEFJC},
    {"mdeg", CONTROL_DESTINATION, RTF_MDEG},
    {"mdegHide", CONTROL_DESTINATION, RTF_MDEGHIDE},
    {"mden", CONTROL_DESTINATION, RTF_MDEN},
    {"mdiff", CONTROL_DESTINATION, RTF_MDIFF},
    {"mdiffSty", CONTROL_VALUE, RTF_MDIFFSTY},
    {"mdispdef", CONTROL_VALUE, RTF_MDISPDEF},
    {"mdPr", CONTROL_DESTINATION, RTF_MDPR},
    {"me", CONTROL_DESTINATION, RTF_ME},
    {"mendChr", CONTROL_DESTINATION, RTF_MENDCHR},
    {"meqArr", CONTROL_DESTINATION, RTF_MEQARR},
    {"meqArrPr", CONTROL_DESTINATION, RTF_MEQARRPR},
    {"mf", CONTROL_DESTINATION, RTF_MF},
    {"mfName", CONTROL_DESTINATION, RTF_MFNAME},
    {"mfPr", CONTROL_DESTINATION, RTF_MFPR},
    {"mfunc", CONTROL_DESTINATION, RTF_MFUNC},
    {"mfuncPr", CONTROL_DESTINATION, RTF_MFUNCPR},
    {"mgroupChr", CONTROL_DESTINATION, RTF_MGROUPCHR},
    {"mgroupChrPr", CONTROL_DESTINATION, RTF_MGROUPCHRPR},
    {"mgrow", CONTROL_DESTINATION, RTF_MGROW},
    {"mhideBot", CONTROL_DESTINATION, RTF_MHIDEBOT},
    {"mhideLeft", CONTROL_DESTINATION, RTF_MHIDELEFT},
    {"mhideRight", CONTROL_DESTINATION, RTF_MHIDERIGHT},
    {"mhideTop", CONTROL_DESTINATION, RTF_MHIDETOP},
    {"mhtmltag", CONTROL_DESTINATION, RTF_MHTMLTAG},
    {"min", CONTROL_VALUE, RTF_MIN},
    {"minterSp", CONTROL_VALUE, RTF_MINTERSP},
    {"mintLim", CONTROL_VALUE, RTF_MINTLIM},
    {"mintraSp", CONTROL_VALUE, RTF_MINTRASP},
    {"mjc", CONTROL_VALUE, RTF_MJC},
    {"mlim", CONTROL_DESTINATION, RTF_MLIM},
    {"mlimloc", CONTROL_DESTINATION, RTF_MLIMLOC},
    {"mlimLoc", CONTROL_DESTINATION, RTF_MLIMLOC},
    {"mlimlow", CONTROL_DESTINATION, RTF_MLIMLOW},
    {"mlimLow", CONTROL_DESTINATION, RTF_MLIMLOW},
    {"mlimlowPr", CONTROL_DESTINATION, RTF_MLIMLOWPR},
    {"mlimLowPr", CONTROL_DESTINATION, RTF_MLIMLOWPR},
    {"mlimupp", CONTROL_DESTINATION, RTF_MLIMUPP},
    {"mlimUpp", CONTROL_DESTINATION, RTF_MLIMUPP},
    {"mlimuppPr", CONTROL_DESTINATION, RTF_MLIMUPPPR},
    {"mlimUppPr", CONTROL_DESTINATION, RTF_MLIMUPPPR},
    {"mlit", CONTROL_FLAG, RTF_MLIT},
    {"mlMargin", CONTROL_VALUE, RTF_MLMARGIN},
    {"mm", CONTROL_DESTINATION, RTF_MM},
    {"mmaddfieldname", CONTROL_DESTINATION, RTF_MMADDFIELDNAME},
    {"mmath", CONTROL_DESTINATION, RTF_MMATH},
    {"mmathFont", CONTROL_VALUE, RTF_MMATHFONT},
    {"mmathPict", CONTROL_DESTINATION, RTF_MMATHPICT},
    {"mmathPr", CONTROL_DESTINATION, RTF_MMATHPR},
    {"mmattach", CONTROL_FLAG, RTF_MMATTACH},
    {"mmaxdist", CONTROL_DESTINATION, RTF_MMAXDIST},
    {"mmblanklines", CONTROL_FLAG, RTF_MMBLANKLINES},
    {"mmc", CONTROL_DESTINATION, RTF_MMC},
    {"mmcJc", CONTROL_DESTINATION, RTF_MMCJC},
    {"mmconnectstr", CONTROL_DESTINATION, RTF_MMCONNECTSTR},
    {"mmconnectstrdata", CONTROL_DESTINATION, RTF_MMCONNECTSTRDATA},
    {"mmcPr", CONTROL_DESTINATION, RTF_MMCPR},
    {"mmcs", CONTROL_DESTINATION, RTF_MMCS},
    {"mmdatasource", CONTROL_DESTINATION, RTF_MMDATASOURCE},
    {"mmdatatypeaccess", CONTROL_FLAG, RTF_MMDATATYPEACCESS},
    {"mmdatatypeexcel", CONTROL_FLAG, RTF_MMDATATYPEEXCEL},
    {"mmdatatypefile", CONTROL_FLAG, RTF_MMDATATYPEFILE},
    {"mmdatatypeodbc", CONTROL_FLAG, RTF_MMDATATYPEODBC},
    {"mmdatatypeodso", CONTROL_FLAG, RTF_MMDATATYPEODSO},
    {"mmdatatypeqt", CONTROL_FLAG, RTF_MMDATATYPEQT},
    {"mmdefaultsql", CONTROL_FLAG, RTF_MMDEFAULTSQL},
    {"mmdestemail", CONTROL_FLAG, RTF_MMDESTEMAIL},
    {"mmdestfax", CONTROL_FLAG, RTF_MMDESTFAX},
    {"mmdestnewdoc", CONTROL_FLAG, RTF_MMDESTNEWDOC},
    {"mmdestprinter", CONTROL_FLAG, RTF_MMDESTPRINTER},
    {"mmerrors", CONTROL_VALUE, RTF_MMERRORS},
    {"mmfttypeaddress", CONTROL_FLAG, RTF_MMFTTYPEADDRESS},
    {"mmfttypebarcode", CONTROL_FLAG, RTF_MMFTTYPEBARCODE},
    {"mmfttypedbcolumn", CONTROL_FLAG, RTF_MMFTTYPEDBCOLUMN},
    {"mmfttypemapped", CONTROL_FLAG, RTF_MMFTTYPEMAPPED},
    {"mmfttypenull", CONTROL_FLAG, RTF_MMFTTYPENULL},
    {"mmfttypesalutation", CONTROL_FLAG, RTF_MMFTTYPESALUTATION},
    {"mmheadersource", CONTROL_DESTINATION, RTF_MMHEADERSOURCE},
    {"mmjdsotype", CONTROL_VALUE, RTF_MMJDSOTYPE},
    {"mmlinktoquery", CONTROL_FLAG, RTF_MMLINKTOQUERY},
    {"mmmailsubject", CONTROL_DESTINATION, RTF_MMMAILSUBJECT},
    {"mmmaintypecatalog", CONTROL_FLAG, RTF_MMMAINTYPECATALOG},
    {"mmmaintypeemail", CONTROL_FLAG, RTF_MMMAINTYPEEMAIL},
    {"mmmaintypeenvelopes", CONTROL_FLAG, RTF_MMMAINTYPEENVELOPES},
    {"mmmaintypefax", CONTROL_FLAG, RTF_MMMAINTYPEFAX},
    {"mmmaintypelabels", CONTROL_FLAG, RTF_MMMAINTYPELABELS},
    {"mmmaintypeletters", CONTROL_FLAG, RTF_MMMAINTYPELETTERS},
    {"mmodso", CONTROL_DESTINATION, RTF_MMODSO},
    {"mmodsoactive", CONTROL_VALUE, RTF_MMODSOACTIVE},
    {"mmodsocoldelim", CONTROL_VALUE, RTF_MMODSOCOLDELIM},
    {"mmodsocolumn", CONTROL_VALUE, RTF_MMODSOCOLUMN},
    {"mmodsodynaddr", CONTROL_VALUE, RTF_MMODSODYNADDR},
    {"mmodsofhdr", CONTROL_VALUE, RTF_MMODSOFHDR},
    {"mmodsofilter", CONTROL_DESTINATION, RTF_MMODSOFILTER},
    {"mmodsofldmpdata", CONTROL_DESTINATION, RTF_MMODSOFLDMPDATA},
    {"mmodsofmcolumn", CONTROL_VALUE, RTF_MMODSOFMCOLUMN},
    {"mmodsohash", CONTROL_VALUE, RTF_MMODSOHASH},
    {"mmodsolid", CONTROL_VALUE, RTF_MMODSOLID},
    {"mmodsomappedname", CONTROL_DESTINATION, RTF_MMODSOMAPPEDNAME},
    {"mmodsoname", CONTROL_DESTINATION, RTF_MMODSONAME},
    {"mmodsorecipdata", CONTROL_DESTINATION, RTF_MMODSORECIPDATA},
    {"mmodsosort", CONTROL_DESTINATION, RTF_MMODSOSORT},
    {"mmodsosrc", CONTROL_DESTINATION, RTF_MMODSOSRC},
    {"mmodsotable", CONTROL_DESTINATION, RTF_MMODSOTABLE},
    {"mmodsoudl", CONTROL_DESTINATION, RTF_MMODSOUDL},
    {"mmodsoudldata", CONTROL_DESTINATION, RTF_MMODSOUDLDATA},
    {"mmodsouniquetag", CONTROL_DESTINATION, RTF_MMODSOUNIQUETAG},
    {"mmPr", CONTROL_DESTINATION, RTF_MMPR},
    {"mmquery", CONTROL_DESTINATION, RTF_MMQUERY},
    {"mmr", CONTROL_DESTINATION, RTF_MMR},
    {"mmreccur", CONTROL_VALUE, RTF_MMRECCUR},
    {"mmshowdata", CONTROL_FLAG, RTF_MMSHOWDATA},
    {"mnary", CONTROL_DESTINATION, RTF_MNARY},
    {"mnaryLim", CONTROL_VALUE, RTF_MNARYLIM},
    {"mnaryPr", CONTROL_DESTINATION, RTF_MNARYPR},
    {"mnoBreak", CONTROL_DESTINATION, RTF_MNOBREAK},
    {"mnor", CONTROL_FLAG, RTF_MNOR},
    {"mnum", CONTROL_DESTINATION, RTF_MNUM},
    {"mo", CONTROL_VALUE, RTF_MO},
    {"mobjDist", CONTROL_DESTINATION, RTF_MOBJDIST},
    {"moMath", CONTROL_DESTINATION, RTF_MOMATH},
    {"moMathPara", CONTROL_DESTINATION, RTF_MOMATHPARA},
    {"moMathParaPr", CONTROL_DESTINATION, RTF_MOMATHPARAPR},
    {"mopEmu", CONTROL_DESTINATION, RTF_MOPEMU},
    {"mphant", CONTROL_DESTINATION, RTF_MPHANT},
    {"mphantPr", CONTROL_DESTINATION, RTF_MPHANTPR},
    {"mplcHide", CONTROL_DESTINATION, RTF_MPLCHIDE},
    {"mpos", CONTROL_DESTINATION, RTF_MPOS},
    {"mpostSp", CONTROL_VALUE, RTF_MPOSTSP},
    {"mpreSp", CONTROL_VALUE, RTF_MPRESP},
    {"mr", CONTROL_DESTINATION, RTF_MR},
    {"mrad", CONTROL_DESTINATION, RTF_MRAD},
    {"mradPr", CONTROL_DESTINATION, RTF_MRADPR},
    {"mrMargin", CONTROL_VALUE, RTF_MRMARGIN},
    {"mrPr", CONTROL_DESTINATION, RTF_MRPR},
    {"mrSp", CONTROL_VALUE, RTF_MRSP},
    {"mrSpRule", CONTROL_VALUE, RTF_MRSPRULE},
    {"mscr", CONTROL_VALUE, RTF_MSCR},
    {"msepChr", CONTROL_DESTINATION, RTF_MSEPCHR},
    {"mshow", CONTROL_DESTINATION, RTF_MSHOW},
    {"mshp", CONTROL_DESTINATION, RTF_MSHP},
    {"msmallFrac", CONTROL_VALUE, RTF_MSMALLFRAC},
    {"msmcap", CONTROL_FLAG, RTF_MSMCAP},
    {"msPre", CONTROL_DESTINATION, RTF_MSPRE},
    {"msPrePr", CONTROL_DESTINATION, RTF_MSPREPR},
    {"msSub", CONTROL_DESTINATION, RTF_MSSUB},
    {"msSubPr", CONTROL_DESTINATION, RTF_MSSUBPR},
    {"msSubSup", CONTROL_DESTINATION, RTF_MSSUBSUP},
    {"msSubSupPr", CONTROL_DESTINATION, RTF_MSSUBSUPPR},
    {"msSup", CONTROL_DESTINATION, RTF_MSSUP},
    {"msSupPr", CONTROL_DESTINATION, RTF_MSSUPPR},
    {"mstrikeBLTR", CONTROL_DESTINATION, RTF_MSTRIKEBLTR},
    {"mstrikeH", CONTROL_DESTINATION, RTF_MSTRIKEH},
    {"mstrikeTLBR", CONTROL_DESTINATION, RTF_MSTRIKETLBR},
    {"mstrikeV", CONTROL_DESTINATION, RTF_MSTRIKEV},
    {"msty", CONTROL_VALUE, RTF_MSTY},
    {"msub", CONTROL_DESTINATION, RTF_MSUB},
    {"msubHide", CONTROL_DESTINATION, RTF_MSUBHIDE},
    {"msup", CONTROL_DESTINATION, RTF_MSUP},
    {"msupHide", CONTROL_DESTINATION, RTF_MSUPHIDE},
    {"mtransp", CONTROL_DESTINATION, RTF_MTRANSP},
    {"mtype", CONTROL_DESTINATION, RTF_MTYPE},
    {"muser", CONTROL_FLAG, RTF_MUSER},
    {"mvauth", CONTROL_VALUE, RTF_MVAUTH},
    {"mvdate", CONTROL_VALUE, RTF_MVDATE},
    {"mvertJc", CONTROL_DESTINATION, RTF_MVERTJC},
    {"mvf", CONTROL_FLAG, RTF_MVF},
    {"mvfmf", CONTROL_DESTINATION, RTF_MVFMF},
    {"mvfml", CONTROL_DESTINATION, RTF_MVFML},
    {"mvt", CONTROL_FLAG, RTF_MVT},
    {"mvtof", CONTROL_DESTINATION, RTF_MVTOF},
    {"mvtol", CONTROL_DESTINATION, RTF_MVTOL},
    {"mwrapIndent", CONTROL_VALUE, RTF_MWRAPINDENT},
    {"mwrapRight", CONTROL_VALUE, RTF_MWRAPRIGHT},
    {"mzeroAsc", CONTROL_DESTINATION, RTF_MZEROASC},
    {"mzeroDesc", CONTROL_DESTINATION, RTF_MZERODESC},
    {"mzeroWid", CONTROL_DESTINATION, RTF_MZEROWID},
    {"nestcell", CONTROL_SYMBOL, RTF_NESTCELL},
    {"nestrow", CONTROL_SYMBOL, RTF_NESTROW},
    {"nesttableprops", CONTROL_DESTINATION, RTF_NESTTABLEPROPS},
    {"newtblstyruls", CONTROL_FLAG, RTF_NEWTBLSTYRULS},
    {"nextfile", CONTROL_DESTINATION, RTF_NEXTFILE},
    {"noafcnsttbl", CONTROL_FLAG, RTF_NOAFCNSTTBL},
    {"nobrkwrptbl", CONTROL_FLAG, RTF_NOBRKWRPTBL},
    {"nocolbal", CONTROL_FLAG, RTF_NOCOLBAL},
    {"nocompatoptions", CONTROL_FLAG, RTF_NOCOMPATOPTIONS},
    {"nocwrap", CONTROL_FLAG, RTF_NOCWRAP},
    {"nocxsptable", CONTROL_FLAG, RTF_NOCXSPTABLE},
    {"noextrasprl", CONTROL_FLAG, RTF_NOEXTRASPRL},
    {"nofchars", CONTROL_VALUE, RTF_NOFCHARS},
    {"nofcharsws", CONTROL_VALUE, RTF_NOFCHARSWS},
    {"nofeaturethrottle", CONTROL_FLAG, RTF_NOFEATURETHROTTLE},
    {"nofpages", CONTROL_VALUE, RTF_NOFPAGES},
    {"nofwords", CONTROL_VALUE, RTF_NOFWORDS},
    {"nogrowautofit", CONTROL_FLAG, RTF_NOGROWAUTOFIT},
    {"noindnmbrts", CONTROL_FLAG, RTF_NOINDNMBRTS},
    {"nojkernpunct", CONTROL_FLAG, RTF_NOJKERNPUNCT},
    {"nolead", CONTROL_FLAG, RTF_NOLEAD},
    {"noline", CONTROL_FLAG, RTF_NOLINE},
    {"nolnhtadjtbl", CONTROL_FLAG, RTF_NOLNHTADJTBL},
    {"nonesttables", CONTROL_DESTINATION, RTF_NONESTTABLES},
    {"nonshppict", CONTROL_FLAG, RTF_NONSHPPICT},
    {"nooverflow", CONTROL_FLAG, RTF_NOOVERFLOW},
    {"noproof", CONTROL_FLAG, RTF_NOPROOF},
    {"noqfpromote", CONTROL_FLAG, RTF_NOQFPROMOTE},
    {"nosectexpand", CONTROL_FLAG, RTF_NOSECTEXPAND},
    {"nosnaplinegrid", CONTROL_FLAG, RTF_NOSNAPLINEGRID},
    {"nospaceforul", CONTROL_FLAG, RTF_NOSPACEFORUL},
    {"nosupersub", CONTROL_FLAG, RTF_NOSUPERSUB},
    {"notabind", CONTROL_FLAG, RTF_NOTABIND},
    {"notbrkcnstfrctbl", CONTROL_FLAG, RTF_NOTBRKCNSTFRCTBL},
    {"notcvasp", CONTROL_FLAG, RTF_NOTCVASP},
    {"notvatxbx", CONTROL_FLAG, RTF_NOTVATXBX},
    {"nouicompat", CONTROL_FLAG, RTF_NOUICOMPAT},
    {"noultrlspc", CONTROL_FLAG, RTF_NOULTRLSPC},
    {"nowidctlpar", CONTROL_FLAG, RTF_NOWIDCTLPAR},
    {"nowrap", CONTROL_FLAG, RTF_NOWRAP},
    {"nowwrap", CONTROL_FLAG, RTF_NOWWRAP},
    {"noxlattoyen", CONTROL_FLAG, RTF_NOXLATTOYEN},
    {"objalias", CONTROL_DESTINATION, RTF_OBJALIAS},
    {"objalign", CONTROL_VALUE, RTF_OBJALIGN},
    {"objattph", CONTROL_FLAG, RTF_OBJATTPH},
    {"objautlink", CONTROL_FLAG, RTF_OBJAUTLINK},
    {"objclass", CONTROL_DESTINATION, RTF_OBJCLASS},
    {"objcropb", CONTROL_VALUE, RTF_OBJCROPB},
    {"objcropl", CONTROL_VALUE, RTF_OBJCROPL},
    {"objcropr", CONTROL_VALUE, RTF_OBJCROPR},
    {"objcropt", CONTROL_VALUE, RTF_OBJCROPT},
    {"objdata", CONTROL_DESTINATION, RTF_OBJDATA},
    {"object", CONTROL_DESTINATION, RTF_OBJECT},
    {"objemb", CONTROL_FLAG, RTF_OBJEMB},
    {"objh", CONTROL_VALUE, RTF_OBJH},
    {"objhtml", CONTROL_FLAG, RTF_OBJHTML},
    {"objicemb", CONTROL_FLAG, RTF_OBJICEMB},
    {"objlink", CONTROL_FLAG, RTF_OBJLINK},
    {"objlock", CONTROL_FLAG, RTF_OBJLOCK},
    {"objname", CONTROL_DESTINATION, RTF_OBJNAME},
    {"objocx", CONTROL_FLAG, RTF_OBJOCX},
    {"objpub", CONTROL_FLAG, RTF_OBJPUB},
    {"objscalex", CONTROL_VALUE, RTF_OBJSCALEX},
    {"objscaley", CONTROL_VALUE, RTF_OBJSCALEY},
    {"objsect", CONTROL_DESTINATION, RTF_OBJSECT},
    {"objsetsize", CONTROL_FLAG, RTF_OBJSETSIZE},
    {"objsub", CONTROL_FLAG, RTF_OBJSUB},
    {"objtime", CONTROL_DESTINATION, RTF_OBJTIME},
    {"objtransy", CONTROL_VALUE, RTF_OBJTRANSY},
    {"objupdate", CONTROL_FLAG, RTF_OBJUPDATE},
    {"objw", CONTROL_VALUE, RTF_OBJW},
    {"ogutter", CONTROL_VALUE, RTF_OGUTTER},
    {"oldas", CONTROL_FLAG, RTF_OLDAS},
    {"oldcprops", CONTROL_DESTINATION, RTF_OLDCPROPS},
    {"oldlinewrap", CONTROL_FLAG, RTF_OLDLINEWRAP},
    {"oldpprops", CONTROL_DESTINATION, RTF_OLDPPROPS},
    {"oldsprops", CONTROL_DESTINATION, RTF_OLDSPROPS},
    {"oldtprops", CONTROL_DESTINATION, RTF_OLDTPROPS},
    {"oleclsid", CONTROL_DESTINATION, RTF_OLECLSID},
    {"operator", CONTROL_DESTINATION, RTF_OPERATOR},
    {"otblrul", CONTROL_FLAG, RTF_OTBLRUL},
    {"outl", CONTROL_TOGGLE, RTF_OUTL},
    {"outlinelevel", CONTROL_VALUE, RTF_OUTLINELEVEL},
    {"overlay", CONTROL_FLAG, RTF_OVERLAY},
    {"page", CONTROL_SYMBOL, RTF_PAGE},
    {"pagebb", CONTROL_FLAG, RTF_PAGEBB},
    {"panose", CONTROL_DESTINATION, RTF_PANOSE},
    {"paperh", CONTROL_VALUE, RTF_PAPERH},
    {"paperw", CONTROL_VALUE, RTF_PAPERW},
    {"par", CONTROL_SYMBOL, RTF_PAR},
    {"pararsid", CONTROL_VALUE, RTF_PARARSID},
    {"pard", CONTROL_FLAG, RTF_PARD},
    {"password", CONTROL_DESTINATION, RTF_PASSWORD},
    {"passwordhash", CONTROL_DESTINATION, RTF_PASSWORDHASH},
    {"pc", CONTROL_FLAG, RTF_PC},
    {"pca", CONTROL_FLAG, RTF_PCA},
    {"pgbrdrb", CONTROL_FLAG, RTF_PGBRDRB},
    {"pgbrdrfoot", CONTROL_FLAG, RTF_PGBRDRFOOT},
    {"pgbrdrhead", CONTROL_FLAG, RTF_PGBRDRHEAD},
    {"pgbrdrl", CONTROL_FLAG, RTF_PGBRDRL},
    {"pgbrdropt", CONTROL_VALUE, RTF_PGBRDROPT},
    {"pgbrdrr", CONTROL_FLAG, RTF_PGBRDRR},
    {"pgbrdrsnap", CONTROL_FLAG, RTF_PGBRDRSNAP},
    {"pgbrdrt", CONTROL_FLAG, RTF_PGBRDRT},
    {"pghsxn", CONTROL_VALUE, RTF_PGHSXN},
    {"pgnbidia", CONTROL_FLAG, RTF_PGNBIDIA},
    {"pgnbidib", CONTROL_FLAG, RTF_PGNBIDIB},
    {"pgnchosung", CONTROL_FLAG, RTF_PGNCHOSUNG},
    {"pgncnum", CONTROL_FLAG, RTF_PGNCNUM},
    {"pgncont", CONTROL_FLAG, RTF_PGNCONT},
    {"pgndbnum", CONTROL_FLAG, RTF_PGNDBNUM},
    {"pgndbnumd", CONTROL_FLAG, RTF_PGNDBNUMD},
    {"pgndbnumk", CONTROL_FLAG, RTF_PGNDBNUMK},
    {"pgndbnumt", CONTROL_FLAG, RTF_PGNDBNUMT},
    {"pgndec", CONTROL_FLAG, RTF_PGNDEC},
    {"pgndecd", CONTROL_FLAG, RTF_PGNDECD},
    {"pgnganada", CONTROL_FLAG, RTF_PGNGANADA},
    {"pgngbnum", CONTROL_FLAG, RTF_PGNGBNUM},
    {"pgngbnumd", CONTROL_FLAG, RTF_PGNGBNUMD},
    {"pgngbnumk", CONTROL_FLAG, RTF_PGNGBNUMK},
    {"pgngbnuml", CONTROL_FLAG, RTF_PGNGBNUML},
    {"pgnhindia", CONTROL_FLAG, RTF_PGNHINDIA},
    {"pgnhindib", CONTROL_FLAG, RTF_PGNHINDIB},
    {"pgnhindic", CONTROL_FLAG, RTF_PGNHINDIC},
    {"pgnhindid", CONTROL_FLAG, RTF_PGNHINDID},
    {"pgnhn", CONTROL_VALUE, RTF_PGNHN},
    {"pgnhnsc", CONTROL_FLAG, RTF_PGNHNSC},
    {"pgnhnsh", CONTROL_FLAG, RTF_PGNHNSH},
    {"pgnhnsm", CONTROL_FLAG, RTF_PGNHNSM},
    {"pgnhnsn", CONTROL_FLAG, RTF_PGNHNSN},
    {"pgnhnsp", CONTROL_FLAG, RTF_PGNHNSP},
    {"pgnid", CONTROL_FLAG, RTF_PGNID},
    {"pgnlcltr", CONTROL_FLAG, RTF_PGNLCLTR},
    {"pgnlcrm", CONTROL_FLAG, RTF_PGNLCRM},
    {"pgnrestart", CONTROL_FLAG, RTF_PGNRESTART},
    {"pgnstart", CONTROL_VALUE, RTF_PGNSTART},
    {"pgnstarts", CONTROL_VALUE, RTF_PGNSTARTS},
    {"pgnthaia", CONTROL_FLAG, RTF_PGNTHAIA},
    {"pgnthaib", CONTROL_FLAG, RTF_PGNTHAIB},
    {"pgnthaic", CONTROL_FLAG, RTF_PGNTHAIC},
    {"pgnucltr", CONTROL_FLAG, RTF_PGNUCLTR},
    {"pgnucrm", CONTROL_FLAG, RTF_PGNUCRM},
    {"pgnvieta", CONTROL_FLAG, RTF_PGNVIETA},
    {"pgnx", CONTROL_VALUE, RTF_PGNX},
    {"pgny", CONTROL_VALUE, RTF_PGNY},
    {"pgnzodiac", CONTROL_FLAG, RTF_PGNZODIAC},
    {"pgnzodiacd", CONTROL_FLAG, RTF_PGNZODIACD},
    {"pgnzodiacl", CONTROL_FLAG, RTF_PGNZODIACL},
    {"pgp", CONTROL_DESTINATION, RTF_PGP},
    {"pgptbl", CONTROL_DESTINATION, RTF_PGPTBL},
    {"pgwsxn", CONTROL_VALUE, RTF_PGWSXN},
    {"phcol", CONTROL_FLAG, RTF_PHCOL},
    {"phmrg", CONTROL_FLAG, RTF_PHMRG},
    {"phpg", CONTROL_FLAG, RTF_PHPG},
    {"picbmp", CONTROL_FLAG, RTF_PICBMP},
    {"picbpp", CONTROL_VALUE, RTF_PICBPP},
    {"piccropb", CONTROL_VALUE, RTF_PICCROPB},
    {"piccropl", CONTROL_VALUE, RTF_PICCROPL},
    {"piccropr", CONTROL_VALUE, RTF_PICCROPR},
    {"piccropt", CONTROL_VALUE, RTF_PICCROPT},
    {"pich", CONTROL_VALUE, RTF_PICH},
    {"pichgoal", CONTROL_VALUE, RTF_PICHGOAL},
    {"pichGoal", CONTROL_VALUE, RTF_PICHGOAL},
    {"picprop", CONTROL_DESTINATION, RTF_PICPROP},
    {"picscaled", CONTROL_FLAG, RTF_PICSCALED},
    {"picscalex", CONTROL_VALUE, RTF_PICSCALEX},
    {"picscaley", CONTROL_VALUE, RTF_PICSCALEY},
    {"pict", CONTROL_DESTINATION, RTF_PICT},
    {"picw", CONTROL_VALUE, RTF_PICW},
    {"picwgoal", CONTROL_VALUE, RTF_PICWGOAL},
    {"picwGoal", CONTROL_VALUE, RTF_PICWGOAL},
    {"pindtabqc", CONTROL_FLAG, RTF_PINDTABQC},
    {"pindtabql", CONTROL_FLAG, RTF_PINDTABQL},
    {"pindtabqr", CONTROL_FLAG, RTF_PINDTABQR},
    {"plain", CONTROL_FLAG, RTF_PLAIN},
    {"pmartabqc", CONTROL_FLAG, RTF_PMARTABQC},
    {"pmartabql", CONTROL_FLAG, RTF_PMARTABQL},
    {"pmartabqr", CONTROL_FLAG, RTF_PMARTABQR},
    {"pmmetafile", CONTROL_VALUE, RTF_PMMETAFILE},
    {"pn", CONTROL_DESTINATION, RTF_PN},
    {"pnacross", CONTROL_FLAG, RTF_PNACROSS},
    {"pnaiu", CONTROL_FLAG, RTF_PNAIU},
    {"pnaiud", CONTROL_FLAG, RTF_PNAIUD},
    {"pnaiueo", CONTROL_FLAG, RTF_PNAIUEO},
    {"pnaiueod", CONTROL_FLAG, RTF_PNAIUEOD},
    {"pnb", CONTROL_TOGGLE, RTF_PNB},
    {"pnbidia", CONTROL_FLAG, RTF_PNBIDIA},
    {"pnbidib", CONTROL_FLAG, RTF_PNBIDIB},
    {"pncaps", CONTROL_TOGGLE, RTF_PNCAPS},
    {"pncard", CONTROL_FLAG, RTF_PNCARD},
    {"pncf", CONTROL_VALUE, RTF_PNCF},
    {"pnchosung", CONTROL_FLAG, RTF_PNCHOSUNG},
    {"pncnum", CONTROL_FLAG, RTF_PNCNUM},
    {"pndbnum", CONTROL_FLAG, RTF_PNDBNUM},
    {"pndbnumd", CONTROL_FLAG, RTF_PNDBNUMD},
    {"pndbnumk", CONTROL_FLAG, RTF_PNDBNUMK},
    {"pndbnuml", CONTROL_FLAG, RTF_PNDBNUML},
    {"pndbnumt", CONTROL_FLAG, RTF_PNDBNUMT},
    {"pndec", CONTROL_FLAG, RTF_PNDEC},
    {"pndecd", CONTROL_FLAG, RTF_PNDECD},
    {"pnf", CONTROL_VALUE, RTF_PNF},
    {"pnfs", CONTROL_VALUE, RTF_PNFS},
    {"pnganada", CONTROL_FLAG, RTF_PNGANADA},
    {"pngblip", CONTROL_FLAG, RTF_PNGBLIP},
    {"pngbnum", CONTROL_FLAG, RTF_PNGBNUM},
    {"pngbnumd", CONTROL_FLAG, RTF_PNGBNUMD},
    {"pngbnumk", CONTROL_FLAG, RTF_PNGBNUMK},
    {"pngbnuml", CONTROL_FLAG, RTF_PNGBNUML},
    {"pnhang", CONTROL_FLAG, RTF_PNHANG},
    {"pni", CONTROL_TOGGLE, RTF_PNI},
    {"pnindent", CONTROL_VALUE, RTF_PNINDENT},
    {"pniroha", CONTROL_FLAG, RTF_PNIROHA},
    {"pnirohad", CONTROL_FLAG, RTF_PNIROHAD},
    {"pnlcltr", CONTROL_FLAG, RTF_PNLCLTR},
    {"pnlcrm", CONTROL_FLAG, RTF_PNLCRM},
    {"pnlvl", CONTROL_VALUE, RTF_PNLVL},
    {"pnlvlblt", CONTROL_FLAG, RTF_PNLVLBLT},
    {"pnlvlbody", CONTROL_FLAG, RTF_PNLVLBODY},
    {"pnlvlcont", CONTROL_FLAG, RTF_PNLVLCONT},
    {"pnnumonce", CONTROL_FLAG, RTF_PNNUMONCE},
    {"pnord", CONTROL_FLAG, RTF_PNORD},
    {"pnordt", CONTROL_FLAG, RTF_PNORDT},
    {"pnprev", CONTROL_FLAG, RTF_PNPREV},
    {"pnqc", CONTROL_FLAG, RTF_PNQC},
    {"pnql", CONTROL_FLAG, RTF_PNQL},
    {"pnqr", CONTROL_FLAG, RTF_PNQR},
    {"pnrauth", CONTROL_VALUE, RTF_PNRAUTH},
    {"pnrdate", CONTROL_VALUE, RTF_PNRDATE},
    {"pnrestart", CONTROL_FLAG, RTF_PNRESTART},
    {"pnrnfc", CONTROL_VALUE, RTF_PNRNFC},
    {"pnrnot", CONTROL_FLAG, RTF_PNRNOT},
    {"pnrpnbr", CONTROL_VALUE, RTF_PNRPNBR},
    {"pnrrgb", CONTROL_VALUE, RTF_PNRRGB},
    {"pnrstart", CONTROL_VALUE, RTF_PNRSTART},
    {"pnrstop", CONTROL_VALUE, RTF_PNRSTOP},
    {"pnrxst", CONTROL_VALUE, RTF_PNRXST},
    {"pnscaps", CONTROL_TOGGLE, RTF_PNSCAPS},
    {"pnseclvl", CONTROL_DESTINATION, RTF_PNSECLVL},
    {"pnsp", CONTROL_VALUE, RTF_PNSP},
    {"pnstart", CONTROL_VALUE, RTF_PNSTART},
    {"pnstrike", CONTROL_TOGGLE, RTF_PNSTRIKE},
    {"pntext", CONTROL_DESTINATION, RTF_PNTEXT},
    {"pntxta", CONTROL_DESTINATION, RTF_PNTXTA},
    {"pntxtb", CONTROL_DESTINATION, RTF_PNTXTB},
    {"pnucltr", CONTROL_FLAG, RTF_PNUCLTR},
    {"pnucrm", CONTROL_FLAG, RTF_PNUCRM},
    {"pnul", CONTROL_TOGGLE, RTF_PNUL},
    {"pnuld", CONTROL_FLAG, RTF_PNULD},
    {"pnuldash", CONTROL_FLAG, RTF_PNULDASH},
    {"pnuldashd", CONTROL_FLAG, RTF_PNULDASHD},
    {"pnuldashdd", CONTROL_FLAG, RTF_PNULDASHDD},
    {"pnuldb", CONTROL_FLAG, RTF_PNULDB},
    {"pnulhair", CONTROL_FLAG, RTF_PNULHAIR},
    {"pnulnone", CONTROL_FLAG, RTF_PNULNONE},
    {"pnulth", CONTROL_FLAG, RTF_PNULTH},
    {"pnulw", CONTROL_FLAG, RTF_PNULW},
    {"pnulwave", CONTROL_FLAG, RTF_PNULWAVE},
    {"pnzodiac", CONTROL_FLAG, RTF_PNZODIAC},
    {"pnzodiacd", CONTROL_FLAG, RTF_PNZODIACD},
    {"pnzodiacl", CONTROL_FLAG, RTF_PNZODIACL},
    {"posnegx", CONTROL_VALUE, RTF_POSNEGX},
    {"posnegy", CONTROL_VALUE, RTF_POSNEGY},
    {"posx", CONTROL_VALUE, RTF_POSX},
    {"posxc", CONTROL_FLAG, RTF_POSXC},
    {"posxi", CONTROL_FLAG, RTF_POSXI},
    {"posxl", CONTROL_FLAG, RTF_POSXL},
    {"posxo", CONTROL_FLAG, RTF_POSXO},
    {"posxr", CONTROL_FLAG, RTF_POSXR},
    {"posy", CONTROL_VALUE, RTF_POSY},
    {"posyb", CONTROL_FLAG, RTF_POSYB},
    {"posyc", CONTROL_FLAG, RTF_POSYC},
    {"posyil", CONTROL_FLAG, RTF_POSYIL},
    {"posyin", CONTROL_FLAG, RTF_POSYIN},
    {"posyout", CONTROL_FLAG, RTF_POSYOUT},
    {"posyt", CONTROL_FLAG, RTF_POSYT},
    {"prauth", CONTROL_VALUE, RTF_PRAUTH},
    {"prcolbl", CONTROL_FLAG, RTF_PRCOLBL},
    {"prdate", CONTROL_VALUE, RTF_PRDATE},
    {"printdata", CONTROL_FLAG, RTF_PRINTDATA},
    {"printim", CONTROL_DESTINATION, RTF_PRINTIM},
    {"private", CONTROL_DESTINATION, RTF_PRIVATE},
    {"propname", CONTROL_DESTINATION, RTF_PROPNAME},
    {"proptype", CONTROL_VALUE, RTF_PROPTYPE},
    {"protect", CONTROL_TOGGLE, RTF_PROTECT},
    {"protend", CONTROL_DESTINATION, RTF_PROTEND},
    {"protlevel", CONTROL_VALUE, RTF_PROTLEVEL},
    {"protstart", CONTROL_DESTINATION, RTF_PROTSTART},
    {"protusertbl", CONTROL_DESTINATION, RTF_PROTUSERTBL},
    {"psover", CONTROL_FLAG, RTF_PSOVER},
    {"psz", CONTROL_VALUE, RTF_PSZ},
    {"ptabldot", CONTROL_FLAG, RTF_PTABLDOT},
    {"ptablmdot", CONTROL_FLAG, RTF_PTABLMDOT},
    {"ptablminus", CONTROL_FLAG, RTF_PTABLMINUS},
    {"ptablnone", CONTROL_FLAG, RTF_PTABLNONE},
    {"ptabluscore", CONTROL_FLAG, RTF_PTABLUSCORE},
    {"pubauto", CONTROL_FLAG, RTF_PUBAUTO},
    {"pvmrg", CONTROL_FLAG, RTF_PVMRG},
    {"pvpara", CONTROL_FLAG, RTF_PVPARA},
    {"pvpg", CONTROL_FLAG, RTF_PVPG},
    {"pwd", CONTROL_VALUE, RTF_PWD},
    {"pxe", CONTROL_DESTINATION, RTF_PXE},
    {"qc", CONTROL_FLAG, RTF_QC},
    {"qd", CONTROL_FLAG, RTF_QD},
    {"qj", CONTROL_FLAG, RTF_QJ},
    {"qk", CONTROL_VALUE, RTF_QK},
    {"ql", CONTROL_FLAG, RTF_QL},
    {"qmspace", CONTROL_SYMBOL, RTF_QMSPACE},
    {"qr", CONTROL_FLAG, RTF_QR},
    {"qt", CONTROL_FLAG, RTF_QT},
    {"rawclbgdkbdiag", CONTROL_FLAG, RTF_RAWCLBGDKBDIAG},
    {"rawclbgbdiag", CONTROL_FLAG, RTF_RAWCLBGBDIAG},
    {"rawclbgcross", CONTROL_FLAG, RTF_RAWCLBGCROSS},
    {"rawclbgdcross", CONTROL_FLAG, RTF_RAWCLBGDCROSS},
    {"rawclbgdkcross", CONTROL_FLAG, RTF_RAWCLBGDKCROSS},
    {"rawclbgdkdcross", CONTROL_FLAG, RTF_RAWCLBGDKDCROSS},
    {"rawclbgdkfdiag", CONTROL_FLAG, RTF_RAWCLBGDKFDIAG},
    {"rawclbgdkhor", CONTROL_FLAG, RTF_RAWCLBGDKHOR},
    {"rawclbgdkvert", CONTROL_FLAG, RTF_RAWCLBGDKVERT},
    {"rawclbgfdiag", CONTROL_FLAG, RTF_RAWCLBGFDIAG},
    {"rawclbghoriz", CONTROL_FLAG, RTF_RAWCLBGHORIZ},
    {"rawclbgvert", CONTROL_FLAG, RTF_RAWCLBGVERT},
    {"rdblquote", CONTROL_SYMBOL, RTF_RDBLQUOTE},
    {"readonlyrecommended", CONTROL_FLAG, RTF_READONLYRECOMMENDED},
    {"readprot", CONTROL_FLAG, RTF_READPROT},
    {"red", CONTROL_VALUE, RTF_RED},
    {"relyonvml", CONTROL_VALUE, RTF_RELYONVML},
    {"remdttm", CONTROL_FLAG, RTF_REMDTTM},
    {"rempersonalinfo", CONTROL_FLAG, RTF_REMPERSONALINFO},
    {"result", CONTROL_DESTINATION, RTF_RESULT},
    {"revauth", CONTROL_VALUE, RTF_REVAUTH},
    {"revauthdel", CONTROL_VALUE, RTF_REVAUTHDEL},
    {"revbar", CONTROL_VALUE, RTF_REVBAR},
    {"revdttm", CONTROL_VALUE, RTF_REVDTTM},
    {"revdttmdel", CONTROL_VALUE, RTF_REVDTTMDEL},
    {"revised", CONTROL_TOGGLE, RTF_REVISED},
    {"revisions", CONTROL_FLAG, RTF_REVISIONS},
    {"revprop", CONTROL_VALUE, RTF_REVPROP},
    {"revprot", CONTROL_FLAG, RTF_REVPROT},
    {"revtbl", CONTROL_DESTINATION, RTF_REVTBL},
    {"revtim", CONTROL_DESTINATION, RTF_REVTIM},
    {"ri", CONTROL_VALUE, RTF_RI},
    {"rin", CONTROL_VALUE, RTF_RIN},
    {"row", CONTROL_SYMBOL, RTF_ROW},
    {"rquote", CONTROL_SYMBOL, RTF_RQUOTE},
    {"rsid", CONTROL_VALUE, RTF_RSID},
    {"rsidroot", CONTROL_VALUE, RTF_RSIDROOT},
    {"rsidtbl", CONTROL_DESTINATION, RTF_RSIDTBL},
    {"rsltbmp", CONTROL_FLAG, RTF_RSLTBMP},
    {"rslthtml", CONTROL_FLAG, RTF_RSLTHTML},
    {"rsltmerge", CONTROL_FLAG, RTF_RSLTMERGE},
    {"rsltpict", CONTROL_FLAG, RTF_RSLTPICT},
    {"rsltrtf", CONTROL_FLAG, RTF_RSLTRTF},
    {"rslttxt", CONTROL_FLAG, RTF_RSLTTXT},
    {"rtf", CONTROL_DESTINATION, RTF_RTF},
    {"rtlch", CONTROL_FLAG, RTF_RTLCH},
    {"rtldoc", CONTROL_FLAG, RTF_RTLDOC},
    {"rtlgutter", CONTROL_FLAG, RTF_RTLGUTTER},
    {"rtlmark", CONTROL_SYMBOL, RTF_RTLMARK},
    {"rtlpar", CONTROL_FLAG, RTF_RTLPAR},
    {"rtlrow", CONTROL_FLAG, RTF_RTLROW},
    {"rtlsect", CONTROL_FLAG, RTF_RTLSECT},
    {"rxe", CONTROL_DESTINATION, RTF_RXE},
    {"s", CONTROL_VALUE, RTF_S},
    {"sa", CONTROL_VALUE, RTF_SA},
    {"saauto", CONTROL_TOGGLE, RTF_SAAUTO},
    {"saftnnalc", CONTROL_FLAG, RTF_SAFTNNALC},
    {"saftnnar", CONTROL_FLAG, RTF_SAFTNNAR},
    {"saftnnauc", CONTROL_FLAG, RTF_SAFTNNAUC},
    {"saftnnchi", CONTROL_FLAG, RTF_SAFTNNCHI},
    {"saftnnchosung", CONTROL_FLAG, RTF_SAFTNNCHOSUNG},
    {"saftnncnum", CONTROL_FLAG, RTF_SAFTNNCNUM},
    {"saftnndbar", CONTROL_FLAG, RTF_SAFTNNDBAR},
    {"saftnndbnum", CONTROL_FLAG, RTF_SAFTNNDBNUM},
    {"saftnndbnumd", CONTROL_FLAG, RTF_SAFTNNDBNUMD},
    {"saftnndbnumk", CONTROL_FLAG, RTF_SAFTNNDBNUMK},
    {"saftnndbnumt", CONTROL_FLAG, RTF_SAFTNNDBNUMT},
    {"saftnnganada", CONTROL_FLAG, RTF_SAFTNNGANADA},
    {"saftnngbnum", CONTROL_FLAG, RTF_SAFTNNGBNUM},
    {"saftnngbnumd", CONTROL_FLAG, RTF_SAFTNNGBNUMD},
    {"saftnngbnumk", CONTROL_FLAG, RTF_SAFTNNGBNUMK},
    {"saftnngbnuml", CONTROL_FLAG, RTF_SAFTNNGBNUML},
    {"saftnnrlc", CONTROL_FLAG, RTF_SAFTNNRLC},
    {"saftnnruc", CONTROL_FLAG, RTF_SAFTNNRUC},
    {"saftnnzodiac", CONTROL_FLAG, RTF_SAFTNNZODIAC},
    {"saftnnzodiacd", CONTROL_FLAG, RTF_SAFTNNZODIACD},
    {"saftnnzodiacl", CONTROL_FLAG, RTF_SAFTNNZODIACL},
    {"saftnrestart", CONTROL_FLAG, RTF_SAFTNRESTART},
    {"saftnrstcont", CONTROL_FLAG, RTF_SAFTNRSTCONT},
    {"saftnstart", CONTROL_VALUE, RTF_SAFTNSTART},
    {"sautoupd", CONTROL_FLAG, RTF_SAUTOUPD},
    {"saveinvalidxml", CONTROL_FLAG, RTF_SAVEINVALIDXML},
    {"saveprevpict", CONTROL_FLAG, RTF_SAVEPREVPICT},
    {"sb", CONTROL_VALUE, RTF_SB},
    {"sbasedon", CONTROL_VALUE, RTF_SBASEDON},
    {"sbauto", CONTROL_TOGGLE, RTF_SBAUTO},
    {"sbkcol", CONTROL_FLAG, RTF_SBKCOL},
    {"sbkeven", CONTROL_FLAG, RTF_SBKEVEN},
    {"sbknone", CONTROL_FLAG, RTF_SBKNONE},
    {"sbkodd", CONTROL_FLAG, RTF_SBKODD},
    {"sbkpage", CONTROL_FLAG, RTF_SBKPAGE},
    {"sbys", CONTROL_FLAG, RTF_SBYS},
    {"scaps", CONTROL_TOGGLE, RTF_SCAPS},
    {"scompose", CONTROL_FLAG, RTF_SCOMPOSE},
    {"sec", CONTROL_VALUE, RTF_SEC},
    {"sect", CONTROL_SYMBOL, RTF_SECT},
    {"sectd", CONTROL_FLAG, RTF_SECTD},
    {"sectdefaultcl", CONTROL_FLAG, RTF_SECTDEFAULTCL},
    {"sectexpand", CONTROL_VALUE, RTF_SECTEXPAND},
    {"sectlinegrid", CONTROL_VALUE, RTF_SECTLINEGRID},
    {"sectnum", CONTROL_SYMBOL, RTF_SECTNUM},
    {"sectrsid", CONTROL_VALUE, RTF_SECTRSID},
    {"sectspecifycl", CONTROL_FLAG, RTF_SECTSPECIFYCL},
    {"sectspecifygenN", CONTROL_FLAG, RTF_SECTSPECIFYGENN},
    {"sectspecifyl", CONTROL_FLAG, RTF_SECTSPECIFYL},
    {"sectunlocked", CONTROL_FLAG, RTF_SECTUNLOCKED},
    {"sftnbj", CONTROL_FLAG, RTF_SFTNBJ},
    {"sftnnalc", CONTROL_FLAG, RTF_SFTNNALC},
    {"sftnnar", CONTROL_FLAG, RTF_SFTNNAR},
    {"sftnnauc", CONTROL_FLAG, RTF_SFTNNAUC},
    {"sftnnchi", CONTROL_FLAG, RTF_SFTNNCHI},
    {"sftnnchosung", CONTROL_FLAG, RTF_SFTNNCHOSUNG},
    {"sftnncnum", CONTROL_FLAG, RTF_SFTNNCNUM},
    {"sftnndbar", CONTROL_FLAG, RTF_SFTNNDBAR},
    {"sftnndbnum", CONTROL_FLAG, RTF_SFTNNDBNUM},
    {"sftnndbnumd", CONTROL_FLAG, RTF_SFTNNDBNUMD},
    {"sftnndbnumk", CONTROL_FLAG, RTF_SFTNNDBNUMK},
    {"sftnndbnumt", CONTROL_FLAG, RTF_SFTNNDBNUMT},
    {"sftnnganada", CONTROL_FLAG, RTF_SFTNNGANADA},
    {"sftnngbnum", CONTROL_FLAG, RTF_SFTNNGBNUM},
    {"sftnngbnumd", CONTROL_FLAG, RTF_SFTNNGBNUMD},
    {"sftnngbnumk", CONTROL_FLAG, RTF_SFTNNGBNUMK},
    {"sftnngbnuml", CONTROL_FLAG, RTF_SFTNNGBNUML},
    {"sftnnrlc", CONTROL_FLAG, RTF_SFTNNRLC},
    {"sftnnruc", CONTROL_FLAG, RTF_SFTNNRUC},
    {"sftnnzodiac", CONTROL_FLAG, RTF_SFTNNZODIAC},
    {"sftnnzodiacd", CONTROL_FLAG, RTF_SFTNNZODIACD},
    {"sftnnzodiacl", CONTROL_FLAG, RTF_SFTNNZODIACL},
    {"sftnrestart", CONTROL_FLAG, RTF_SFTNRESTART},
    {"sftnrstcont", CONTROL_FLAG, RTF_SFTNRSTCONT},
    {"sftnrstpg", CONTROL_FLAG, RTF_SFTNRSTPG},
    {"sftnstart", CONTROL_VALUE, RTF_SFTNSTART},
    {"sftntj", CONTROL_FLAG, RTF_SFTNTJ},
    {"shad", CONTROL_TOGGLE, RTF_SHAD},
    {"shading", CONTROL_VALUE, RTF_SHADING},
    {"shidden", CONTROL_FLAG, RTF_SHIDDEN},
    {"shift", CONTROL_FLAG, RTF_SHIFT},
    {"showplaceholdtext", CONTROL_VALUE, RTF_SHOWPLACEHOLDTEXT},
    {"showxmlerrors", CONTROL_VALUE, RTF_SHOWXMLERRORS},
    {"shp", CONTROL_DESTINATION, RTF_SHP},
    {"shpbottom", CONTROL_VALUE, RTF_SHPBOTTOM},
    {"shpbxcolumn", CONTROL_FLAG, RTF_SHPBXCOLUMN},
    {"shpbxignore", CONTROL_FLAG, RTF_SHPBXIGNORE},
    {"shpbxmargin", CONTROL_FLAG, RTF_SHPBXMARGIN},
    {"shpbxpage", CONTROL_FLAG, RTF_SHPBXPAGE},
    {"shpbyignore", CONTROL_FLAG, RTF_SHPBYIGNORE},
    {"shpbymargin", CONTROL_FLAG, RTF_SHPBYMARGIN},
    {"shpbypage", CONTROL_FLAG, RTF_SHPBYPAGE},
    {"shpbypara", CONTROL_FLAG, RTF_SHPBYPARA},
    {"shpfblwtxt", CONTROL_VALUE, RTF_SHPFBLWTXT},
    {"shpfhdr", CONTROL_VALUE, RTF_SHPFHDR},
    {"shpgrp", CONTROL_DESTINATION, RTF_SHPGRP},
    {"shpinst", CONTROL_DESTINATION, RTF_SHPINST},
    {"shpleft", CONTROL_VALUE, RTF_SHPLEFT},
    {"shplid", CONTROL_VALUE, RTF_SHPLID},
    {"shplockanchor", CONTROL_FLAG, RTF_SHPLOCKANCHOR},
    {"shppict", CONTROL_DESTINATION, RTF_SHPPICT},
    {"shpright", CONTROL_VALUE, RTF_SHPRIGHT},
    {"shprslt", CONTROL_DESTINATION, RTF_SHPRSLT},
    {"shptop", CONTROL_VALUE, RTF_SHPTOP},
    {"shptxt", CONTROL_DESTINATION, RTF_SHPTXT},
    {"shpwrk", CONTROL_VALUE, RTF_SHPWRK},
    {"shpwr", CONTROL_VALUE, RTF_SHPWR},
    {"shpz", CONTROL_VALUE, RTF_SHPZ},
    {"sl", CONTROL_VALUE, RTF_SL},
    {"slink", CONTROL_VALUE, RTF_SLINK},
    {"slmult", CONTROL_VALUE, RTF_SLMULT},
    {"slocked", CONTROL_FLAG, RTF_SLOCKED},
    {"sn", CONTROL_DESTINATION, RTF_SN},
    {"snaptogridincell", CONTROL_FLAG, RTF_SNAPTOGRIDINCELL},
    {"snext", CONTROL_VALUE, RTF_SNEXT},
    {"softcol", CONTROL_FLAG, RTF_SOFTCOL},
    {"softlheight", CONTROL_VALUE, RTF_SOFTLHEIGHT},
    {"softline", CONTROL_FLAG, RTF_SOFTLINE},
    {"softpage", CONTROL_FLAG, RTF_SOFTPAGE},
    {"sp", CONTROL_DESTINATION, RTF_SP},
    {"spersonal", CONTROL_FLAG, RTF_SPERSONAL},
    {"spltpgpar", CONTROL_FLAG, RTF_SPLTPGPAR},
    {"splytwnine", CONTROL_FLAG, RTF_SPLYTWNINE},
    {"spriority", CONTROL_VALUE, RTF_SPRIORITY},
    {"sprsbsp", CONTROL_FLAG, RTF_SPRSBSP},
    {"sprslnsp", CONTROL_FLAG, RTF_SPRSLNSP},
    {"sprsspbf", CONTROL_FLAG, RTF_SPRSSPBF},
    {"sprstsm", CONTROL_FLAG, RTF_SPRSTSM},
    {"sprstsp", CONTROL_FLAG, RTF_SPRSTSP},
    {"spv", CONTROL_FLAG, RTF_SPV},
    {"sqformat", CONTROL_FLAG, RTF_SQFORMAT},
    {"srauth", CONTROL_VALUE, RTF_SRAUTH},
    {"srdate", CONTROL_VALUE, RTF_SRDATE},
    {"sreply", CONTROL_FLAG, RTF_SREPLY},
    {"ssemihidden", CONTROL_VALUE, RTF_SSEMIHIDDEN},
    {"staticval", CONTROL_DESTINATION, RTF_STATICVAL},
    {"stextflow", CONTROL_VALUE, RTF_STEXTFLOW},
    {"strike", CONTROL_TOGGLE, RTF_STRIKE},
    {"striked", CONTROL_TOGGLE, RTF_STRIKED},
    {"stshfbi", CONTROL_VALUE, RTF_STSHFBI},
    {"stshfdbch", CONTROL_VALUE, RTF_STSHFDBCH},
    {"stshfhich", CONTROL_VALUE, RTF_STSHFHICH},
    {"stshfloch", CONTROL_VALUE, RTF_STSHFLOCH},
    {"stylelock", CONTROL_FLAG, RTF_STYLELOCK},
    {"stylelockbackcomp", CONTROL_FLAG, RTF_STYLELOCKBACKCOMP},
    {"stylelockenforced", CONTROL_FLAG, RTF_STYLELOCKENFORCED},
    {"stylelockqfset", CONTROL_FLAG, RTF_STYLELOCKQFSET},
    {"stylelocktheme", CONTROL_FLAG, RTF_STYLELOCKTHEME},
    {"stylesheet", CONTROL_DESTINATION, RTF_STYLESHEET},
    {"stylesortmethod", CONTROL_VALUE, RTF_STYLESORTMETHOD},
    {"styrsid", CONTROL_VALUE, RTF_STYRSID},
    {"sub", CONTROL_FLAG, RTF_SUB},
    {"subdocument", CONTROL_VALUE, RTF_SUBDOCUMENT},
    {"subfontbysize", CONTROL_FLAG, RTF_SUBFONTBYSIZE},
    {"subject", CONTROL_DESTINATION, RTF_SUBJECT},
    {"sunhideused", CONTROL_VALUE, RTF_SUNHIDEUSED},
    {"super", CONTROL_FLAG, RTF_SUPER},
    {"sv", CONTROL_DESTINATION, RTF_SV},
    {"svb", CONTROL_DESTINATION, RTF_SVB},
    {"swpbdr", CONTROL_FLAG, RTF_SWPBDR},
    {"tab", CONTROL_SYMBOL, RTF_TAB},
    {"tabsnoovrlp", CONTROL_FLAG, RTF_TABSNOOVRLP},
    {"taprtl", CONTROL_FLAG, RTF_TAPRTL},
    {"tb", CONTROL_VALUE, RTF_TB},
    {"tblind", CONTROL_VALUE, RTF_TBLIND},
    {"tblindtype", CONTROL_VALUE, RTF_TBLINDTYPE},
    {"tbllkbestfit", CONTROL_FLAG, RTF_TBLLKBESTFIT},
    {"tbllkborder", CONTROL_FLAG, RTF_TBLLKBORDER},
    {"tbllkcolor", CONTROL_FLAG, RTF_TBLLKCOLOR},
    {"tbllkfont", CONTROL_FLAG, RTF_TBLLKFONT},
    {"tbllkhdrcols", CONTROL_FLAG, RTF_TBLLKHDRCOLS},
    {"tbllkhdrrows", CONTROL_FLAG, RTF_TBLLKHDRROWS},
    {"tbllklastcol", CONTROL_FLAG, RTF_TBLLKLASTCOL},
    {"tbllklastrow", CONTROL_FLAG, RTF_TBLLKLASTROW},
    {"tbllknocolband", CONTROL_FLAG, RTF_TBLLKNOCOLBAND},
    {"tbllknorowband", CONTROL_FLAG, RTF_TBLLKNOROWBAND},
    {"tbllkshading", CONTROL_FLAG, RTF_TBLLKSHADING},
    {"tblrsid", CONTROL_VALUE, RTF_TBLRSID},
    {"tc", CONTROL_DESTINATION, RTF_TC},
    {"tcelld", CONTROL_FLAG, RTF_TCELLD},
    {"tcf", CONTROL_VALUE, RTF_TCF},
    {"tcl", CONTROL_VALUE, RTF_TCL},
    {"tcn", CONTROL_FLAG, RTF_TCN},
    {"tdfrmtxtBottom", CONTROL_VALUE, RTF_TDFRMTXTBOTTOM},
    {"tdfrmtxtLeft", CONTROL_VALUE, RTF_TDFRMTXTLEFT},
    {"tdfrmtxtRight", CONTROL_VALUE, RTF_TDFRMTXTRIGHT},
    {"tdfrmtxtTop", CONTROL_VALUE, RTF_TDFRMTXTTOP},
    {"template", CONTROL_DESTINATION, RTF_TEMPLATE},
    {"themedata", CONTROL_DESTINATION, RTF_THEMEDATA},
    {"themelang", CONTROL_VALUE, RTF_THEMELANG},
    {"themelangcs", CONTROL_VALUE, RTF_THEMELANGCS},
    {"themelangfe", CONTROL_VALUE, RTF_THEMELANGFE},
    {"time", CONTROL_FLAG, RTF_TIME},
    {"title", CONTROL_DESTINATION, RTF_TITLE},
    {"titlepg", CONTROL_FLAG, RTF_TITLEPG},
    {"tldot", CONTROL_FLAG, RTF_TLDOT},
    {"tleq", CONTROL_FLAG, RTF_TLEQ},
    {"tlhyph", CONTROL_FLAG, RTF_TLHYPH},
    {"tlmdot", CONTROL_FLAG, RTF_TLMDOT},
    {"tlth", CONTROL_FLAG, RTF_TLTH},
    {"tlul", CONTROL_FLAG, RTF_TLUL},
    {"toplinepunct", CONTROL_FLAG, RTF_TOPLINEPUNCT},
    {"tphcol", CONTROL_FLAG, RTF_TPHCOL},
    {"tphmrg", CONTROL_FLAG, RTF_TPHMRG},
    {"tphpg", CONTROL_FLAG, RTF_TPHPG},
    {"tposnegx", CONTROL_VALUE, RTF_TPOSNEGX},
    {"tposnegy", CONTROL_VALUE, RTF_TPOSNEGY},
    {"tposxc", CONTROL_FLAG, RTF_TPOSXC},
    {"tposxi", CONTROL_FLAG, RTF_TPOSXI},
    {"tposxl", CONTROL_FLAG, RTF_TPOSXL},
    {"tposx", CONTROL_VALUE, RTF_TPOSX},
    {"tposxo", CONTROL_FLAG, RTF_TPOSXO},
    {"tposxr", CONTROL_FLAG, RTF_TPOSXR},
    {"tposy", CONTROL_VALUE, RTF_TPOSY},
    {"tposyb", CONTROL_FLAG, RTF_TPOSYB},
    {"tposyc", CONTROL_FLAG, RTF_TPOSYC},
    {"tposyil", CONTROL_FLAG, RTF_TPOSYIL},
    {"tposyin", CONTROL_FLAG, RTF_TPOSYIN},
    {"tposyout", CONTROL_FLAG, RTF_TPOSYOUT},
    {"tposyt", CONTROL_FLAG, RTF_TPOSYT},
    {"tpvmrg", CONTROL_FLAG, RTF_TPVMRG},
    {"tpvpara", CONTROL_FLAG, RTF_TPVPARA},
    {"tpvpg", CONTROL_FLAG, RTF_TPVPG},
    {"tqc", CONTROL_FLAG, RTF_TQC},
    {"tqdec", CONTROL_FLAG, RTF_TQDEC},
    {"tqr", CONTROL_FLAG, RTF_TQR},
    {"trackformatting", CONTROL_VALUE, RTF_TRACKFORMATTING},
    {"trackmoves", CONTROL_VALUE, RTF_TRACKMOVES},
    {"transmf", CONTROL_FLAG, RTF_TRANSMF},
    {"trauth", CONTROL_VALUE, RTF_TRAUTH},
    {"trautofit", CONTROL_TOGGLE, RTF_TRAUTOFIT},
    {"trbgbdiag", CONTROL_FLAG, RTF_TRBGBDIAG},
    {"trbgcross", CONTROL_FLAG, RTF_TRBGCROSS},
    {"trbgdcross", CONTROL_FLAG, RTF_TRBGDCROSS},
    {"trbgdkbdiag", CONTROL_FLAG, RTF_TRBGDKBDIAG},
    {"trbgdkcross", CONTROL_FLAG, RTF_TRBGDKCROSS},
    {"trbgdkdcross", CONTROL_FLAG, RTF_TRBGDKDCROSS},
    {"trbgdkfdiag", CONTROL_FLAG, RTF_TRBGDKFDIAG},
    {"trbgdkhor", CONTROL_FLAG, RTF_TRBGDKHOR},
    {"trbgdkvert", CONTROL_FLAG, RTF_TRBGDKVERT},
    {"trbgfdiag", CONTROL_FLAG, RTF_TRBGFDIAG},
    {"trbghoriz", CONTROL_FLAG, RTF_TRBGHORIZ},
    {"trbgvert", CONTROL_FLAG, RTF_TRBGVERT},
    {"trbrdrb", CONTROL_FLAG, RTF_TRBRDRB},
    {"trbrdrh", CONTROL_FLAG, RTF_TRBRDRH},
    {"trbrdrl", CONTROL_FLAG, RTF_TRBRDRL},
    {"trbrdrr", CONTROL_FLAG, RTF_TRBRDRR},
    {"trbrdrt", CONTROL_FLAG, RTF_TRBRDRT},
    {"trbrdrv", CONTROL_FLAG, RTF_TRBRDRV},
    {"trcbpat", CONTROL_VALUE, RTF_TRCBPAT},
    {"trcfpat", CONTROL_VALUE, RTF_TRCFPAT},
    {"trdate", CONTROL_VALUE, RTF_TRDATE},
    {"trftsWidthA", CONTROL_VALUE, RTF_TRFTSWIDTHA},
    {"trftsWidthB", CONTROL_VALUE, RTF_TRFTSWIDTHB},
    {"trftsWidth", CONTROL_VALUE, RTF_TRFTSWIDTH},
    {"trgaph", CONTROL_VALUE, RTF_TRGAPH},
    {"trhdr", CONTROL_FLAG, RTF_TRHDR},
    {"trkeep", CONTROL_FLAG, RTF_TRKEEP},
    {"trkeepfollow", CONTROL_FLAG, RTF_TRKEEPFOLLOW},
    {"trleft", CONTROL_VALUE, RTF_TRLEFT},
    {"trowd", CONTROL_FLAG, RTF_TROWD},
    {"trpaddb", CONTROL_VALUE, RTF_TRPADDB},
    {"trpaddfb", CONTROL_VALUE, RTF_TRPADDFB},
    {"trpaddfl", CONTROL_VALUE, RTF_TRPADDFL},
    {"trpaddfr", CONTROL_VALUE, RTF_TRPADDFR},
    {"trpaddft", CONTROL_VALUE, RTF_TRPADDFT},
    {"trpaddl", CONTROL_VALUE, RTF_TRPADDL},
    {"trpaddr", CONTROL_VALUE, RTF_TRPADDR},
    {"trpaddt", CONTROL_VALUE, RTF_TRPADDT},
    {"trpadob", CONTROL_VALUE, RTF_TRPADOB},
    {"trpadofb", CONTROL_VALUE, RTF_TRPADOFB},
    {"trpadofl", CONTROL_VALUE, RTF_TRPADOFL},
    {"trpadofr", CONTROL_VALUE, RTF_TRPADOFR},
    {"trpadoft", CONTROL_VALUE, RTF_TRPADOFT},
    {"trpadol", CONTROL_VALUE, RTF_TRPADOL},
    {"trpador", CONTROL_VALUE, RTF_TRPADOR},
    {"trpadot", CONTROL_VALUE, RTF_TRPADOT},
    {"trpat", CONTROL_VALUE, RTF_TRPAT},
    {"trqc", CONTROL_FLAG, RTF_TRQC},
    {"trql", CONTROL_FLAG, RTF_TRQL},
    {"trqr", CONTROL_FLAG, RTF_TRQR},
    {"trrh", CONTROL_VALUE, RTF_TRRH},
    {"trshdng", CONTROL_VALUE, RTF_TRSHDNG},
    {"trspdb", CONTROL_VALUE, RTF_TRSPDB},
    {"trspdfb", CONTROL_VALUE, RTF_TRSPDFB},
    {"trspdfl", CONTROL_VALUE, RTF_TRSPDFL},
    {"trspdfr", CONTROL_VALUE, RTF_TRSPDFR},
    {"trspdft", CONTROL_VALUE, RTF_TRSPDFT},
    {"trspdl", CONTROL_VALUE, RTF_TRSPDL},
    {"trspdr", CONTROL_VALUE, RTF_TRSPDR},
    {"trspdt", CONTROL_VALUE, RTF_TRSPDT},
    {"trspob", CONTROL_VALUE, RTF_TRSPOB},
    {"trspofb", CONTROL_VALUE, RTF_TRSPOFB},
    {"trspofl", CONTROL_VALUE, RTF_TRSPOFL},
    {"trspofr", CONTROL_VALUE, RTF_TRSPOFR},
    {"trspoft", CONTROL_VALUE, RTF_TRSPOFT},
    {"trspol", CONTROL_VALUE, RTF_TRSPOL},
    {"trspor", CONTROL_VALUE, RTF_TRSPOR},
    {"trspot", CONTROL_VALUE, RTF_TRSPOT},
    {"truncatefontheight", CONTROL_FLAG, RTF_TRUNCATEFONTHEIGHT},
    {"truncex", CONTROL_FLAG, RTF_TRUNCEX},
    {"trwWidthA", CONTROL_VALUE, RTF_TRWWIDTHA},
    {"trwWidthB", CONTROL_VALUE, RTF_TRWWIDTHB},
    {"trwWidth", CONTROL_VALUE, RTF_TRWWIDTH},
    {"ts", CONTROL_VALUE, RTF_TS},
    {"tsbgbdiag", CONTROL_FLAG, RTF_TSBGBDIAG},
    {"tsbgcross", CONTROL_FLAG, RTF_TSBGCROSS},
    {"tsbgdcross", CONTROL_FLAG, RTF_TSBGDCROSS},
    {"tsbgdkbdiag", CONTROL_FLAG, RTF_TSBGDKBDIAG},
    {"tsbgdkcross", CONTROL_FLAG, RTF_TSBGDKCROSS},
    {"tsbgdkdcross", CONTROL_FLAG, RTF_TSBGDKDCROSS},
    {"tsbgdkfdiag", CONTROL_FLAG, RTF_TSBGDKFDIAG},
    {"tsbgdkhor", CONTROL_FLAG, RTF_TSBGDKHOR},
    {"tsbgdkvert", CONTROL_FLAG, RTF_TSBGDKVERT},
    {"tsbgfdiag", CONTROL_FLAG, RTF_TSBGFDIAG},
    {"tsbghoriz", CONTROL_FLAG, RTF_TSBGHORIZ},
    {"tsbgvert", CONTROL_FLAG, RTF_TSBGVERT},
    {"tsbrdrb", CONTROL_FLAG, RTF_TSBRDRB},
    {"tsbrdrdgl", CONTROL_FLAG, RTF_TSBRDRDGL},
    {"tsbrdrdgr", CONTROL_FLAG, RTF_TSBRDRDGR},
    {"tsbrdrh", CONTROL_FLAG, RTF_TSBRDRH},
    {"tsbrdrl", CONTROL_FLAG, RTF_TSBRDRL},
    {"tsbrdrr", CONTROL_FLAG, RTF_TSBRDRR},
    {"tsbrdrt", CONTROL_FLAG, RTF_TSBRDRT},
    {"tsbrdrv", CONTROL_FLAG, RTF_TSBRDRV},
    {"tscbandhorzeven", CONTROL_FLAG, RTF_TSCBANDHORZEVEN},
    {"tscbandhorzodd", CONTROL_FLAG, RTF_TSCBANDHORZODD},
    {"tscbandsh", CONTROL_VALUE, RTF_TSCBANDSH},
    {"tscbandsv", CONTROL_VALUE, RTF_TSCBANDSV},
    {"tscbandverteven", CONTROL_FLAG, RTF_TSCBANDVERTEVEN},
    {"tscbandvertodd", CONTROL_FLAG, RTF_TSCBANDVERTODD},
    {"tscellcbpat", CONTROL_VALUE, RTF_TSCELLCBPAT},
    {"tscellcfpat", CONTROL_VALUE, RTF_TSCELLCFPAT},
    {"tscellpaddb", CONTROL_VALUE, RTF_TSCELLPADDB},
    {"tscellpaddfb", CONTROL_VALUE, RTF_TSCELLPADDFB},
    {"tscellpaddfl", CONTROL_VALUE, RTF_TSCELLPADDFL},
    {"tscellpaddfr", CONTROL_VALUE, RTF_TSCELLPADDFR},
    {"tscellpaddft", CONTROL_VALUE, RTF_TSCELLPADDFT},
    {"tscellpaddl", CONTROL_VALUE, RTF_TSCELLPADDL},
    {"tscellpaddr", CONTROL_VALUE, RTF_TSCELLPADDR},
    {"tscellpaddt", CONTROL_VALUE, RTF_TSCELLPADDT},
    {"tscellpct", CONTROL_VALUE, RTF_TSCELLPCT},
    {"tscellwidth", CONTROL_VALUE, RTF_TSCELLWIDTH},
    {"tscellwidthfts", CONTROL_VALUE, RTF_TSCELLWIDTHFTS},
    {"tscfirstcol", CONTROL_FLAG, RTF_TSCFIRSTCOL},
    {"tscfirstrow", CONTROL_FLAG, RTF_TSCFIRSTROW},
    {"tsclastcol", CONTROL_FLAG, RTF_TSCLASTCOL},
    {"tsclastrow", CONTROL_FLAG, RTF_TSCLASTROW},
    {"tscnecell", CONTROL_FLAG, RTF_TSCNECELL},
    {"tscnwcell", CONTROL_FLAG, RTF_TSCNWCELL},
    {"tscsecell", CONTROL_FLAG, RTF_TSCSECELL},
    {"tscswcell", CONTROL_FLAG, RTF_TSCSWCELL},
    {"tsd", CONTROL_FLAG, RTF_TSD},
    {"tsnowrap", CONTROL_FLAG, RTF_TSNOWRAP},
    {"tsrowd", CONTROL_FLAG, RTF_TSROWD},
    {"tsvertalb", CONTROL_FLAG, RTF_TSVERTALB},
    {"tsvertalc", CONTROL_FLAG, RTF_TSVERTALC},
    {"tsvertalt", CONTROL_FLAG, RTF_TSVERTALT},
    {"twoinone", CONTROL_VALUE, RTF_TWOINONE},
    {"twoonone", CONTROL_FLAG, RTF_TWOONONE},
    {"tx", CONTROL_VALUE, RTF_TX},
    {"txbxtwalways", CONTROL_FLAG, RTF_TXBXTWALWAYS},
    {"txbxtwfirst", CONTROL_FLAG, RTF_TXBXTWFIRST},
    {"txbxtwfirstlast", CONTROL_FLAG, RTF_TXBXTWFIRSTLAST},
    {"txbxtwlast", CONTROL_FLAG, RTF_TXBXTWLAST},
    {"txbxtwno", CONTROL_FLAG, RTF_TXBXTWNO},
    {"txe", CONTROL_DESTINATION, RTF_TXE},
    {"u", CONTROL_VALUE, RTF_U},
    {"uc", CONTROL_VALUE, RTF_UC},
    {"ud", CONTROL_DESTINATION, RTF_UD},
    {"ul", CONTROL_TOGGLE, RTF_UL},
    {"ulc", CONTROL_VALUE, RTF_ULC},
    {"uld", CONTROL_FLAG, RTF_ULD},
    {"uldash", CONTROL_TOGGLE, RTF_ULDASH},
    {"uldashd", CONTROL_TOGGLE, RTF_ULDASHD},
    {"uldashdd", CONTROL_TOGGLE, RTF_ULDASHDD},
    {"uldb", CONTROL_TOGGLE, RTF_ULDB},
    {"ulhair", CONTROL_TOGGLE, RTF_ULHAIR},
    {"ulhwave", CONTROL_TOGGLE, RTF_ULHWAVE},
    {"ulldash", CONTROL_TOGGLE, RTF_ULLDASH},
    {"ulnone", CONTROL_FLAG, RTF_ULNONE},
    {"ulth", CONTROL_TOGGLE, RTF_ULTH},
    {"ulthd", CONTROL_TOGGLE, RTF_ULTHD},
    {"ulthdash", CONTROL_TOGGLE, RTF_ULTHDASH},
    {"ulthdashd", CONTROL_TOGGLE, RTF_ULTHDASHD},
    {"ulthdashdd", CONTROL_TOGGLE, RTF_ULTHDASHDD},
    {"ulthldash", CONTROL_TOGGLE, RTF_ULTHLDASH},
    {"ululdbwave", CONTROL_TOGGLE, RTF_ULULDBWAVE},
    {"ulw", CONTROL_FLAG, RTF_ULW},
    {"ulwave", CONTROL_TOGGLE, RTF_ULWAVE},
    {"up", CONTROL_VALUE, RTF_UP},
    {"upr", CONTROL_DESTINATION, RTF_UPR},
    {"urtf", CONTROL_VALUE, RTF_URTF},
    {"useltbaln", CONTROL_FLAG, RTF_USELTBALN},
    {"usenormstyforlist", CONTROL_FLAG, RTF_USENORMSTYFORLIST},
    {"userprops", CONTROL_DESTINATION, RTF_USERPROPS},
    {"usexform", CONTROL_FLAG, RTF_USEXFORM},
    {"utinl", CONTROL_FLAG, RTF_UTINL},
    {"v", CONTROL_TOGGLE, RTF_V},
    {"validatexml", CONTROL_VALUE, RTF_VALIDATEXML},
    {"vern", CONTROL_VALUE, RTF_VERN},
    {"version", CONTROL_VALUE, RTF_VERSION},
    {"vertal", CONTROL_FLAG, RTF_VERTAL},
    {"vertalb", CONTROL_FLAG, RTF_VERTALB},
    {"vertalc", CONTROL_FLAG, RTF_VERTALC},
    {"vertalj", CONTROL_FLAG, RTF_VERTALJ},
    {"vertalt", CONTROL_FLAG, RTF_VERTALT},
    {"vertdoc", CONTROL_FLAG, RTF_VERTDOC},
    {"vertsect", CONTROL_FLAG, RTF_VERTSECT},
    {"viewbksp", CONTROL_VALUE, RTF_VIEWBKSP},
    {"viewkind", CONTROL_VALUE, RTF_VIEWKIND},
    {"viewnobound", CONTROL_FLAG, RTF_VIEWNOBOUND},
    {"viewscale", CONTROL_VALUE, RTF_VIEWSCALE},
    {"viewzk", CONTROL_VALUE, RTF_VIEWZK},
    {"wbitmap", CONTROL_VALUE, RTF_WBITMAP},
    {"wbmbitspixel", CONTROL_VALUE, RTF_WBMBITSPIXEL},
    {"wbmplanes", CONTROL_VALUE, RTF_WBMPLANES},
    {"wbmwidthbyte", CONTROL_VALUE, RTF_WBMWIDTHBYTE},
    {"webhidden", CONTROL_FLAG, RTF_WEBHIDDEN},
    {"wgrffmtfilter", CONTROL_DESTINATION, RTF_WGRFFMTFILTER},
    {"widctlpar", CONTROL_FLAG, RTF_WIDCTLPAR},
    {"widowctrl", CONTROL_FLAG, RTF_WIDOWCTRL},
    {"windowcaption", CONTROL_DESTINATION, RTF_WINDOWCAPTION},
    {"wmetafile", CONTROL_VALUE, RTF_WMETAFILE},
    {"wpeqn", CONTROL_FLAG, RTF_WPEQN},
    {"wpjst", CONTROL_FLAG, RTF_WPJST},
    {"wpsp", CONTROL_FLAG, RTF_WPSP},
    {"wraparound", CONTROL_FLAG, RTF_WRAPAROUND},
    {"wrapdefault", CONTROL_FLAG, RTF_WRAPDEFAULT},
    {"wrapthrough", CONTROL_FLAG, RTF_WRAPTHROUGH},
    {"wraptight", CONTROL_FLAG, RTF_WRAPTIGHT},
    {"wraptrsp", CONTROL_FLAG, RTF_WRAPTRSP},
    {"writereservation", CONTROL_DESTINATION, RTF_WRITERESERVATION},
    {"writereservhash", CONTROL_DESTINATION, RTF_WRITERESERVHASH},
    {"wrppunct", CONTROL_FLAG, RTF_WRPPUNCT},
    {"xe", CONTROL_DESTINATION, RTF_XE},
    {"xef", CONTROL_VALUE, RTF_XEF},
    {"xform", CONTROL_DESTINATION, RTF_XFORM},
    {"xmlattr", CONTROL_FLAG, RTF_XMLATTR},
    {"xmlattrname", CONTROL_DESTINATION, RTF_XMLATTRNAME},
    {"xmlattrns", CONTROL_VALUE, RTF_XMLATTRNS},
    {"xmlattrvalue", CONTROL_DESTINATION, RTF_XMLATTRVALUE},
    {"xmlclose", CONTROL_DESTINATION, RTF_XMLCLOSE},
    {"xmlname", CONTROL_DESTINATION, RTF_XMLNAME},
    {"xmlns", CONTROL_VALUE, RTF_XMLNS},
    {"xmlnstbl", CONTROL_DESTINATION, RTF_XMLNSTBL},
    {"xmlopen", CONTROL_DESTINATION, RTF_XMLOPEN},
    {"xmlsdttcell", CONTROL_FLAG, RTF_XMLSDTTCELL},
    {"xmlsdttpara", CONTROL_FLAG, RTF_XMLSDTTPARA},
    {"xmlsdttregular", CONTROL_FLAG, RTF_XMLSDTTREGULAR},
    {"xmlsdttrow", CONTROL_FLAG, RTF_XMLSDTTROW},
    {"xmlsdttunknown", CONTROL_FLAG, RTF_XMLSDTTUNKNOWN},
    {"yr", CONTROL_VALUE, RTF_YR},
    {"yts", CONTROL_VALUE, RTF_YTS},
    {"yxe", CONTROL_FLAG, RTF_YXE},
    {"zwbo", CONTROL_SYMBOL, RTF_ZWBO},
    {"zwj", CONTROL_SYMBOL, RTF_ZWJ},
    {"zwnbo", CONTROL_SYMBOL, RTF_ZWNBO},
    {"zwnj", CONTROL_SYMBOL, RTF_ZWNJ},
    {"flymaincnt", CONTROL_DESTINATION, RTF_FLYMAINCNT},
    {"flyvert", CONTROL_VALUE, RTF_FLYVERT},
    {"flyhorz", CONTROL_VALUE, RTF_FLYHORZ},
    {"flyanchor", CONTROL_VALUE, RTF_FLYANCHOR},
};
int nRTFControlWords = SAL_N_ELEMENTS(aRTFControlWords);

bool RTFSymbol::operator<(const RTFSymbol& rOther) const
{
    return strcmp(sKeyword, rOther.sKeyword) < 0;
}

RTFMathSymbol aRTFMathControlWords[] =
{
    // eKeyword nToken eDestination
    {RTF_MOMATH, M_TOKEN(oMath), Destination::MOMATH},
    {RTF_MF, M_TOKEN(f), Destination::MF},
    {RTF_MFPR, M_TOKEN(fPr), Destination::MFPR},
    {RTF_MCTRLPR, M_TOKEN(ctrlPr), Destination::MCTRLPR},
    {RTF_MNUM, M_TOKEN(num), Destination::MNUM},
    {RTF_MDEN, M_TOKEN(den), Destination::MDEN},
    {RTF_MACC, M_TOKEN(acc), Destination::MACC},
    {RTF_MACCPR, M_TOKEN(accPr), Destination::MACCPR},
    {RTF_MBAR, M_TOKEN(bar), Destination::MBAR},
    {RTF_MBARPR, M_TOKEN(barPr), Destination::MBARPR},
    {RTF_ME, M_TOKEN(e), Destination::ME},
    {RTF_MD, M_TOKEN(d), Destination::MD},
    {RTF_MDPR, M_TOKEN(dPr), Destination::MDPR},
    {RTF_MFUNC, M_TOKEN(func), Destination::MFUNC},
    {RTF_MFUNCPR, M_TOKEN(funcPr), Destination::MFUNCPR},
    {RTF_MFNAME, M_TOKEN(fName), Destination::MFNAME},
    {RTF_MLIMLOW, M_TOKEN(limLow), Destination::MLIMLOW},
    {RTF_MLIMLOWPR, M_TOKEN(limLowPr), Destination::MLIMLOWPR},
    {RTF_MLIM, M_TOKEN(lim), Destination::MLIM},
    {RTF_MM, M_TOKEN(m), Destination::MM},
    {RTF_MMPR, M_TOKEN(mPr), Destination::MMPR},
    {RTF_MMR, M_TOKEN(mr), Destination::MMR},
    {RTF_MNARY, M_TOKEN(nary), Destination::MNARY},
    {RTF_MNARYPR, M_TOKEN(naryPr), Destination::MNARYPR},
    {RTF_MSUB, M_TOKEN(sub), Destination::MSUB},
    {RTF_MSUP, M_TOKEN(sup), Destination::MSUP},
    {RTF_MLIMUPP, M_TOKEN(limUpp), Destination::MLIMUPP},
    {RTF_MLIMUPPPR, M_TOKEN(limUppPr), Destination::MLIMUPPPR},
    {RTF_MGROUPCHR, M_TOKEN(groupChr), Destination::MGROUPCHR},
    {RTF_MGROUPCHRPR, M_TOKEN(groupChrPr), Destination::MGROUPCHRPR},
    {RTF_MBORDERBOX, M_TOKEN(borderBox), Destination::MBORDERBOX},
    {RTF_MBORDERBOXPR, M_TOKEN(borderBoxPr), Destination::MBORDERBOXPR},
    {RTF_MRAD, M_TOKEN(rad), Destination::MRAD},
    {RTF_MRADPR, M_TOKEN(radPr), Destination::MRADPR},
    {RTF_MDEG, M_TOKEN(deg), Destination::MDEG},
    {RTF_MSSUB, M_TOKEN(sSub), Destination::MSSUB},
    {RTF_MSSUBPR, M_TOKEN(sSubPr), Destination::MSSUBPR},
    {RTF_MSSUP, M_TOKEN(sSup), Destination::MSSUP},
    {RTF_MSSUPPR, M_TOKEN(sSupPr), Destination::MSSUPPR},
    {RTF_MSSUBSUP, M_TOKEN(sSubSup), Destination::MSSUBSUP},
    {RTF_MSSUBSUPPR, M_TOKEN(sSubSupPr), Destination::MSSUBSUPPR},
    {RTF_MSPRE, M_TOKEN(sPre), Destination::MSPRE},
    {RTF_MSPREPR, M_TOKEN(sPrePr), Destination::MSPREPR},
    {RTF_MBOX, M_TOKEN(box), Destination::MBOX},
    {RTF_MEQARR, M_TOKEN(eqArr), Destination::MEQARR},
};
int nRTFMathControlWords = SAL_N_ELEMENTS(aRTFMathControlWords);

bool RTFMathSymbol::operator<(const RTFMathSymbol& rOther) const
{
    return eKeyword < rOther.eKeyword;
}

} // namespace rtftok
} // namespace writerfilter

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
