/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#ifndef INCLUDED_SW_SOURCE_UI_ENVELP_LABFMT_HXX
#define INCLUDED_SW_SOURCE_UI_ENVELP_LABFMT_HXX

#include "swuilabimp.hxx"
#include "labimg.hxx"
#include <vcl/msgbox.hxx>
#include <vcl/idle.hxx>
class SwLabFormatPage;

class SwLabPreview : public vcl::Window
{
    Color aGrayColor;

    OUString aHDistStr;
    OUString aVDistStr;
    OUString aWidthStr;
    OUString aHeightStr;
    OUString aLeftStr;
    OUString aUpperStr;
    OUString aColsStr;
    OUString aRowsStr;
    OUString aPWidthStr;
    OUString aPHeightStr;

    long lHDistWidth;
    long lVDistWidth;
    long lHeightWidth;
    long lLeftWidth;
    long lUpperWidth;
    long lColsWidth;
    long lPWidthWidth;
    long lPHeightWidth;

    long lXWidth;
    long lXHeight;

    SwLabItem aItem;

    virtual void Paint(vcl::RenderContext& rRenderContext, const Rectangle&) SAL_OVERRIDE;

    virtual Size GetOptimalSize() const SAL_OVERRIDE;

public:

    SwLabPreview(vcl::Window* pParent);

    void UpdateItem(const SwLabItem& rItem);
};

class SwLabFormatPage : public SfxTabPage
{
    VclPtr<FixedText>    m_pMakeFI;
    VclPtr<FixedText>    m_pTypeFI;
    VclPtr<SwLabPreview> m_pPreview;
    VclPtr<MetricField>  m_pHDistField;
    VclPtr<MetricField>  m_pVDistField;
    VclPtr<MetricField>  m_pWidthField;
    VclPtr<MetricField>  m_pHeightField;
    VclPtr<MetricField>  m_pLeftField;
    VclPtr<MetricField>  m_pUpperField;
    VclPtr<NumericField> m_pColsField;
    VclPtr<NumericField> m_pRowsField;
    VclPtr<MetricField>  m_pPWidthField;
    VclPtr<MetricField>  m_pPHeightField;
    VclPtr<PushButton>   m_pSavePB;

    Idle aPreviewIdle;
    bool  bModified;

    SwLabItem    aItem;

    DECL_LINK(ModifyHdl, void *);
    DECL_LINK_TYPED(PreviewHdl, Idle *, void);
    DECL_LINK( LoseFocusHdl, Control * );
    DECL_LINK(SaveHdl, void *);

    void ChangeMinMax();

    using TabPage::ActivatePage;
    using TabPage::DeactivatePage;

public:
    SwLabFormatPage(vcl::Window* pParent, const SfxItemSet& rSet);
    virtual ~SwLabFormatPage();
    virtual void dispose() SAL_OVERRIDE;

    static VclPtr<SfxTabPage> Create(vcl::Window* pParent, const SfxItemSet* rSet);

    virtual void ActivatePage(const SfxItemSet& rSet) SAL_OVERRIDE;
    virtual sfxpg DeactivatePage(SfxItemSet* pSet = 0) SAL_OVERRIDE;
            void FillItem(SwLabItem& rItem);
    virtual bool FillItemSet(SfxItemSet* rSet) SAL_OVERRIDE;
    virtual void Reset(const SfxItemSet* rSet) SAL_OVERRIDE;

    SwLabDlg* GetParentSwLabDlg() {return static_cast<SwLabDlg*>(GetParentDialog());}
};

class SwSaveLabelDlg : public ModalDialog
{
    VclPtr<ComboBox>   m_pMakeCB;
    VclPtr<Edit>       m_pTypeED;
    VclPtr<OKButton>   m_pOKPB;

    bool        bSuccess;
    VclPtr<SwLabFormatPage>   pLabPage;
    SwLabRec&       rLabRec;

    DECL_LINK(OkHdl, void *);
    DECL_LINK(ModifyHdl, void *);

public:
    SwSaveLabelDlg(SwLabFormatPage* pParent, SwLabRec& rRec);
    virtual ~SwSaveLabelDlg();
    virtual void dispose() SAL_OVERRIDE;

    void SetLabel(const OUString& rMake, const OUString& rType)
    {
        m_pMakeCB->SetText(rMake);
        m_pTypeED->SetText(rType);
    }
    bool GetLabel(SwLabItem& rItem);
};
#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
