/*
 * Decompiled with CFR 0.152.
 */
package org.probatron.officeotron;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class MceXmlFilter
extends XMLFilterImpl {
    private static final String NS_XML = "http://www.w3.org/XML/1998/namespace";
    private static final String NS_MCE = "http://schemas.openxmlformats.org/markup-compatibility/2006";
    private static final String TAG_XML = "xml";
    private static final String ATTR_IGNORABLE = "Ignorable";
    private static final String ATTR_PROCESS_CONTENT = "ProcessContent";
    private static final String TAG_ALTERNATE_CONTENT = "AlternateContent";
    private static final String TAG_CHOICE = "Choice";
    private static final String TAG_FALLBACK = "Fallback";
    private Stack<ElementInfos> mInfos;
    private HashMap<String, String> mPrefixes;
    private Locator mLocator;
    private boolean mVMLStream = false;

    public MceXmlFilter(XMLReader xMLReader) {
        super(xMLReader);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.mLocator = locator;
        super.setDocumentLocator(locator);
    }

    public void setVMLStream(boolean bl) {
        this.mVMLStream = bl;
    }

    @Override
    public void startDocument() throws SAXException {
        this.mInfos = new Stack();
        this.mPrefixes = new HashMap();
        super.startDocument();
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.mPrefixes.put(string, string2);
        super.startPrefixMapping(string, string2);
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        super.endPrefixMapping(string);
        this.mPrefixes.remove(string);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        boolean bl;
        String string4;
        int n;
        Object object;
        Object object2;
        List<String> list = this.getCurrentIgnorables();
        ElementInfos elementInfos = new ElementInfos(string, string2);
        boolean bl2 = this.checkMceElement(string, string2, string3, attributes);
        String string5 = attributes.getValue(NS_MCE, ATTR_IGNORABLE);
        if (string5 != null) {
            object2 = MceXmlFilter.normalizeWhitespaces(string5).split(" ");
            elementInfos.ignorableValue.addAll(Arrays.asList(object2));
        }
        if ((object2 = attributes.getValue(NS_MCE, ATTR_PROCESS_CONTENT)) != null) {
            String[] stringArray;
            object = stringArray = MceXmlFilter.normalizeWhitespaces((String)object2).split(" ");
            int n2 = ((String[])object).length;
            for (n = 0; n < n2; ++n) {
                string4 = object[n];
                elementInfos.processContentValue.add(this.parsePrefixedName(string4));
            }
        }
        boolean bl3 = false;
        if (this.mVMLStream && this.mInfos.empty()) {
            if (!string3.equals(TAG_XML)) {
                object = new SAXParseException("VML streams need to start with <xml>: 8.1 (Part 4)", this.mLocator);
                this.getErrorHandler().error((SAXParseException)object);
            } else {
                bl3 = true;
            }
        }
        elementInfos.ignoreContent = bl = bl3 || this.isIgnorable(string3, list);
        elementInfos.processContent = this.isProcessContent(string, string2);
        if (!(bl || this.isInIgnoredContent() || bl2)) {
            AttributesImpl attributesImpl = new AttributesImpl();
            for (n = 0; n < attributes.getLength(); ++n) {
                string4 = attributes.getURI(n);
                String string6 = attributes.getLocalName(n);
                String string7 = attributes.getQName(n);
                boolean bl4 = false;
                bl4 = this.isIgnorable(string7, list);
                if (!bl4 && NS_MCE.equals(string4)) {
                    bl4 = true;
                }
                if (bl4) continue;
                attributesImpl.addAttribute(string4, string6, attributes.getQName(n), attributes.getType(n), attributes.getValue(n));
            }
            super.startElement(string, string2, string3, attributesImpl);
        }
        this.mInfos.push(elementInfos);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.isInIgnoredContent()) {
            super.characters(cArray, n, n2);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!this.mInfos.isEmpty() && this.mInfos.peek().isElement(string, string2)) {
            this.mInfos.pop();
        }
        List<String> list = this.getCurrentIgnorables();
        boolean bl = this.checkMceElement(string, string2, string3, null);
        if (!(this.isIgnorable(string3, list) || this.isInIgnoredContent() || bl)) {
            super.endElement(string, string2, string3);
        }
    }

    private boolean checkMceElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        boolean bl = NS_MCE.equals(string);
        if (bl) {
            Object object;
            if (!(TAG_ALTERNATE_CONTENT.equals(string2) || TAG_CHOICE.equals(string2) || TAG_FALLBACK.equals(string2))) {
                object = new SAXParseException("Invalid MCE element: " + string2, this.mLocator);
                this.getErrorHandler().error((SAXParseException)object);
            }
            object = this.getPrefix(string);
            if (attributes != null) {
                Object object2;
                if (!TAG_ALTERNATE_CONTENT.equals(string2)) {
                    Object object3;
                    if (this.mInfos.isEmpty()) {
                        object2 = MessageFormat.format("Invalid root element: {0}:{1}", object, string2);
                        object3 = new SAXParseException((String)object2, this.mLocator);
                        this.getErrorHandler().error((SAXParseException)object3);
                    } else {
                        object2 = this.mInfos.peek();
                        if (!((ElementInfos)object2).uri.equals(NS_MCE) || !((ElementInfos)object2).localName.equals(TAG_ALTERNATE_CONTENT)) {
                            object3 = MessageFormat.format("Parent of {0}:{1} element should be {0}:AlternateContent", object, string2);
                            SAXParseException sAXParseException = new SAXParseException((String)object3, this.mLocator);
                            this.getErrorHandler().error(sAXParseException);
                        }
                    }
                }
                object2 = null;
                boolean bl2 = bl && TAG_CHOICE.equals(string2);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Object object4;
                    String string4 = attributes.getURI(i);
                    String string5 = attributes.getLocalName(i);
                    if (!(!string4.isEmpty() || bl2 && string5.equals("Requires"))) {
                        object4 = MessageFormat.format("{0}:{1} element shouldn't have any attribute with no namespace", object, string2);
                        if (bl2) {
                            object4 = MessageFormat.format("Invalid attribute {0} with no namespace in {1}:Choice element", string5, object);
                        }
                        SAXParseException sAXParseException = new SAXParseException((String)object4, this.mLocator);
                        this.getErrorHandler().error(sAXParseException);
                    } else if (NS_XML.equals(string4) && (string5.equals("lang") || string5.equals("space"))) {
                        object4 = new SAXParseException(MessageFormat.format("xml:{2} is not allowed in {0}:{1} element", object, string2, string5), this.mLocator);
                        this.getErrorHandler().error((SAXParseException)object4);
                    }
                    if (!bl2) continue;
                    if (string4.isEmpty() && "Requires".equals(string5)) {
                        object2 = attributes.getValue(i);
                        continue;
                    }
                    if (!NS_MCE.equals(string4) || !"Requires".equals(string5)) continue;
                    object4 = new SAXParseException(MessageFormat.format("{0}:Choice element shouldn''t have a Requires element with the {0} prefix", object), this.mLocator);
                    this.getErrorHandler().error((SAXParseException)object4);
                }
                if (bl2 && (object2 == null || ((String)object2).isEmpty())) {
                    SAXParseException sAXParseException = new SAXParseException(MessageFormat.format("{0}:Choice element needs a Requires attribute with no namespace", object), this.mLocator);
                    this.getErrorHandler().error(sAXParseException);
                }
            }
        }
        return bl;
    }

    private List<String> getCurrentIgnorables() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ElementInfos elementInfos : this.mInfos) {
            for (String string : elementInfos.ignorableValue) {
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    protected static String normalizeWhitespaces(String string) {
        return string.replaceAll("\\p{Space}+", " ").trim();
    }

    private boolean isIgnorable(String string, List<String> list) {
        if (this.mVMLStream && string.equals(TAG_XML)) {
            return true;
        }
        boolean bl = false;
        for (String string2 : list) {
            if (!string.startsWith(string2 + ":")) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean isProcessContent(String string, String string2) {
        boolean bl = false;
        Iterator iterator = this.mInfos.iterator();
        while (!bl && iterator.hasNext()) {
            ArrayList<QName> arrayList = ((ElementInfos)iterator.next()).processContentValue;
            Iterator<QName> iterator2 = arrayList.iterator();
            while (!bl && iterator2.hasNext()) {
                QName qName = iterator2.next();
                boolean bl2 = qName.getNamespaceURI().equals(string);
                boolean bl3 = qName.getLocalPart().equals(string2) || qName.getLocalPart().equals("*");
                bl = bl2 && bl3;
            }
        }
        return bl;
    }

    private boolean isInIgnoredContent() {
        boolean bl = false;
        for (ElementInfos elementInfos : this.mInfos) {
            if (elementInfos.ignoreContent) {
                bl = true;
            }
            if (bl && elementInfos.processContent) {
                bl = false;
            }
            if (!elementInfos.isElement(NS_MCE, TAG_CHOICE)) continue;
            bl = true;
        }
        return bl;
    }

    private QName parsePrefixedName(String string) {
        QName qName = null;
        String[] stringArray = string.split(":");
        if (stringArray.length <= 2) {
            String string2 = new String();
            String string3 = new String();
            String string4 = stringArray[0];
            if (stringArray.length == 2) {
                string3 = stringArray[0];
                string2 = this.mPrefixes.get(string3);
                string4 = stringArray[1];
            }
            qName = new QName(string2, string4, string3);
        }
        return qName;
    }

    private String getPrefix(String string) {
        String string2 = new String();
        Iterator<Map.Entry<String, String>> iterator = this.mPrefixes.entrySet().iterator();
        while (string2.isEmpty() && iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (!entry.getValue().equals(string)) continue;
            string2 = entry.getKey();
        }
        return string2;
    }

    private class ElementInfos {
        String uri;
        String localName;
        ArrayList<String> ignorableValue;
        ArrayList<QName> processContentValue;
        boolean ignoreContent = false;
        boolean processContent = false;

        public ElementInfos(String string, String string2) {
            this.uri = string;
            this.localName = string2;
            this.ignorableValue = new ArrayList();
            this.processContentValue = new ArrayList();
        }

        public boolean isElement(String string, String string2) {
            boolean bl = this.uri == null && string == null || this.uri.equals(string);
            boolean bl2 = this.localName == null && string2 == null || this.localName.equals(string2);
            return bl && bl2;
        }
    }
}

