/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfxml.xmloutput.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.jena.rdfxml.xmloutput.impl.PairEntry;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.Map1Iterator;
import org.apache.jena.util.iterator.WrappedIterator;

class Relation<T> {
    private final Map<T, Set<T>> rows = new HashMap<T, Set<T>>();
    private final Map<T, Set<T>> cols = new HashMap<T, Set<T>>();
    private final Set<T> index = new HashSet<T>();

    public synchronized void set(T a, T b) {
        this.index.add(a);
        this.index.add(b);
        Relation.innerAdd(this.rows, a, b);
        Relation.innerAdd(this.cols, b, a);
    }

    public synchronized void set11(T a, T b) {
        this.clearX(a, this.forward(a));
        this.clearX(this.backward(b), b);
        this.set(a, b);
    }

    public synchronized void set1N(T a, T b) {
        this.clearX(this.backward(b), b);
        this.set(a, b);
    }

    public synchronized void setN1(T a, T b) {
        this.clearX(a, this.forward(a));
        this.set(a, b);
    }

    public synchronized void setNN(T a, T b) {
        this.set(a, b);
    }

    public synchronized void clear(T a, T b) {
        Relation.innerClear(this.rows, a, b);
        Relation.innerClear(this.cols, b, a);
    }

    private void clearX(Set<T> s, T b) {
        if (s == null) {
            return;
        }
        for (T value : s) {
            this.clear(value, b);
        }
    }

    private void clearX(T a, Set<T> s) {
        if (s == null) {
            return;
        }
        for (T value : s) {
            this.clear(a, value);
        }
    }

    private static <T> void innerAdd(Map<T, Set<T>> s, T a, T b) {
        Set<T> vals = s.get(a);
        if (vals == null) {
            vals = new HashSet<T>();
            s.put(a, vals);
        }
        vals.add(b);
    }

    private static <T> void innerClear(Map<T, Set<T>> s, T a, T b) {
        Set<T> vals = s.get(a);
        if (vals != null) {
            vals.remove(b);
        }
    }

    public boolean get(T a, T b) {
        Set<T> vals = this.rows.get(a);
        return vals != null && vals.contains(b);
    }

    public synchronized void transitiveClosure() {
        for (T oj : this.index) {
            Set<T> si = this.cols.get(oj);
            Set<T> sk = this.rows.get(oj);
            if (si == null || sk == null) continue;
            for (T oi : si) {
                if (oi == oj) continue;
                for (T ok : sk) {
                    if (ok == oj) continue;
                    this.set(oi, ok);
                }
            }
        }
    }

    public synchronized Set<T> getDiagonal() {
        HashSet<T> rslt = new HashSet<T>();
        for (T o : this.index) {
            if (!this.get(o, o)) continue;
            rslt.add(o);
        }
        return rslt;
    }

    public synchronized Relation<T> copy() {
        Relation rslt = new Relation();
        Iterator<PairEntry<T, T>> it = this.iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            rslt.set(e.getKey(), e.getValue());
        }
        return rslt;
    }

    public Set<T> forward(T a) {
        return this.rows.get(a);
    }

    public Set<T> backward(T b) {
        return this.cols.get(b);
    }

    private static <T> Iterator<PairEntry<T, T>> pairEntry(Map.Entry<T, Set<T>> pair) {
        Object a = pair.getKey();
        Set<T> bs = pair.getValue();
        return new Map1Iterator<Object, PairEntry>(b -> new PairEntry<Object, Object>(a, b), bs.iterator());
    }

    public Iterator<PairEntry<T, T>> iterator() {
        Map1Iterator<Map.Entry<T, Set<T>>, Iterator> iter1 = new Map1Iterator<Map.Entry<T, Set<T>>, Iterator>(entry -> Relation.pairEntry(entry), this.rows.entrySet().iterator());
        ExtendedIterator<PairEntry<T, T>> iter2 = WrappedIterator.createIteratorIterator(iter1);
        return iter2;
    }
}

