// Copyright 2016 PDFium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef PNGPREFIX_H
#define PNGPREFIX_H

// The purpose of this file is to rename conflicting functions
// when this version of libpng and chromium's version of it are
// both simultaneously present.

#define png_access_version_number PDFIUM_png_access_version_number
#define png_app_error PDFIUM_png_app_error
#define png_app_warning PDFIUM_png_app_warning
#define png_ascii_from_fixed PDFIUM_png_ascii_from_fixed
#define png_ascii_from_fp PDFIUM_png_ascii_from_fp
#define png_benign_error PDFIUM_png_benign_error
#define png_build_gamma_table PDFIUM_png_build_gamma_table
#define png_build_grayscale_palette PDFIUM_png_build_grayscale_palette
#define png_calculate_crc PDFIUM_png_calculate_crc
#define png_calloc PDFIUM_png_calloc
#define png_check_IHDR PDFIUM_png_check_IHDR
#define png_check_chunk_length PDFIUM_png_check_chunk_length
#define png_check_chunk_name PDFIUM_png_check_chunk_name
#define png_check_fp_number PDFIUM_png_check_fp_number
#define png_check_fp_string PDFIUM_png_check_fp_string
#define png_check_keyword PDFIUM_png_check_keyword
#define png_chunk_benign_error PDFIUM_png_chunk_benign_error
#define png_chunk_error PDFIUM_png_chunk_error
#define png_chunk_report PDFIUM_png_chunk_report
#define png_chunk_unknown_handling PDFIUM_png_chunk_unknown_handling
#define png_chunk_warning PDFIUM_png_chunk_warning
#define png_colorspace_set_ICC PDFIUM_png_colorspace_set_ICC
#define png_colorspace_set_chromaticities PDFIUM_png_colorspace_set_chromaticities
#define png_colorspace_set_endpoints PDFIUM_png_colorspace_set_endpoints
#define png_colorspace_set_gamma PDFIUM_png_colorspace_set_gamma
#define png_colorspace_set_rgb_coefficients PDFIUM_png_colorspace_set_rgb_coefficients
#define png_colorspace_set_sRGB PDFIUM_png_colorspace_set_sRGB
#define png_colorspace_sync PDFIUM_png_colorspace_sync
#define png_colorspace_sync_info PDFIUM_png_colorspace_sync_info
#define png_combine_row PDFIUM_png_combine_row
#define png_compress_IDAT PDFIUM_png_compress_IDAT
#define png_convert_from_struct_tm PDFIUM_png_convert_from_struct_tm
#define png_convert_from_time_t PDFIUM_png_convert_from_time_t
#define png_convert_to_rfc1123 PDFIUM_png_convert_to_rfc1123
#define png_convert_to_rfc1123_buffer PDFIUM_png_convert_to_rfc1123_buffer
#define png_crc_error PDFIUM_png_crc_error
#define png_crc_finish PDFIUM_png_crc_finish
#define png_crc_read PDFIUM_png_crc_read
#define png_create_info_struct PDFIUM_png_create_info_struct
#define png_create_png_struct PDFIUM_png_create_png_struct
#define png_create_read_struct PDFIUM_png_create_read_struct
#define png_create_read_struct_2 PDFIUM_png_create_read_struct_2
#define png_create_write_struct PDFIUM_png_create_write_struct
#define png_create_write_struct_2 PDFIUM_png_create_write_struct_2
#define png_data_freer PDFIUM_png_data_freer
#define png_default_flush PDFIUM_png_default_flush
#define png_default_read_data PDFIUM_png_default_read_data
#define png_default_write_data PDFIUM_png_default_write_data
#define png_destroy_gamma_table PDFIUM_png_destroy_gamma_table
#define png_destroy_info_struct PDFIUM_png_destroy_info_struct
#define png_destroy_png_struct PDFIUM_png_destroy_png_struct
#define png_destroy_read_struct PDFIUM_png_destroy_read_struct
#define png_destroy_write_struct PDFIUM_png_destroy_write_struct
#define png_do_bgr PDFIUM_png_do_bgr
#define png_do_check_palette_indexes PDFIUM_png_do_check_palette_indexes
#define png_do_chop PDFIUM_png_do_chop
#define png_do_compose PDFIUM_png_do_compose
#define png_do_encode_alpha PDFIUM_png_do_encode_alpha
#define png_do_expand PDFIUM_png_do_expand
#define png_do_expand_16 PDFIUM_png_do_expand_16
#define png_do_expand_palette PDFIUM_png_do_expand_palette
#define png_do_gamma PDFIUM_png_do_gamma
#define png_do_gray_to_rgb PDFIUM_png_do_gray_to_rgb
#define png_do_invert PDFIUM_png_do_invert
#define png_do_pack PDFIUM_png_do_pack
#define png_do_packswap PDFIUM_png_do_packswap
#define png_do_quantize PDFIUM_png_do_quantize
#define png_do_read_filler PDFIUM_png_do_read_filler
#define png_do_read_interlace PDFIUM_png_do_read_interlace
#define png_do_read_intrapixel PDFIUM_png_do_read_intrapixel
#define png_do_read_invert_alpha PDFIUM_png_do_read_invert_alpha
#define png_do_read_swap_alpha PDFIUM_png_do_read_swap_alpha
#define png_do_read_transformations PDFIUM_png_do_read_transformations
#define png_do_rgb_to_gray PDFIUM_png_do_rgb_to_gray
#define png_do_scale_16_to_8 PDFIUM_png_do_scale_16_to_8
#define png_do_shift PDFIUM_png_do_shift
#define png_do_strip_channel PDFIUM_png_do_strip_channel
#define png_do_swap PDFIUM_png_do_swap
#define png_do_unpack PDFIUM_png_do_unpack
#define png_do_unshift PDFIUM_png_do_unshift
#define png_do_write_interlace PDFIUM_png_do_write_interlace
#define png_do_write_intrapixel PDFIUM_png_do_write_intrapixel
#define png_do_write_invert_alpha PDFIUM_png_do_write_invert_alpha
#define png_do_write_swap_alpha PDFIUM_png_do_write_swap_alpha
#define png_do_write_transformations PDFIUM_png_do_write_transformations
#define png_error PDFIUM_png_error
#define png_fixed PDFIUM_png_fixed
#define png_fixed_error PDFIUM_png_fixed_error
#define png_flush PDFIUM_png_flush
#define png_format_number PDFIUM_png_format_number
#define png_formatted_warning PDFIUM_png_formatted_warning
#define png_free PDFIUM_png_free
#define png_free_buffer_list PDFIUM_png_free_buffer_list
#define png_free_data PDFIUM_png_free_data
#define png_free_default PDFIUM_png_free_default
#define png_free_jmpbuf PDFIUM_png_free_jmpbuf
#define png_gamma_16bit_correct PDFIUM_png_gamma_16bit_correct
#define png_gamma_8bit_correct PDFIUM_png_gamma_8bit_correct
#define png_gamma_correct PDFIUM_png_gamma_correct
#define png_gamma_significant PDFIUM_png_gamma_significant
#define png_get_IHDR PDFIUM_png_get_IHDR
#define png_get_PLTE PDFIUM_png_get_PLTE
#define png_get_bKGD PDFIUM_png_get_bKGD
#define png_get_bit_depth PDFIUM_png_get_bit_depth
#define png_get_cHRM PDFIUM_png_get_cHRM
#define png_get_cHRM_XYZ PDFIUM_png_get_cHRM_XYZ
#define png_get_cHRM_XYZ_fixed PDFIUM_png_get_cHRM_XYZ_fixed
#define png_get_cHRM_fixed PDFIUM_png_get_cHRM_fixed
#define png_get_channels PDFIUM_png_get_channels
#define png_get_chunk_cache_max PDFIUM_png_get_chunk_cache_max
#define png_get_chunk_malloc_max PDFIUM_png_get_chunk_malloc_max
#define png_get_color_type PDFIUM_png_get_color_type
#define png_get_compression_buffer_size PDFIUM_png_get_compression_buffer_size
#define png_get_compression_type PDFIUM_png_get_compression_type
#define png_get_copyright PDFIUM_png_get_copyright
#define png_get_current_pass_number PDFIUM_png_get_current_pass_number
#define png_get_current_row_number PDFIUM_png_get_current_row_number
#define png_get_eXIf PDFIUM_png_get_eXIf
#define png_get_eXIf_1 PDFIUM_png_get_eXIf_1
#define png_get_error_ptr PDFIUM_png_get_error_ptr
#define png_get_filter_type PDFIUM_png_get_filter_type
#define png_get_gAMA PDFIUM_png_get_gAMA
#define png_get_gAMA_fixed PDFIUM_png_get_gAMA_fixed
#define png_get_hIST PDFIUM_png_get_hIST
#define png_get_header_ver PDFIUM_png_get_header_ver
#define png_get_header_version PDFIUM_png_get_header_version
#define png_get_iCCP PDFIUM_png_get_iCCP
#define png_get_image_height PDFIUM_png_get_image_height
#define png_get_image_width PDFIUM_png_get_image_width
#define png_get_int_32 PDFIUM_png_get_int_32
#define png_get_interlace_type PDFIUM_png_get_interlace_type
#define png_get_io_chunk_type PDFIUM_png_get_io_chunk_type
#define png_get_io_ptr PDFIUM_png_get_io_ptr
#define png_get_io_state PDFIUM_png_get_io_state
#define png_get_libpng_ver PDFIUM_png_get_libpng_ver
#define png_get_mem_ptr PDFIUM_png_get_mem_ptr
#define png_get_oFFs PDFIUM_png_get_oFFs
#define png_get_pCAL PDFIUM_png_get_pCAL
#define png_get_pHYs PDFIUM_png_get_pHYs
#define png_get_pHYs_dpi PDFIUM_png_get_pHYs_dpi
#define png_get_palette_max PDFIUM_png_get_palette_max
#define png_get_pixel_aspect_ratio PDFIUM_png_get_pixel_aspect_ratio
#define png_get_pixel_aspect_ratio_fixed PDFIUM_png_get_pixel_aspect_ratio_fixed
#define png_get_pixels_per_inch PDFIUM_png_get_pixels_per_inch
#define png_get_pixels_per_meter PDFIUM_png_get_pixels_per_meter
#define png_get_progressive_ptr PDFIUM_png_get_progressive_ptr
#define png_get_rgb_to_gray_status PDFIUM_png_get_rgb_to_gray_status
#define png_get_rowbytes PDFIUM_png_get_rowbytes
#define png_get_rows PDFIUM_png_get_rows
#define png_get_sBIT PDFIUM_png_get_sBIT
#define png_get_sCAL PDFIUM_png_get_sCAL
#define png_get_sCAL_fixed PDFIUM_png_get_sCAL_fixed
#define png_get_sCAL_s PDFIUM_png_get_sCAL_s
#define png_get_sPLT PDFIUM_png_get_sPLT
#define png_get_sRGB PDFIUM_png_get_sRGB
#define png_get_signature PDFIUM_png_get_signature
#define png_get_tIME PDFIUM_png_get_tIME
#define png_get_tRNS PDFIUM_png_get_tRNS
#define png_get_text PDFIUM_png_get_text
#define png_get_uint_16 PDFIUM_png_get_uint_16
#define png_get_uint_31 PDFIUM_png_get_uint_31
#define png_get_uint_32 PDFIUM_png_get_uint_32
#define png_get_unknown_chunks PDFIUM_png_get_unknown_chunks
#define png_get_user_chunk_ptr PDFIUM_png_get_user_chunk_ptr
#define png_get_user_height_max PDFIUM_png_get_user_height_max
#define png_get_user_transform_ptr PDFIUM_png_get_user_transform_ptr
#define png_get_user_width_max PDFIUM_png_get_user_width_max
#define png_get_valid PDFIUM_png_get_valid
#define png_get_x_offset_inches PDFIUM_png_get_x_offset_inches
#define png_get_x_offset_inches_fixed PDFIUM_png_get_x_offset_inches_fixed
#define png_get_x_offset_microns PDFIUM_png_get_x_offset_microns
#define png_get_x_offset_pixels PDFIUM_png_get_x_offset_pixels
#define png_get_x_pixels_per_inch PDFIUM_png_get_x_pixels_per_inch
#define png_get_x_pixels_per_meter PDFIUM_png_get_x_pixels_per_meter
#define png_get_y_offset_inches PDFIUM_png_get_y_offset_inches
#define png_get_y_offset_inches_fixed PDFIUM_png_get_y_offset_inches_fixed
#define png_get_y_offset_microns PDFIUM_png_get_y_offset_microns
#define png_get_y_offset_pixels PDFIUM_png_get_y_offset_pixels
#define png_get_y_pixels_per_inch PDFIUM_png_get_y_pixels_per_inch
#define png_get_y_pixels_per_meter PDFIUM_png_get_y_pixels_per_meter
#define png_handle_IEND PDFIUM_png_handle_IEND
#define png_handle_IHDR PDFIUM_png_handle_IHDR
#define png_handle_PLTE PDFIUM_png_handle_PLTE
#define png_handle_as_unknown PDFIUM_png_handle_as_unknown
#define png_handle_bKGD PDFIUM_png_handle_bKGD
#define png_handle_cHRM PDFIUM_png_handle_cHRM
#define png_handle_gAMA PDFIUM_png_handle_gAMA
#define png_handle_hIST PDFIUM_png_handle_hIST
#define png_handle_iCCP PDFIUM_png_handle_iCCP
#define png_handle_iTXt PDFIUM_png_handle_iTXt
#define png_handle_oFFs PDFIUM_png_handle_oFFs
#define png_handle_pCAL PDFIUM_png_handle_pCAL
#define png_handle_pHYs PDFIUM_png_handle_pHYs
#define png_handle_sBIT PDFIUM_png_handle_sBIT
#define png_handle_sCAL PDFIUM_png_handle_sCAL
#define png_handle_sPLT PDFIUM_png_handle_sPLT
#define png_handle_sRGB PDFIUM_png_handle_sRGB
#define png_handle_tEXt PDFIUM_png_handle_tEXt
#define png_handle_tIME PDFIUM_png_handle_tIME
#define png_handle_tRNS PDFIUM_png_handle_tRNS
#define png_handle_unknown PDFIUM_png_handle_unknown
#define png_handle_zTXt PDFIUM_png_handle_zTXt
#define png_icc_check_header PDFIUM_png_icc_check_header
#define png_icc_check_length PDFIUM_png_icc_check_length
#define png_icc_check_tag_table PDFIUM_png_icc_check_tag_table
#define png_icc_set_sRGB PDFIUM_png_icc_set_sRGB
#define png_image_begin_read_from_file PDFIUM_png_image_begin_read_from_file
#define png_image_begin_read_from_memory PDFIUM_png_image_begin_read_from_memory
#define png_image_begin_read_from_stdio PDFIUM_png_image_begin_read_from_stdio
#define png_image_error PDFIUM_png_image_error
#define png_image_finish_read PDFIUM_png_image_finish_read
#define png_image_free PDFIUM_png_image_free
#define png_image_write_to_file PDFIUM_png_image_write_to_file
#define png_image_write_to_memory PDFIUM_png_image_write_to_memory
#define png_image_write_to_stdio PDFIUM_png_image_write_to_stdio
#define png_info_init_3 PDFIUM_png_info_init_3
#define png_init_filter_functions_neon PDFIUM_png_init_filter_functions_neon
#define png_init_filter_functions_sse2 PDFIUM_png_init_filter_functions_sse2
#define png_init_io PDFIUM_png_init_io
#define png_init_read_transformations PDFIUM_png_init_read_transformations
#define png_longjmp PDFIUM_png_longjmp
#define png_malloc PDFIUM_png_malloc
#define png_malloc_array PDFIUM_png_malloc_array
#define png_malloc_base PDFIUM_png_malloc_base
#define png_malloc_default PDFIUM_png_malloc_default
#define png_malloc_warn PDFIUM_png_malloc_warn
#define png_muldiv PDFIUM_png_muldiv
#define png_muldiv_warn PDFIUM_png_muldiv_warn
#define png_permit_mng_features PDFIUM_png_permit_mng_features
#define png_process_IDAT_data PDFIUM_png_process_IDAT_data
#define png_process_data PDFIUM_png_process_data
#define png_process_data_pause PDFIUM_png_process_data_pause
#define png_process_data_skip PDFIUM_png_process_data_skip
#define png_process_some_data PDFIUM_png_process_some_data
#define png_progressive_combine_row PDFIUM_png_progressive_combine_row
#define png_push_check_crc PDFIUM_png_push_check_crc
#define png_push_crc_finish PDFIUM_png_push_crc_finish
#define png_push_crc_skip PDFIUM_png_push_crc_skip
#define png_push_fill_buffer PDFIUM_png_push_fill_buffer
#define png_push_handle_iTXt PDFIUM_png_push_handle_iTXt
#define png_push_handle_tEXt PDFIUM_png_push_handle_tEXt
#define png_push_handle_unknown PDFIUM_png_push_handle_unknown
#define png_push_handle_zTXt PDFIUM_png_push_handle_zTXt
#define png_push_have_end PDFIUM_png_push_have_end
#define png_push_have_info PDFIUM_png_push_have_info
#define png_push_have_row PDFIUM_png_push_have_row
#define png_push_process_row PDFIUM_png_push_process_row
#define png_push_read_IDAT PDFIUM_png_push_read_IDAT
#define png_push_read_chunk PDFIUM_png_push_read_chunk
#define png_push_read_end PDFIUM_png_push_read_end
#define png_push_read_iTXt PDFIUM_png_push_read_iTXt
#define png_push_read_sig PDFIUM_png_push_read_sig
#define png_push_read_tEXt PDFIUM_png_push_read_tEXt
#define png_push_read_zTXt PDFIUM_png_push_read_zTXt
#define png_push_restore_buffer PDFIUM_png_push_restore_buffer
#define png_push_save_buffer PDFIUM_png_push_save_buffer
#define png_read_IDAT_data PDFIUM_png_read_IDAT_data
#define png_read_chunk_header PDFIUM_png_read_chunk_header
#define png_read_data PDFIUM_png_read_data
#define png_read_end PDFIUM_png_read_end
#define png_read_filter_row PDFIUM_png_read_filter_row
#define png_read_filter_row_avg3_neon PDFIUM_png_read_filter_row_avg3_neon
#define png_read_filter_row_avg3_sse2 PDFIUM_png_read_filter_row_avg3_sse2
#define png_read_filter_row_avg4_neon PDFIUM_png_read_filter_row_avg4_neon
#define png_read_filter_row_avg4_sse2 PDFIUM_png_read_filter_row_avg4_sse2
#define png_read_filter_row_paeth3_neon PDFIUM_png_read_filter_row_paeth3_neon
#define png_read_filter_row_paeth3_sse2 PDFIUM_png_read_filter_row_paeth3_sse2
#define png_read_filter_row_paeth4_neon PDFIUM_png_read_filter_row_paeth4_neon
#define png_read_filter_row_paeth4_sse2 PDFIUM_png_read_filter_row_paeth4_sse2
#define png_read_filter_row_sub3_neon PDFIUM_png_read_filter_row_sub3_neon
#define png_read_filter_row_sub3_sse2 PDFIUM_png_read_filter_row_sub3_sse2
#define png_read_filter_row_sub4_neon PDFIUM_png_read_filter_row_sub4_neon
#define png_read_filter_row_sub4_sse2 PDFIUM_png_read_filter_row_sub4_sse2
#define png_read_filter_row_up_neon PDFIUM_png_read_filter_row_up_neon
#define png_read_finish_IDAT PDFIUM_png_read_finish_IDAT
#define png_read_finish_row PDFIUM_png_read_finish_row
#define png_read_image PDFIUM_png_read_image
#define png_read_info PDFIUM_png_read_info
#define png_read_png PDFIUM_png_read_png
#define png_read_push_finish_row PDFIUM_png_read_push_finish_row
#define png_read_row PDFIUM_png_read_row
#define png_read_rows PDFIUM_png_read_rows
#define png_read_sig PDFIUM_png_read_sig
#define png_read_start_row PDFIUM_png_read_start_row
#define png_read_transform_info PDFIUM_png_read_transform_info
#define png_read_update_info PDFIUM_png_read_update_info
#define png_realloc_array PDFIUM_png_realloc_array
#define png_reciprocal PDFIUM_png_reciprocal
#define png_reciprocal2 PDFIUM_png_reciprocal2
#define png_reset_crc PDFIUM_png_reset_crc
#define png_reset_zstream PDFIUM_png_reset_zstream
#define png_sRGB_base PDFIUM_png_sRGB_base
#define png_sRGB_delta PDFIUM_png_sRGB_delta
#define png_sRGB_table PDFIUM_png_sRGB_table
#define png_safe_error PDFIUM_png_safe_error
#define png_safe_execute PDFIUM_png_safe_execute
#define png_safe_warning PDFIUM_png_safe_warning
#define png_safecat PDFIUM_png_safecat
#define png_save_int_32 PDFIUM_png_save_int_32
#define png_save_uint_16 PDFIUM_png_save_uint_16
#define png_save_uint_32 PDFIUM_png_save_uint_32
#define png_set_IHDR PDFIUM_png_set_IHDR
#define png_set_PLTE PDFIUM_png_set_PLTE
#define png_set_add_alpha PDFIUM_png_set_add_alpha
#define png_set_alpha_mode PDFIUM_png_set_alpha_mode
#define png_set_alpha_mode_fixed PDFIUM_png_set_alpha_mode_fixed
#define png_set_bKGD PDFIUM_png_set_bKGD
#define png_set_background PDFIUM_png_set_background
#define png_set_background_fixed PDFIUM_png_set_background_fixed
#define png_set_benign_errors PDFIUM_png_set_benign_errors
#define png_set_bgr PDFIUM_png_set_bgr
#define png_set_cHRM PDFIUM_png_set_cHRM
#define png_set_cHRM_XYZ PDFIUM_png_set_cHRM_XYZ
#define png_set_cHRM_XYZ_fixed PDFIUM_png_set_cHRM_XYZ_fixed
#define png_set_cHRM_fixed PDFIUM_png_set_cHRM_fixed
#define png_set_check_for_invalid_index PDFIUM_png_set_check_for_invalid_index
#define png_set_chunk_cache_max PDFIUM_png_set_chunk_cache_max
#define png_set_chunk_malloc_max PDFIUM_png_set_chunk_malloc_max
#define png_set_compression_buffer_size PDFIUM_png_set_compression_buffer_size
#define png_set_compression_level PDFIUM_png_set_compression_level
#define png_set_compression_mem_level PDFIUM_png_set_compression_mem_level
#define png_set_compression_method PDFIUM_png_set_compression_method
#define png_set_compression_strategy PDFIUM_png_set_compression_strategy
#define png_set_compression_window_bits PDFIUM_png_set_compression_window_bits
#define png_set_crc_action PDFIUM_png_set_crc_action
#define png_set_eXIf PDFIUM_png_set_eXIf
#define png_set_eXIf_1 PDFIUM_png_set_eXIf_1
#define png_set_error_fn PDFIUM_png_set_error_fn
#define png_set_expand PDFIUM_png_set_expand
#define png_set_expand_16 PDFIUM_png_set_expand_16
#define png_set_expand_gray_1_2_4_to_8 PDFIUM_png_set_expand_gray_1_2_4_to_8
#define png_set_filler PDFIUM_png_set_filler
#define png_set_filter PDFIUM_png_set_filter
#define png_set_filter_heuristics PDFIUM_png_set_filter_heuristics
#define png_set_filter_heuristics_fixed PDFIUM_png_set_filter_heuristics_fixed
#define png_set_flush PDFIUM_png_set_flush
#define png_set_gAMA PDFIUM_png_set_gAMA
#define png_set_gAMA_fixed PDFIUM_png_set_gAMA_fixed
#define png_set_gamma PDFIUM_png_set_gamma
#define png_set_gamma_fixed PDFIUM_png_set_gamma_fixed
#define png_set_gray_to_rgb PDFIUM_png_set_gray_to_rgb
#define png_set_hIST PDFIUM_png_set_hIST
#define png_set_iCCP PDFIUM_png_set_iCCP
#define png_set_interlace_handling PDFIUM_png_set_interlace_handling
#define png_set_invalid PDFIUM_png_set_invalid
#define png_set_invert_alpha PDFIUM_png_set_invert_alpha
#define png_set_invert_mono PDFIUM_png_set_invert_mono
#define png_set_keep_unknown_chunks PDFIUM_png_set_keep_unknown_chunks
#define png_set_longjmp_fn PDFIUM_png_set_longjmp_fn
#define png_set_mem_fn PDFIUM_png_set_mem_fn
#define png_set_oFFs PDFIUM_png_set_oFFs
#define png_set_option PDFIUM_png_set_option
#define png_set_pCAL PDFIUM_png_set_pCAL
#define png_set_pHYs PDFIUM_png_set_pHYs
#define png_set_packing PDFIUM_png_set_packing
#define png_set_packswap PDFIUM_png_set_packswap
#define png_set_palette_to_rgb PDFIUM_png_set_palette_to_rgb
#define png_set_progressive_read_fn PDFIUM_png_set_progressive_read_fn
#define png_set_quantize PDFIUM_png_set_quantize
#define png_set_read_fn PDFIUM_png_set_read_fn
#define png_set_read_status_fn PDFIUM_png_set_read_status_fn
#define png_set_read_user_chunk_fn PDFIUM_png_set_read_user_chunk_fn
#define png_set_read_user_transform_fn PDFIUM_png_set_read_user_transform_fn
#define png_set_rgb_to_gray PDFIUM_png_set_rgb_to_gray
#define png_set_rgb_to_gray_fixed PDFIUM_png_set_rgb_to_gray_fixed
#define png_set_rows PDFIUM_png_set_rows
#define png_set_sBIT PDFIUM_png_set_sBIT
#define png_set_sCAL PDFIUM_png_set_sCAL
#define png_set_sCAL_fixed PDFIUM_png_set_sCAL_fixed
#define png_set_sCAL_s PDFIUM_png_set_sCAL_s
#define png_set_sPLT PDFIUM_png_set_sPLT
#define png_set_sRGB PDFIUM_png_set_sRGB
#define png_set_sRGB_gAMA_and_cHRM PDFIUM_png_set_sRGB_gAMA_and_cHRM
#define png_set_scale_16 PDFIUM_png_set_scale_16
#define png_set_shift PDFIUM_png_set_shift
#define png_set_sig_bytes PDFIUM_png_set_sig_bytes
#define png_set_strip_16 PDFIUM_png_set_strip_16
#define png_set_strip_alpha PDFIUM_png_set_strip_alpha
#define png_set_swap PDFIUM_png_set_swap
#define png_set_swap_alpha PDFIUM_png_set_swap_alpha
#define png_set_tIME PDFIUM_png_set_tIME
#define png_set_tRNS PDFIUM_png_set_tRNS
#define png_set_tRNS_to_alpha PDFIUM_png_set_tRNS_to_alpha
#define png_set_text PDFIUM_png_set_text
#define png_set_text_2 PDFIUM_png_set_text_2
#define png_set_text_compression_level PDFIUM_png_set_text_compression_level
#define png_set_text_compression_mem_level PDFIUM_png_set_text_compression_mem_level
#define png_set_text_compression_method PDFIUM_png_set_text_compression_method
#define png_set_text_compression_strategy PDFIUM_png_set_text_compression_strategy
#define png_set_text_compression_window_bits PDFIUM_png_set_text_compression_window_bits
#define png_set_unknown_chunk_location PDFIUM_png_set_unknown_chunk_location
#define png_set_unknown_chunks PDFIUM_png_set_unknown_chunks
#define png_set_user_limits PDFIUM_png_set_user_limits
#define png_set_user_transform_info PDFIUM_png_set_user_transform_info
#define png_set_write_fn PDFIUM_png_set_write_fn
#define png_set_write_status_fn PDFIUM_png_set_write_status_fn
#define png_set_write_user_transform_fn PDFIUM_png_set_write_user_transform_fn
#define png_sig_cmp PDFIUM_png_sig_cmp
#define png_start_read_image PDFIUM_png_start_read_image
#define png_user_version_check PDFIUM_png_user_version_check
#define png_warning PDFIUM_png_warning
#define png_warning_parameter PDFIUM_png_warning_parameter
#define png_warning_parameter_signed PDFIUM_png_warning_parameter_signed
#define png_warning_parameter_unsigned PDFIUM_png_warning_parameter_unsigned
#define png_write_IEND PDFIUM_png_write_IEND
#define png_write_IHDR PDFIUM_png_write_IHDR
#define png_write_PLTE PDFIUM_png_write_PLTE
#define png_write_bKGD PDFIUM_png_write_bKGD
#define png_write_cHRM_fixed PDFIUM_png_write_cHRM_fixed
#define png_write_chunk PDFIUM_png_write_chunk
#define png_write_chunk_data PDFIUM_png_write_chunk_data
#define png_write_chunk_end PDFIUM_png_write_chunk_end
#define png_write_chunk_start PDFIUM_png_write_chunk_start
#define png_write_data PDFIUM_png_write_data
#define png_write_end PDFIUM_png_write_end
#define png_write_find_filter PDFIUM_png_write_find_filter
#define png_write_finish_row PDFIUM_png_write_finish_row
#define png_write_flush PDFIUM_png_write_flush
#define png_write_gAMA_fixed PDFIUM_png_write_gAMA_fixed
#define png_write_hIST PDFIUM_png_write_hIST
#define png_write_iCCP PDFIUM_png_write_iCCP
#define png_write_iTXt PDFIUM_png_write_iTXt
#define png_write_image PDFIUM_png_write_image
#define png_write_info PDFIUM_png_write_info
#define png_write_info_before_PLTE PDFIUM_png_write_info_before_PLTE
#define png_write_oFFs PDFIUM_png_write_oFFs
#define png_write_pCAL PDFIUM_png_write_pCAL
#define png_write_pHYs PDFIUM_png_write_pHYs
#define png_write_png PDFIUM_png_write_png
#define png_write_row PDFIUM_png_write_row
#define png_write_rows PDFIUM_png_write_rows
#define png_write_sBIT PDFIUM_png_write_sBIT
#define png_write_sCAL_s PDFIUM_png_write_sCAL_s
#define png_write_sPLT PDFIUM_png_write_sPLT
#define png_write_sRGB PDFIUM_png_write_sRGB
#define png_write_sig PDFIUM_png_write_sig
#define png_write_start_row PDFIUM_png_write_start_row
#define png_write_tEXt PDFIUM_png_write_tEXt
#define png_write_tIME PDFIUM_png_write_tIME
#define png_write_tRNS PDFIUM_png_write_tRNS
#define png_write_zTXt PDFIUM_png_write_zTXt
#define png_zalloc PDFIUM_png_zalloc
#define png_zfree PDFIUM_png_zfree
#define png_zlib_inflate PDFIUM_png_zlib_inflate
#define png_zstream_error PDFIUM_png_zstream_error

#endif  // PNGPREFIX_H
