#include <unistd.h>
#include <errno.h>
#include <getopt.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <pwd.h>
#include <sys/wait.h>
#include <selinux/selinux.h>
#include <string.h>
#include <limits.h>

#include <linux/unistd.h>
#define CLONE_NEWNS 0x00020000 /* Flag to create new namespace */
static inline _syscall2 (int, clone, int, flags, int, arg)

char *progname;

void usage(int rc) 
{
	fprintf(stderr, "usage:  %s [-X] unixuser context\n", progname);
	exit(rc);
}

int main(int argc, char **argv)
{
	struct passwd *pwd;
	int rc, pid, setup_x11 = 0;

	progname = argv[0];

	while ((rc = getopt(argc, argv, "X?h")) != -1) {
		switch (rc) {
		case 'X':
			setup_x11 = 1;
			break;
		default:
			usage(0);
		}
	}

	if (optind != (argc - 2))
		usage(1);

	pwd = getpwnam(argv[optind]);
	if (!pwd) {
		fprintf(stderr, "%s is not defined in passwd.\n", argv[optind]);
		exit(1);
	}
	
	rc = setenv("HOME", pwd->pw_dir, 1);
	if (rc < 0) {
		fprintf(stderr, "Unable to set $HOME for %s to %s\n", argv[optind],
			pwd->pw_dir);
		exit(1);
	}

	optind++;

	rc = setexeccon(argv[optind]);
	if (rc < 0) {
		fprintf(stderr, "setexeccon(%s):  %s\n", argv[optind], strerror(errno));
		exit(1);
	}

	rc = security_setupns(0,pwd->pw_uid);
	if (rc < 0) {
		perror("security_setupns");
		exit(1);
	}
	if (rc == 0) {
		printf("No polyinstantiation required.");
		exit(0);
	}
	pid = clone(CLONE_NEWNS|SIGCHLD, 0);
	if (pid < 0) {
		perror("clone");
		exit(1);
	}
	if (!pid) {
		security_setupns(1,pwd->pw_uid);
		if (setup_x11) {
			/* Copy the .Xauthority file into the user's new home directory */
			FILE *xauthfile, *newxauthfile;
			int myrc, mywc;
			char *c;
			char *polyfname=NULL, *polypath=NULL, *xdirfname=NULL;
			polyfname = malloc(PATH_MAX);
			if (!polyfname)
				goto polyend;
			polypath = getenv("HOME");
			if (!polypath)
				goto polyend;
			c = strrchr(polypath,'/');
			*c = '\0';
			snprintf(polyfname, PATH_MAX, "%s/.%s-poly-orig/.Xauthority",polypath,(c+1));
			*c = '/';
			xauthfile = fopen(polyfname, "r");
			if (xauthfile != NULL) {
				snprintf(polyfname, PATH_MAX, "%s/.Xauthority",polypath);
				newxauthfile = fopen(polyfname, "w");
				if (newxauthfile != NULL) {
					while (!feof(xauthfile) && !ferror(xauthfile)) {
						myrc=fread(polyfname, 1, PATH_MAX, xauthfile);
						mywc=0;
						while (myrc > mywc) {
							mywc+=fwrite((polyfname+mywc), 1, (myrc-mywc), newxauthfile);
							if (ferror(newxauthfile))
								break;
						}
					}
					fclose(newxauthfile);
				}
				fclose(xauthfile);
			}
			/* Link /tmp/.X11-unix to poly directory */
			xdirfname = malloc(PATH_MAX);
			if (!xdirfname)
				goto polyend;
			sprintf(xdirfname, "/tmp/.X11-unix");
			sprintf(polyfname, "/.tmp-poly-orig/.X11-unix");
			symlink(polyfname,xdirfname);
polyend:
			free(xdirfname);
			free(polyfname);
		}
		execl("/bin/bash", "bash", NULL);
		perror("execl");
		exit(1);
	}
	waitpid(pid, &rc, 0);
	exit(rc);	
}
