/*
 * unity-webapps-action-tracker.c
 * Copyright (C) Canonical LTD 2011
 *
 * Author: Robert Carr <racarr@canonical.com>
 * 
 unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gio/gio.h>

#define WNCK_I_KNOW_THIS_IS_UNSTABLE
#include <libwnck/libwnck.h>

#include "unity-webapps-window-tracker-wnck.h"

#include "../unity-webapps-debug.h"

struct _UnityWebappsWindowTrackerWnckPrivate {
  WnckWindow *active_window;
};

G_DEFINE_TYPE(UnityWebappsWindowTrackerWnck, unity_webapps_window_tracker_wnck, UNITY_WEBAPPS_TYPE_WINDOW_TRACKER)

#define UNITY_WEBAPPS_WINDOW_TRACKER_WNCK_GET_PRIVATE(object) (G_TYPE_INSTANCE_GET_PRIVATE ((object), UNITY_WEBAPPS_TYPE_WINDOW_TRACKER_WNCK, UnityWebappsWindowTrackerWnckPrivate))

static void unity_webapps_window_tracker_wnck_initialize_screen (UnityWebappsWindowTrackerWnck *tracker);
static void unity_webapps_window_tracker_wnck_active_window_changed (WnckScreen *screen, WnckWindow *old_active,
								gpointer user_data);

static void
unity_webapps_window_tracker_wnck_finalize (GObject *object)
{

}

static gboolean
unity_webapps_window_tracker_wnck_name_in_ignore_list (WnckWindow *window)
{
  static const gchar *const ignored_names[] = {
    "Hud",
    "DNDCollectionWindow",
    "launcher",
    "dash",
    "Dash",
    "panel",
    "hud",
    "unity-launcher",
    "unity-2d-shell"
  };
  gboolean ignored;
  const gchar *window_name;
  gint i;
  
  window_name = wnck_window_get_name (window);
  
  if (window_name == NULL)
    return TRUE;
  
  ignored = FALSE;
  
  for (i = 0; i < G_N_ELEMENTS (ignored_names); i++)
    {
      if (g_str_equal (ignored_names[i], window_name))
	{
	  UNITY_WEBAPPS_NOTE (WINDOW_TRACKER, "Ignoring switch to blacklisted window with name: %s", window_name);
	  ignored = TRUE;
	  break;
	}
    }
 
  return ignored;
}

// Based off hud_window_source_active_window_changed 
static void
unity_webapps_window_tracker_wnck_active_window_changed (WnckScreen *screen,
						    WnckWindow *old_window,
						    gpointer user_data)
{
  UnityWebappsWindowTrackerWnck *tracker;
  //  WnckApplication *application;
  WnckWindow *window;
  //  const gchar *desktop_file;
  
  tracker = (UnityWebappsWindowTrackerWnck *)user_data;

  window = wnck_screen_get_active_window (wnck_screen_get_default ());
  
  if (window == tracker->priv->active_window)
    {
      UNITY_WEBAPPS_NOTE (WINDOW_TRACKER, "Ignoring switch to already active window");
    }
  
  if (unity_webapps_window_tracker_wnck_name_in_ignore_list (window))
    return;
  
  /*  if (application == NULL)
    {
      UNITY_WEBAPPS_NOTE (WINDOW_TRACKER_WNCK, "Ignoring switch to window with no application");
      return;
    }
  
  desktop_file = bamf_application_get_desktop_file (application);
  
  if (desktop_file == NULL)
    {
      UNITY_WEBAPPS_NOTE (WINDOW_TRACKER_WNCK, "Ignoring switch to window with no desktop file");
      return;
      }*/
  
  tracker->priv->active_window = window;
  g_object_notify (G_OBJECT (tracker), "active-window-id");  
}



static void
unity_webapps_window_tracker_wnck_initialize_screen (UnityWebappsWindowTrackerWnck *tracker)
{
  WnckScreen *screen;
  
  screen = wnck_screen_get_default ();
  
  g_signal_connect_object (screen, "active-window-changed",
			   G_CALLBACK (unity_webapps_window_tracker_wnck_active_window_changed),
			   tracker, 0);
  
  tracker->priv->active_window = wnck_screen_get_active_window (screen);
}

static guint64
unity_webapps_window_tracker_wnck_get_active_window_id (UnityWebappsWindowTracker *tracker)
{
  UnityWebappsWindowTrackerWnck *self;
  
  self = UNITY_WEBAPPS_WINDOW_TRACKER_WNCK (tracker);
  return self->priv->active_window ? wnck_window_get_xid (self->priv->active_window) : 0;
}

static void
unity_webapps_window_tracker_wnck_class_init (UnityWebappsWindowTrackerWnckClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);
  UnityWebappsWindowTrackerClass *window_tracker_class = UNITY_WEBAPPS_WINDOW_TRACKER_CLASS (klass);
  
  object_class->finalize = unity_webapps_window_tracker_wnck_finalize;
  
  window_tracker_class->get_active_window_id = unity_webapps_window_tracker_wnck_get_active_window_id;
  
  g_type_class_add_private (object_class, sizeof(UnityWebappsWindowTrackerWnckPrivate));
}

static void
unity_webapps_window_tracker_wnck_init (UnityWebappsWindowTrackerWnck *tracker)
{
  tracker->priv = UNITY_WEBAPPS_WINDOW_TRACKER_WNCK_GET_PRIVATE (tracker);
  
  tracker->priv->active_window = NULL;
  
  unity_webapps_window_tracker_wnck_initialize_screen (tracker);
}

UnityWebappsWindowTrackerWnck *
unity_webapps_window_tracker_wnck_new ()
{
  return g_object_new (UNITY_WEBAPPS_TYPE_WINDOW_TRACKER_WNCK, NULL);
}

