/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-indicator-view.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */


#ifndef __UNITY_WEBAPPS_INDICATOR_VIEW_H
#define __UNITY_WEBAPPS_INDICATOR_VIEW_H

#include "unity-webapps-indicator-model.h"


#define UNITY_WEBAPPS_TYPE_INDICATOR_VIEW              (unity_webapps_indicator_view_get_type())
#define UNITY_WEBAPPS_INDICATOR_VIEW(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), UNITY_WEBAPPS_TYPE_INDICATOR_VIEW, UnityWebappsIndicatorView))
#define UNITY_WEBAPPS_INDICATOR_VIEW_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), UNITY_WEBAPPS_TYPE_INDICATOR_VIEW, UnityWebappsIndicatorViewClass))
#define UNITY_WEBAPPS_IS_INDICATOR_VIEW(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), UNITY_WEBAPPS_TYPE_INDICATOR_VIEW))
#define UNITY_WEBAPPS_IS_INDICATOR_VIEW_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPPS_TYPE_INDICATOR_VIEW))
#define UNITY_WEBAPPS_INDICATOR_VIEW_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), UNITY_WEBAPPS_TYPE_INDICATOR_VIEW, UnityWebappsIndicatorViewClass))

typedef struct _UnityWebappsIndicatorViewPrivate UnityWebappsIndicatorViewPrivate;

typedef struct _UnityWebappsIndicatorView UnityWebappsIndicatorView;


struct _UnityWebappsIndicatorView {
	GObject object;
	
	UnityWebappsIndicatorViewPrivate *priv;
};

typedef struct _UnityWebappsIndicatorViewClass UnityWebappsIndicatorViewClass;

struct _UnityWebappsIndicatorViewClass
{
	GObjectClass parent_class;

	void (*show) (UnityWebappsIndicatorView *self);

	void (*clear_indicator) (UnityWebappsIndicatorView *self, const gchar *name);
	void (*show_indicator) (UnityWebappsIndicatorView *self, const gchar *name);
	
	void (*set_indicator_property) (UnityWebappsIndicatorView *self, const gchar *indicator_name,
									const gchar *property_name, GVariant *value, gboolean draw_attention);
};

GType unity_webapps_indicator_view_get_type (void) G_GNUC_CONST;

UnityWebappsIndicatorModel *unity_webapps_indicator_view_get_model (UnityWebappsIndicatorView *view);

void unity_webapps_indicator_view_show_indicator (UnityWebappsIndicatorView *self, const gchar *name);
void unity_webapps_indicator_view_clear_indicator (UnityWebappsIndicatorView *self, const gchar *name);

void unity_webapps_indicator_view_set_indicator_property (UnityWebappsIndicatorView *self, const gchar *indicator_name,
														  const gchar *property_name, GVariant *value,
														  gboolean draw_attention);

void unity_webapps_indicator_view_show (UnityWebappsIndicatorView *self);




#endif
