/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-service.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#ifndef __UNITY_WEBAPPS_SERVICE_H
#define __UNITY_WEBAPPS_SERVICE_H

#include <glib.h>
#include <glib-object.h>

#include <gio/gio.h>

#include "unity-webapps-dbus-defs.h"


#define UNITY_WEBAPPS_TYPE_SERVICE              (unity_webapps_service_get_type())
#define UNITY_WEBAPPS_SERVICE(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), UNITY_WEBAPPS_TYPE_SERVICE, UnityWebappsService))
#define UNITY_WEBAPPS_SERVICE_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), UNITY_WEBAPPS_TYPE_SERVICE, UnityWebappsServiceClass))
#define UNITY_WEBAPPS_IS_SERVICE(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), UNITY_WEBAPPS_TYPE_SERVICE))
#define UNITY_WEBAPPS_IS_SERVICE_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPPS_TYPE_SERVICE))
#define UNITY_WEBAPPS_SERVICE_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), UNITY_WEBAPPS_TYPE_SERVICE, UnityWebappsServiceClass))

typedef struct _UnityWebappsServicePrivate UnityWebappsServicePrivate;

typedef struct _UnityWebappsService UnityWebappsService;


struct _UnityWebappsService {
	GObject object;

	UnityWebappsServicePrivate *priv;
};

typedef struct _UnityWebappsServiceClass UnityWebappsServiceClass;

struct _UnityWebappsServiceClass {
	GObjectClass parent_class;
};

typedef void (*UnityWebappsServiceContextNotifyCallback) (UnityWebappsService *service, const gchar *name, gpointer user_data);

GType unity_webapps_service_get_type (void) G_GNUC_CONST;

UnityWebappsService *unity_webapps_service_new ();

GDBusConnection *unity_webapps_service_get_connection (UnityWebappsService *service);
GDBusProxy *unity_webapps_service_get_proxy (UnityWebappsService *service);

void unity_webapps_service_activate_application (UnityWebappsService *service, const gchar *name, const gchar *domain, const gchar *const *files);
void unity_webapps_service_open_homepage_sync (UnityWebappsService *service, const gchar *homepage);
void unity_webapps_service_on_context_appeared (UnityWebappsService *service, UnityWebappsServiceContextNotifyCallback callback, gpointer user_data);
void unity_webapps_service_on_context_vanished (UnityWebappsService *service, UnityWebappsServiceContextNotifyCallback callback, gpointer user_data);
gchar **unity_webapps_service_list_contexts (UnityWebappsService *service);

void unity_webapps_service_shutdown (UnityWebappsService *service);

void unity_webapps_service_destroy_interest_for_context (UnityWebappsService *service
														 , const gchar *name, const gchar *domain
														 , gint interest_id
														 , gboolean abandoned);


#endif
