/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

using GLib;
using Unity.Protocol;

namespace Unity {

/*
 * Proxies a Scope from DBus
 */

private abstract interface ScopeProxy : GLib.Object
{
  public abstract OptionsFilter sources { get; set; }
  public abstract bool search_in_global { get; set; }
  public abstract bool provides_personal_content { get; set; }
  public abstract ViewType view_type { get; set; }
  public abstract Dee.SerializableModel results_model { get; set; }
  public abstract Dee.SerializableModel global_results_model { get; set; }
  public abstract Dee.SerializableModel filters_model { get; set; }

  public abstract async ActivationReplyRaw activate (string uri,
                                                     ActionType action_type,
                                                     HashTable<string, Variant> hints);
  public abstract async HashTable<string, Variant> update_preview_property (
      string uri, HashTable<string, Variant> values) throws IOError;
  public abstract async HashTable<string, Variant> search (
      string search_string, HashTable<string, Variant> hints);
  public abstract async HashTable<string, Variant> global_search (
      string search_string, HashTable<string, Variant> hints);
  public abstract async void set_active_sources (string[] sources);
}

} /* namespace */
