/* Libvoikko: Finnish spellchecker and hyphenator library
 * Copyright (C) 2009 - 2010 Harri Pitkänen <hatapitk@iki.fi>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *********************************************************************************/

#include "spellchecker/suggestion/SuggestionStrategy.hpp"

using namespace std;

namespace libvoikko { namespace spellchecker { namespace suggestion {

SuggestionStrategy::SuggestionStrategy(size_t maxCost) :
	maxCost(maxCost) { }

SuggestionStrategy::~SuggestionStrategy() {
	list<SuggestionGenerator *>::iterator i = generators.begin();
	for (; i != generators.end(); ++i) {
		delete *i;
	}
	i = primaryGenerators.begin();
	for (; i != primaryGenerators.end(); ++i) {
		delete *i;
	}
}

void SuggestionStrategy::generate(SuggestionStatus * s) const {
	s->setMaxCost(this->maxCost);

	list<SuggestionGenerator *>::const_iterator i = primaryGenerators.begin();
	for (; i != primaryGenerators.end() && !s->shouldAbort(); ++i) {
		(*i)->generate(s);
	}
	if (s->getSuggestionCount() > 0) {
		// suggestion generated by primary generator, skip other generators.
		return;
	}

	i = generators.begin();
	for (; i != generators.end() && !s->shouldAbort(); ++i) {
		(*i)->generate(s);
	}
}

}}}
