.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XrmInitialize __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XrmInitialize, XrmParseCommand, XrmValue, XrmOptionKind, XrmOptionDescRec \- initialize the Resource Manager, Resource Manager structures, and parse the command line
.SH SYNTAX
.HP
#include <X11/Xresource.h>
.HP
void XrmInitialize\^(void\^);
.HP
void XrmParseCommand\^(\^XrmDatabase *\fIdatabase\fP\^, XrmOptionDescList
\fItable\fP\^, int \fItable_count\fP\^,
_Xconst char *\fIname\fP\^, int
*\fIargc_in_out\fP\^, char **\fIargv_in_out\fP\^);
.SH ARGUMENTS
.IP \fIargc_in_out\fP 1i
Specifies the number of arguments and returns the number of remaining arguments.
.IP \fIargv_in_out\fP 1i
Specifies the command line arguments
and returns the remaining arguments.
.IP \fIdatabase\fP 1i
Specifies the resource database.
.IP \fIname\fP 1i
Specifies the application name.
.IP \fItable\fP 1i
Specifies the table of command line arguments to be parsed.
.IP \fItable_count\fP 1i
Specifies the number of entries in the table.
.SH DESCRIPTION
The
.B XrmInitialize
function initialize the resource manager.
It must be called before any other Xrm functions are used.
.LP
The
.B XrmParseCommand
function parses an (argc, argv) pair according to the specified option table,
loads recognized options into the specified database with type \*(lqString,\*(rq
and modifies the (argc, argv) pair to remove all recognized options.
If database contains NULL,
.B XrmParseCommand
creates a new database and returns a pointer to it.
Otherwise, entries are added to the database specified.
If a database is created, it is created in the current locale.
.LP
The specified table is used to parse the command line.
Recognized options in the table are removed from argv,
and entries are added to the specified resource database
in the order they occur in argv.
The table entries contain information on the option string,
the option name, the style of option,
and a value to provide if the option kind is
.BR XrmoptionNoArg .
The option names are compared byte-for-byte to arguments in argv,
independent of any locale.
The resource values given in the table are stored in the resource database
without modification.
All resource database entries are created
using a \*(lqString\*(rq representation type.
The argc argument specifies the number of arguments in argv
and is set on return to the remaining number of arguments that were not parsed.
The name argument should be the name of your application
for use in building the database entry.
The name argument is prefixed to the resourceName in the option table
before storing a database entry.
The name argument is treated as a single component, even if it
has embedded periods.
No separating (binding) character is inserted,
so the table must contain either a period (.) or an asterisk (*)
as the first character in each resourceName entry.
To specify a more completely qualified resource name,
the resourceName entry can contain multiple components.
If the name argument and the resourceNames are not in the
Host Portable Character Encoding,
the result is implementation-dependent.
.SH STRUCTURES
The
.BR XrmValue ,
.BR XrmOptionKind ,
and
.B XrmOptionDescRec
structures contain:
.LP
.EX
typedef struct {
        unsigned int size;
        XPointer addr;
} XrmValue, *XrmValuePtr;
.EE
.LP
.EX
typedef enum {
        XrmoptionNoArg, /\&* Value is specified in XrmOptionDescRec.value */
        XrmoptionIsArg, /\&* Value is the option string itself */
        XrmoptionStickyArg,     /\&* Value is characters immediately following option */
        XrmoptionSepArg,        /\&* Value is next argument in argv */
        XrmoptionResArg,        /\&* Resource and value in next argument in argv */
        XrmoptionSkipArg,       /\&* Ignore this option and the next argument in argv */
        XrmoptionSkipLine,      /\&* Ignore this option and the rest of argv */
        XrmoptionSkipNArgs      /\&* Ignore this option and the next
                \ \ \ XrmOptionDescRec.value arguments in argv */
} XrmOptionKind;
.EE
.LP
.EX
typedef struct {
        char *option;   /\&* Option specification string in argv                    */
        char *specifier;        /\&* Binding and resource name (sans application name)    */
        XrmOptionKind argKind;  /\&* Which style of option it is            */
        XPointer value; /\&* Value to provide if XrmoptionNoArg or
                \ \ \ XrmoptionSkipNArgs   */
} XrmOptionDescRec, *XrmOptionDescList;
.EE
.SH "SEE ALSO"
XrmGetResource(__libmansuffix__),
XrmMergeDatabases(__libmansuffix__),
XrmPutResource(__libmansuffix__),
XrmUniqueQuark(__libmansuffix__)
.br
\fI\*(xL\fP
