'\" t
.\"     Title: xigrabdevice
.\"    Author: [FIXME: author] [see http://docbook.sf.net/el/author]
.\" Generator: DocBook XSL Stylesheets v1.76.1 <http://docbook.sf.net/>
.\"      Date: 12/21/2011
.\"    Manual: [FIXME: manual]
.\"    Source: [FIXME: source]
.\"  Language: English
.\"
.TH "XIGRABDEVICE" "libmansuffix" "12/21/2011" "[FIXME: source]" "[FIXME: manual]"
.\" -----------------------------------------------------------------
.\" * Define some portability stuff
.\" -----------------------------------------------------------------
.\" ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.\" http://bugs.debian.org/507673
.\" http://lists.gnu.org/archive/html/groff/2009-02/msg00013.html
.\" ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\" -----------------------------------------------------------------
.\" * set default formatting
.\" -----------------------------------------------------------------
.\" disable hyphenation
.nh
.\" disable justification (adjust text to left margin only)
.ad l
.\" -----------------------------------------------------------------
.\" * MAIN CONTENT STARTS HERE *
.\" -----------------------------------------------------------------
.SH "NAME"
XIGrabDevice, XIUngrabDevice \- grab or ungrab the device\&.
.SH "SYNOPSIS"
.sp
.nf
#include <X11/extensions/XInput2\&.h>
.fi
.sp
.nf
Status XIGrabDevice( Display *display,
                     int deviceid,
                     Window grab_window,
                     Time time,
                     Cursor cursor,
                     int grab_mode,
                     int paired_device_mode,
                     Bool owner_events,
                     XIEventMask *mask);
.fi
.sp
.nf
Status XIUngrabDevice( Display *display,
                       int deviceid,
                       Time time);
.fi
.sp
.nf
cursor
       Specifies the cursor image to display for the duration
       of the grab\&.
.fi
.sp
.nf
display
       Specifies the connection to the X server\&.
.fi
.sp
.nf
deviceid
       Specifies the device that should be grabbed or
       ungrabbed\&.
.fi
.sp
.nf
grab_mode, paired_device_mode
       The grab mode for this device and (if applicable) the
       paired device\&.
.fi
.sp
.nf
grab_window
       The grab window\&.
.fi
.sp
.nf
mask
       Event mask\&.
.fi
.sp
.nf
owner_events
       True if events are to be reported normally\&.
.fi
.sp
.nf
time
       A valid timestamp or CurrentTime\&.
.fi
.SH "DESCRIPTION"
.sp
.if n \{\
.RS 4
.\}
.nf
XIGrabDevice actively grabs control of the device\&. Further
device events are reported only to the grabbing client\&.
XIGrabDevice overrides any active device grab by this client\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
If the device is an attached slave device, the device is
automatically detached from the master device and reattached to
the same master device when client ungrabs the device\&. If the
master device is removed while the device is floating as a
result of a grab, the device remains floating once the grab
deactivates\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
If owner_events is False, all generated device events are
reported with respect to grab_window if selected\&. If
owner_events is True and if a generated device event would
normally be reported to this client, it is reported normally;
otherwise, the event is reported with respect to the
grab_window, and is only reported if specified in the event
mask\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
If the grab_mode argument is XIGrabModeAsync, device event
processing continues as usual\&. If the device is currently
frozen by this client, then processing of device events is
resumed\&. If the grab_mode argument is XIGrabModeSync, the state
of the device (as seen by client applications) appears to
freeze, and the X server generates no further device events
until the grabbing client issues a releasing XIAllowEvents call
or until the device grab is released\&. Actual device changes are
not lost while the device is frozen; they are simply queued in
the server for later processing\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
If paired_device_mode is XIGrabModeAsync, processing of events
from the paired master device is unaffected by activation of
the grab\&. If paired_device_mode is XIGrabModeSync, the state of
the paired master device (as seen by client applications)
appears to freeze, and the X server generates no further events
from this device until the grabbing client issues a releasing
XIAllowEvents call or until the device grab is released\&. Actual
events are not lost while the devices are frozen; they are
simply queued in the server for later processing\&. If the device
is a slave device paired_device_mode is ignored\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
If the device is actively grabbed by some other client,
XIGrabDevice fails and returns AlreadyGrabbed\&. If grab_window
is not viewable, it fails and returns GrabNotViewable\&. If the
device is frozen by an active grab of another client, it fails
and returns GrabFrozen\&. If the specified time is earlier than
the last\-device\-grab time or later than the current X server
time, it fails and returns GrabInvalidTime\&. Otherwise, the
last\-device\-grab time is set to the specified time\&. CurrentTime
is replaced by the current X server time\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
If cursor is not None this cursor is displayed until the client
calls XIUngrabDevice\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XIGrabDevice can generate BadDevice, BadValue, and BadWindow
errors\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The XIUngrabDevice request releases the device and any queued
events if this client has it actively grabbed from either
XIGrabDevice or XIGrabKey or XIGrabButton\&. If other devices are
frozen by the grab, XUngrabDevice thaws them\&. XUngrabDevice
does not release the device and any queued events if the
specified time is earlier than the last\-device\-grab time or is
later than the current X server time\&. The X server
automatically performs an XIUngrabDevice request if the event
window for an active device grab becomes not viewable\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XIUngrabDevice can generate a BadDevice error\&.
.fi
.if n \{\
.RE
.\}
.SH "DIAGNOSTICS"
.sp
.if n \{\
.RS 4
.\}
.nf
BadValue
       A value is outside of the permitted range\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadDevice
       An invalid device was specified\&. The device does not
       exist or is not a appropriate for the type of change\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadMatch
       The window is not viewable\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadWindow
       A value for a Window argument does not name a defined
       Window\&.
.fi
.if n \{\
.RE
.\}
.SH "BUGS"
.sp
.if n \{\
.RS 4
.\}
.nf
The protocol headers for XI 2\&.0 did not provide
XIGrabModeAsync or XIGrabModeSync\&. Use GrabModeSync and
GrabModeAsync instead, respectively\&.
.fi
.if n \{\
.RE
.\}
.SH "SEE ALSO"
.sp
.if n \{\
.RS 4
.\}
.nf
XIAllowEvents(libmansuffix)
.fi
.if n \{\
.RE
.\}
