.\" Copyright (c) 1993, 1994  X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
.\" OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall not
.\" be used in advertising or otherwise to promote the sale, use or other
.\" dealing in this Software without prior written authorization from the
.\" X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.ie \n(.g .ds `` \(lq
.el       .ds `` ``
.ie \n(.g .ds '' \(rq
.el       .ds '' ''
.hw XtFind-File wid-get
.na
.TH XtFindFile __libmansuffix__ __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtFindFile \- search for a file using substitutions in the path list
.SH SYNTAX
#include <X11/Intrinsic.h>
.HP
char * XtFindFile(const char *\fIpath\fP, Substitution \fIsubstitutions\fP,
Cardinal \fInum_substitutions\fP, XtFilePredicate \fIpredicate\fP);
.SH ARGUMENTS
.IP \fIpath\fP 1i
Specifies a path of file names, including substitution characters.
.IP \fIsubstitutions\fP 1i
Specifies a list of substitutions to make into a path.
.IP \fInum_substitutions\fP 1i
Specifies the number of substitutions passed in.
.IP \fIpredicate\fP 1i
Specifies a procedure to call to judge a potential file name, or NULL.
.SH DESCRIPTION
The \fIpath\fP parameter specifies a string that consists of a series of
potential file names delimited by colons.
Within each name, the
percent character specifies a string substitution selected by the
following character.
The character sequence \*(``%:\*('' specifies an
embedded colon that is not a delimiter; the sequence is replaced by a
single colon.
The character sequence \*(``%%\*('' specifies a percent
character that does not introduce a substitution; the sequence is
replaced by a single percent character.
If a percent character is
followed by any other character,
.B XtFindFile
looks through the
specified \fIsubstitutions\fP for that character in the \fImatch\fP field and if
found replaces the percent and match characters with the string in the
corresponding \fIsubstitution\fP field.
A \fIsubstitution\fP field entry of NULL
is equivalent to a pointer to an empty string.
If the operating
system does not interpret multiple embedded name separators in the
path (i.e., \*(``/\*('' in POSIX) the same way as a single separator,
.B XtFindFile
will collapse multiple separators into a single one after performing
all string substitutions.
Except for collapsing embedded separators,
the contents of the string substitutions are not interpreted by
.B XtFindFile
and may therefore contain any operating-system-dependent
characters, including additional name separators.
Each resulting
string is passed to the predicate procedure until a string is found for
which the procedure returns
.BR True ;
this string is the return value for
.BR XtFindFile .
If no string yields a
.B True
return from the predicate,
.B XtFindFile
returns NULL.
.LP
If the \fIpredicate\fP parameter is NULL, an internal procedure that checks
if the file exists, is readable, and is not a directory will be used.
.LP
It is the responsibility of the caller to free the returned string using
.B XtFree
when it is no longer needed.
.SH "SEE ALSO"
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
