/*
 * Decompiled with CFR 0.152.
 */
package org.anywikidraw.any;

import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.PopupFactory;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import org.anywikidraw.any.io.HtmlForm;
import org.anywikidraw.any.io.HttpRequest;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.ImageOutputFormat;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.io.BoundedRangeInputStream;
import org.jhotdraw.samples.svg.figures.SVGTextFigure;
import org.jhotdraw.samples.svg.gui.DrawingComponent;
import org.jhotdraw.samples.svg.gui.MessagePanel;
import org.jhotdraw.samples.svg.gui.ProgressIndicator;
import org.jhotdraw.samples.svg.gui.ServerAuthenticationException;
import org.jhotdraw.samples.svg.io.ImageMapOutputFormat;
import org.jhotdraw.util.ResourceBundleUtil;

public abstract class AbstractDrawingApplet
extends JApplet {
    private DrawingComponent drawingComponent;
    private String version;
    private long start;

    public AbstractDrawingApplet() {
        this.setBackground(Color.WHITE);
        this.start = System.currentTimeMillis();
    }

    @Override
    public String getParameter(String string) {
        try {
            return super.getParameter(string);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @Override
    public URL getDocumentBase() {
        try {
            return super.getDocumentBase();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getParameter(String string, String string2) {
        try {
            String string3 = super.getParameter(string);
            return string3 == null ? string2 : string3;
        }
        catch (NullPointerException nullPointerException) {
            return string2;
        }
    }

    @Override
    public final void init() {
        if (this.getParameter("Locale") != null) {
            Locale.setDefault(new Locale(this.getParameter("Locale")));
        }
        final ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PopupFactory.setSharedInstance(new PopupFactory());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Container container = this.getContentPane();
        final ProgressIndicator progressIndicator = new ProgressIndicator(this.getName(), resourceBundleUtil.getString("progressInitializing"));
        container.add(progressIndicator);
        progressIndicator.revalidate();
        new Worker(){

            public Object construct() {
                try {
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            AbstractDrawingApplet.this.drawingComponent = AbstractDrawingApplet.this.createDrawingComponent();
                        }
                    };
                    thread.start();
                    progressIndicator.setNote(resourceBundleUtil.getString("progressLoading"));
                    long l = System.currentTimeMillis();
                    Drawing drawing = AbstractDrawingApplet.this.loadDrawing(progressIndicator);
                    long l2 = System.currentTimeMillis();
                    System.out.println("AnyWikiDraw loading time:" + (l2 - l));
                    progressIndicator.setNote(resourceBundleUtil.getString("progressOpeningEditor"));
                    progressIndicator.setIndeterminate(true);
                    thread.join();
                    return drawing;
                }
                catch (Throwable throwable) {
                    return throwable;
                }
            }

            @Override
            public void finished() {
                Object t = this.getValue();
                JComponent jComponent = (JComponent)AbstractDrawingApplet.this.getContentPane();
                jComponent.setBorder(new LineBorder(new Color(0x202020)));
                jComponent.setLayout(new BorderLayout());
                jComponent.removeAll();
                if (t instanceof Throwable) {
                    Throwable throwable = (Throwable)t;
                    throwable.printStackTrace();
                    String string = throwable.getMessage() == null ? throwable.toString() : throwable.getMessage();
                    MessagePanel messagePanel = new MessagePanel(UIManager.getIcon("OptionPane.errorIcon"), resourceBundleUtil.getFormatted("messageLoadFailed", AbstractDrawingApplet.htmlencode(AbstractDrawingApplet.this.getParameter("DrawingURL")), AbstractDrawingApplet.htmlencode(string)));
                    jComponent.add(messagePanel);
                    messagePanel.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (actionEvent.getActionCommand().equals("close")) {
                                AbstractDrawingApplet.this.close();
                            }
                        }
                    });
                } else {
                    jComponent.add(AbstractDrawingApplet.this.drawingComponent.getComponent());
                    AbstractDrawingApplet.this.drawingComponent.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (actionEvent.getActionCommand().equals("save")) {
                                AbstractDrawingApplet.this.save();
                            } else if (actionEvent.getActionCommand().equals("cancel")) {
                                AbstractDrawingApplet.this.cancel();
                            }
                        }
                    });
                    AbstractDrawingApplet.this.initComponents();
                    if (t != null) {
                        if (t instanceof Drawing) {
                            AbstractDrawingApplet.this.setDrawing((Drawing)t);
                        } else if (t instanceof Throwable) {
                            AbstractDrawingApplet.this.setDrawing(AbstractDrawingApplet.this.createDrawing());
                            AbstractDrawingApplet.this.getDrawing().add(new SVGTextFigure(t.toString()));
                            ((Throwable)t).printStackTrace();
                        }
                    }
                }
                jComponent.validate();
                long l = System.currentTimeMillis();
                System.out.println("AbstractDrawingApplet startup latency:" + (l - AbstractDrawingApplet.this.start));
            }
        }.start();
    }

    private void setDrawing(Drawing drawing) {
        this.drawingComponent.setDrawing(drawing);
    }

    private Drawing getDrawing() {
        return this.drawingComponent.getDrawing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() {
        if (this.version == null) {
            BufferedReader bufferedReader = null;
            try {
                InputStream inputStream = AbstractDrawingApplet.class.getResourceAsStream("version.txt");
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                this.version = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                this.version = "unknown";
            }
            catch (NullPointerException nullPointerException) {
                this.version = "unknown";
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this.version;
    }

    @Override
    public String getAppletInfo() {
        return this.getName() + "\nVersion " + this.getVersion() + "\n\nCopyright (c) by the authors of AnyWikiDraw.org" + "\nThis software is licensed under LGPL or" + "\nCreative Commons 2.5 BY";
    }

    protected abstract Drawing createDrawing();

    protected abstract DrawingComponent createDrawingComponent();

    protected DrawingComponent getDrawingComponent() {
        return this.drawingComponent;
    }

    public final void save() {
        final ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        Container container = this.getContentPane();
        container.removeAll();
        final ProgressIndicator progressIndicator = new ProgressIndicator(this.getName(), resourceBundleUtil.getString("progressSaving"));
        container.add(progressIndicator);
        container.validate();
        new Worker(){

            public Object construct() {
                try {
                    AbstractDrawingApplet.this.saveDrawing(AbstractDrawingApplet.this.drawingComponent.getDrawing(), progressIndicator);
                    return null;
                }
                catch (Throwable throwable) {
                    return throwable;
                }
            }

            @Override
            public void finished() {
                Object t = this.getValue();
                if (t instanceof ServerAuthenticationException) {
                    if (AbstractDrawingApplet.this.showAuthenticationDialog() == 0) {
                        AbstractDrawingApplet.this.save();
                    } else {
                        Container container = AbstractDrawingApplet.this.getContentPane();
                        container.removeAll();
                        container.add(AbstractDrawingApplet.this.drawingComponent.getComponent());
                        container.validate();
                        container.repaint();
                    }
                } else if (t instanceof Throwable) {
                    Throwable throwable = (Throwable)t;
                    throwable.printStackTrace();
                    Container container = AbstractDrawingApplet.this.getContentPane();
                    container.setLayout(new BorderLayout());
                    container.removeAll();
                    String string = throwable.getMessage() == null ? throwable.toString() : throwable.getMessage();
                    MessagePanel messagePanel = new MessagePanel(UIManager.getIcon("OptionPane.errorIcon"), resourceBundleUtil.getFormatted("messageSaveFailed", AbstractDrawingApplet.htmlencode(AbstractDrawingApplet.this.getParameter("UploadURL")), AbstractDrawingApplet.htmlencode(string)));
                    container.add(messagePanel);
                    messagePanel.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (actionEvent.getActionCommand().equals("close")) {
                                JComponent jComponent = (JComponent)AbstractDrawingApplet.this.getContentPane();
                                jComponent.removeAll();
                                jComponent.setLayout(new BorderLayout());
                                jComponent.add(AbstractDrawingApplet.this.drawingComponent.getComponent());
                                jComponent.revalidate();
                                jComponent.repaint();
                            }
                        }
                    });
                    container.validate();
                } else {
                    AbstractDrawingApplet.this.close();
                }
            }
        }.start();
    }

    protected void cancel() {
        this.close();
    }

    @Override
    public String[][] getParameterInfo() {
        return new String[][]{{"DrawingURL", "URL", "The URL of the drawing."}, {"DrawingName", "String", "The name of the drawing."}, {"DrawingRevision", "String", "The revision of the drawing to detect concurrent updates."}, {"DrawingWidth", "int", "The width of the drawing."}, {"DrawingHeight", "int", "The height of the drawing."}, {"PageURL", "URL", "The page to be opened when the applet is closed."}, {"PageName", "String", "The name of the page to be opened when the applet is closed."}, {"UploadURL", "URL", "The page to which the applet posts the image."}, {"UploadAction", "String", "The value of the action parameter in the post data."}, {"Locale", "String", "The locale of the user interface, for example 'en_us'."}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Drawing loadDrawing(ProgressIndicator progressIndicator) throws IOException {
        Drawing drawing;
        block12: {
            ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
            drawing = this.createDrawing();
            InputStream inputStream = null;
            try {
                if (this.getParameter("DrawingURL") == null) break block12;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                URL uRL = new URL(this.getDocumentBase(), this.getParameter("DrawingURL"));
                URLConnection uRLConnection = uRL.openConnection();
                if (uRLConnection instanceof HttpURLConnection) {
                    ((HttpURLConnection)uRLConnection).setUseCaches(false);
                }
                int n = uRLConnection.getContentLength();
                inputStream = uRLConnection.getInputStream();
                if (n != -1) {
                    inputStream = new BoundedRangeInputStream(inputStream);
                    ((BoundedRangeInputStream)inputStream).setMaximum(n + 1);
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                bufferedInputStream.mark(512);
                IOException iOException = null;
                for (InputFormat inputFormat : drawing.getInputFormats()) {
                    long l;
                    if (!inputFormat.getFileFilter().accept(new File(this.getParameter("DrawingURL")))) continue;
                    try {
                        bufferedInputStream.reset();
                    }
                    catch (IOException iOException2) {
                        uRLConnection = uRL.openConnection();
                        inputStream = uRLConnection.getInputStream();
                        inputStream = new BoundedRangeInputStream(inputStream);
                        ((BoundedRangeInputStream)inputStream).setMaximum(n + 1);
                        bufferedInputStream = new BufferedInputStream(inputStream);
                        bufferedInputStream.mark(512);
                    }
                    long l2 = System.currentTimeMillis();
                    try {
                        inputFormat.read(bufferedInputStream, drawing, true);
                        iOException = null;
                        l = System.currentTimeMillis();
                        System.out.println("Format " + inputFormat.toString() + " elapsed:" + (l - l2));
                        break;
                    }
                    catch (IOException iOException3) {
                        iOException = iOException3;
                        l = System.currentTimeMillis();
                        System.out.println("Format " + inputFormat.toString() + " elapsed:" + (l - l2));
                    }
                }
                if (iOException != null) {
                    throw iOException;
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return drawing;
    }

    /*
     * WARNING - void declaration
     */
    protected void saveDrawing(Drawing drawing, ProgressIndicator progressIndicator) throws IOException, ServerAuthenticationException {
        void var11_20;
        Object object;
        Object object2;
        void var8_14;
        String string;
        Cloneable cloneable;
        Dimension dimension;
        Double d = AttributeKeys.CANVAS_WIDTH.get(drawing);
        Double d2 = AttributeKeys.CANVAS_HEIGHT.get(drawing);
        Dimension dimension2 = dimension = d == null || d2 == null ? new Dimension(-1, -1) : new Dimension(d.intValue(), d2.intValue());
        if (dimension.width == -1 || dimension.height == -1) {
            cloneable = null;
            for (Figure object42 : drawing.getChildren()) {
                if (cloneable == null) {
                    cloneable = object42.getDrawingArea();
                    continue;
                }
                ((Rectangle2D)cloneable).add(object42.getDrawingArea());
            }
            if (cloneable == null) {
                cloneable = new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0);
            }
            if (dimension.width == -1) {
                dimension.width = (int)(Math.abs(((Rectangle2D.Double)cloneable).x) + ((Rectangle2D.Double)cloneable).getWidth());
            }
            if (dimension.height == -1) {
                dimension.height = (int)(Math.abs(((Rectangle2D.Double)cloneable).y) + ((Rectangle2D.Double)cloneable).getHeight());
            }
        }
        cloneable = new Dimension(-1, -1);
        try {
            ((Dimension)cloneable).width = Math.max(1, Integer.parseInt(this.getParameter("DrawingWidth")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((Dimension)cloneable).height = Math.max(1, Integer.parseInt(this.getParameter("DrawingHeight")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (((Dimension)cloneable).width == -1 || ((Dimension)cloneable).height == -1) {
            ((Dimension)cloneable).width = dimension.width;
            ((Dimension)cloneable).height = dimension.height;
        }
        Object object5 = new ByteArrayOutputStream();
        String string2 = this.getParameter("DrawingName", "unnamed.svg").toLowerCase();
        String string3 = string = string2 == null ? "" : string2.substring(string2.lastIndexOf(46) + 1);
        if (string.equals("")) {
            String string4 = "svg";
        }
        byte[] byArray = null;
        for (OutputFormat outputFormat : drawing.getOutputFormats()) {
            if (!var8_14.equals(outputFormat.getFileExtension())) continue;
            if (outputFormat instanceof ImageOutputFormat) {
                ((ImageOutputFormat)outputFormat).write((OutputStream)object5, drawing, new AffineTransform(), dimension);
            } else {
                outputFormat.write((OutputStream)object5, drawing);
            }
            byArray = ((ByteArrayOutputStream)object5).toByteArray();
            break;
        }
        if (byArray == null) {
            throw new IOException("Unsupported file format.");
        }
        Object object3 = null;
        Object var11_18 = null;
        if (var8_14.startsWith("svg")) {
            object5 = new ByteArrayOutputStream();
            object2 = new ImageOutputFormat();
            ((ImageOutputFormat)object2).write((OutputStream)object5, drawing, new AffineTransform(), dimension);
            object3 = ((ByteArrayOutputStream)object5).toByteArray();
            object5 = new ByteArrayOutputStream();
            object = new ImageMapOutputFormat();
            ((ImageMapOutputFormat)object).write((OutputStream)object5, drawing, new AffineTransform(), dimension);
            byte[] byArray2 = ((ByteArrayOutputStream)object5).toByteArray();
        }
        object2 = new HtmlForm();
        ((HtmlForm)object2).putString("Action", this.getParameter("UploadAction", ""));
        ((HtmlForm)object2).putString("UploadSummary", this.getDrawingComponent().getSummary());
        ((HtmlForm)object2).putString("DrawingName", this.getParameter("DrawingName"));
        ((HtmlForm)object2).putString("DrawingRevision", this.getParameter("DrawingRevision", ""));
        ((HtmlForm)object2).putString("DrawingWidth", Integer.toString(dimension.width));
        ((HtmlForm)object2).putString("DrawingHeight", Integer.toString(dimension.height));
        ((HtmlForm)object2).putFile("DrawingData", this.getParameter("DrawingName"), "image/" + (String)var8_14, byArray);
        if (object3 != null) {
            ((HtmlForm)object2).putFile("RenderedImageData", this.getParameter("DrawingName") + ".png", "image/png", (byte[])object3);
            ((HtmlForm)object2).putString("RenderedImageWidth", Integer.toString(dimension.width));
            ((HtmlForm)object2).putString("RenderedImageHeight", Integer.toString(dimension.height));
        }
        if (var11_20 != null) {
            ((HtmlForm)object2).putFile("ImageMapData", this.getParameter("DrawingName") + ".map", "text/html", (byte[])var11_20);
        }
        object = new URL(this.getDocumentBase(), this.getParameter("UploadURL"));
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.open("POST", (URL)object);
        httpRequest.send((HtmlForm)object2);
        if (httpRequest.getResponseCode() != 200) {
            throw new IOException(httpRequest.getResponseCode() + " " + httpRequest.getResponseMessage() + "\n" + httpRequest.getResponseDataAsString());
        }
    }

    protected int showAuthenticationDialog() {
        return 2;
    }

    protected void close() {
        AppletContext appletContext;
        try {
            appletContext = this.getAppletContext();
        }
        catch (Throwable throwable) {
            appletContext = null;
        }
        if (appletContext == null) {
            System.exit(0);
        } else {
            try {
                appletContext.showDocument(new URL(this.getDocumentBase(), this.getParameter("PageURL")));
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
    }

    public static String htmlencode(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        block5: for (char c : string.toCharArray()) {
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block5;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block5;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block5;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private void initComponents() {
    }
}

