/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.jhotdraw.contrib.FloatingTextArea;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.CreationTool;
import org.jhotdraw.standard.SingleFigureEnumerator;
import org.jhotdraw.standard.TextHolder;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class TextAreaTool
extends CreationTool {
    protected FloatingTextArea fTextField;
    protected TextHolder fTypingTarget;
    protected Figure fEditedFigure;

    public TextAreaTool(DrawingEditor drawingEditor, Figure figure) {
        super(drawingEditor, figure);
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        this.setView((DrawingView)mouseEvent.getSource());
        Figure figure = this.drawing().findFigureInside(n, n2);
        System.out.println(figure);
        TextHolder textHolder = null;
        if (figure != null) {
            textHolder = figure.getTextHolder();
        }
        System.out.println(textHolder);
        if (textHolder != null && textHolder.acceptsTyping()) {
            this.beginEdit(textHolder, figure);
            return;
        }
        if (this.getTypingTarget() != null) {
            this.endEdit();
            if (this.getCreatedFigure() != null && this.getCreatedFigure().isEmpty()) {
                this.drawing().remove(this.getAddedFigure());
                this.setUndoActivity(null);
            }
            this.setTypingTarget(null);
            this.setCreatedFigure(null);
            this.setEditedFigure(null);
            this.setAddedFigure(null);
            this.editor().toolDone();
        } else {
            super.mouseDown(mouseEvent, n, n2);
        }
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        if (this.getCreatedFigure() == null) {
            return;
        }
        super.mouseDrag(mouseEvent, n, n2);
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        if (this.getCreatedFigure() == null) {
            return;
        }
        this.view().checkDamage();
        TextHolder textHolder = (TextHolder)((Object)this.getCreatedFigure());
        if (textHolder.acceptsTyping()) {
            this.beginEdit(textHolder, this.getCreatedFigure());
        } else {
            this.editor().toolDone();
        }
    }

    public void deactivate() {
        this.endEdit();
        super.deactivate();
    }

    public void activate() {
        super.activate();
        this.getActiveView().clearSelection();
    }

    public boolean isActivated() {
        return this.getTypingTarget() != null;
    }

    protected void beginEdit(TextHolder textHolder, Figure figure) {
        if (this.fTextField == null) {
            this.fTextField = new FloatingTextArea();
        }
        if (textHolder != this.getTypingTarget() && this.getTypingTarget() != null) {
            this.endEdit();
        }
        this.fTextField.createOverlay((Container)((Object)this.view()), this.getFont(textHolder));
        this.fTextField.setBounds(this.fieldBounds(textHolder), textHolder.getText());
        this.setTypingTarget(textHolder);
        this.setEditedFigure(figure);
        this.setUndoActivity(this.createUndoActivity());
    }

    protected Font getFont(TextHolder textHolder) {
        return textHolder.getFont();
    }

    protected void endEdit() {
        if (this.getTypingTarget() != null && this.fTextField != null) {
            if (this.fTextField.getText().length() > 0) {
                this.getTypingTarget().setText(this.fTextField.getText());
                this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.getEditedFigure()));
                ((UndoActivity)this.getUndoActivity()).setBackupText(this.getTypingTarget().getText());
            } else {
                this.drawing().orphan(this.getAddedFigure());
            }
            this.fTextField.endOverlay();
            this.fTextField = null;
        }
    }

    private Rectangle fieldBounds(TextHolder textHolder) {
        return textHolder.textDisplayBox();
    }

    protected void setTypingTarget(TextHolder textHolder) {
        this.fTypingTarget = textHolder;
    }

    protected Figure getEditedFigure() {
        return this.fEditedFigure;
    }

    protected void setEditedFigure(Figure figure) {
        this.fEditedFigure = figure;
    }

    protected TextHolder getTypingTarget() {
        return this.fTypingTarget;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view(), this.getTypingTarget().getText());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private String myOriginalText;
        private String myBackupText;

        public UndoActivity(DrawingView drawingView, String string) {
            super(drawingView);
            this.setOriginalText(string);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            if (!this.isValidText(this.getOriginalText())) {
                FigureEnumeration figureEnumeration = this.getAffectedFigures();
                while (figureEnumeration.hasNextFigure()) {
                    this.getDrawingView().drawing().orphan(figureEnumeration.nextFigure());
                }
            } else if (!this.isValidText(this.getBackupText())) {
                FigureEnumeration figureEnumeration = this.getAffectedFigures();
                while (figureEnumeration.hasNextFigure()) {
                    this.getDrawingView().add(figureEnumeration.nextFigure());
                }
                this.setText(this.getOriginalText());
            } else {
                this.setText(this.getOriginalText());
            }
            return true;
        }

        public boolean redo() {
            if (!super.redo()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            if (!this.isValidText(this.getBackupText())) {
                FigureEnumeration figureEnumeration = this.getAffectedFigures();
                while (figureEnumeration.hasNextFigure()) {
                    this.getDrawingView().drawing().orphan(figureEnumeration.nextFigure());
                }
            } else if (!this.isValidText(this.getOriginalText())) {
                FigureEnumeration figureEnumeration = this.getAffectedFigures();
                while (figureEnumeration.hasNextFigure()) {
                    this.getDrawingView().drawing().add(figureEnumeration.nextFigure());
                    this.setText(this.getBackupText());
                }
            } else {
                this.setText(this.getBackupText());
            }
            return true;
        }

        protected boolean isValidText(String string) {
            return string != null && string.length() > 0;
        }

        protected void setText(String string) {
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            while (figureEnumeration.hasNextFigure()) {
                Figure figure = figureEnumeration.nextFigure();
                if (figure.getTextHolder() == null) continue;
                figure.getTextHolder().setText(string);
            }
        }

        public void setBackupText(String string) {
            this.myBackupText = string;
        }

        public String getBackupText() {
            return this.myBackupText;
        }

        public void setOriginalText(String string) {
            this.myOriginalText = string;
        }

        public String getOriginalText() {
            return this.myOriginalText;
        }
    }
}

