/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public class TextOverflowHandle
extends AbstractHandle {
    public TextOverflowHandle(TextHolderFigure textHolderFigure) {
        super(textHolderFigure);
    }

    @Override
    public TextHolderFigure getOwner() {
        return (TextHolderFigure)super.getOwner();
    }

    @Override
    public boolean contains(Point point) {
        return false;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (this.getOwner().isTextOverflow()) {
            this.drawRectangle(graphics2D, this.getEditor().getHandleAttribute(HandleAttributeKeys.OVERFLOW_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.OVERFLOW_HANDLE_STROKE_COLOR));
            graphics2D.setColor(this.getEditor().getHandleAttribute(HandleAttributeKeys.OVERFLOW_HANDLE_STROKE_COLOR));
            Rectangle rectangle = this.basicGetBounds();
            graphics2D.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
            graphics2D.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + 1, rectangle.x + 1, rectangle.y + rectangle.height - 2);
        }
    }

    @Override
    protected Rectangle basicGetBounds() {
        Rectangle2D.Double double_ = this.getOwner().getBounds();
        Point2D.Double double_2 = new Point2D.Double(double_.x + double_.width, double_.y + double_.height);
        TextHolderFigure textHolderFigure = this.getOwner();
        if (textHolderFigure.get(AttributeKeys.TRANSFORM) != null) {
            textHolderFigure.get(AttributeKeys.TRANSFORM).transform(double_2, double_2);
        }
        Rectangle rectangle = new Rectangle(this.view.drawingToView(double_2));
        int n = this.getHandlesize();
        rectangle.x -= n;
        rectangle.y -= n;
        rectangle.width = rectangle.height = n;
        return rectangle;
    }

    @Override
    public void trackStart(Point point, int n) {
    }

    @Override
    public void trackStep(Point point, Point point2, int n) {
    }

    @Override
    public void trackEnd(Point point, Point point2, int n) {
    }

    @Override
    public String getToolTipText(Point point) {
        return this.getOwner().isTextOverflow() ? ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels").getString("handle.textOverflow.toolTipText") : null;
    }
}

