//
// System.Reflection.ObfuscationAttribute.cs
//
//
// (C) Ximian, Inc. http://www.ximian.com
//

//
// Copyright (C) 2004 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

#if NET_2_0 || BOOTSTRAP_NET_2_0

using System;
using System.Runtime.InteropServices;

namespace System.Reflection
{
	[ComVisible (true)]
	[AttributeUsage (AttributeTargets.Assembly|AttributeTargets.Class|AttributeTargets.Struct|AttributeTargets.Enum|AttributeTargets.Method|AttributeTargets.Property|AttributeTargets.Field|AttributeTargets.Event|AttributeTargets.Interface|AttributeTargets.Parameter|AttributeTargets.Delegate, AllowMultiple=true, Inherited=false)]
	public sealed class ObfuscationAttribute : Attribute {

		private bool exclude;
		private bool strip;
		private bool applyToMembers;
		private string feature;

		public ObfuscationAttribute ()
		{
			exclude = true;
			strip = true;
			applyToMembers = true;
			feature = "all";
		}
		
		public bool Exclude {
			get {
				return exclude;
			}
			set {
				exclude = value;
			}
		}

		public bool StripAfterObfuscation {
			get {
				return strip;
			}
			set {
				strip = value;
			}
		}

		[Obsolete ("Use 'StripAfterObfuscation' instead.")]
		public bool Strip {
			get {
				return strip;
			}
			set {
				strip = value;
			}
		}

		public bool ApplyToMembers {
			get {
				return applyToMembers;
			}
			set {
				applyToMembers = value;
			}
		}

		public string Feature {
			get {
				return feature;
			}
			set {
				feature = value;
			}
		}
	}
}

#endif
			
