// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Copyright (c) 2007 Novell, Inc.
//
// Authors:
//	Andreia Gaita (avidigal@novell.com)
//

using System;
using System.Runtime.InteropServices;
using System.Runtime.CompilerServices;

namespace Mono.Mozilla
{

	[Guid ("f5d9e7b0-d930-11d3-b057-00a024ffc08c")]
	[InterfaceType (ComInterfaceType.InterfaceIsIUnknown)]
	[ComImport ()]
	internal interface nsIWebNavigation
	{
		[PreserveSigAttribute]
		[MethodImpl (MethodImplOptions.InternalCall, MethodCodeType = MethodCodeType.Runtime)]
		int CanGoBack (out bool canGoBack);

		[PreserveSigAttribute]
		[MethodImpl (MethodImplOptions.InternalCall, MethodCodeType = MethodCodeType.Runtime)]
		int CanGoForward (out bool canGoForward);

		/// <summary>
		/// Do not use on non-windows platforms due to threading problems
		/// </summary>
		/// <returns></returns>
		[PreserveSigAttribute]
		[MethodImpl (MethodImplOptions.InternalCall, MethodCodeType = MethodCodeType.Runtime)]
		int GoBack ();

		/// <summary>
		/// Do not use on non-windows platforms due to threading problems
		/// </summary>
		/// <returns></returns>
		[PreserveSigAttribute]
		[MethodImpl (MethodImplOptions.InternalCall, MethodCodeType = MethodCodeType.Runtime)]
		int GoForward ();

		/// <summary>
		/// Do not use on non-windows platforms due to threading problems
		/// </summary>
		/// <returns></returns>
		[PreserveSigAttribute]
		[MethodImpl (MethodImplOptions.InternalCall, MethodCodeType = MethodCodeType.Runtime)]
		int GotoIndex (Int32 index);

		/// <summary>
		/// Do not use on non-windows platforms due to threading problems
		/// </summary>
		/// <returns></returns>
		[PreserveSigAttribute]
		[MethodImpl (MethodImplOptions.InternalCall, MethodCodeType = MethodCodeType.Runtime)]
		int LoadURI (string uri, UInt32 loadFlags,
					[MarshalAs (UnmanagedType.Interface)] nsIURI referrer,
				   [MarshalAs (UnmanagedType.Interface)] nsIInputStream postData,
				   [MarshalAs (UnmanagedType.Interface)] nsIInputStream headers);

		/// <summary>
		/// Do not use on non-windows platforms due to threading problems
		/// </summary>
		/// <returns></returns>
		[PreserveSigAttribute]
		[MethodImpl (MethodImplOptions.InternalCall, MethodCodeType = MethodCodeType.Runtime)]
		int Reload (UInt32 reloadFlags);

		[PreserveSigAttribute]
		[MethodImpl (MethodImplOptions.InternalCall, MethodCodeType = MethodCodeType.Runtime)]
		int Stop (UInt32 stopFlags);

		[PreserveSigAttribute]
		[MethodImpl (MethodImplOptions.InternalCall, MethodCodeType = MethodCodeType.Runtime)]
		int GetDocument ([MarshalAs (UnmanagedType.Interface)] out nsIDOMDocument document);

		[PreserveSigAttribute]
		[MethodImpl (MethodImplOptions.InternalCall, MethodCodeType = MethodCodeType.Runtime)]
		int GetCurrentURI ([MarshalAs (UnmanagedType.Interface)] out nsIURI currentURI);

		[PreserveSigAttribute]
		[MethodImpl (MethodImplOptions.InternalCall, MethodCodeType = MethodCodeType.Runtime)]
		int GetReferringURI ([MarshalAs (UnmanagedType.Interface)] out nsIURI referringURI);

		[PreserveSigAttribute]
		[MethodImpl (MethodImplOptions.InternalCall, MethodCodeType = MethodCodeType.Runtime)]
		int GetSessionHistory ([MarshalAs (UnmanagedType.Interface)] out nsISHistory sessionHistory);

		[PreserveSigAttribute]
		[MethodImpl (MethodImplOptions.InternalCall, MethodCodeType = MethodCodeType.Runtime)]
		int SetSessionHistory ([MarshalAs (UnmanagedType.Interface)] nsISHistory sessionHistory);

	}
}
