using System;
using System.IO;
using System.Xml;

public class Monodocs2SlashDoc {
	
	public static void Main(string[] args) {
		if (args.Length == 0) {
			Console.WriteLine("Specify a path to a Monodoc documentation base directory.");
			return;
		}
		
		string basepath = args[0];
		
		XmlDocument index_doc = new XmlDocument();
		index_doc.Load(Path.Combine(basepath, "index.xml"));
		XmlElement index = index_doc.DocumentElement;
		
		XmlDocument output = new XmlDocument();
		XmlElement output_root = output.CreateElement("doc");
		output.AppendChild(output_root);
		
		XmlElement output_assembly = output.CreateElement("assembly");
		output_root.AppendChild(output_assembly);
		XmlElement output_assembly_name = output.CreateElement("name");
		output_assembly.AppendChild(output_assembly_name);
		output_assembly_name.InnerText = index.SelectSingleNode("Assembly").InnerText;
		
		XmlElement members = output.CreateElement("members");
		output_root.AppendChild(members);
		
		foreach (XmlElement nsnode in index.SelectNodes("Types/Namespace")) {
			string ns = nsnode.GetAttribute("Name");
			foreach (XmlElement typedoc in nsnode.SelectNodes("Type")) {
				string typename = typedoc.GetAttribute("Name");
				XmlDocument type = new XmlDocument();
				type.Load(Path.Combine(Path.Combine(basepath, ns), typename) + ".xml");
				
				CreateMember("T:" + type.SelectSingleNode("Type/@FullName").InnerText,
					type.DocumentElement, members);
					
				foreach (XmlElement memberdoc in type.SelectNodes("Type/Members/Member")) {
					string name = type.SelectSingleNode("Type/@FullName").InnerText;
					switch (memberdoc.SelectSingleNode("MemberType").InnerText) {
						case "Constructor":
							name = "C:" + name + ".#ctor";
							break;
						case "Method":
							name = "M:" + name + "." + memberdoc.GetAttribute("MemberName") + MakeArgs(memberdoc);
							if (memberdoc.GetAttribute("MemberName") == "op_Implicit" || memberdoc.GetAttribute("MemberName") == "op_Explicit")
								name += "~" + memberdoc.SelectSingleNode("ReturnValue/ReturnType").InnerText;
							break;
						case "Property":
							name = "P:" + name + "." + memberdoc.GetAttribute("MemberName") + MakeArgs(memberdoc);
							break;
						case "Field":
							name = "F:" + name + "." + memberdoc.GetAttribute("MemberName");
							break;
						case "Event":
							name = "E:" + name + "." + memberdoc.GetAttribute("MemberName");
							break;
					}
					
					CreateMember(name, memberdoc, members);
				}
			}
		}
		
		WriteXml(output.DocumentElement, Console.Out);
	}
	
	private static void CreateMember(string name, XmlElement input, XmlElement output) {
		XmlElement member = output.OwnerDocument.CreateElement("member");
		output.AppendChild(member);
		
		member.SetAttribute("name", name);
		
		foreach (XmlNode docnode in input.SelectSingleNode("Docs"))
			member.AppendChild(output.OwnerDocument.ImportNode(docnode, true));
	}
	
	private static string MakeArgs(XmlElement member) {
		string ret = "";
		foreach (XmlElement p in member.SelectNodes("Parameters/Parameter")) {
			if (ret != "") ret += ",";
			ret += p.GetAttribute("Type").Replace("&", "@");
		}
		if (ret != "")
			ret = "(" + ret + ")";
		return ret;
	}

	private static void WriteXml(XmlElement element, System.IO.TextWriter output) {
		XmlTextWriter writer = new XmlTextWriter(output);
		writer.Formatting = Formatting.Indented;
		writer.Indentation = 2;
		writer.IndentChar = ' ';
		element.WriteTo(writer);
		output.WriteLine();	
	}
	
}
