// |jit-test| skip-if: !wasmSimdEnabled()

/* Copyright 2021 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:4
let $0 = instantiate(`(module
  (func (export "i32x4.extmul_low_i16x8_s") (param v128 v128) (result v128) (i32x4.extmul_low_i16x8_s (local.get 0) (local.get 1)))
  (func (export "i32x4.extmul_high_i16x8_s") (param v128 v128) (result v128) (i32x4.extmul_high_i16x8_s (local.get 0) (local.get 1)))
  (func (export "i32x4.extmul_low_i16x8_u") (param v128 v128) (result v128) (i32x4.extmul_low_i16x8_u (local.get 0) (local.get 1)))
  (func (export "i32x4.extmul_high_i16x8_u") (param v128 v128) (result v128) (i32x4.extmul_high_i16x8_u (local.get 0) (local.get 1)))
)`);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:13
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:16
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:19
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i32x4([0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:22
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:25
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:28
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:31
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff]),
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
    ]),
  [i32x4([0xfffc000, 0xfffc000, 0xfffc000, 0xfffc000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:34
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
    ]),
  [i32x4([0x10000000, 0x10000000, 0x10000000, 0x10000000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:37
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i32x4([0xfffc000, 0xfffc000, 0xfffc000, 0xfffc000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:40
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i32x4([0x10000000, 0x10000000, 0x10000000, 0x10000000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:43
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i32x4([0x10004000, 0x10004000, 0x10004000, 0x10004000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:46
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i32x4([0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:49
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i32x4([0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:52
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i32x4([0xffff8000, 0xffff8000, 0xffff8000, 0xffff8000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:55
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:58
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0x7fff, 0x7fff, 0x7fff, 0x7fff])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:61
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:64
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
    ]),
  [i32x4([0x3fff0001, 0x3fff0001, 0x3fff0001, 0x3fff0001])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:67
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i32x4([0x40000000, 0x40000000, 0x40000000, 0x40000000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:70
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001]),
    ]),
  [i32x4([0x3fff8000, 0x3fff8000, 0x3fff8000, 0x3fff8000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:73
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:76
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:79
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:82
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
    ]),
  [i32x4([0xffff8001, 0xffff8001, 0xffff8001, 0xffff8001])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:85
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i32x4([0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:88
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:93
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:96
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:99
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i32x4([0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:102
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:105
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:108
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:111
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff]),
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
    ]),
  [i32x4([0xfffc000, 0xfffc000, 0xfffc000, 0xfffc000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:114
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
    ]),
  [i32x4([0x10000000, 0x10000000, 0x10000000, 0x10000000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:117
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i32x4([0xfffc000, 0xfffc000, 0xfffc000, 0xfffc000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:120
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i32x4([0x10000000, 0x10000000, 0x10000000, 0x10000000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:123
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i32x4([0x10004000, 0x10004000, 0x10004000, 0x10004000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:126
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i32x4([0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:129
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i32x4([0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:132
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i32x4([0xffff8000, 0xffff8000, 0xffff8000, 0xffff8000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:135
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:138
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0x7fff, 0x7fff, 0x7fff, 0x7fff])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:141
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:144
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
    ]),
  [i32x4([0x3fff0001, 0x3fff0001, 0x3fff0001, 0x3fff0001])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:147
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i32x4([0x40000000, 0x40000000, 0x40000000, 0x40000000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:150
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001]),
    ]),
  [i32x4([0x3fff8000, 0x3fff8000, 0x3fff8000, 0x3fff8000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:153
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:156
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:159
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:162
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
    ]),
  [i32x4([0xffff8001, 0xffff8001, 0xffff8001, 0xffff8001])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:165
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i32x4([0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:168
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:173
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:176
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:179
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i32x4([0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:182
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:185
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:188
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0xfffe0001, 0xfffe0001, 0xfffe0001, 0xfffe0001])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:191
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff]),
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
    ]),
  [i32x4([0xfffc000, 0xfffc000, 0xfffc000, 0xfffc000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:194
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
    ]),
  [i32x4([0x10000000, 0x10000000, 0x10000000, 0x10000000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:197
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i32x4([0x9000c000, 0x9000c000, 0x9000c000, 0x9000c000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:200
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i32x4([0x90000000, 0x90000000, 0x90000000, 0x90000000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:203
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i32x4([0x8fff4000, 0x8fff4000, 0x8fff4000, 0x8fff4000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:206
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i32x4([0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:209
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i32x4([0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:212
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i32x4([0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:215
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0x80017ffe, 0x80017ffe, 0x80017ffe, 0x80017ffe])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:218
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0x80007fff, 0x80007fff, 0x80007fff, 0x80007fff])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:221
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0x7fff8000, 0x7fff8000, 0x7fff8000, 0x7fff8000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:224
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
    ]),
  [i32x4([0x3fff0001, 0x3fff0001, 0x3fff0001, 0x3fff0001])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:227
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i32x4([0x40000000, 0x40000000, 0x40000000, 0x40000000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:230
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001]),
    ]),
  [i32x4([0x40008000, 0x40008000, 0x40008000, 0x40008000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:233
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:236
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i32x4([0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:239
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0xfffe0001, 0xfffe0001, 0xfffe0001, 0xfffe0001])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:242
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
    ]),
  [i32x4([0x7ffe8001, 0x7ffe8001, 0x7ffe8001, 0x7ffe8001])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:245
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i32x4([0x7fff8000, 0x7fff8000, 0x7fff8000, 0x7fff8000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:248
assert_return(
  () =>
    invoke($0, `i32x4.extmul_low_i16x8_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0xfffe0001, 0xfffe0001, 0xfffe0001, 0xfffe0001])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:253
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:256
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:259
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i32x4([0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:262
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:265
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:268
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0xfffe0001, 0xfffe0001, 0xfffe0001, 0xfffe0001])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:271
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff]),
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
    ]),
  [i32x4([0xfffc000, 0xfffc000, 0xfffc000, 0xfffc000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:274
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
    ]),
  [i32x4([0x10000000, 0x10000000, 0x10000000, 0x10000000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:277
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i32x4([0x9000c000, 0x9000c000, 0x9000c000, 0x9000c000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:280
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i32x4([0x90000000, 0x90000000, 0x90000000, 0x90000000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:283
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i32x4([0x8fff4000, 0x8fff4000, 0x8fff4000, 0x8fff4000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:286
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i32x4([0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:289
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i32x4([0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:292
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i32x4([0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:295
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0x80017ffe, 0x80017ffe, 0x80017ffe, 0x80017ffe])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:298
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0x80007fff, 0x80007fff, 0x80007fff, 0x80007fff])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:301
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0x7fff8000, 0x7fff8000, 0x7fff8000, 0x7fff8000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:304
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
    ]),
  [i32x4([0x3fff0001, 0x3fff0001, 0x3fff0001, 0x3fff0001])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:307
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i32x4([0x40000000, 0x40000000, 0x40000000, 0x40000000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:310
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001]),
    ]),
  [i32x4([0x40008000, 0x40008000, 0x40008000, 0x40008000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:313
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:316
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i32x4([0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:319
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0xfffe0001, 0xfffe0001, 0xfffe0001, 0xfffe0001])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:322
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
    ]),
  [i32x4([0x7ffe8001, 0x7ffe8001, 0x7ffe8001, 0x7ffe8001])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:325
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i32x4([0x7fff8000, 0x7fff8000, 0x7fff8000, 0x7fff8000])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:328
assert_return(
  () =>
    invoke($0, `i32x4.extmul_high_i16x8_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i32x4([0xfffe0001, 0xfffe0001, 0xfffe0001, 0xfffe0001])],
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:333
assert_invalid(
  () =>
    instantiate(
      `(module (func (result v128) (i32x4.extmul_low_i16x8_s (i32.const 0) (f32.const 0.0))))`,
    ),
  `type mismatch`,
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:334
assert_invalid(
  () =>
    instantiate(
      `(module (func (result v128) (i32x4.extmul_high_i16x8_s (i32.const 0) (f32.const 0.0))))`,
    ),
  `type mismatch`,
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:335
assert_invalid(
  () =>
    instantiate(
      `(module (func (result v128) (i32x4.extmul_low_i16x8_u (i32.const 0) (f32.const 0.0))))`,
    ),
  `type mismatch`,
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:336
assert_invalid(
  () =>
    instantiate(
      `(module (func (result v128) (i32x4.extmul_high_i16x8_u (i32.const 0) (f32.const 0.0))))`,
    ),
  `type mismatch`,
);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:340
assert_invalid(() =>
  instantiate(`(module
    (func $$i32x4.extmul_low_i16x8_s-1st-arg-empty (result v128)
      (i32x4.extmul_low_i16x8_s (v128.const i32x4 0 0 0 0))
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:348
assert_invalid(() =>
  instantiate(`(module
    (func $$i32x4.extmul_low_i16x8_s-arg-empty (result v128)
      (i32x4.extmul_low_i16x8_s)
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:356
assert_invalid(() =>
  instantiate(`(module
    (func $$i32x4.extmul_high_i16x8_s-1st-arg-empty (result v128)
      (i32x4.extmul_high_i16x8_s (v128.const i32x4 0 0 0 0))
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:364
assert_invalid(() =>
  instantiate(`(module
    (func $$i32x4.extmul_high_i16x8_s-arg-empty (result v128)
      (i32x4.extmul_high_i16x8_s)
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:372
assert_invalid(() =>
  instantiate(`(module
    (func $$i32x4.extmul_low_i16x8_u-1st-arg-empty (result v128)
      (i32x4.extmul_low_i16x8_u (v128.const i32x4 0 0 0 0))
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:380
assert_invalid(() =>
  instantiate(`(module
    (func $$i32x4.extmul_low_i16x8_u-arg-empty (result v128)
      (i32x4.extmul_low_i16x8_u)
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:388
assert_invalid(() =>
  instantiate(`(module
    (func $$i32x4.extmul_high_i16x8_u-1st-arg-empty (result v128)
      (i32x4.extmul_high_i16x8_u (v128.const i32x4 0 0 0 0))
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i32x4_extmul_i16x8.wast:396
assert_invalid(() =>
  instantiate(`(module
    (func $$i32x4.extmul_high_i16x8_u-arg-empty (result v128)
      (i32x4.extmul_high_i16x8_u)
    )
  )`), `type mismatch`);
